/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.script;

import dk.hkj.script.Functions;
import dk.hkj.script.ProgramExceptions;
import dk.hkj.script.Script;
import dk.hkj.util.Complex;
import dk.hkj.util.MathUtil;
import dk.hkj.util.Polyfit;
import dk.hkj.vars.Var;
import java.util.List;

public class FunctionsMath {
    public static double[] getDoubleArray(Var v) {
        double[] a = new double[]{};
        if (v.isArray()) {
            a = new double[v.getSize()];
            int i = 0;
            while (i < v.getSize()) {
                a[i] = v.get(i).asDouble();
                ++i;
            }
        } else if (v.isVector()) {
            a = v.asVector().getVec();
        } else if (v.canDouble()) {
            a = new double[]{v.asDouble()};
        }
        return a;
    }

    public static void add() {
        if (Var.gl.find("PI") == null) {
            Var.gl.getCreate("PI").set(Math.PI);
            Var.gl.getCreate("pi").set(Math.PI);
            Var.gl.getCreate("e").set(Math.E);
            Var.gl.getCreate("PI").setReadOnly(true);
            Var.gl.getCreate("pi").setReadOnly(true);
            Var.gl.getCreate("e").setReadOnly(true);
        }
        Functions.gf().add(new Functions.Func("cpxPolar"){

            @Override
            public Var execute(Script script, List<Var> params) {
                switch (params.size()) {
                    case 2: {
                        double v = params.get(0).asDouble();
                        double a = params.get(1).asDouble();
                        return Var.createValue(new Complex(v * Math.cos(a), v * Math.sin(a)));
                    }
                }
                1.invalidNumberOfParams(script, "vector,angle");
                return null;
            }
        });
        Functions.gf().add(new Functions.Func("conj"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    2.invalidNumberOfParams(script, "number");
                }
                if (params.get(0).isComplex()) {
                    return Var.createValue(params.get(0).asComplex().conjugate());
                }
                return Var.createValue(params.get(0).asDouble());
            }
        });
        Functions.gf().add(new Functions.Func("toRad"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    3.invalidNumberOfParams(script, "number");
                }
                return Var.createValue(params.get(0).asDouble() * Math.PI / 180.0);
            }
        });
        Functions.gf().add(new Functions.Func("toDeg"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    4.invalidNumberOfParams(script, "number");
                }
                return Var.createValue(params.get(0).asDouble() * 180.0 / Math.PI);
            }
        });
        Functions.gf().add(new Functions.Func("log"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    5.invalidNumberOfParams(script, "number");
                }
                if (params.get(0).isComplex()) {
                    return Var.createValue(params.get(0).asComplex().log10());
                }
                return Var.createValue(Math.log10(params.get(0).asDouble()));
            }
        });
        Functions.gf().add(new Functions.Func("ln"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    6.invalidNumberOfParams(script, "number");
                }
                if (params.get(0).isComplex()) {
                    return Var.createValue(params.get(0).asComplex().ln());
                }
                return Var.createValue(Math.log(params.get(0).asDouble()));
            }
        });
        Functions.gf().add(new Functions.Func("abs"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    7.invalidNumberOfParams(script, "number");
                }
                if (params.get(0).isInt()) {
                    return Var.createValue(Math.abs(params.get(0).asInt()));
                }
                if (params.get(0).isLong()) {
                    return Var.createValue(Math.abs(params.get(0).asLong()));
                }
                if (params.get(0).isComplex()) {
                    return Var.createValue(params.get(0).asComplex().abs());
                }
                if (params.get(0).isVector()) {
                    return Var.createValue(params.get(0).asVector().abs());
                }
                return Var.createValue(Math.abs(params.get(0).asDouble()));
            }
        });
        Functions.gf().add(new Functions.Func("pow"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2) {
                    8.invalidNumberOfParams(script, "number,power");
                }
                if (params.get(0).isComplex() || params.get(1).isComplex()) {
                    return Var.createValue(params.get(0).asComplex().pow(params.get(1).asComplex()));
                }
                return Var.createValue(Math.pow(params.get(0).asDouble(), params.get(1).asDouble()));
            }
        });
        Functions.gf().add(new Functions.Func("acos"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    9.invalidNumberOfParams(script, "number");
                }
                if (params.get(0).isComplex()) {
                    return Var.createValue(params.get(0).asComplex().acos());
                }
                return Var.createValue(Math.acos(params.get(0).asDouble()));
            }
        });
        Functions.gf().add(new Functions.Func("asin"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    10.invalidNumberOfParams(script, "number");
                }
                if (params.get(0).isComplex()) {
                    return Var.createValue(params.get(0).asComplex().asin());
                }
                return Var.createValue(Math.asin(params.get(0).asDouble()));
            }
        });
        Functions.gf().add(new Functions.Func("atan"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    11.invalidNumberOfParams(script, "number");
                }
                if (params.get(0).isComplex()) {
                    return Var.createValue(params.get(0).asComplex().atan());
                }
                return Var.createValue(Math.atan(params.get(0).asDouble()));
            }
        });
        Functions.gf().add(new Functions.Func("atan2"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2) {
                    12.invalidNumberOfParams(script, "y,x");
                }
                return Var.createValue(Math.atan2(params.get(0).asDouble(), params.get(1).asDouble()));
            }
        });
        Functions.gf().add(new Functions.Func("cos"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    13.invalidNumberOfParams(script, "number");
                }
                if (params.get(0).isComplex()) {
                    return Var.createValue(params.get(0).asComplex().cos());
                }
                return Var.createValue(Math.cos(params.get(0).asDouble()));
            }
        });
        Functions.gf().add(new Functions.Func("sin"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    14.invalidNumberOfParams(script, "number");
                }
                if (params.get(0).isComplex()) {
                    return Var.createValue(params.get(0).asComplex().sin());
                }
                return Var.createValue(Math.sin(params.get(0).asDouble()));
            }
        });
        Functions.gf().add(new Functions.Func("tan"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    15.invalidNumberOfParams(script, "number");
                }
                if (params.get(0).isComplex()) {
                    return Var.createValue(params.get(0).asComplex().tan());
                }
                return Var.createValue(Math.tan(params.get(0).asDouble()));
            }
        });
        Functions.gf().add(new Functions.Func("sinh"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    16.invalidNumberOfParams(script, "number");
                }
                if (params.get(0).isComplex()) {
                    return Var.createValue(params.get(0).asComplex().sinh());
                }
                return Var.createValue(Math.sinh(params.get(0).asDouble()));
            }
        });
        Functions.gf().add(new Functions.Func("cosh"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    17.invalidNumberOfParams(script, "number");
                }
                if (params.get(0).isComplex()) {
                    return Var.createValue(params.get(0).asComplex().cosh());
                }
                return Var.createValue(Math.cosh(params.get(0).asDouble()));
            }
        });
        Functions.gf().add(new Functions.Func("tanh"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    18.invalidNumberOfParams(script, "number");
                }
                if (params.get(0).isComplex()) {
                    return Var.createValue(params.get(0).asComplex().tanh());
                }
                return Var.createValue(Math.tanh(params.get(0).asDouble()));
            }
        });
        Functions.gf().add(new Functions.Func("asinh"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    19.invalidNumberOfParams(script, "number");
                }
                if (params.get(0).isComplex()) {
                    return Var.createValue(params.get(0).asComplex().asinh());
                }
                double x = params.get(0).asDouble();
                if (Math.abs(x) > 1.0) {
                    throw new ProgramExceptions.ValueOutOfRangeException(script, "");
                }
                return Var.createValue(Math.log(x + Math.sqrt(x * x + 1.0)));
            }
        });
        Functions.gf().add(new Functions.Func("acosh"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    20.invalidNumberOfParams(script, "number");
                }
                if (params.get(0).isComplex()) {
                    return Var.createValue(params.get(0).asComplex().acosh());
                }
                double x = params.get(0).asDouble();
                if (Math.abs(x) > 1.0) {
                    throw new ProgramExceptions.ValueOutOfRangeException(script, "");
                }
                return Var.createValue(Math.log(x + Math.sqrt(x * x - 1.0)));
            }
        });
        Functions.gf().add(new Functions.Func("atanh"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    21.invalidNumberOfParams(script, "number");
                }
                if (params.get(0).isComplex()) {
                    return Var.createValue(params.get(0).asComplex().atanh());
                }
                double x = params.get(0).asDouble();
                if (Math.abs(x) > 1.0) {
                    throw new ProgramExceptions.ValueOutOfRangeException(script, "");
                }
                return Var.createValue(0.5 * Math.log((1.0 + x) / (1.0 - x)));
            }
        });
        Functions.gf().add(new Functions.Func("csc"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    22.invalidNumberOfParams(script, "number");
                }
                if (params.get(0).isComplex()) {
                    return Var.createValue(params.get(0).asComplex().csc());
                }
                double x = params.get(0).asDouble();
                return Var.createValue(1.0 / Math.sin(x));
            }
        });
        Functions.gf().add(new Functions.Func("acsc"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    23.invalidNumberOfParams(script, "number");
                }
                if (params.get(0).isComplex()) {
                    return Var.createValue(params.get(0).asComplex().acsc());
                }
                double x = params.get(0).asDouble();
                return Var.createValue(Math.asin(1.0 / x));
            }
        });
        Functions.gf().add(new Functions.Func("sec"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    24.invalidNumberOfParams(script, "number");
                }
                if (params.get(0).isComplex()) {
                    return Var.createValue(params.get(0).asComplex().sec());
                }
                double x = params.get(0).asDouble();
                return Var.createValue(1.0 / Math.cos(x));
            }
        });
        Functions.gf().add(new Functions.Func("asec"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    25.invalidNumberOfParams(script, "number");
                }
                if (params.get(0).isComplex()) {
                    return Var.createValue(params.get(0).asComplex().asec());
                }
                double x = params.get(0).asDouble();
                return Var.createValue(Math.acos(1.0 / x));
            }
        });
        Functions.gf().add(new Functions.Func("cot"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    26.invalidNumberOfParams(script, "number");
                }
                if (params.get(0).isComplex()) {
                    return Var.createValue(params.get(0).asComplex().cot());
                }
                double x = params.get(0).asDouble();
                return Var.createValue(Math.cos(x) / Math.sin(x));
            }
        });
        Functions.gf().add(new Functions.Func("acot"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    27.invalidNumberOfParams(script, "number");
                }
                if (params.get(0).isComplex()) {
                    return Var.createValue(params.get(0).asComplex().acot());
                }
                double x = params.get(0).asDouble();
                return Var.createValue(Math.atan(1.0 / x));
            }
        });
        Functions.gf().add(new Functions.Func("hypot"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2) {
                    28.invalidNumberOfParams(script, "x,y");
                }
                if (params.get(0).isComplex() || params.get(1).isComplex()) {
                    return Var.createValue(params.get(0).asComplex().sqr().add(params.get(1).asComplex().sqr()).sqrt());
                }
                return Var.createValue(Math.hypot(params.get(0).asDouble(), params.get(1).asDouble()));
            }
        });
        Functions.gf().add(new Functions.Func("exp"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    29.invalidNumberOfParams(script, "number");
                }
                if (params.get(0).isComplex()) {
                    return Var.createValue(params.get(0).asComplex().exp());
                }
                return Var.createValue(Math.exp(params.get(0).asDouble()));
            }
        });
        Functions.gf().add(new Functions.Func("expm1"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    30.invalidNumberOfParams(script, "number");
                }
                return Var.createValue(Math.expm1(params.get(0).asDouble()));
            }
        });
        Functions.gf().add(new Functions.Func("log1p"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    31.invalidNumberOfParams(script, "number");
                }
                return Var.createValue(Math.log1p(params.get(0).asDouble()));
            }
        });
        Functions.gf().add(new Functions.Func("sqrt"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    32.invalidNumberOfParams(script, "number");
                }
                if (params.get(0).isComplex()) {
                    return Var.createValue(params.get(0).asComplex().sqrt());
                }
                return Var.createValue(Math.sqrt(params.get(0).asDouble()));
            }
        });
        Functions.gf().add(new Functions.Func("sqr"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    33.invalidNumberOfParams(script, "number");
                }
                if (params.get(0).isInt() || params.get(0).isLong()) {
                    return Var.createValue(params.get(0).asLong() * params.get(0).asLong());
                }
                if (params.get(0).isComplex()) {
                    return Var.createValue(params.get(0).asComplex().sqr());
                }
                return Var.createValue(params.get(0).asDouble() * params.get(0).asDouble());
            }
        });
        Functions.gf().add(new Functions.Func("sign"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    34.invalidNumberOfParams(script, "number");
                }
                if (params.get(0).isInt() || params.get(0).isLong()) {
                    long v = params.get(0).asLong();
                    if (v == 0L) {
                        return Var.createValue(0);
                    }
                    return Var.createValue(v > 0L ? 1 : -1);
                }
                return Var.createValue(Math.signum(params.get(0).asDouble()));
            }
        });
        Functions.gf().add(new Functions.Func("round"){

            @Override
            public Var execute(Script script, List<Var> params) {
                switch (params.size()) {
                    case 1: {
                        return Var.createValue(Math.round(params.get(0).asDouble()));
                    }
                    case 2: {
                        double precision = params.get(0).asDouble();
                        return Var.createValue((double)Math.round(params.get(0).asDouble() / precision) * precision);
                    }
                }
                35.invalidNumberOfParams(script, "number{,precision}");
                return null;
            }
        });
        Functions.gf().add(new Functions.Func("floor1"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    36.invalidNumberOfParams(script, "number");
                }
                return Var.createValue(Math.floor(params.get(0).asDouble()));
            }
        });
        Functions.gf().add(new Functions.Func("ceil"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    37.invalidNumberOfParams(script, "number");
                }
                return Var.createValue(Math.log(params.get(0).asDouble()));
            }
        });
        Functions.gf().add(new Functions.Func("max1"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2) {
                    38.invalidNumberOfParams(script, "number,number");
                }
                if (params.get(0).isInt() && params.get(1).isInt()) {
                    return Var.createValue(Math.max(params.get(0).asInt(), params.get(1).asInt()));
                }
                if (params.get(0).isLong() && params.get(1).isLong()) {
                    return Var.createValue(Math.max(params.get(0).asLong(), params.get(1).asLong()));
                }
                return Var.createValue(Math.max(params.get(0).asDouble(), params.get(1).asDouble()));
            }
        });
        Functions.gf().add(new Functions.Func("min1"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2) {
                    39.invalidNumberOfParams(script, "number,number");
                }
                if (params.get(0).isInt() && params.get(1).isInt()) {
                    return Var.createValue(Math.min(params.get(0).asInt(), params.get(1).asInt()));
                }
                if (params.get(0).isLong() && params.get(1).isLong()) {
                    return Var.createValue(Math.min(params.get(0).asLong(), params.get(1).asLong()));
                }
                return Var.createValue(Math.min(params.get(0).asDouble(), params.get(1).asDouble()));
            }
        });
        Functions.gf().add(new Functions.Func("limit"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 3) {
                    40.invalidNumberOfParams(script, "number,number,number");
                }
                double v = params.get(0).asDouble();
                double min = params.get(1).asDouble();
                double max = params.get(2).asDouble();
                if (v < min) {
                    return params.get(1);
                }
                if (v > max) {
                    return params.get(2);
                }
                return params.get(0);
            }
        });
        Functions.gf().add(new Functions.Func("primes"){

            @Override
            public Var execute(Script script, List<Var> params) {
                long v;
                if (params.size() != 1) {
                    41.invalidNumberOfParams(script, "number");
                }
                if ((v = params.get(0).asLong()) < 0L) {
                    v = 0L;
                }
                long[] primes = MathUtil.primes(v);
                Var vv = Var.createArray();
                int i = 0;
                while (i < primes.length) {
                    vv.addVar(i, Var.createValue(primes[i]));
                    ++i;
                }
                return vv;
            }
        });
        Functions.gf().add(new Functions.Func("factor"){

            @Override
            public Var execute(Script script, List<Var> params) {
                long v;
                if (params.size() != 1) {
                    42.invalidNumberOfParams(script, "number");
                }
                if ((v = params.get(0).asLong()) < 0L) {
                    v = 0L;
                }
                long[] primes = MathUtil.factor(v);
                Var vv = Var.createArray();
                int i = 0;
                while (i < primes.length) {
                    vv.addVar(i, Var.createValue(primes[i]));
                    ++i;
                }
                return vv;
            }
        });
        Functions.gf().add(new Functions.Func("gcd"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() < 2) {
                    43.invalidNumberOfParams(script, "number,number{,number...}");
                }
                if (params.size() == 2) {
                    long a = params.get(0).asLong();
                    long b = params.get(1).asLong();
                    return Var.createValue(MathUtil.gcd(a, b));
                }
                long[] v = new long[params.size()];
                int i = 0;
                while (i < params.size()) {
                    v[i] = params.get(i).asLong();
                    ++i;
                }
                return Var.createValue(MathUtil.gcd(v));
            }
        });
        Functions.gf().add(new Functions.Func("lcm"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() < 2) {
                    44.invalidNumberOfParams(script, "number,number{,number...}");
                }
                if (params.size() == 2) {
                    long a = params.get(0).asLong();
                    long b = params.get(1).asLong();
                    return Var.createValue(MathUtil.lcm(a, b));
                }
                long[] v = new long[params.size()];
                int i = 0;
                while (i < params.size()) {
                    v[i] = params.get(i).asLong();
                    ++i;
                }
                return Var.createValue(MathUtil.lcm(v));
            }
        });
        Functions.gf().add(new Functions.Func("toFrac"){

            @Override
            public Var execute(Script script, List<Var> params) {
                double err;
                if (params.size() == 0 || params.size() > 2) {
                    45.invalidNumberOfParams(script, "number{,maxDenominator}");
                }
                long maxd = Long.MAX_VALUE;
                if (params.size() == 2) {
                    maxd = params.get(1).asLong();
                }
                long[] a = MathUtil.toFraction(params.get(0).asDouble(), maxd);
                Var result = Var.createStruct();
                if (a[0] != 0L || a[1] == 0L) {
                    result.addVar(Var.createValue("Int", a[0]));
                }
                if (a[1] != 0L) {
                    result.addVar(Var.createValue("Num", a[1]));
                    result.addVar(Var.createValue("Denum", a[2]));
                }
                if ((err = params.get(0).asDouble() - (double)a[0] - (double)a[1] / (double)a[2]) != 0.0) {
                    result.addVar(Var.createValue("Error", err));
                }
                return result;
            }
        });
        Functions.gf().add(new Functions.Func("toInchFrac"){

            @Override
            public Var execute(Script script, List<Var> params) {
                double err;
                if (params.size() == 0 || params.size() > 2) {
                    46.invalidNumberOfParams(script, "number");
                }
                int[] a = MathUtil.toInchFraction(params.get(0).asDouble());
                Var result = Var.createArray();
                if (a[0] != 0 || a[1] == 0) {
                    result.addVar(Var.createValue("Int", a[0]));
                }
                if (a[1] != 0) {
                    result.addVar(Var.createValue("Num", a[1]));
                    result.addVar(Var.createValue("Denum", a[2]));
                }
                if ((err = params.get(0).asDouble() - (double)a[0] - (double)a[1] / (double)a[2]) != 0.0) {
                    result.addVar(Var.createValue("Error", err));
                }
                return result;
            }
        });
        Functions.gf().add(new Functions.Func("roundDigits"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() == 0 || params.size() != 2) {
                    47.invalidNumberOfParams(script, "number,digits");
                }
                return Var.createValue(MathUtil.roundDigits(params.get(0).asDouble(), params.get(1).asInt()));
            }
        });
        Functions.gf().add(new Functions.Func("polyfit"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 3) {
                    48.invalidNumberOfParams(script, "degree,y,x");
                }
                int degree = params.get(0).asInt();
                double[] x = FunctionsMath.getDoubleArray(params.get(1));
                double[] y = FunctionsMath.getDoubleArray(params.get(2));
                double[] a = Polyfit.fit(degree, x, y);
                return Var.createValue(a);
            }
        });
    }
}

