/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.script;

import dk.hkj.script.Functions;
import dk.hkj.script.Script;
import dk.hkj.util.ByteBuffer;
import dk.hkj.util.FileUtil;
import dk.hkj.vars.Var;
import dk.hkj.vars.VarValueDateTime;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FunctionsFile {
    static Map<String, Writer> appendFiles = null;

    public static void add() {
        Functions.gf().add(new Functions.Func("fileReadAsArray"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    1.invalidNumberOfParams(script, "filename");
                }
                try {
                    LineNumberReader reader = new LineNumberReader(new FileReader(new File(params.get(0).asString())));
                    Var v = Var.createArray();
                    while (reader.ready()) {
                        v.addVar(Var.createValue(reader.readLine()));
                    }
                    reader.close();
                    return v;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        Functions.gf().add(new Functions.Func("fileReadText"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    2.invalidNumberOfParams(script, "filename");
                }
                try {
                    Var v = Var.createValue(FileUtil.readFileAsString(new File(params.get(0).asString())));
                    return v;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        Functions.gf().add(new Functions.Func("fileReadBytes"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    3.invalidNumberOfParams(script, "filename");
                }
                try {
                    ByteBuffer bb = new ByteBuffer();
                    try (FileInputStream fis = new FileInputStream(new File(params.get(0).asString()));){
                        bb.append(fis);
                    }
                    return Var.createValue(bb.getAsArray());
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        Functions.gf().add(new Functions.Func("fileWriteBytes"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() < 2) {
                    4.invalidNumberOfParams(script, "filename,data,...");
                }
                try (FileOutputStream fos = new FileOutputStream(new File(params.get(0).asString()));){
                    int i = 1;
                    while (i < params.size()) {
                        fos.write(params.get(i).asBytes());
                        ++i;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
        Functions.gf().add(new Functions.Func("fileReadAndParseAsArray"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2 && params.size() != 3) {
                    5.invalidNumberOfParams(script, "filename,delimeter{,fields}");
                }
                String deli = params.get(1).asString();
                String[] fieldNames = null;
                String line = null;
                if (params.size() == 3) {
                    line = params.get(2).asString();
                }
                try {
                    LineNumberReader reader = new LineNumberReader(new FileReader(new File(params.get(0).asString())));
                    Var array = Var.createArray();
                    if (line == null) {
                        line = reader.readLine();
                    }
                    fieldNames = line.split(deli);
                    while (reader.ready()) {
                        line = reader.readLine();
                        String[] list = line.split(deli);
                        Var v = Var.createStruct();
                        int i = 0;
                        while (i < fieldNames.length) {
                            String val = "";
                            if (i < list.length) {
                                val = list[i];
                            }
                            v.addVar(Var.createValue(fieldNames[i], val));
                            ++i;
                        }
                        array.addVar(v);
                    }
                    reader.close();
                    return array;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        Functions.gf().add(new Functions.Func("fileAppendClose"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized Var execute(Script script, List<Var> params) {
                if (appendFiles == null) {
                    return null;
                }
                if (params.size() == 0) {
                    FunctionsFile.appendFileClose();
                }
                for (Var p : params) {
                    File f = new File(p.asString());
                    try {
                        String uname = f.getCanonicalPath();
                        Map<String, Writer> map = appendFiles;
                        synchronized (map) {
                            Writer fw = appendFiles.get(uname);
                            if (fw != null) {
                                try {
                                    fw.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                appendFiles.remove(uname);
                            }
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return null;
            }
        });
        Functions.gf().add(new Functions.Func("fileAppendText"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized Var execute(Script script, List<Var> params) {
                if (params.size() < 2) {
                    7.invalidNumberOfParams(script, "filename,text,...");
                }
                try {
                    Object shutdownHook;
                    if (appendFiles == null) {
                        appendFiles = new HashMap<String, Writer>();
                        shutdownHook = new MyShutdownHook();
                        Runtime.getRuntime().addShutdownHook((Thread)shutdownHook);
                    }
                    shutdownHook = appendFiles;
                    synchronized (shutdownHook) {
                        File f = new File(params.get(0).asString());
                        String uname = f.getCanonicalPath();
                        Writer fw = appendFiles.get(uname);
                        if (fw == null) {
                            fw = new FileWriter(uname, true);
                            appendFiles.put(uname, fw);
                        }
                        int i = 1;
                        while (i < params.size()) {
                            fw.append(params.get(i).asString());
                            ++i;
                        }
                        fw.flush();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
        Functions.gf().add(new Functions.Func("fileExists"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    8.invalidNumberOfParams(script, "filename");
                }
                return Var.createValue(new File(params.get(0).asString()).exists());
            }
        });
        Functions.gf().add(new Functions.Func("fileDelete"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    9.invalidNumberOfParams(script, "filename");
                }
                return Var.createValue(new File(params.get(0).asString()).delete());
            }
        });
        Functions.gf().add(new Functions.Func("fileInfo"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    10.invalidNumberOfParams(script, "filename");
                }
                return FunctionsFile.fileInfoStruct(new File(params.get(0).asString()));
            }
        });
        Functions.gf().add(new Functions.Func("fileList"){
            boolean includeFiles = false;
            boolean includeDirs = false;
            boolean useStruct = false;
            char format = (char)65;
            MyFilenameFilter ff = null;
            Var result;

            private void scan(String path, int depth) {
                File[] list = new File(path).listFiles(this.ff);
                if (list == null) {
                    return;
                }
                int i = 0;
                while (i < list.length) {
                    boolean valid;
                    File f = list[i];
                    boolean bl = valid = this.includeFiles && f.isFile() || this.includeDirs && f.isDirectory();
                    if (valid) {
                        if (this.useStruct) {
                            this.result.addVar(FunctionsFile.fileInfoStruct(f));
                        } else {
                            switch (this.format) {
                                case 'A': {
                                    this.result.addVar(Var.createValue(f.getAbsolutePath()));
                                    break;
                                }
                                case 'R': {
                                    this.result.addVar(Var.createValue(f.getPath()));
                                    break;
                                }
                                case 'N': {
                                    this.result.addVar(Var.createValue(f.getName()));
                                }
                            }
                        }
                    }
                    ++i;
                }
                if (depth > 0) {
                    File[] dirList;
                    File[] fileArray = dirList = new File(path).listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File f) {
                            return f.isDirectory();
                        }
                    });
                    int n = dirList.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File dir = fileArray[n2];
                        this.scan(dir.getPath(), depth - 1);
                        ++n2;
                    }
                }
            }

            @Override
            public Var execute(Script script, List<Var> params) {
                String path = "";
                String mask = ".*";
                String kind = "FD";
                int depth = 0;
                if (params.size() == 0 || params.size() > 3) {
                    11.invalidNumberOfParams(script, "path{,mask{,flags}}");
                }
                path = params.get(0).asString();
                if (params.size() >= 2 && (mask = params.get(1).asString()).length() == 0) {
                    mask = ".*";
                }
                if (params.size() >= 3) {
                    kind = params.get(2).asString().toUpperCase();
                }
                this.includeFiles = kind.indexOf(70) >= 0;
                boolean bl = this.includeDirs = kind.indexOf(68) >= 0;
                if (!this.includeFiles && !this.includeDirs) {
                    this.includeFiles = true;
                    this.includeDirs = true;
                }
                this.format = kind.indexOf(65) >= 0 ? (char)65 : (kind.indexOf(82) >= 0 ? (char)82 : (kind.indexOf(78) >= 0 ? (char)78 : (char)65));
                if (kind.indexOf(43) >= 0) {
                    this.useStruct = true;
                }
                if (kind.indexOf(88) >= 0) {
                    depth = Integer.MAX_VALUE;
                } else if (kind.indexOf(49) >= 0) {
                    depth = 1;
                } else if (kind.indexOf(50) >= 0) {
                    depth = 2;
                } else if (kind.indexOf(51) >= 0) {
                    depth = 3;
                } else if (kind.indexOf(52) >= 0) {
                    depth = 4;
                } else if (kind.indexOf(53) >= 0) {
                    depth = 5;
                } else if (kind.indexOf(54) >= 0) {
                    depth = 6;
                } else if (kind.indexOf(55) >= 0) {
                    depth = 7;
                } else if (kind.indexOf(56) >= 0) {
                    depth = 8;
                } else if (kind.indexOf(57) >= 0) {
                    depth = 9;
                }
                this.ff = new MyFilenameFilter(mask);
                this.result = Var.createArray();
                this.scan(path, depth);
                return this.result;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void appendFileClose() {
        if (appendFiles == null) {
            return;
        }
        Map<String, Writer> map = appendFiles;
        synchronized (map) {
            for (Writer fw : appendFiles.values()) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            appendFiles.clear();
        }
        appendFiles = null;
    }

    private static Var fileInfoStruct(File f) {
        Var info = Var.createStruct();
        info.addVar(Var.createValue("name", f.getName()));
        info.addVar(Var.createValue("fullname", f.getPath()));
        info.addVar(Var.createValue("path", f.getParent()));
        info.addVar(Var.createValue("type", String.valueOf(f.isFile() ? "F" : "") + (f.isDirectory() ? "D" : "") + (f.isHidden() ? "H" : "") + (f.canExecute() ? "X" : "") + (f.canRead() ? "R" : "") + (f.canWrite() ? "W" : "")));
        Var v = new Var("date");
        v.set(new VarValueDateTime(new Date()));
        info.addVar(v);
        info.addVar(Var.createValue("size", f.length()));
        return info;
    }

    static class MyFilenameFilter
    implements FilenameFilter {
        String mask = ".*";

        MyFilenameFilter(String mask) {
            this.mask = mask;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.matches(this.mask);
        }
    }

    private static class MyShutdownHook
    extends Thread {
        private MyShutdownHook() {
        }

        @Override
        public void run() {
            FunctionsFile.appendFileClose();
        }
    }
}

