/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.script;

import dk.hkj.script.Functions;
import dk.hkj.script.ProgramExceptions;
import dk.hkj.script.Script;
import dk.hkj.util.Complex;
import dk.hkj.util.ElectronicUtils;
import dk.hkj.util.FFT;
import dk.hkj.util.StringUtil;
import dk.hkj.util.Thermocouples;
import dk.hkj.vars.Var;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;

public class FunctionsElectronic {
    public static void add() {
        Functions.gf().add(new Functions.Func("ntc"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2) {
                    1.invalidNumberOfParams(script, "coef,r");
                }
                ElectronicUtils.NtcCoefficients nc = new ElectronicUtils.NtcCoefficients();
                Var x = params.get(0);
                nc.a = x.getAsDouble("A", 0.0);
                nc.b = x.getAsDouble("B", 0.0);
                nc.c = x.getAsDouble("C", 0.0);
                nc.r0 = x.getAsDouble("R0", 0.0);
                nc.t0 = x.getAsDouble("T0", 0.0);
                nc.beta = x.getAsDouble("beta", 0.0);
                double r = params.get(1).asDouble();
                if (nc.a == 0.0 && nc.b == 0.0) {
                    return Var.createValue(ElectronicUtils.ntcBetaRtoT(nc, r));
                }
                return Var.createValue(ElectronicUtils.ntcSHRtoT(nc, r));
            }
        });
        Functions.gf().add(new Functions.Func("ntcT"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2) {
                    2.invalidNumberOfParams(script, "coef,t");
                }
                ElectronicUtils.NtcCoefficients nc = new ElectronicUtils.NtcCoefficients();
                Var x = params.get(0);
                nc.a = x.getAsDouble("A", 0.0);
                nc.b = x.getAsDouble("B", 0.0);
                nc.c = x.getAsDouble("C", 0.0);
                nc.r0 = x.getAsDouble("R0", 0.0);
                nc.t0 = x.getAsDouble("T0", 0.0);
                nc.beta = x.getAsDouble("beta", 0.0);
                double t = params.get(1).asDouble();
                if (nc.a == 0.0 && nc.b == 0.0) {
                    return Var.createValue(ElectronicUtils.ntcBetaTtoR(nc, t));
                }
                return Var.createValue(ElectronicUtils.ntcSHTtoR(nc, t));
            }
        });
        Functions.gf().add(new Functions.Func("ntcSH"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2 && params.size() != 4) {
                    3.invalidNumberOfParams(script, "a,b,c,r");
                }
                ElectronicUtils.NtcCoefficients nc = new ElectronicUtils.NtcCoefficients();
                double r = 0.0;
                if (params.size() == 4) {
                    nc.a = params.get(0).asDouble();
                    nc.b = params.get(1).asDouble();
                    nc.c = params.get(2).asDouble();
                    r = params.get(3).asDouble();
                } else {
                    Var x = params.get(0);
                    nc.a = x.get("A").asDouble();
                    nc.b = x.get("B").asDouble();
                    nc.c = x.get("C").asDouble();
                    r = params.get(1).asDouble();
                }
                return Var.createValue(ElectronicUtils.ntcSHRtoT(nc, r));
            }
        });
        Functions.gf().add(new Functions.Func("ntcB"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2 && params.size() != 4) {
                    4.invalidNumberOfParams(script, "r0,t0,beta,r");
                }
                ElectronicUtils.NtcCoefficients nc = new ElectronicUtils.NtcCoefficients();
                double r = 0.0;
                if (params.size() == 4) {
                    nc.r0 = params.get(0).asDouble();
                    nc.t0 = params.get(1).asDouble();
                    nc.beta = params.get(2).asDouble();
                    r = params.get(3).asDouble();
                } else {
                    Var x = params.get(0);
                    nc.r0 = x.get("R0").asDouble();
                    nc.t0 = x.get("T0").asDouble();
                    nc.beta = x.get("beta").asDouble();
                    r = params.get(1).asDouble();
                }
                return Var.createValue(ElectronicUtils.ntcBetaRtoT(nc, r));
            }
        });
        Functions.gf().add(new Functions.Func("ntcSHT"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2 && params.size() != 4) {
                    5.invalidNumberOfParams(script, "a,b,c,t");
                }
                ElectronicUtils.NtcCoefficients nc = new ElectronicUtils.NtcCoefficients();
                double t = 0.0;
                if (params.size() == 4) {
                    nc.a = params.get(0).asDouble();
                    nc.b = params.get(1).asDouble();
                    nc.c = params.get(2).asDouble();
                    t = params.get(3).asDouble();
                } else {
                    Var x = params.get(0);
                    nc.a = x.get("A").asDouble();
                    nc.b = x.get("B").asDouble();
                    nc.c = x.get("C").asDouble();
                    t = params.get(1).asDouble();
                }
                return Var.createValue(ElectronicUtils.ntcSHTtoR(nc, t));
            }
        });
        Functions.gf().add(new Functions.Func("ntcBT"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2 && params.size() != 4) {
                    6.invalidNumberOfParams(script, "r0,t0,beta,t");
                }
                ElectronicUtils.NtcCoefficients nc = new ElectronicUtils.NtcCoefficients();
                double r = 0.0;
                if (params.size() == 4) {
                    nc.r0 = params.get(0).asDouble();
                    nc.t0 = params.get(1).asDouble();
                    nc.beta = params.get(2).asDouble();
                    r = params.get(3).asDouble();
                } else {
                    Var x = params.get(0);
                    nc.r0 = x.get("R0").asDouble();
                    nc.t0 = x.get("T0").asDouble();
                    nc.beta = x.get("beta").asDouble();
                    r = params.get(1).asDouble();
                }
                return Var.createValue(ElectronicUtils.ntcBetaTtoR(nc, r));
            }
        });
        Functions.gf().add(new Functions.Func("ntcCoef"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2 && params.size() != 3 && params.size() != 4 && params.size() != 6) {
                    7.invalidNumberOfParams(script, "r,beta or a,b,c or r,t,r,t{,r,t}");
                }
                ElectronicUtils.NtcCoefficients nc = new ElectronicUtils.NtcCoefficients();
                if (params.size() == 2) {
                    nc.r0 = params.get(0).asDouble();
                    nc.t0 = 25.0;
                    nc.beta = params.get(1).asDouble();
                } else if (params.size() == 3) {
                    nc.a = params.get(0).asDouble();
                    nc.b = params.get(1).asDouble();
                    nc.c = params.get(2).asDouble();
                } else {
                    double r1 = params.get(0).asDouble();
                    double t1 = params.get(1).asDouble();
                    double r2 = params.get(2).asDouble();
                    double t2 = params.get(3).asDouble();
                    if (params.size() == 6) {
                        double r3 = params.get(4).asDouble();
                        double t3 = params.get(5).asDouble();
                        nc = ElectronicUtils.calcNtcCoefficients(r1, t1, r2, t2, r3, t3);
                    } else {
                        nc = ElectronicUtils.calcNtcCoefficients(r1, t1, r2, t2);
                    }
                }
                Var v = Var.createStruct();
                v.addVar(Var.createValue("A", nc.a));
                v.addVar(Var.createValue("B", nc.b));
                v.addVar(Var.createValue("C", nc.c));
                v.addVar(Var.createValue("R0", nc.r0));
                v.addVar(Var.createValue("T0", nc.t0));
                v.addVar(Var.createValue("beta", nc.beta));
                return v;
            }
        });
        Functions.gf().add(new Functions.Func("par"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() < 2) {
                    8.invalidNumberOfParams(script, "number,number,...");
                }
                boolean cpx = false;
                int i = 0;
                while (i < params.size()) {
                    if (params.get(i).isComplex()) {
                        cpx = true;
                    }
                    ++i;
                }
                if (cpx) {
                    Complex sum = new Complex();
                    boolean isZero = false;
                    int i2 = 0;
                    while (i2 < params.size()) {
                        Complex v = params.get(i2).asComplex();
                        if (v.abs() < 2.5E-323) {
                            isZero = true;
                            break;
                        }
                        sum = sum.add(v.reciprocal());
                        ++i2;
                    }
                    return Var.createValue(isZero ? new Complex() : sum.reciprocal());
                }
                double sum = 0.0;
                boolean isZero = false;
                int i3 = 0;
                while (i3 < params.size()) {
                    double v = params.get(i3).asDouble();
                    if (Math.abs(v) < 2.5E-323) {
                        isZero = true;
                        break;
                    }
                    sum += 1.0 / v;
                    ++i3;
                }
                return Var.createValue(isZero ? 0.0 : 1.0 / sum);
            }
        });
        Functions.gf().add(new Functions.Func("findE"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2) {
                    9.invalidNumberOfParams(script, "series,resistance");
                }
                return Var.createValue(ElectronicUtils.findValue(params.get(0).asInt(), params.get(1).asDouble()));
            }
        });
        Functions.gf().add(new Functions.Func("findE6"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    10.invalidNumberOfParams(script, "resistance");
                }
                return Var.createValue(ElectronicUtils.findE6(params.get(0).asDouble()));
            }
        });
        Functions.gf().add(new Functions.Func("findE12"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    11.invalidNumberOfParams(script, "resistance");
                }
                return Var.createValue(ElectronicUtils.findE12(params.get(0).asDouble()));
            }
        });
        Functions.gf().add(new Functions.Func("findE24"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    12.invalidNumberOfParams(script, "resistance");
                }
                return Var.createValue(ElectronicUtils.findE24(params.get(0).asDouble()));
            }
        });
        Functions.gf().add(new Functions.Func("findE48"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    13.invalidNumberOfParams(script, "resistance");
                }
                return Var.createValue(ElectronicUtils.findE48(params.get(0).asDouble()));
            }
        });
        Functions.gf().add(new Functions.Func("findE96"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    14.invalidNumberOfParams(script, "resistance");
                }
                return Var.createValue(ElectronicUtils.findE96(params.get(0).asDouble()));
            }
        });
        Functions.gf().add(new Functions.Func("findE192"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    15.invalidNumberOfParams(script, "resistance");
                }
                return Var.createValue(ElectronicUtils.findE192(params.get(0).asDouble()));
            }
        });
        Functions.gf().add(new Functions.Func("findRser"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2) {
                    16.invalidNumberOfParams(script, "series,resistance");
                }
                double[] v = ElectronicUtils.findRser(params.get(0).asInt(), params.get(1).asDouble(), false);
                return FunctionsElectronic.formatSerPar(v, "R", "Series");
            }
        });
        Functions.gf().add(new Functions.Func("findRpar"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2) {
                    17.invalidNumberOfParams(script, "series,resistance");
                }
                double[] v = ElectronicUtils.findRpar(params.get(0).asInt(), params.get(1).asDouble(), false);
                return FunctionsElectronic.formatSerPar(v, "R", "Parallel");
            }
        });
        Functions.gf().add(new Functions.Func("findCpar"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2) {
                    18.invalidNumberOfParams(script, "series,capacitance");
                }
                double[] v = ElectronicUtils.findRser(params.get(0).asInt(), params.get(1).asDouble(), false);
                return FunctionsElectronic.formatSerPar(v, "C", "Parallel");
            }
        });
        Functions.gf().add(new Functions.Func("findCser"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2) {
                    19.invalidNumberOfParams(script, "series,capacitance");
                }
                double[] v = ElectronicUtils.findRpar(params.get(0).asInt(), params.get(1).asDouble(), false);
                return FunctionsElectronic.formatSerPar(v, "C", "Series");
            }
        });
        Functions.gf().add(new Functions.Func("findLser"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2) {
                    20.invalidNumberOfParams(script, "series,inductance");
                }
                double[] v = ElectronicUtils.findRser(params.get(0).asInt(), params.get(1).asDouble(), false);
                return FunctionsElectronic.formatSerPar(v, "L", "Series");
            }
        });
        Functions.gf().add(new Functions.Func("findLpar"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2) {
                    21.invalidNumberOfParams(script, "series,inductance");
                }
                double[] v = ElectronicUtils.findRpar(params.get(0).asInt(), params.get(1).asDouble(), false);
                return FunctionsElectronic.formatSerPar(v, "L", "Parallel");
            }
        });
        Functions.gf().add(new Functions.Func("findR"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2) {
                    22.invalidNumberOfParams(script, "series,resistance");
                }
                double[] single = ElectronicUtils.findR(params.get(0).asInt(), params.get(1).asDouble());
                double[] par = ElectronicUtils.findRpar(params.get(0).asInt(), params.get(1).asDouble(), false);
                double[] ser = ElectronicUtils.findRser(params.get(0).asInt(), params.get(1).asDouble(), false);
                if (Math.abs(single[1]) <= Math.abs(par[2]) && Math.abs(single[1]) <= Math.abs(ser[2]) || Math.abs(single[1]) <= 1.0E-5) {
                    return FunctionsElectronic.formatSingle(single, "R");
                }
                if (ElectronicUtils.isParBest(par, ser)) {
                    return FunctionsElectronic.formatSerPar(par, "R", "Parallel");
                }
                return FunctionsElectronic.formatSerPar(ser, "R", "Series");
            }
        });
        Functions.gf().add(new Functions.Func("findC"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2) {
                    23.invalidNumberOfParams(script, "series,capacitance");
                }
                double[] single = ElectronicUtils.findR(params.get(0).asInt(), params.get(1).asDouble());
                double[] ser = ElectronicUtils.findRpar(params.get(0).asInt(), params.get(1).asDouble(), false);
                double[] par = ElectronicUtils.findRser(params.get(0).asInt(), params.get(1).asDouble(), false);
                if (Math.abs(single[1]) <= Math.abs(par[2]) && Math.abs(single[1]) <= Math.abs(ser[2]) || Math.abs(single[1]) <= 1.0E-5) {
                    return FunctionsElectronic.formatSingle(single, "C");
                }
                if (ElectronicUtils.isParBest(par, ser)) {
                    return FunctionsElectronic.formatSerPar(par, "C", "Series");
                }
                return FunctionsElectronic.formatSerPar(ser, "C", "Parellel");
            }
        });
        Functions.gf().add(new Functions.Func("findL"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2) {
                    24.invalidNumberOfParams(script, "series,inductance");
                }
                double[] single = ElectronicUtils.findR(params.get(0).asInt(), params.get(1).asDouble());
                double[] par = ElectronicUtils.findRpar(params.get(0).asInt(), params.get(1).asDouble(), false);
                double[] ser = ElectronicUtils.findRser(params.get(0).asInt(), params.get(1).asDouble(), false);
                if (Math.abs(single[1]) <= Math.abs(par[2]) && Math.abs(single[1]) <= Math.abs(ser[2]) || Math.abs(single[1]) <= 1.0E-5) {
                    return FunctionsElectronic.formatSingle(single, "L");
                }
                if (ElectronicUtils.isParBest(par, ser)) {
                    return FunctionsElectronic.formatSerPar(par, "L", "Parallel");
                }
                return FunctionsElectronic.formatSerPar(ser, "L", "Series");
            }
        });
        Functions.gf().add(new Functions.Func("test+++"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 0) {
                    25.invalidNumberOfParams(script, "number,number");
                }
                FunctionsElectronic.testSerPar(125);
                return null;
            }
        });
        Functions.gf().add(new Functions.Func("dBV"){

            @Override
            public Var execute(Script script, List<Var> params) {
                double v;
                if (params.size() != 1) {
                    26.invalidNumberOfParams(script, "voltage");
                }
                if ((v = params.get(0).asDouble()) < 0.0) {
                    v = 0.0;
                }
                return Var.createValue(20.0 * Math.log10(v));
            }
        });
        Functions.gf().add(new Functions.Func("dBm"){

            @Override
            public Var execute(Script script, List<Var> params) {
                double v;
                if (params.size() == 0 || params.size() > 2) {
                    27.invalidNumberOfParams(script, "value{,resistance}");
                }
                if ((v = params.get(0).asDouble()) < 0.0) {
                    v = 0.0;
                }
                if (params.size() > 1) {
                    double r = params.get(1).asDouble();
                    return Var.createValue(10.0 * Math.log10(v * v * 1000.0 / r));
                }
                return Var.createValue(10.0 * Math.log10(v * 1000.0));
            }
        });
        Functions.gf().add(new Functions.Func("rtd"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2 && params.size() != 3) {
                    28.invalidNumberOfParams(script, "type{,r0},resistance");
                }
                String type = params.get(0).asString();
                double r0 = 0.0;
                double r = 0.0;
                if (type.equalsIgnoreCase("PT100")) {
                    r0 = 100.0;
                    r = params.get(1).asDouble();
                    type = "PT";
                } else if (type.equalsIgnoreCase("PT1000")) {
                    r0 = 1000.0;
                    r = params.get(1).asDouble();
                    type = "PT";
                } else {
                    r0 = params.get(1).asDouble();
                    r = params.get(2).asDouble();
                }
                return Var.createValue(ElectronicUtils.rtdRtoT(type, r0, r));
            }
        });
        Functions.gf().add(new Functions.Func("ptcT"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2 && params.size() != 3) {
                    29.invalidNumberOfParams(script, "type,temperature{,Rref}");
                }
                String type = params.get(0).asString();
                double t = params.get(1).asDouble();
                double rref = params.size() < 3 ? -1.0 : params.get(2).asDouble();
                return Var.createValue(ElectronicUtils.ptcTtoR(type, t, rref));
            }
        });
        Functions.gf().add(new Functions.Func("ptc"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2 && params.size() != 3) {
                    30.invalidNumberOfParams(script, "type,temperature{,Rref}");
                }
                String type = params.get(0).asString();
                double r = params.get(1).asDouble();
                double rref = params.size() < 3 ? -1.0 : params.get(2).asDouble();
                return Var.createValue(ElectronicUtils.ptcRtoT(type, r, rref));
            }
        });
        Functions.gf().add(new Functions.Func("ptcTypes"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 0) {
                    31.invalidNumberOfParams(script, "No parameters");
                }
                return Var.createValue(ElectronicUtils.ptcTypes());
            }
        });
        Functions.gf().add(new Functions.Func("ptcInfo"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    32.invalidNumberOfParams(script, "Type");
                }
                return ElectronicUtils.ptcParams(params.get(0).asString()).getParams();
            }
        });
        Functions.gf().add(new Functions.Func("rtdT"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2 && params.size() != 3) {
                    33.invalidNumberOfParams(script, "type{,r0},temperature");
                }
                String type = params.get(0).asString();
                double r0 = 0.0;
                double t = 0.0;
                if (type.equalsIgnoreCase("PT100")) {
                    r0 = 100.0;
                    t = params.get(1).asDouble();
                    type = "PT";
                } else if (type.equalsIgnoreCase("PT1000")) {
                    r0 = 1000.0;
                    t = params.get(1).asDouble();
                    type = "PT";
                } else {
                    r0 = params.get(1).asDouble();
                    t = params.get(2).asDouble();
                }
                return Var.createValue(ElectronicUtils.rtdTtoR(type, r0, t));
            }
        });
        Functions.gf().add(new Functions.Func("thermocouple"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2) {
                    34.invalidNumberOfParams(script, "type,voltage");
                }
                String type = params.get(0).asString();
                double volt = params.get(1).asDouble();
                return Var.createValue(Thermocouples.thermocouple(type, volt));
            }
        });
        Functions.gf().add(new Functions.Func("thermocoupleT"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2) {
                    35.invalidNumberOfParams(script, "type,temperature");
                }
                String type = params.get(0).asString();
                double temperature = params.get(1).asDouble();
                return Var.createValue(Thermocouples.thermocouple(type, temperature));
            }
        });
        Functions.gf().add(new Functions.Func("thermocoupleInfo"){

            @Override
            public Var execute(Script script, List<Var> params) {
                String type;
                if (params.size() != 1) {
                    36.invalidNumberOfParams(script, "type");
                }
                type = (type = params.get(0).asString().trim()).length() == 0 ? "J" : type.substring(0, 1);
                Var v = Var.createStruct();
                v.addVar(Var.createValue("type", type.toUpperCase()));
                v.addVar(Var.createValue("MinTemp", Thermocouples.thermocoupleMinT(type.charAt(0))));
                v.addVar(Var.createValue("MaxTemp", Thermocouples.thermocoupleMaxT(type.charAt(0))));
                v.addVar(Var.createValue("MinVolt", Thermocouples.thermocoupleMinV(type.charAt(0))));
                v.addVar(Var.createValue("MaxVolt", Thermocouples.thermocoupleMaxV(type.charAt(0))));
                return v;
            }
        });
        Functions.gf().add(new Functions.Func("test+++"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 0) {
                    37.invalidNumberOfParams(script, "");
                }
                Thermocouples.test();
                return null;
            }
        });
        Functions.gf().add(new Functions.Func("vdivLowR"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 3) {
                    38.invalidNumberOfParams(script, "vin,highR,vout");
                }
                double vin = params.get(0).asDouble();
                double highR = params.get(1).asDouble();
                double vout = params.get(2).asDouble();
                return Var.createValue(ElectronicUtils.vdivLowR(vin, highR, vout));
            }
        });
        Functions.gf().add(new Functions.Func("vdiv"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 3 && params.size() != 4) {
                    39.invalidNumberOfParams(script, "vin,r1,r2 or series,vin,vout,current");
                }
                Var v = Var.createStruct();
                if (params.size() == 3) {
                    double vin = params.get(0).asDouble();
                    double r1 = params.get(1).asDouble();
                    double r2 = params.get(2).asDouble();
                    double[] result = ElectronicUtils.vdiv(vin, r1, r2);
                    v.addVar(Var.createValue("Vout", result[0]));
                    v.addVar(Var.createValue("current", result[1]));
                } else {
                    int series = params.get(0).asInt();
                    double vin = params.get(1).asDouble();
                    double vout = params.get(2).asDouble();
                    double current = params.get(3).asDouble();
                    double[] result = ElectronicUtils.vdiv(series, vin, vout, current);
                    v.addVar(Var.createValue("R1", result[0]));
                    v.addVar(Var.createValue("R2", result[1]));
                    v.addVar(Var.createValue("Vout", result[2]));
                    v.addVar(Var.createValue("current", result[3]));
                    v.addVar(Var.createValue("tolerance", result[4]));
                }
                return v;
            }
        });
        Functions.gf().add(new Functions.Func("vdiv2"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 4) {
                    40.invalidNumberOfParams(script, "series,vin,vout,current");
                }
                int series = params.get(0).asInt();
                double vin = params.get(1).asDouble();
                double vout = params.get(2).asDouble();
                double current = params.get(3).asDouble();
                double[] result = ElectronicUtils.vdiv2(series, vin, vout, current);
                Var v = Var.createStruct();
                v.addVar(Var.createValue("R1", result[0]));
                if (Double.isInfinite(result[2])) {
                    v.addVar(Var.createValue("R2", result[1]));
                } else {
                    v.addVar(Var.createValue("R2A", result[1]));
                    v.addVar(Var.createValue("R2B", result[2]));
                }
                v.addVar(Var.createValue("Vout", result[3]));
                v.addVar(Var.createValue("current", result[4]));
                v.addVar(Var.createValue("tolerance", result[5]));
                return v;
            }
        });
        Functions.gf().add(new Functions.Func("cpxC"){

            @Override
            public Var execute(Script script, List<Var> params) {
                switch (params.size()) {
                    case 2: {
                        return Var.createValue(ElectronicUtils.cpxC(params.get(0).asDouble(), params.get(1).asDouble()));
                    }
                    case 3: {
                        return Var.createValue(ElectronicUtils.cpxC(params.get(0).asDouble(), params.get(1).asDouble(), params.get(2).asDouble()));
                    }
                }
                41.invalidNumberOfParams(script, "freq,C,Rs");
                return null;
            }
        });
        Functions.gf().add(new Functions.Func("cpxL"){

            @Override
            public Var execute(Script script, List<Var> params) {
                switch (params.size()) {
                    case 2: {
                        return Var.createValue(ElectronicUtils.cpxL(params.get(0).asDouble(), params.get(1).asDouble()));
                    }
                    case 3: {
                        return Var.createValue(ElectronicUtils.cpxL(params.get(0).asDouble(), params.get(1).asDouble(), params.get(2).asDouble()));
                    }
                }
                42.invalidNumberOfParams(script, "freq,L,Rs");
                return null;
            }
        });
        Functions.gf().add(new Functions.Func("cpxR"){

            @Override
            public Var execute(Script script, List<Var> params) {
                switch (params.size()) {
                    case 1: {
                        return Var.createValue(ElectronicUtils.cpxR(params.get(0).asDouble()));
                    }
                }
                43.invalidNumberOfParams(script, "freq,R");
                return null;
            }
        });
        Functions.gf().add(new Functions.Func("cpxCLRs"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 4 && params.size() != 5) {
                    44.invalidNumberOfParams(script, "freq,C,L,Rs{,Rp]");
                }
                double f = params.get(0).asDouble();
                double c = params.get(1).asDouble();
                double l = params.get(2).asDouble();
                double rs = params.get(3).asDouble();
                Complex v = ElectronicUtils.cpxL(f, l, rs).add(ElectronicUtils.cpxC(f, c));
                if (params.size() == 5) {
                    double rp = params.get(4).asDouble();
                    v = ElectronicUtils.par(v, ElectronicUtils.cpxR(rp));
                }
                return Var.createValue(v);
            }
        });
        Functions.gf().add(new Functions.Func("cpxCLRp"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 4 && params.size() != 5) {
                    45.invalidNumberOfParams(script, "freq,C,L,Rs{,Rp]");
                }
                double f = params.get(0).asDouble();
                double c = params.get(1).asDouble();
                double l = params.get(2).asDouble();
                double rs = params.get(3).asDouble();
                Complex v = ElectronicUtils.par(ElectronicUtils.cpxL(f, l), ElectronicUtils.cpxC(f, c));
                if (params.size() == 5) {
                    double rp = params.get(4).asDouble();
                    v = ElectronicUtils.par(v, ElectronicUtils.cpxR(rp));
                }
                return Var.createValue(v.add(ElectronicUtils.cpxR(rs)));
            }
        });
        Functions.gf().add(new Functions.Func("cpxToQ"){

            @Override
            public Var execute(Script script, List<Var> params) {
                switch (params.size()) {
                    case 1: {
                        return Var.createValue(ElectronicUtils.cpxToQ(params.get(0).asComplex()));
                    }
                }
                46.invalidNumberOfParams(script, "complex");
                return null;
            }
        });
        Functions.gf().add(new Functions.Func("cpxToZ"){

            @Override
            public Var execute(Script script, List<Var> params) {
                switch (params.size()) {
                    case 1: {
                        return Var.createValue(ElectronicUtils.cpxToZ(params.get(0).asComplex()));
                    }
                }
                47.invalidNumberOfParams(script, "complex");
                return null;
            }
        });
        Functions.gf().add(new Functions.Func("cpxToPhase"){

            @Override
            public Var execute(Script script, List<Var> params) {
                switch (params.size()) {
                    case 1: {
                        return Var.createValue(ElectronicUtils.cpxToPhase(params.get(0).asComplex()));
                    }
                }
                48.invalidNumberOfParams(script, "complex");
                return null;
            }
        });
        Functions.gf().add(new Functions.Func("cpxToCLRs"){

            @Override
            public Var execute(Script script, List<Var> params) {
                switch (params.size()) {
                    case 2: {
                        double[] v = ElectronicUtils.cpxToCLRs(params.get(0).asDouble(), params.get(1).asComplex());
                        Var result = Var.createStruct();
                        if (v[0] != 0.0) {
                            if (v[0] < 0.0) {
                                result.addVar(Var.createValue("C", -v[0]));
                            } else {
                                result.addVar(Var.createValue("L", v[0]));
                            }
                            result.addVar(Var.createValue("Rs", v[1]));
                        } else {
                            result.addVar(Var.createValue("R", v[1]));
                        }
                        return result;
                    }
                }
                49.invalidNumberOfParams(script, "complex");
                return null;
            }
        });
        Functions.gf().add(new Functions.Func("cpxToCLRp"){

            @Override
            public Var execute(Script script, List<Var> params) {
                switch (params.size()) {
                    case 2: {
                        double[] v = ElectronicUtils.cpxToCLRp(params.get(0).asDouble(), params.get(1).asComplex());
                        Var result = Var.createStruct();
                        if (v[0] != 0.0) {
                            if (v[0] < 0.0) {
                                result.addVar(Var.createValue("C", -v[0]));
                            } else {
                                result.addVar(Var.createValue("L", v[0]));
                            }
                            result.addVar(Var.createValue("Rp", v[1]));
                        } else {
                            result.addVar(Var.createValue("R", v[1]));
                        }
                        return result;
                    }
                }
                50.invalidNumberOfParams(script, "complex");
                return null;
            }
        });
        Functions.gf().add(new Functions.Func("fft"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    51.invalidNumberOfParams(script, "inputDataArray");
                }
                Var input = params.get(0);
                double[] inputDataArray = null;
                if (input.isArray()) {
                    inputDataArray = new double[input.getSize()];
                    int i = 0;
                    while (i < input.getSize()) {
                        inputDataArray[i] = input.get(i).asDouble();
                        ++i;
                    }
                } else if (input.isVector()) {
                    inputDataArray = input.asVector().getVec();
                } else {
                    throw new ProgramExceptions.OperationNotSupportedForDataTypeException(script, "Only supported for array and vector", input);
                }
                int nn = FFT.pointsPower2(inputDataArray.length);
                inputDataArray = FFT.interpolate(nn, inputDataArray);
                Complex[] output = FFT.fft(inputDataArray);
                Var result = Var.createArray();
                int i = 0;
                while (i < output.length) {
                    Var v = Var.createValue(output[i]);
                    result.addVar(i, v);
                    ++i;
                }
                return result;
            }
        });
    }

    static void testSerPar(int series) {
        double value = 10.0;
        String s = "";
        double tol = 0.0;
        double maxTol = 0.0;
        double maxTols = 0.0;
        double maxTolp = 0.0;
        double maxTolss = 0.0;
        double delta = 1.0E-4;
        int cp = 0;
        int cs = 0;
        int css = 0;
        System.out.println("Series: " + ElectronicUtils.getSeriesName(series) + "  -------------------------------------------------------");
        NumberFormat nf = NumberFormat.getInstance(Locale.US);
        nf.setGroupingUsed(false);
        nf.setMaximumFractionDigits(2);
        do {
            double[] single = ElectronicUtils.findR(series, value);
            double[] par = ElectronicUtils.findRpar(series, value, false);
            double[] ser = ElectronicUtils.findRser(series, value, false);
            if (Math.abs(single[1]) <= Math.abs(par[2]) && Math.abs(single[1]) <= Math.abs(ser[2]) || Math.abs(single[1]) <= 1.0E-5) {
                ++css;
                s = FunctionsElectronic.formatSingle(single, "R").asString();
                tol = single[1];
            } else if (ElectronicUtils.isParBest(par, ser)) {
                ++cp;
                s = FunctionsElectronic.formatSerPar(par, "R", "Parallel").asString();
                tol = par[2];
            } else {
                s = FunctionsElectronic.formatSerPar(par, "R", "Series").asString();
                ++cs;
                tol = ser[2];
            }
            if (Math.abs(single[1]) > Math.abs(maxTolss)) {
                maxTolss = single[1];
            }
            if (Math.abs(par[2]) > Math.abs(maxTolp)) {
                maxTolp = par[2];
            }
            if (Math.abs(ser[2]) > Math.abs(maxTols)) {
                maxTols = ser[2];
            }
            if (Math.abs(tol) > Math.abs(maxTol)) {
                maxTol = tol;
            }
            if (!(Math.abs(tol) > 0.111)) continue;
            System.out.println("Single: " + StringUtil.formatDoubleEE(single[0]) + "  " + nf.format(single[1] * 100.0) + "%");
            System.out.println("Par: " + StringUtil.formatDoubleEE(par[0]) + "  " + StringUtil.formatDoubleEE(par[1]) + "  " + nf.format(par[2] * 100.0) + "%");
            System.out.println("Ser: " + StringUtil.formatDoubleEE(ser[0]) + "  " + StringUtil.formatDoubleEE(ser[1]) + "  " + nf.format(ser[2] * 100.0) + "%");
            System.out.println(String.valueOf(StringUtil.formatDoubleEE(value, false)) + "  ->  " + s);
            System.out.println();
        } while ((value += delta) <= 100.0 + delta);
        System.out.println();
        System.out.println("Worst tolerance: " + nf.format(maxTol * 100.0) + "%   Single: " + nf.format(maxTolss * 100.0) + "%  Series: " + nf.format(maxTols * 100.0) + "%    Parallel: " + nf.format(maxTolp * 100.0) + "%");
        double sum = (css + cs + cp) / 100;
        System.out.println("Topology distribution: Single: " + nf.format((double)css / sum) + "%  series: " + nf.format((double)cs / sum) + "%  parallel: " + nf.format((double)cp / sum) + "%");
        System.out.println();
    }

    static Var formatSerPar(double[] value, String component, String type) {
        Var v = Var.createStruct();
        v.addVar(Var.createValue("type", type));
        v.addVar(Var.createValue(String.valueOf(component) + "1", value[0]));
        v.addVar(Var.createValue(String.valueOf(component) + "2", value[1]));
        v.addVar(Var.createValue("tolerance", value[2]));
        return v;
    }

    static Var formatSingle(double[] value, String component) {
        Var v = Var.createStruct();
        v.addVar(Var.createValue("type", "Single"));
        v.addVar(Var.createValue(component, value[0]));
        v.addVar(Var.createValue("tolerance", value[1]));
        return v;
    }
}

