/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.script;

import dk.hkj.script.FunctionSolve;
import dk.hkj.script.FunctionsColor;
import dk.hkj.script.FunctionsElectronic;
import dk.hkj.script.FunctionsFile;
import dk.hkj.script.FunctionsMath;
import dk.hkj.script.FunctionsPopup;
import dk.hkj.script.FunctionsProbabilities;
import dk.hkj.script.FunctionsString;
import dk.hkj.script.FunctionsSumIntegrate;
import dk.hkj.script.FunctionsSystem;
import dk.hkj.script.ProgramExceptions;
import dk.hkj.script.Script;
import dk.hkj.vars.Var;
import dk.hkj.vars.VarValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Functions {
    private Map<String, Func> funcList = new HashMap<String, Func>(100);
    static Functions functions = new Functions();

    public void add(Func func) {
        this.funcList.put(func.name, func);
    }

    public void remove(String name) {
        this.funcList.remove(name);
    }

    public Func find(String name) {
        return this.funcList.get(name);
    }

    public Func get(String name, Script script) {
        Func f = this.funcList.get(name);
        if (f == null) {
            throw new ProgramExceptions.UnknownFunctionException(script, "Function " + name + " not found");
        }
        return f;
    }

    public static Functions gf() {
        return functions;
    }

    public Var execute(String name, Script script, List<Var> params) {
        Func f = this.funcList.get(name);
        if (f == null) {
            Functions.UnknownFunctionException(script, name);
        }
        return f.execute(script, params);
    }

    public static void UnknownFunctionException(Script script, String name) {
        throw new ProgramExceptions.UnknownFunctionException(script, "Function " + name + " not found");
    }

    public List<String> getFuncList() {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : this.funcList.keySet()) {
            list.add(String.valueOf(s) + "()");
        }
        list.sort(null);
        return list;
    }

    public static void removeAll() {
        Functions.functions.funcList.clear();
    }

    public static void addAll() {
        FunctionsColor.add();
        FunctionsFile.add();
        FunctionsMath.add();
        FunctionsString.add();
        FunctionsSystem.add();
        FunctionsElectronic.add();
        FunctionSolve.add();
        FunctionsSumIntegrate.add();
        FunctionsProbabilities.add();
        FunctionsPopup.add();
    }

    public static abstract class Func {
        public String name;

        public Func() {
        }

        public Func(String name) {
            this.name = name;
        }

        public static void invalidNumberOfParams(Script script, String required) {
            throw new ProgramExceptions.InvalidNumberOfParamsException(script, "Invalid number of params, requires: " + required);
        }

        public abstract Var execute(Script var1, List<Var> var2);

        public String format() {
            return "any;...";
        }
    }

    public static class FuncScript
    extends Func {
        private String definition = null;

        public FuncScript(String name, String script) {
            super(name);
            this.definition = script;
        }

        @Override
        public Var execute(Script script, List<Var> params) {
            Script s = new Script(script);
            Var p = Var.createArray("params");
            int i = 0;
            while (i < params.size()) {
                p.addVar(i, params.get(i));
                ++i;
            }
            return s.execute(this.definition, p);
        }

        @Override
        public String format() {
            return "any;...";
        }
    }

    public static class FuncScriptEmbedded
    extends Func {
        private String definition = null;

        public FuncScriptEmbedded(String name, String script) {
            super(name);
            this.definition = script;
        }

        @Override
        public Var execute(Script script, List<Var> params) {
            Script s = new Script(script);
            Var p = Var.createArray("params");
            int i = 0;
            while (i < params.size()) {
                p.addVar(i, params.get(i));
                ++i;
            }
            return Var.createValue(s.executeEmbedded(this.definition, p));
        }

        @Override
        public String format() {
            return "any;...";
        }
    }

    public static abstract class FuncVar
    extends Func {
        private Var var;

        public FuncVar(Var var) {
            this.var = var;
        }

        @Override
        public Var execute(Script script, List<Var> params) {
            return this.execute(this.var, script, params);
        }

        public abstract Var execute(Var var1, Script var2, List<Var> var3);

        @Override
        public String format() {
            return "any;...";
        }
    }

    public static abstract class FuncVarValue
    extends Func {
        private VarValue value;

        public FuncVarValue(VarValue value) {
            this.value = value;
        }

        public FuncVarValue(String name) {
            super(name);
            this.value = null;
        }

        public void setValue(VarValue value) {
            this.value = value;
        }

        @Override
        public Var execute(Script script, List<Var> params) {
            return this.execute(this.value, script, params);
        }

        public abstract Var execute(VarValue var1, Script var2, List<Var> var3);

        @Override
        public String format() {
            return "any;...";
        }
    }
}

