/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.script;

import dk.hkj.script.Functions;
import dk.hkj.script.Script;
import dk.hkj.util.Complex;
import dk.hkj.vars.Var;
import dk.hkj.vars.VarValueArray;
import java.util.List;

public class FunctionSolve {
    public static void add() {
        Functions.gf().add(new Functions.Func("solve"){

            @Override
            public Var execute(Script script, List<Var> params) {
                double max;
                if (params.size() != 3) {
                    1.invalidNumberOfParams(script, "expression,start,end");
                }
                String exp = params.get(0).asString();
                double min = params.get(1).asDouble();
                if (min > (max = params.get(2).asDouble())) {
                    double a = min;
                    min = max;
                    max = a;
                }
                Script solveScript = new Script(script);
                solveScript.getLocalVars().getCreate("x").set(min);
                double vmin = solveScript.expression(exp).asDouble();
                solveScript.getLocalVars().getCreate("x").set(max);
                double vmax = solveScript.expression(exp).asDouble();
                Var result = Var.createStruct();
                TargetFunction tf = null;
                if (vmin > 0.0 && vmax < 0.0) {
                    result.addVar(Var.createValue("type", "zero"));
                    tf = new TargetFunctionZero1();
                } else if (vmin < 0.0 && vmax > 0.0) {
                    result.addVar(Var.createValue("type", "zero"));
                    tf = new TargetFunctionZero2();
                } else {
                    solveScript.getLocalVars().getCreate("x").set((min + max) / 2.0);
                    double vmid = solveScript.expression(exp).asDouble();
                    if (vmid < vmin && vmid < vmax) {
                        result.addVar(Var.createValue("type", "min"));
                        tf = new TargetFunctionMin();
                    } else if (vmid > vmin && vmid > vmax) {
                        result.addVar(Var.createValue("type", "max"));
                        tf = new TargetFunctionMax();
                    } else {
                        result.addVar(Var.createValue("type", "none"));
                    }
                }
                if (tf != null) {
                    double x = min;
                    double y = vmin;
                    double dx = (max - min) / 4.0;
                    double dxx = (max - min) / 1.0E11;
                    int n = 0;
                    if (tf.isZero()) {
                        boolean s = false;
                        do {
                            if (tf.cont(y)) {
                                if (s) {
                                    s = false;
                                    dx /= 2.0;
                                }
                                x += dx;
                            } else {
                                if (!s) {
                                    s = true;
                                    dx /= 2.0;
                                }
                                x -= dx;
                            }
                            solveScript.getLocalVars().getCreate("x").set(x);
                            y = solveScript.expression(exp).asDouble();
                        } while (dx > dxx && ++n <= 1000);
                    } else {
                        x = (min + max) / 2.0;
                        solveScript.getLocalVars().getCreate("x").set(x);
                        y = solveScript.expression(exp).asDouble();
                        do {
                            solveScript.getLocalVars().getCreate("x").set(x + dx);
                            double y1 = solveScript.expression(exp).asDouble();
                            solveScript.getLocalVars().getCreate("x").set(x - dx);
                            double y2 = solveScript.expression(exp).asDouble();
                            if (tf.cont(y, y1)) {
                                x += dx;
                                y = y1;
                                continue;
                            }
                            if (!tf.cont(y, y2)) continue;
                            x -= dx;
                            y = y2;
                        } while ((dx /= 2.0) > dxx && ++n <= 1000);
                    }
                    if (n > 1000) {
                        result.addVar(Var.createValue("result", "failed"));
                    } else {
                        result.addVar(Var.createValue("x", x));
                        result.addVar(Var.createValue("result", y));
                    }
                }
                return result;
            }
        });
        Functions.gf().add(new Functions.Func("poly"){

            @Override
            public Var execute(Script script, List<Var> params) {
                double[] a;
                if (params.size() < 2) {
                    2.invalidNumberOfParams(script, "x,a0,a1,a2,...");
                }
                double x = params.get(0).asDouble();
                if (params.size() == 2 && params.get(1).isArray()) {
                    VarValueArray v = (VarValueArray)params.get(1).getValue();
                    a = new double[v.getSize()];
                    int i = 0;
                    while (i < v.getSize()) {
                        a[i] = v.getVar(i).asDouble();
                        ++i;
                    }
                } else {
                    a = new double[params.size() - 1];
                    int i = 0;
                    while (i < params.size() - 1) {
                        a[i] = params.get(i + 1).asDouble();
                        ++i;
                    }
                }
                double s = 0.0;
                int i = 0;
                while (i < a.length) {
                    s += a[i] * Math.pow(x, i);
                    ++i;
                }
                return Var.createValue(s);
            }
        });
        Functions.gf().add(new Functions.Func("qeq"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 3) {
                    3.invalidNumberOfParams(script, "a,b,c");
                }
                Var result = Var.createStruct();
                if (params.get(0).isComplex() || params.get(1).isComplex() || params.get(2).isComplex()) {
                    Complex a = params.get(0).asComplex();
                    Complex b = params.get(1).asComplex();
                    Complex c = params.get(2).asComplex();
                    Complex sq = b.sqr().sub(a.mult(4.0).mult(c));
                    if (a.isZero() && b.isZero()) {
                        result.addVar(Var.createValue("Failed"));
                    } else if (a.isZero()) {
                        result.addVar(Var.createValue(c.div(b.neg())));
                    } else if (sq.isZero()) {
                        result.addVar(Var.createValue(b.neg().div(2.0).div(a)));
                    } else {
                        sq = sq.sqrt();
                        result.addVar(Var.createValue(b.neg().add(sq).div(2.0).div(a)));
                        result.addVar(Var.createValue(b.neg().sub(sq).div(2.0).div(a)));
                    }
                } else {
                    double a = params.get(0).asDouble();
                    double b = params.get(1).asDouble();
                    double c = params.get(2).asDouble();
                    double sq = b * b - 4.0 * a * c;
                    if (a == 0.0 && b == 0.0) {
                        result.addVar(Var.createValue("Failed"));
                    } else if (a == 0.0) {
                        result.addVar(Var.createValue(c / -b));
                    } else if (sq < 0.0) {
                        result.addVar(Var.createValue("Failed"));
                    } else if (sq == 0.0) {
                        result.addVar(Var.createValue(-b / 2.0 / a));
                    } else {
                        sq = Math.sqrt(sq);
                        result.addVar(Var.createValue((-b + sq) / 2.0 / a));
                        result.addVar(Var.createValue((-b - sq) / 2.0 / a));
                    }
                }
                return result;
            }
        });
    }

    static abstract class TargetFunction {
        TargetFunction() {
        }

        public abstract boolean cont(double var1);

        public abstract boolean cont(double var1, double var3);

        public abstract boolean isZero();
    }

    static class TargetFunctionMax
    extends TargetFunction {
        TargetFunctionMax() {
        }

        @Override
        public boolean cont(double v) {
            return false;
        }

        @Override
        public boolean cont(double v1, double v2) {
            return v1 < v2;
        }

        @Override
        public boolean isZero() {
            return false;
        }
    }

    static class TargetFunctionMin
    extends TargetFunction {
        TargetFunctionMin() {
        }

        @Override
        public boolean cont(double v) {
            return false;
        }

        @Override
        public boolean cont(double v1, double v2) {
            return v1 > v2;
        }

        @Override
        public boolean isZero() {
            return false;
        }
    }

    static class TargetFunctionZero1
    extends TargetFunction {
        TargetFunctionZero1() {
        }

        @Override
        public boolean cont(double v) {
            return v > 0.0;
        }

        @Override
        public boolean cont(double v1, double v2) {
            return false;
        }

        @Override
        public boolean isZero() {
            return true;
        }
    }

    static class TargetFunctionZero2
    extends TargetFunction {
        TargetFunctionZero2() {
        }

        @Override
        public boolean cont(double v) {
            return v < 0.0;
        }

        @Override
        public boolean cont(double v1, double v2) {
            return false;
        }

        @Override
        public boolean isZero() {
            return true;
        }
    }
}

