/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.main.DeviceInterface;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.ValueFormat;
import dk.hkj.panels.BasicDualLargeSingleMediumPanel;
import dk.hkj.panels.BasicPanel;
import dk.hkj.vars.Var;
import java.awt.event.ActionEvent;

public class VoltCurrentPowerReadoutPanel
extends BasicDualLargeSingleMediumPanel {
    public static String panelName = "VoltCurrentPowerReadout";
    protected String device = null;
    protected int channelNo = 0;
    DeviceInterface di = null;
    private double current = 0.0;
    private double voltage = 0.0;
    private double power = 0.0;
    private boolean hasPower = false;
    private String voltageName = null;
    private String currentName = null;
    private String powerName = null;
    private ValueFormat fmtV = new ValueFormat("??", "V", ValueFormat.formatD2);
    private ValueFormat fmtC = new ValueFormat("??", "A", ValueFormat.formatD2);
    private ValueFormat fmtP = new ValueFormat("??", "W", ValueFormat.formatD2);

    public VoltCurrentPowerReadoutPanel() {
        super(1);
        this.largeLeftLabel.setToolTipText("Voltage");
        this.largeRightLabel.setToolTipText("Current");
        this.mediumLabel.setToolTipText("Power");
        this.displayLayout(this.includeName);
    }

    @Override
    public String getPanelName() {
        return panelName;
    }

    @Override
    public BasicPanel.ParamsSet getParamsSet() {
        BasicPanel.ParamsSet ps = super.getParamsSet();
        ps.nChannels = 1;
        return ps;
    }

    @Override
    public void setParams(BasicPanel.ParamsSet paramsSet) {
        super.setParams(paramsSet);
        this.setupDevice(paramsSet.channels.get(0));
    }

    @Override
    public void update() {
        if (!this.isVisible()) {
            return;
        }
        if (this.device == null) {
            super.update();
            return;
        }
        try {
            this.voltage = Var.gl.get(this.voltageName).asDouble();
            this.current = Var.gl.get(this.currentName).asDouble();
            this.power = this.hasPower ? Var.gl.get(this.powerName).asDouble() : this.voltage * this.current;
        }
        catch (Exception exception) {
            this.voltage = 0.0;
            this.current = 0.0;
            this.power = 0.0;
        }
        String currentText = String.valueOf(this.fmtC.format.formatDisplay(this.current)) + this.fmtC.unit;
        String voltageText = String.valueOf(this.fmtV.format.formatDisplay(this.voltage)) + this.fmtV.unit;
        String powerText = String.valueOf(this.fmtP.format.formatDisplay(this.power)) + this.fmtP.unit;
        this.update(this.getDeviceName(), voltageText, currentText, powerText);
    }

    @Override
    protected boolean supportReset() {
        return false;
    }

    private String stripHandle(String name) {
        int i = name.indexOf(46);
        if (i < 0) {
            return name;
        }
        return name.substring(i + 1);
    }

    protected String getDeviceName() {
        if (this.device == null) {
            return null;
        }
        if (this.channelNo > 1) {
            return String.valueOf(this.device) + ":" + this.channelNo;
        }
        return this.device;
    }

    protected void setupDevice(String handleName) {
        this.device = this.stripHandle(handleName);
        this.di = InterfaceThreads.getLoadedDeviceInterfaceHandle(handleName);
        if (this.di == null) {
            return;
        }
        int deviceChannel = 1;
        int i = handleName.indexOf(58);
        if (i > 1) {
            deviceChannel = Integer.parseInt(handleName.substring(i + 1));
        }
        this.hasPower = this.di.getIFaces().containsKey("readPower");
        this.voltageName = this.di.executeIFace("nameVoltage", deviceChannel, "").asString();
        this.currentName = this.di.executeIFace("nameCurrent", deviceChannel, "").asString();
        this.fmtV = this.di.getValueFormat(this.stripHandle(this.voltageName));
        this.fmtC = this.di.getValueFormat(this.stripHandle(this.currentName));
        if (this.hasPower) {
            this.powerName = this.di.executeIFace("namePower", deviceChannel, "").asString();
            this.fmtP = this.di.getValueFormat(this.stripHandle(this.powerName));
        }
        this.nameLabel.setText(this.getDeviceName());
        this.reset();
    }

    @Override
    protected void popupMenuAdjust() {
        this.selectMenu("Select device", "D:", this.getDeviceName(), InterfaceThreads.getDevicesHandlesWithInterface("*", "readVoltage readCurrent", true), '.', this);
        super.popupMenuAdjust();
        this.addBasicPopupMenu();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().startsWith("D:")) {
            this.setupDevice(arg0.getActionCommand().substring(2));
        }
    }

    @Override
    public boolean needData() {
        return true;
    }

    @Override
    public void reset() {
    }

    @Override
    public String generateScriptCmd() {
        StringBuilder sb = new StringBuilder();
        sb.append(panelName);
        sb.append(" ");
        sb.append(this.getDeviceName());
        sb.append(" ");
        sb.append(this.generateParams());
        sb.append(this.generateParamsColor());
        return sb.toString();
    }
}

