/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.main.CommandProcessor;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.Support;
import dk.hkj.panels.BasicButtonsPanel;
import dk.hkj.panels.BasicPanel;
import dk.hkj.panels.PopupAskValue;
import dk.hkj.util.StringUtil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.JMenuItem;

public class SystemPanel
extends BasicButtonsPanel {
    public static String panelName = "System";
    protected boolean includeCalculator = true;
    protected boolean includeTimer = true;
    protected boolean includeOutputsOff = true;
    protected Support.LongList includeLog = new Support.LongList();

    public SystemPanel() {
        this.nameLabel.setText("System");
        this.defineButtons();
    }

    @Override
    public String getPanelName() {
        return panelName;
    }

    @Override
    public BasicPanel.ParamsSet getParamsSet() {
        BasicPanel.ParamsSet ps = super.getParamsSet();
        ps.addParams(new String[]{"calc", "timer", "oo", "log"});
        return ps;
    }

    @Override
    public void setParams(BasicPanel.ParamsSet paramsSet) {
        this.includeCalculator = paramsSet.isPresent("calc");
        this.includeTimer = paramsSet.isPresent("timer");
        this.includeOutputsOff = paramsSet.isPresent("oo");
        double[] logTimes = paramsSet.getTimes("log");
        if (logTimes != null) {
            double[] dArray = logTimes;
            int n = logTimes.length;
            int n2 = 0;
            while (n2 < n) {
                double logTime = dArray[n2];
                this.includeLog.add((long)(logTime * 1000.0));
                ++n2;
            }
        }
        this.defineButtons();
        super.setParams(paramsSet);
    }

    @Override
    public void setSize(Dimension dim) {
        super.setSize(dim);
        this.displayLayout(this.includeName);
    }

    private void defineButtons() {
        this.buttons.clear();
        if (this.includeCalculator) {
            this.buttons.add(new BasicButtonsPanel.Button((BasicButtonsPanel)this, "Calc", "Calc"));
        }
        if (this.includeTimer) {
            this.buttons.add(new BasicButtonsPanel.Button((BasicButtonsPanel)this, "Timer", "Timer"));
        }
        if (this.includeOutputsOff) {
            this.buttons.add(new BasicButtonsPanel.Button((BasicButtonsPanel)this, "Outputs off", "oo"));
        }
        for (Long log : this.includeLog) {
            if (log == 0L) {
                this.buttons.add(new BasicButtonsPanel.Button((BasicButtonsPanel)this, "Log off", 0.0));
                continue;
            }
            this.buttons.add(new BasicButtonsPanel.Button((BasicButtonsPanel)this, "Log " + (double)log.longValue() / 1000.0, log.longValue()));
        }
        this.buttons.sort(null);
        this.displayLayout(this.includeName);
        this.forceFontResize();
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean needData() {
        return false;
    }

    private void doFunction(String func) {
        if (func.equalsIgnoreCase("calc")) {
            CommandProcessor.runScript("#ShowPopupSystem calculator");
        } else if (func.equals("Timer")) {
            CommandProcessor.runScript("#ShowPopupSystem timer");
        } else if (func.equals("oo")) {
            Support.paneCommand.buttonOutputOff();
        }
    }

    private void doLog(long time) {
        CommandProcessor.sysCmdLog((double)time / 1000.0, null, false);
    }

    @Override
    protected void popupMenuAdjust() {
        JMenuItem mi = null;
        mi = null;
        mi = new FontAdjust.FontCheckBoxMenuItem("Include Calculator");
        mi.setSelected(this.includeCalculator);
        mi.setActionCommand("Calc");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        mi = new FontAdjust.FontCheckBoxMenuItem("Include Timer");
        mi.setSelected(this.includeTimer);
        mi.setActionCommand("Timer");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        mi = new FontAdjust.FontCheckBoxMenuItem("Include Outputs off");
        mi.setSelected(this.includeOutputsOff);
        mi.setActionCommand("oo");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        mi = new FontAdjust.FontCheckBoxMenuItem("Include log off");
        mi.setSelected(this.includeLog.contains(0));
        mi.setActionCommand("T:0");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        mi = new FontAdjust.FontCheckBoxMenuItem("Include log 1");
        mi.setSelected(this.includeLog.contains(1000));
        mi.setActionCommand("T:1000");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Log interval");
        mi.setActionCommand("LogInterval");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        this.addBasicPopupMenu();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase("calc")) {
            this.includeCalculator = !this.includeCalculator;
            this.defineButtons();
        } else if (e.getActionCommand().equalsIgnoreCase("timer")) {
            this.includeTimer = !this.includeTimer;
            this.defineButtons();
        } else if (e.getActionCommand().equalsIgnoreCase("oo")) {
            this.includeOutputsOff = !this.includeOutputsOff;
            this.defineButtons();
        } else if (e.getActionCommand().equalsIgnoreCase("LogInterval")) {
            PopupAskValue pav = new PopupAskValue(this, "Interval", Double.NaN, 0.005, 3600.0);
            if (!Double.isNaN(pav.getValue())) {
                this.includeLog.flip((long)(pav.getValue() * 1000.0));
                this.defineButtons();
                this.displayLayout(this.includeName);
            }
        } else if (e.getActionCommand().startsWith("T:")) {
            long t = Long.parseLong(e.getActionCommand().substring(2));
            this.includeLog.flip(t);
            this.defineButtons();
        } else if (e.getActionCommand().startsWith("V:")) {
            this.doLog((long)StringUtil.parseDoubleEE(e.getActionCommand().substring(2)));
        } else if (e.getActionCommand().startsWith("F:")) {
            this.doFunction(e.getActionCommand().substring(2));
        }
    }

    @Override
    public String generateScriptCmd() {
        StringBuilder sb = new StringBuilder();
        sb.append(panelName);
        sb.append(" ");
        if (this.includeTimer) {
            sb.append("timer ");
        }
        if (this.includeCalculator) {
            sb.append("calc ");
        }
        if (this.includeOutputsOff) {
            sb.append("oo ");
        }
        if (this.includeLog.size() > 0) {
            sb.append("log");
            for (Long interval : this.includeLog) {
                sb.append(":");
                sb.append((double)interval.longValue() / 1000.0);
            }
            sb.append(" ");
        }
        sb.append(this.generateParams());
        sb.append(this.generateParamsColor());
        return sb.toString();
    }
}

