/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.main.DeviceInterface;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.ValueFormat;
import dk.hkj.panels.BasicLargeNSmallPanel;
import dk.hkj.panels.BasicPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;

public class SimpleDeviceReadoutPanel
extends BasicLargeNSmallPanel
implements ActionListener {
    public static String panelName = "SimpleDeviceReadout";
    protected String device = null;
    protected DeviceInterface di = null;

    public SimpleDeviceReadoutPanel() {
        super(0);
        this.displayLayout(this.includeName);
    }

    @Override
    public String getPanelName() {
        return panelName;
    }

    @Override
    public BasicPanel.ParamsSet getParamsSet() {
        BasicPanel.ParamsSet ps = super.getParamsSet();
        ps.nChannels = 1;
        return ps;
    }

    @Override
    public void setParams(BasicPanel.ParamsSet paramsSet) {
        super.setParams(paramsSet);
        this.device = paramsSet.channels.get(0);
        this.di = InterfaceThreads.getLoadedDeviceInterfaceHandle(this.device);
    }

    @Override
    public void update() {
        if (this.di == null || this.device == null) {
            super.update();
            return;
        }
        String c1 = String.valueOf(this.device) + "." + this.di.getValueName(0);
        ValueFormat fmt = InterfaceThreads.findValueFormat(c1);
        this.largeLabel.setToolTipText(this.device);
        double v = this.readValue(c1);
        if (!Double.isNaN(v)) {
            this.update(c1, String.valueOf(fmt.format.formatDisplay(v)) + fmt.unit);
        } else {
            this.update("---");
        }
    }

    @Override
    public void reset() {
    }

    @Override
    protected void popupMenuAdjust() {
        List<String> list = InterfaceThreads.listDeviceHandles();
        this.selectMenu("Select device", "D:", this.device, list, '.', this);
        super.popupMenuAdjust();
        this.addBasicPopupMenu();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().startsWith("D")) {
            this.device = arg0.getActionCommand().substring(2);
            this.di = InterfaceThreads.getLoadedDeviceInterfaceHandle(this.device);
            this.largeLabel.setToolTipText(this.device);
            this.reset();
        }
    }

    @Override
    public boolean needData() {
        return true;
    }

    @Override
    public String generateScriptCmd() {
        StringBuilder sb = new StringBuilder();
        sb.append(panelName);
        sb.append(" ");
        sb.append(this.device);
        sb.append(" ");
        sb.append(this.generateParams());
        sb.append(this.generateParamsColor());
        return sb.toString();
    }
}

