/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.devices.SetupFormatsAdjuster;
import dk.hkj.main.FontAdjust;
import dk.hkj.panels.BasicButtonsPanel;
import dk.hkj.panels.BasicPanel;
import dk.hkj.panels.PopupAskTripleValue;
import dk.hkj.util.StringUtil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class SetTripleParamPanel
extends BasicButtonsPanel
implements ActionListener {
    public static String panelName = "SetTripleParam";
    protected SetupFormatsAdjuster.AdjustParam param1 = null;
    protected SetupFormatsAdjuster.AdjustParam param2 = null;
    protected SetupFormatsAdjuster.AdjustParam param3 = null;
    protected List<TripleParam> params = new ArrayList<TripleParam>();

    public SetTripleParamPanel() {
        this.displayLayout(this.includeName);
    }

    @Override
    public String getPanelName() {
        return panelName;
    }

    @Override
    public BasicPanel.ParamsSet getParamsSet() {
        BasicPanel.ParamsSet ps = super.getParamsSet();
        ps.addParams(new String[]{"set"});
        ps.nChannels = 3;
        return ps;
    }

    @Override
    public void setParams(BasicPanel.ParamsSet paramsSet) {
        this.param1 = SetupFormatsAdjuster.getAdjustParam(paramsSet.channels.get(0));
        this.param2 = SetupFormatsAdjuster.getAdjustParam(paramsSet.channels.get(1));
        this.param3 = SetupFormatsAdjuster.getAdjustParam(paramsSet.channels.get(2));
        double[] vv = paramsSet.getDoubles("set");
        if (vv != null) {
            int i = 0;
            while (i < vv.length / 3) {
                this.params.add(new TripleParam(vv[i * 3], vv[i * 3 + 1], vv[i * 3 + 2]));
                ++i;
            }
        }
        this.validateButtons();
        this.forceFontResize();
        super.setParams(paramsSet);
    }

    private void validateButtons() {
        HashSet<String> titleSet = new HashSet<String>();
        titleSet.add(this.param1 != null ? this.param1.getHandle() : "");
        titleSet.add(this.param2 != null ? this.param2.getHandle() : "");
        titleSet.add(this.param3 != null ? this.param3.getHandle() : "");
        String title = "";
        for (String s : titleSet) {
            if (title.length() > 0) {
                title = String.valueOf(title) + " ";
            }
            title = String.valueOf(title) + s;
        }
        if (this.param1 == null || this.param2 == null || this.param3 == null) {
            this.nameLabel.setText("(" + title + ")");
            this.forceFontResize();
            return;
        }
        this.nameLabel.setText(title);
        this.setToolTipText("<html>" + this.param1.getName() + "<br>" + this.param2.getName() + "<br>" + this.param3.getName());
        this.nameLabel.setToolTipText(this.getToolTipText());
        this.buttons.clear();
        this.params.sort(null);
        for (TripleParam p : this.params) {
            this.buttons.add((BasicButtonsPanel)this.new BasicButtonsPanel.Button(p.toString(), p.toString()));
        }
        this.forceFontResize();
        this.displayLayout(this.includeName);
    }

    @Override
    public void reset() {
    }

    @Override
    protected void popupMenuAdjust() {
        this.selectMenu("Select param 1", "P1:", this.param1 == null ? null : this.param1.getName(), SetupFormatsAdjuster.listAdjustableParamsNames(false), ' ', this);
        this.selectMenu("Select param 2", "P2:", this.param2 == null ? null : this.param2.getName(), SetupFormatsAdjuster.listAdjustableParamsNames(false), ' ', this);
        this.selectMenu("Select param 3", "P3:", this.param3 == null ? null : this.param3.getName(), SetupFormatsAdjuster.listAdjustableParamsNames(false), ' ', this);
        FontAdjust.FontMenuItem mi = null;
        if (this.param1 != null && this.param2 != null && this.param3 != null) {
            mi = new FontAdjust.FontMenuItem("Add setting");
            mi.setActionCommand("add");
            mi.addActionListener(this);
            this.popupMenu.add(mi);
        }
        if (this.params.size() > 0) {
            ArrayList<String> list = new ArrayList<String>();
            for (TripleParam p : this.params) {
                list.add(p.toString());
            }
            this.listMenu("Remove setting", "X:", list, ' ', this);
        }
        this.addBasicPopupMenu();
    }

    private void deviceSetParam(String id) {
        TripleParam dp = null;
        for (TripleParam p : this.params) {
            if (!p.toString().equals(id)) continue;
            dp = p;
            break;
        }
        if (dp == null || this.param1 == null || this.param2 == null || this.param3 == null) {
            return;
        }
        this.param1.setParam(dp.p1, true);
        this.param2.setParam(dp.p2, true);
        this.param3.setParam(dp.p3, true);
    }

    @Override
    public void setSize(Dimension dim) {
        super.setSize(dim);
        this.displayLayout(this.includeName);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().startsWith("P1:")) {
            this.param1 = SetupFormatsAdjuster.getAdjustParam(e.getActionCommand().substring(3));
            this.validateButtons();
        } else if (e.getActionCommand().startsWith("P2:")) {
            this.param2 = SetupFormatsAdjuster.getAdjustParam(e.getActionCommand().substring(3));
            this.validateButtons();
        } else if (e.getActionCommand().startsWith("P3:")) {
            this.param3 = SetupFormatsAdjuster.getAdjustParam(e.getActionCommand().substring(3));
            this.validateButtons();
        } else if (e.getActionCommand().equals("add")) {
            PopupAskTripleValue pav = new PopupAskTripleValue(this, "Add setting", this.param1.getName(), this.param2.getName(), this.param3.getName(), this.param1.getMin(), this.param1.getMax(), this.param2.getMin(), this.param2.getMax(), this.param3.getMin(), this.param3.getMax());
            if (!Double.isNaN(pav.getValue1()) && !Double.isNaN(pav.getValue1())) {
                this.params.add(new TripleParam(pav.getValue1(), pav.getValue2(), pav.getValue3()));
                this.validateButtons();
                this.forceFontResize();
                this.displayLayout(this.includeName);
            }
        } else if (e.getActionCommand().startsWith("X:")) {
            String remove = e.getActionCommand().substring(2);
            for (TripleParam p : this.params) {
                if (!p.toString().equals(remove)) continue;
                this.params.remove(p);
                break;
            }
            this.validateButtons();
        } else if (e.getActionCommand().startsWith("F:")) {
            this.deviceSetParam(e.getActionCommand().substring(2));
        }
    }

    @Override
    public boolean needData() {
        return false;
    }

    @Override
    public String generateScriptCmd() {
        StringBuilder sb = new StringBuilder();
        sb.append(panelName);
        sb.append(" \"");
        sb.append(this.param1.getName());
        sb.append("\" \"");
        sb.append(this.param2.getName());
        sb.append("\" \"");
        sb.append(this.param3.getName());
        sb.append("\" ");
        sb.append(this.generateParams());
        if (this.params.size() > 0) {
            StringBuilder sbb = new StringBuilder();
            sbb.append("set");
            for (TripleParam p : this.params) {
                sbb.append(":");
                sbb.append(StringUtil.formatDoubleEE(p.p1, false));
                sbb.append(":");
                sbb.append(StringUtil.formatDoubleEE(p.p2, false));
                sbb.append(":");
                sbb.append(StringUtil.formatDoubleEE(p.p3, false));
            }
            if (sbb.toString().indexOf(32) >= 0) {
                sb.append("\"");
                sb.append(sbb.toString());
                sb.append("\" ");
            } else {
                sb.append(sbb.toString());
                sb.append(" ");
            }
        }
        sb.append(this.generateParamsColor());
        return sb.toString();
    }

    protected class TripleParam
    implements Comparable<TripleParam> {
        double p1;
        double p2;
        double p3;

        public TripleParam(double p1, double p2, double p3) {
            this.p1 = p1;
            this.p2 = p2;
            this.p3 = p3;
        }

        public boolean inRange() {
            return this.p1 >= SetTripleParamPanel.this.param1.getMin() && this.p1 <= SetTripleParamPanel.this.param1.getMax() && this.p2 >= SetTripleParamPanel.this.param2.getMin() && this.p2 <= SetTripleParamPanel.this.param2.getMax() && this.p3 >= SetTripleParamPanel.this.param3.getMin() && this.p3 <= SetTripleParamPanel.this.param3.getMax();
        }

        public String toString() {
            return String.valueOf(SetTripleParamPanel.this.param1 != null ? String.valueOf(StringUtil.formatDoubleEE(this.p1, false)) + SetTripleParamPanel.this.param1.getUnit() : "") + " " + (SetTripleParamPanel.this.param2 != null ? String.valueOf(StringUtil.formatDoubleEE(this.p2, false)) + SetTripleParamPanel.this.param2.getUnit() : "") + " " + (SetTripleParamPanel.this.param3 != null ? String.valueOf(StringUtil.formatDoubleEE(this.p3, false)) + SetTripleParamPanel.this.param3.getUnit() : "");
        }

        @Override
        public int compareTo(TripleParam arg0) {
            if (this.p1 > arg0.p1) {
                return 1;
            }
            if (this.p1 < arg0.p1) {
                return -1;
            }
            if (this.p2 > arg0.p2) {
                return 1;
            }
            if (this.p2 < arg0.p2) {
                return -1;
            }
            if (this.p3 > arg0.p3) {
                return 1;
            }
            if (this.p3 < arg0.p3) {
                return -1;
            }
            return 0;
        }
    }
}

