/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.comm.CommInterface;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.PopupTestInterface;
import dk.hkj.panels.BasicButtonsPanel;
import dk.hkj.panels.BasicPanel;
import dk.hkj.panels.PopupAskValue;
import dk.hkj.util.StringUtil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;

public class SetParamWithOffPanel
extends BasicButtonsPanel
implements ActionListener {
    public static String panelName = "SetParamWithOff";
    protected String channel = null;
    protected String func = null;
    protected String device = null;
    protected int deviceChannel = 0;
    protected String unit = "";
    protected boolean offWhileChanging = false;

    public SetParamWithOffPanel() {
        this.buttons.add(new BasicButtonsPanel.Button((BasicButtonsPanel)this, "off", "off"));
        this.displayLayout(this.includeName);
    }

    @Override
    public String getPanelName() {
        return panelName;
    }

    @Override
    public BasicPanel.ParamsSet getParamsSet() {
        BasicPanel.ParamsSet ps = super.getParamsSet();
        ps.addParams(new String[]{"oc", "set"});
        ps.nChannels = 2;
        return ps;
    }

    @Override
    public void setParams(BasicPanel.ParamsSet paramsSet) {
        this.splitChannel(String.valueOf(paramsSet.channels.get(0)) + " " + paramsSet.channels.get(1));
        this.offWhileChanging = paramsSet.isPresent("oc");
        double[] vv = paramsSet.getDoubles("set");
        if (vv != null) {
            double[] dArray = vv;
            int n = vv.length;
            int n2 = 0;
            while (n2 < n) {
                double v = dArray[n2];
                this.addButton(v);
                ++n2;
            }
            this.buttons.sort(null);
            this.forceFontResize();
        }
        if (this.channel != null) {
            this.nameLabel.setText(this.channel);
        }
        super.setParams(paramsSet);
    }

    private void splitChannel(String channel) {
        DeviceInterface di;
        this.channel = channel;
        int i = channel.indexOf(32);
        if (i < 0) {
            return;
        }
        this.deviceChannel = 1;
        this.device = channel.substring(0, i);
        this.func = channel.substring(i + 1);
        if (this.func.startsWith("set") || this.func.startsWith("get")) {
            this.func = this.func.substring(3);
        } else if (this.func.startsWith("read")) {
            this.func = this.func.substring(4);
        }
        if (this.device == null) {
            return;
        }
        this.nameLabel.setText(channel);
        i = this.device.indexOf(58);
        if (i > 0) {
            this.deviceChannel = Integer.parseInt(this.device.substring(i + 1));
            this.device = this.device.substring(0, i);
        }
        if ((di = InterfaceThreads.getLoadedDeviceInterfaceHandle(this.device)) != null) {
            String columnName = di.executeIFace("name" + this.func, this.deviceChannel, "").asString();
            this.unit = di.getValueFormat((String)columnName).unit;
        }
    }

    private String deviceName() {
        if (this.deviceChannel <= 1) {
            return this.device;
        }
        return String.valueOf(this.device) + ":" + this.deviceChannel;
    }

    @Override
    public void reset() {
    }

    private List<String> getChannels() {
        ArrayList<String> list = new ArrayList<String>();
        for (InterfaceThreads.DeviceThread dt : InterfaceThreads.getDevices()) {
            DeviceInterface di = dt.getDeviceInterface();
            for (String iff : di.getIFaces().keySet()) {
                if (!iff.startsWith("set") || PopupTestInterface.isTextFunction(iff) || PopupTestInterface.isOnOffFunction(iff)) continue;
                int i = 0;
                while (i < di.getIFaceChannels()) {
                    list.add(String.valueOf(di.getHandleName()) + (i == 0 ? "" : ":" + Integer.toString(i + 1)) + " " + iff.substring(3));
                    ++i;
                }
            }
        }
        list.sort(null);
        return list;
    }

    private void buildAdjustParamsMenu() {
        FontAdjust.FontMenu menu = new FontAdjust.FontMenu("Select param");
        this.popupMenu.add(menu);
        FontAdjust.FontMenu subMenu = null;
        String subMenuName = null;
        for (String pp : this.getChannels()) {
            int i;
            String handle = pp.substring(0, i = pp.indexOf(32));
            if (!handle.equals(subMenuName)) {
                subMenu = new FontAdjust.FontMenu(handle);
                menu.add(subMenu);
                subMenuName = handle;
            }
            FontAdjust.FontRadioButtonMenuItem mi = new FontAdjust.FontRadioButtonMenuItem(pp.substring(i + 1));
            if (this.channel != null && this.channel.equals(pp)) {
                mi.setSelected(true);
            }
            mi.setActionCommand("P:" + pp);
            mi.addActionListener(this);
            subMenu.add(mi);
        }
    }

    @Override
    protected void popupMenuAdjust() {
        this.selectMenu("Select param", "P:", this.channel, this.getChannels(), ' ', this);
        JMenuItem mi = null;
        if (this.channel != null) {
            mi = new FontAdjust.FontMenuItem("Add setting");
            mi.setActionCommand("add");
            mi.addActionListener(this);
            this.popupMenu.add(mi);
        }
        if (this.buttons.size() > 1) {
            mi = new FontAdjust.FontMenuItem("Remove last setting");
            mi.setActionCommand("remove");
            mi.addActionListener(this);
            this.popupMenu.add(mi);
        }
        mi = new FontAdjust.FontCheckBoxMenuItem("Off while changing");
        mi.setSelected(this.offWhileChanging);
        mi.setActionCommand("oc");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        this.addBasicPopupMenu();
    }

    @Override
    public void setSize(Dimension dim) {
        super.setSize(dim);
        this.displayLayout(this.includeName);
    }

    private void addButton(double v) {
        this.buttons.add(new BasicButtonsPanel.Button((BasicButtonsPanel)this, v, this.unit));
        this.buttons.sort(null);
    }

    private void setParam(boolean on, double v) {
        if (on) {
            DeviceInterface di = InterfaceThreads.getLoadedDeviceInterfaceHandle(this.device);
            if (di != null) {
                if (this.offWhileChanging) {
                    if (di != null) {
                        di.executeIFace("setOn", this.deviceChannel, 0.0);
                    }
                    CommInterface.sleep(100);
                }
                di.executeIFace("set" + this.func, this.deviceChannel, v);
                di.executeIFace("setOn", this.deviceChannel, 1.0);
            }
        } else {
            DeviceInterface di = InterfaceThreads.getLoadedDeviceInterfaceHandle(this.device);
            if (di != null) {
                di.executeIFace("setOn", this.deviceChannel, 0.0);
            }
        }
        InterfaceThreads.getLoadedDeviceInterfaceHandle(this.device).syncPopup();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().startsWith("P:")) {
            this.splitChannel(e.getActionCommand().substring(2));
            this.displayLayout(this.includeName);
            this.changeUnit(this.unit);
        } else if (e.getActionCommand().equals("add")) {
            PopupAskValue pav = new PopupAskValue(this, "Add setting", Double.NaN, Double.NaN, Double.NaN);
            if (!Double.isNaN(pav.getValue())) {
                this.addButton(pav.getValue());
                this.forceFontResize();
                this.displayLayout(this.includeName);
            }
        } else if (e.getActionCommand().equals("remove")) {
            if (this.buttons.size() > 1) {
                this.buttons.remove(this.buttons.size() - 1);
                this.forceFontResize();
                this.displayLayout(this.includeName);
            }
        } else if (e.getActionCommand().equals("F:off")) {
            this.setParam(false, 0.0);
        } else if (e.getActionCommand().equals("oc")) {
            this.offWhileChanging = !this.offWhileChanging;
        } else if (e.getActionCommand().startsWith("V:")) {
            this.setParam(true, StringUtil.parseDoubleEE(e.getActionCommand().substring(2)));
        }
    }

    @Override
    public boolean needData() {
        return false;
    }

    @Override
    public String generateScriptCmd() {
        StringBuilder sb = new StringBuilder();
        sb.append(panelName);
        sb.append(" ");
        sb.append(this.channel);
        sb.append(" ");
        sb.append(this.generateParams());
        sb.append(" ");
        if (this.buttons.size() > 0) {
            sb.append("set");
            for (BasicButtonsPanel.Button b : this.buttons) {
                if (b.generateParam().equalsIgnoreCase("Off")) continue;
                sb.append(":");
                sb.append(b.generateParam());
            }
            sb.append(" ");
        }
        if (this.offWhileChanging) {
            sb.append("oc ");
        }
        sb.append(this.generateParamsColor());
        return sb.toString();
    }
}

