/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.devices.SetupFormatsAdjuster;
import dk.hkj.main.FontAdjust;
import dk.hkj.panels.BasicButtonsPanel;
import dk.hkj.panels.BasicPanel;
import dk.hkj.panels.PopupAskValue;
import dk.hkj.util.StringUtil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

public class SetParamPanel
extends BasicButtonsPanel
implements ActionListener {
    public static String panelName = "SetParam";
    protected SetupFormatsAdjuster.AdjustParam param = null;

    public SetParamPanel() {
        this.displayLayout(this.includeName);
    }

    @Override
    public String getPanelName() {
        return panelName;
    }

    @Override
    public BasicPanel.ParamsSet getParamsSet() {
        BasicPanel.ParamsSet ps = super.getParamsSet();
        ps.addParams(new String[]{"set"});
        ps.nChannels = 1;
        return ps;
    }

    @Override
    public void setParams(BasicPanel.ParamsSet paramsSet) {
        this.param = SetupFormatsAdjuster.getAdjustParam(paramsSet.channels.get(0));
        double[] vv = paramsSet.getDoubles("set");
        if (vv != null) {
            double[] dArray = vv;
            int n = vv.length;
            int n2 = 0;
            while (n2 < n) {
                double v = dArray[n2];
                this.addButton(v);
                ++n2;
            }
            this.buttons.sort(null);
            this.validateButtons();
            this.forceFontResize();
        }
        if (this.param != null) {
            this.nameLabel.setText(this.param.getName());
        }
        super.setParams(paramsSet);
    }

    private void validateButtons() {
        if (this.param == null) {
            return;
        }
        double min = this.param.getMin();
        double max = this.param.getMax();
        int i = this.buttons.size() - 1;
        while (i >= 0) {
            if (((BasicButtonsPanel.Button)this.buttons.get(i)).getValue() < min || ((BasicButtonsPanel.Button)this.buttons.get(i)).getValue() > max) {
                this.buttons.remove(i);
            }
            --i;
        }
        for (BasicButtonsPanel.Button b : this.buttons) {
            b.setUnit(this.param.getUnit());
            b.generateButton();
        }
        this.displayLayout(this.includeName);
    }

    @Override
    public void reset() {
    }

    @Override
    protected void popupMenuAdjust() {
        this.selectMenu("Select param", "P:", this.param == null ? null : this.param.getName(), SetupFormatsAdjuster.listAdjustableParamsNames(false), ' ', this);
        FontAdjust.FontMenuItem mi = null;
        if (this.param != null) {
            mi = new FontAdjust.FontMenuItem("Add setting");
            mi.setActionCommand("add");
            mi.addActionListener(this);
            this.popupMenu.add(mi);
        }
        if (this.buttons.size() > 0) {
            ArrayList<String> list = new ArrayList<String>();
            for (BasicButtonsPanel.Button b : this.buttons) {
                list.add(b.getTitle());
            }
            this.listMenu("Remove setting", "X:", list, ' ', this);
        }
        this.addBasicPopupMenu();
    }

    @Override
    public void setSize(Dimension dim) {
        super.setSize(dim);
        this.displayLayout(this.includeName);
    }

    private void addButton(double v) {
        this.buttons.add(new BasicButtonsPanel.Button((BasicButtonsPanel)this, v, this.param != null ? this.param.getUnit() : ""));
        this.buttons.sort(null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().startsWith("P:")) {
            this.param = SetupFormatsAdjuster.getAdjustParam(e.getActionCommand().substring(2));
            this.nameLabel.setText(this.param.getName());
            this.validateButtons();
        } else if (e.getActionCommand().equals("add")) {
            PopupAskValue pav = new PopupAskValue(this, "Add setting", Double.NaN, this.param.getMin(), this.param.getMax());
            if (!Double.isNaN(pav.getValue())) {
                this.addButton(pav.getValue());
                this.forceFontResize();
                this.displayLayout(this.includeName);
            }
        } else if (e.getActionCommand().startsWith("X:")) {
            String remove = e.getActionCommand().substring(2);
            for (BasicButtonsPanel.Button b : this.buttons) {
                if (!b.getTitle().equals(remove)) continue;
                this.buttons.remove(b);
                break;
            }
            this.forceFontResize();
            this.displayLayout(this.includeName);
        } else if (e.getActionCommand().startsWith("V:")) {
            double v = StringUtil.parseDoubleEE(e.getActionCommand().substring(2));
            this.param.setParam(v, true);
        }
    }

    @Override
    public boolean needData() {
        return false;
    }

    @Override
    public String generateScriptCmd() {
        StringBuilder sb = new StringBuilder();
        sb.append(panelName);
        sb.append(" \"");
        sb.append(this.param.getName());
        sb.append("\" ");
        sb.append(this.generateParams());
        if (this.buttons.size() > 0) {
            StringBuilder sbb = new StringBuilder();
            sbb.append("set");
            for (BasicButtonsPanel.Button b : this.buttons) {
                sbb.append(":");
                sbb.append(b.generateParam());
            }
            if (sbb.toString().indexOf(32) >= 0) {
                sb.append("\"");
                sb.append(sbb.toString());
                sb.append("\" ");
            } else {
                sb.append(sbb.toString());
                sb.append(" ");
            }
        }
        sb.append(this.generateParamsColor());
        return sb.toString();
    }
}

