/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.comm.CommInterface;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.panels.BasicButtonsPanel;
import dk.hkj.panels.BasicPanel;
import dk.hkj.panels.PopupAskDualValue;
import dk.hkj.util.StringUtil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class SetPSVoltCurrentWithOffPanel
extends BasicButtonsPanel
implements ActionListener {
    public static String panelName = "SetPSVoltCurrentWithOff";
    protected String device = null;
    DeviceInterface di = InterfaceThreads.getLoadedDeviceInterfaceHandle(this.getDeviceOnly());
    protected boolean offWhileChanging = false;
    protected List<Setting> settings = new ArrayList<Setting>();
    protected boolean canGetVoltage = false;
    protected boolean canGetCurrent = false;
    protected boolean remoteSense = false;

    @Override
    public String getPanelName() {
        return panelName;
    }

    protected String getDeviceOnly() {
        if (this.device == null) {
            return null;
        }
        int i = this.device.indexOf(58);
        if (i <= 0) {
            return this.device;
        }
        return this.device.substring(0, i);
    }

    protected int getChannel() {
        if (this.device == null) {
            return 0;
        }
        int i = this.device.indexOf(58);
        if (i <= 0) {
            return 1;
        }
        return Integer.parseInt(this.device.substring(i + 1));
    }

    public SetPSVoltCurrentWithOffPanel() {
        this.buttons.add(new BasicButtonsPanel.Button((BasicButtonsPanel)this, "off", "off"));
        this.displayLayout(this.includeName);
    }

    @Override
    public BasicPanel.ParamsSet getParamsSet() {
        BasicPanel.ParamsSet ps = super.getParamsSet();
        ps.addParams(new String[]{"oc", "set", "remote"});
        ps.nChannels = 1;
        return ps;
    }

    private void makeButtons() {
        this.settings.sort(null);
        this.buttons.clear();
        this.buttons.add(new BasicButtonsPanel.Button((BasicButtonsPanel)this, "Off", "off"));
        int i = 0;
        while (i < this.settings.size()) {
            Setting setting = this.settings.get(i);
            this.buttons.add(new BasicButtonsPanel.Button((BasicButtonsPanel)this, setting.toString(), Integer.toString(i)));
            ++i;
        }
        this.forceFontResize();
        this.displayLayout(this.includeName);
    }

    @Override
    public void setParams(BasicPanel.ParamsSet paramsSet) {
        this.setDevice(paramsSet.channels.get(0));
        this.offWhileChanging = paramsSet.isPresent("oc");
        this.remoteSense = paramsSet.isPresent("remote");
        double[] vv = paramsSet.getDoubles("set");
        if (vv != null) {
            int i = 0;
            while (i < vv.length / 2) {
                this.settings.add(new Setting(vv[i * 2], vv[i * 2 + 1]));
                ++i;
            }
            this.makeButtons();
        }
        super.setParams(paramsSet);
    }

    @Override
    public void reset() {
    }

    @Override
    protected void popupMenuAdjust() {
        this.selectMenu("Devices", "D:", this.device, InterfaceThreads.getDevicesHandlesWithInterface("!(PS|ACPS)", "setOn setVoltage setCurrent", true), '.', this);
        JMenuItem mi = null;
        if (this.device != null) {
            mi = new FontAdjust.FontMenuItem("Add setting");
            mi.setActionCommand("add");
            mi.addActionListener(this);
            this.popupMenu.add(mi);
        }
        if (this.buttons.size() > 1) {
            ArrayList<String> list = new ArrayList<String>();
            for (Setting setting : this.settings) {
                list.add(setting.toString());
            }
            this.listMenu("Remove setting", "X:", list, ' ', this);
        }
        mi = new FontAdjust.FontCheckBoxMenuItem("Off while changing");
        mi.setSelected(this.offWhileChanging);
        mi.setActionCommand("oc");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        if (this.di != null && this.di.getIFace("setRemoteSense") != null) {
            mi = new FontAdjust.FontCheckBoxMenuItem("Remote sense");
            mi.setSelected(this.remoteSense);
            mi.setActionCommand("remote");
            mi.addActionListener(this);
            this.popupMenu.add(mi);
        }
        this.addBasicPopupMenu();
    }

    @Override
    public void setSize(Dimension dim) {
        super.setSize(dim);
        this.displayLayout(this.includeName);
    }

    private void setDevice(String device) {
        this.device = device;
        this.nameLabel.setText(device);
        this.displayLayout(this.includeName);
        this.di = InterfaceThreads.getLoadedDeviceInterfaceHandle(this.getDeviceOnly());
        this.canGetVoltage = this.di.getIFace("getVoltage") != null;
        this.canGetCurrent = this.di.getIFace("getCurrent") != null;
        this.makeButtons();
    }

    private boolean valueEquals(double v1, double v2) {
        double max = Math.max(Math.abs(v1), Math.abs(v2)) + 0.001;
        return Math.abs(v1 - v2) <= max / 100.0;
    }

    private void setParam(boolean on, Setting setting) {
        if (this.di == null) {
            return;
        }
        if (on) {
            boolean ok = true;
            if (this.offWhileChanging) {
                this.di.executeIFace("setOn", this.getChannel(), 0.0);
                CommInterface.sleep(100);
            }
            try {
                double c;
                if (this.di.getIFace("setRemoteSense") != null) {
                    this.di.executeIFace("setRemoteSense", this.getChannel(), this.remoteSense ? 1 : 0);
                }
                this.di.executeIFace("setCurrent", this.getChannel(), setting.current);
                this.di.executeIFace("setVoltage", this.getChannel(), setting.voltage);
                if (this.canGetCurrent && !this.valueEquals(c = this.di.executeIFace("getCurrent", this.getChannel(), null).asDouble(), setting.current)) {
                    ok = false;
                }
                if (this.canGetVoltage && !this.valueEquals(c = this.di.executeIFace("getVoltage", this.getChannel(), null).asDouble(), setting.voltage)) {
                    ok = false;
                }
            }
            catch (Exception exception) {
                ok = false;
            }
            if (ok) {
                this.di.executeIFace("setOn", this.getChannel(), 1.0);
            } else {
                this.di.executeIFace("setOn", this.getChannel(), 0.0);
                JOptionPane.showMessageDialog(this, "Cannot set " + setting.toString(), "Setting failed", 0);
            }
        } else {
            this.di.executeIFace("setOn", this.getChannel(), 0.0);
        }
        this.di.syncPopup();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().startsWith("D:")) {
            this.setDevice(e.getActionCommand().substring(2));
        } else if (e.getActionCommand().equals("add")) {
            PopupAskDualValue pav = new PopupAskDualValue(this, "Add setting", "Volt:", "Current:");
            if (!Double.isNaN(pav.getValue1()) && !Double.isNaN(pav.getValue2())) {
                this.settings.add(new Setting(pav.getValue1(), pav.getValue2()));
                this.makeButtons();
            }
        } else if (e.getActionCommand().startsWith("X:")) {
            String remove = e.getActionCommand().substring(2);
            for (Setting setting : this.settings) {
                if (!remove.equals(setting.toString())) continue;
                this.settings.remove(setting);
                break;
            }
            this.makeButtons();
        } else if (e.getActionCommand().equals("F:off")) {
            this.setParam(false, null);
        } else if (e.getActionCommand().equals("oc")) {
            this.offWhileChanging = !this.offWhileChanging;
        } else if (e.getActionCommand().equals("remote")) {
            this.remoteSense = !this.remoteSense;
        } else if (e.getActionCommand().startsWith("F:")) {
            int i = Integer.parseInt(e.getActionCommand().substring(2));
            this.setParam(true, this.settings.get(i));
        }
    }

    @Override
    public boolean needData() {
        return false;
    }

    @Override
    public String generateScriptCmd() {
        StringBuilder sb = new StringBuilder();
        sb.append(panelName);
        sb.append(" ");
        sb.append(this.device);
        sb.append(" ");
        sb.append(this.generateParams());
        if (this.buttons.size() > 0) {
            sb.append("set");
            for (Setting settings : this.settings) {
                sb.append(":");
                sb.append(settings.voltage);
                sb.append(":");
                sb.append(settings.current);
            }
            sb.append(" ");
        }
        if (this.offWhileChanging) {
            sb.append("oc ");
        }
        if (this.remoteSense) {
            sb.append("remote ");
        }
        sb.append(this.generateParamsColor());
        return sb.toString();
    }

    private class Setting
    implements Comparable<Setting> {
        double voltage;
        double current;

        Setting(double voltage, double current) {
            this.voltage = voltage;
            this.current = current;
        }

        public String toString() {
            return String.valueOf(StringUtil.formatDoubleEE(this.voltage, false)) + "V " + StringUtil.formatDoubleEE(this.current, false) + "A";
        }

        @Override
        public int compareTo(Setting o) {
            if (this.voltage > o.voltage) {
                return 1;
            }
            if (this.voltage < o.voltage) {
                return -1;
            }
            if (this.current > o.current) {
                return 1;
            }
            if (this.current < o.current) {
                return -1;
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Setting)) {
                return false;
            }
            return this.compareTo((Setting)o) == 0;
        }
    }
}

