/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.comm.CommInterface;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.Support;
import dk.hkj.panels.BasicButtonsPanel;
import dk.hkj.panels.BasicPanel;
import dk.hkj.panels.PopupAskValue;
import dk.hkj.util.StringUtil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class SetMultiLoadsWithOffPanel
extends BasicButtonsPanel
implements ActionListener {
    public static String panelName = "SetMultiLoadsWithOff";
    protected Support.StringListIC devices = new Support.StringListIC();
    protected double minCurrent = 1.0;
    protected boolean remoteSense = false;
    protected boolean offWhileChanging = false;

    public SetMultiLoadsWithOffPanel() {
        this.buttons.add(new BasicButtonsPanel.Button((BasicButtonsPanel)this, "off", "off"));
        this.displayLayout(this.includeName);
    }

    protected String getDeviceOnly(int no) {
        if (no >= this.devices.size()) {
            return null;
        }
        String dev = (String)this.devices.get(no);
        int i = dev.indexOf(58);
        if (i <= 0) {
            return dev;
        }
        return dev.substring(0, i);
    }

    protected int getChannel(int no) {
        if (no >= this.devices.size()) {
            return 0;
        }
        String dev = (String)this.devices.get(no);
        int i = dev.indexOf(58);
        if (i <= 0) {
            return 1;
        }
        return Integer.parseInt(dev.substring(i + 1));
    }

    @Override
    public BasicPanel.ParamsSet getParamsSet() {
        BasicPanel.ParamsSet ps = super.getParamsSet();
        ps.addParams(new String[]{"oc", "set", "min", "remote"});
        ps.nChannels = 1;
        return ps;
    }

    private void addButton(double current) {
        this.buttons.add(new BasicButtonsPanel.Button((BasicButtonsPanel)this, current, "A"));
        this.buttons.sort(null);
    }

    @Override
    public String getPanelName() {
        return panelName;
    }

    @Override
    public void setParams(BasicPanel.ParamsSet paramsSet) {
        String[] stringArray = paramsSet.channels.get(0).split("[ ]+");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String d = stringArray[n2];
            this.setDevice(d);
            ++n2;
        }
        Double v = paramsSet.getValue("min");
        if (v != null && v >= 0.001 && v <= 1000000.0) {
            this.minCurrent = v;
        }
        this.offWhileChanging = paramsSet.isPresent("oc");
        this.remoteSense = paramsSet.isPresent("remote");
        double[] vv = paramsSet.getDoubles("set");
        if (vv != null) {
            int i = 0;
            while (i < vv.length) {
                this.addButton(vv[i]);
                ++i;
            }
            this.forceFontResize();
            this.displayLayout(this.includeName);
        }
        super.setParams(paramsSet);
    }

    @Override
    public void reset() {
    }

    @Override
    protected void popupMenuAdjust() {
        JMenuItem mi = null;
        this.multiSelectMenu("Devices", "D:", this.devices, InterfaceThreads.getDevicesHandlesWithInterface("!(Load)", "setOn setCurrent", true), '.', this);
        mi = new FontAdjust.FontMenuItem("Min. current");
        mi.setToolTipText("Addition loads will not be used before current is double minium value");
        mi.setActionCommand("min");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        if (this.devices.size() > 0) {
            mi = new FontAdjust.FontMenuItem("Add setting");
            mi.setActionCommand("add");
            mi.addActionListener(this);
            this.popupMenu.add(mi);
        }
        if (this.buttons.size() > 1) {
            ArrayList<String> list = new ArrayList<String>();
            for (BasicButtonsPanel.Button b : this.buttons) {
                if (b.getTitle().equalsIgnoreCase("off")) continue;
                list.add(b.getTitle());
            }
            this.listMenu("Remove setting", "X:", list, ' ', this);
        }
        mi = new FontAdjust.FontCheckBoxMenuItem("Off while changing");
        mi.setSelected(this.offWhileChanging);
        mi.setActionCommand("oc");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        if (this.isAnyRemoteSense()) {
            mi = new FontAdjust.FontCheckBoxMenuItem("Remote sense");
            mi.setSelected(this.remoteSense);
            mi.setActionCommand("remote");
            mi.addActionListener(this);
            this.popupMenu.add(mi);
        }
        this.addBasicPopupMenu();
    }

    @Override
    public void setSize(Dimension dim) {
        super.setSize(dim);
        this.displayLayout(this.includeName);
    }

    private void setDevice(String device) {
        this.devices.flip(device);
        String s = "--empty--";
        if (this.devices.size() == 1) {
            s = (String)this.devices.get(0);
        } else if (this.devices.size() == 2) {
            s = String.valueOf((String)this.devices.get(0)) + " " + (String)this.devices.get(1);
        } else if (this.devices.size() > 2) {
            s = String.valueOf(Integer.toString(this.devices.size())) + " Loads";
        }
        this.nameLabel.setText(s);
        this.displayLayout(this.includeName);
    }

    private boolean valueEquals(double v1, double v2) {
        double max = Math.max(Math.abs(v1), Math.abs(v2)) + 0.001;
        return Math.abs(v1 - v2) <= max / 100.0;
    }

    private boolean isAnyRemoteSense() {
        int i = 0;
        while (i < this.devices.size()) {
            DeviceInterface di = InterfaceThreads.getLoadedDeviceInterfaceHandle(this.getDeviceOnly(i));
            if (di != null && di.getIFace("setRemoteSense") != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void setParam(boolean on, double current) {
        int i;
        if (this.devices.size() == 0) {
            return;
        }
        if (on) {
            DeviceInterface di;
            int i2;
            DeviceInterface di2;
            int i3;
            boolean ok = true;
            if (this.offWhileChanging) {
                i3 = 0;
                while (i3 < this.devices.size()) {
                    di2 = InterfaceThreads.getLoadedDeviceInterfaceHandle(this.getDeviceOnly(i3));
                    di2.executeIFace("setOn", this.getChannel(i3), 0.0);
                    ++i3;
                }
                CommInterface.sleep(100);
            }
            i3 = 0;
            while (i3 < this.devices.size()) {
                di2 = InterfaceThreads.getLoadedDeviceInterfaceHandle(this.getDeviceOnly(i3));
                if (di2.getIFace("setRemoteSense") != null) {
                    di2.executeIFace("setRemoteSense", this.getChannel(i3), this.remoteSense ? 1 : 0);
                }
                ++i3;
            }
            int loads = Math.min(this.devices.size(), 1 + (int)(current / this.minCurrent / 2.0));
            try {
                DeviceInterface di3;
                double cc = current / (double)loads;
                int i4 = loads;
                while (i4 < this.devices.size()) {
                    di3 = InterfaceThreads.getLoadedDeviceInterfaceHandle(this.getDeviceOnly(i4));
                    di3.executeIFace("setCurrent", this.getChannel(i4), 0.0);
                    ++i4;
                }
                i4 = 0;
                while (i4 < loads) {
                    double c;
                    di3 = InterfaceThreads.getLoadedDeviceInterfaceHandle(this.getDeviceOnly(i4));
                    di3.executeIFace("setCurrent", this.getChannel(i4), cc);
                    if (di3.getIFaces().containsKey("getCurrent") && !this.valueEquals(c = di3.executeIFace("getCurrent", this.getChannel(i4), null).asDouble(), cc)) {
                        ok = false;
                    }
                    ++i4;
                }
            }
            catch (Exception exception) {
                ok = false;
            }
            if (ok) {
                i2 = 0;
                while (i2 < this.devices.size()) {
                    di = InterfaceThreads.getLoadedDeviceInterfaceHandle(this.getDeviceOnly(i2));
                    di.executeIFace("setOn", this.getChannel(i2), i2 < loads ? 1 : 0);
                    ++i2;
                }
            } else {
                i2 = 0;
                while (i2 < this.devices.size()) {
                    di = InterfaceThreads.getLoadedDeviceInterfaceHandle(this.getDeviceOnly(i2));
                    di.executeIFace("setOn", this.getChannel(i2), 0.0);
                    ++i2;
                }
                JOptionPane.showMessageDialog(this, "Cannot set " + StringUtil.formatDoubleEE(current, false) + "A", "Setting failed", 0);
            }
        } else {
            i = 0;
            while (i < this.devices.size()) {
                DeviceInterface di = InterfaceThreads.getLoadedDeviceInterfaceHandle(this.getDeviceOnly(i));
                di.executeIFace("setOn", this.getChannel(i), 0.0);
                ++i;
            }
        }
        i = 0;
        while (i < this.devices.size()) {
            InterfaceThreads.getLoadedDeviceInterfaceHandle(this.getDeviceOnly(i)).syncPopup();
            ++i;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().startsWith("D:")) {
            this.setDevice(e.getActionCommand().substring(2));
        } else if (e.getActionCommand().equals("add")) {
            PopupAskValue pav = new PopupAskValue(this, "Add current", Double.NaN, Double.NaN, Double.NaN);
            if (!Double.isNaN(pav.getValue())) {
                this.addButton(pav.getValue());
            }
            this.forceFontResize();
            this.displayLayout(this.includeName);
        } else if (e.getActionCommand().startsWith("X:")) {
            String remove = e.getActionCommand().substring(2);
            for (BasicButtonsPanel.Button b : this.buttons) {
                if (!remove.equals(b.getTitle())) continue;
                this.buttons.remove(b);
                break;
            }
            this.forceFontResize();
            this.displayLayout(this.includeName);
        } else if (e.getActionCommand().equals("F:off")) {
            this.setParam(false, 0.0);
        } else if (e.getActionCommand().equals("min")) {
            PopupAskValue pav = new PopupAskValue(this, "Min. current in load", this.minCurrent, 0.001, 1000000.0);
            if (!Double.isNaN(pav.getValue())) {
                this.minCurrent = pav.getValue();
            }
        } else if (e.getActionCommand().equals("oc")) {
            this.offWhileChanging = !this.offWhileChanging;
        } else if (e.getActionCommand().equals("remote")) {
            this.remoteSense = !this.remoteSense;
        } else if (e.getActionCommand().startsWith("V:")) {
            this.setParam(true, StringUtil.parseDoubleEE(e.getActionCommand().substring(2)));
        }
    }

    @Override
    public boolean needData() {
        return false;
    }

    @Override
    public String generateScriptCmd() {
        StringBuilder sb = new StringBuilder();
        sb.append(panelName);
        sb.append(" \"");
        int i = 0;
        while (i < this.devices.size()) {
            sb.append((String)this.devices.get(i));
            if (i != this.devices.size() - 1) {
                sb.append(" ");
            }
            ++i;
        }
        sb.append("\" min:");
        sb.append(StringUtil.formatDoubleEE(this.minCurrent, false));
        sb.append(" ");
        if (this.remoteSense) {
            sb.append("remote ");
        }
        sb.append(this.generateParams());
        if (this.buttons.size() > 0) {
            sb.append("set");
            for (BasicButtonsPanel.Button b : this.buttons) {
                if (b.generateParam().equalsIgnoreCase("off")) continue;
                sb.append(":");
                sb.append(b.generateParam());
            }
            sb.append(" ");
        }
        if (this.offWhileChanging) {
            sb.append("oc ");
        }
        sb.append(this.generateParamsColor());
        return sb.toString();
    }
}

