/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.comm.CommInterface;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.panels.BasicButtonsPanel;
import dk.hkj.panels.BasicPanel;
import dk.hkj.panels.PopupAskDualValue;
import dk.hkj.util.StringUtil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class SetDualParamsWithOffPanel
extends BasicButtonsPanel
implements ActionListener {
    public static String panelName = "SetDualParamsWithOff";
    protected String device = null;
    DeviceInterface di = InterfaceThreads.getLoadedDeviceInterfaceHandle(this.getDeviceOnly());
    protected boolean offWhileChanging = false;
    protected List<Setting> settings = new ArrayList<Setting>();
    protected String p1name = null;
    protected String p2name = null;
    protected String p1unit = "";
    protected String p2unit = "";
    protected boolean canGetP1 = false;
    protected boolean canGetP2 = false;

    protected String getDeviceOnly() {
        if (this.device == null) {
            return null;
        }
        int i = this.device.indexOf(58);
        if (i <= 0) {
            return this.device;
        }
        return this.device.substring(0, i);
    }

    protected int getChannel() {
        if (this.device == null) {
            return 0;
        }
        int i = this.device.indexOf(58);
        if (i <= 0) {
            return 1;
        }
        return Integer.parseInt(this.device.substring(i + 1));
    }

    public SetDualParamsWithOffPanel() {
        this.buttons.add(new BasicButtonsPanel.Button((BasicButtonsPanel)this, "off", "off"));
        this.displayLayout(this.includeName);
    }

    @Override
    public String getPanelName() {
        return panelName;
    }

    @Override
    public BasicPanel.ParamsSet getParamsSet() {
        BasicPanel.ParamsSet ps = super.getParamsSet();
        ps.addParams(new String[]{"oc", "set"});
        ps.nChannels = 3;
        return ps;
    }

    private void makeButtons() {
        this.settings.sort(null);
        this.buttons.clear();
        this.buttons.add(new BasicButtonsPanel.Button((BasicButtonsPanel)this, "Off", "off"));
        int i = 0;
        while (i < this.settings.size()) {
            Setting setting = this.settings.get(i);
            this.buttons.add(new BasicButtonsPanel.Button((BasicButtonsPanel)this, setting.toString(), Integer.toString(i)));
            ++i;
        }
        this.forceFontResize();
        this.displayLayout(this.includeName);
    }

    @Override
    public void setParams(BasicPanel.ParamsSet paramsSet) {
        String d = paramsSet.channels.get(0);
        this.p1name = paramsSet.channels.get(1);
        this.p2name = paramsSet.channels.get(2);
        this.setDevice(d);
        this.offWhileChanging = paramsSet.isPresent("oc");
        double[] vv = paramsSet.getDoubles("set");
        if (vv != null) {
            int i = 0;
            while (i < vv.length / 2) {
                this.settings.add(new Setting(vv[i * 2], vv[i * 2 + 1]));
                ++i;
            }
            this.makeButtons();
        }
        super.setParams(paramsSet);
    }

    @Override
    public void reset() {
    }

    private List<String> getDeviceList() {
        ArrayList<String> list = new ArrayList<String>();
        for (String handle : InterfaceThreads.getDevicesHandlesWithInterface("*", "setOn", true)) {
            if (this.getNumericFunctions(handle, "set*").size() <= 0) continue;
            list.add(handle);
        }
        return list;
    }

    private List<String> getFunctionList(String handle) {
        ArrayList<String> list = new ArrayList<String>();
        for (String iff : this.getNumericFunctions(handle, "set*")) {
            list.add(iff.substring(3));
        }
        return list;
    }

    @Override
    protected void popupMenuAdjust() {
        this.selectMenu("Devices", "D:", this.device, this.getDeviceList(), '.', this);
        this.selectMenu("Param 1", "P1:", this.p1name, this.getFunctionList(this.device), '.', this);
        this.selectMenu("Param 2", "P2:", this.p2name, this.getFunctionList(this.device), '.', this);
        JMenuItem mi = null;
        if (this.device != null) {
            mi = new FontAdjust.FontMenuItem("Add setting");
            mi.setActionCommand("add");
            mi.addActionListener(this);
            this.popupMenu.add(mi);
        }
        if (this.buttons.size() > 1) {
            ArrayList<String> list = new ArrayList<String>();
            for (Setting setting : this.settings) {
                list.add(setting.toString());
            }
            this.listMenu("Remove setting", "X:", list, ' ', this);
        }
        mi = new FontAdjust.FontCheckBoxMenuItem("Off while changing");
        mi.setSelected(this.offWhileChanging);
        mi.setActionCommand("oc");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        this.addBasicPopupMenu();
    }

    @Override
    public void setSize(Dimension dim) {
        super.setSize(dim);
        this.displayLayout(this.includeName);
    }

    private void setDevice(String device) {
        this.device = device;
        this.nameLabel.setText(device);
        this.displayLayout(this.includeName);
        this.di = InterfaceThreads.getLoadedDeviceInterfaceHandle(this.getDeviceOnly());
        if (this.di == null || this.p1name == null || this.p2name == null) {
            return;
        }
        this.p1unit = this.getUnit(this.getDeviceOnly(), this.p1name, this.getChannel());
        this.p2unit = this.getUnit(this.getDeviceOnly(), this.p2name, this.getChannel());
        boolean bl = this.p1name == null ? false : (this.canGetP1 = this.di.getIFace("get" + this.p1name) != null);
        this.canGetP2 = this.p2name == null ? false : this.di.getIFace("get" + this.p2name) != null;
        this.makeButtons();
    }

    private boolean valueEquals(double v1, double v2) {
        double max = Math.max(Math.abs(v1), Math.abs(v2)) + 0.001;
        return Math.abs(v1 - v2) <= max / 100.0;
    }

    private void setParam(boolean on, Setting setting) {
        if (this.di == null) {
            return;
        }
        if (on) {
            boolean ok = true;
            if (this.offWhileChanging) {
                this.di.executeIFace("setOn", this.getChannel(), 0.0);
                CommInterface.sleep(100);
            }
            try {
                double c;
                this.di.executeIFace("set" + this.p1name, this.getChannel(), setting.p1);
                this.di.executeIFace("set" + this.p2name, this.getChannel(), setting.p2);
                if (this.canGetP1 && !this.valueEquals(c = this.di.executeIFace("get" + this.p1name, this.getChannel(), null).asDouble(), setting.p1)) {
                    ok = false;
                }
                if (this.canGetP2 && !this.valueEquals(c = this.di.executeIFace("get" + this.p2name, this.getChannel(), null).asDouble(), setting.p2)) {
                    ok = false;
                }
            }
            catch (Exception exception) {
                ok = false;
            }
            if (ok) {
                this.di.executeIFace("setOn", this.getChannel(), 1.0);
            } else {
                this.di.executeIFace("setOn", this.getChannel(), 0.0);
                JOptionPane.showMessageDialog(this, "Cannot set " + setting.toString(), "Setting failed", 0);
            }
        } else {
            this.di.executeIFace("setOn", this.getChannel(), 0.0);
        }
        this.di.syncPopup();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().startsWith("D:")) {
            this.setDevice(e.getActionCommand().substring(2));
        } else if (e.getActionCommand().startsWith("P1:")) {
            this.p1name = e.getActionCommand().substring(3);
            this.setDevice(this.device);
        } else if (e.getActionCommand().startsWith("P2:")) {
            this.p2name = e.getActionCommand().substring(3);
            this.setDevice(this.device);
        } else if (e.getActionCommand().equals("add")) {
            PopupAskDualValue pav = new PopupAskDualValue(this, "Add setting", String.valueOf(this.p1name) + ":", String.valueOf(this.p2name) + ":");
            if (!Double.isNaN(pav.getValue1()) && !Double.isNaN(pav.getValue2())) {
                this.settings.add(new Setting(pav.getValue1(), pav.getValue2()));
                this.makeButtons();
            }
        } else if (e.getActionCommand().startsWith("X:")) {
            String remove = e.getActionCommand().substring(2);
            for (Setting setting : this.settings) {
                if (!remove.equals(setting.toString())) continue;
                this.settings.remove(setting);
                break;
            }
            this.makeButtons();
        } else if (e.getActionCommand().equals("F:off")) {
            this.setParam(false, null);
        } else if (e.getActionCommand().equals("oc")) {
            this.offWhileChanging = !this.offWhileChanging;
        } else if (e.getActionCommand().startsWith("F:")) {
            int i = Integer.parseInt(e.getActionCommand().substring(2));
            this.setParam(true, this.settings.get(i));
        }
    }

    @Override
    public boolean needData() {
        return false;
    }

    @Override
    public String generateScriptCmd() {
        StringBuilder sb = new StringBuilder();
        sb.append(panelName);
        sb.append(" ");
        sb.append(this.device);
        sb.append(" ");
        sb.append(this.p1name);
        sb.append(" ");
        sb.append(this.p2name);
        sb.append(" ");
        sb.append(this.generateParams());
        if (this.buttons.size() > 0) {
            sb.append("set");
            for (Setting settings : this.settings) {
                sb.append(":");
                sb.append(settings.p1);
                sb.append(":");
                sb.append(settings.p2);
            }
            sb.append(" ");
        }
        if (this.offWhileChanging) {
            sb.append("oc ");
        }
        sb.append(this.generateParamsColor());
        return sb.toString();
    }

    private class Setting
    implements Comparable<Setting> {
        double p1;
        double p2;

        Setting(double p1, double p2) {
            this.p1 = p1;
            this.p2 = p2;
        }

        public String toString() {
            return String.valueOf(StringUtil.formatDoubleEE(this.p1, false)) + SetDualParamsWithOffPanel.this.p1unit + " " + StringUtil.formatDoubleEE(this.p2, false) + SetDualParamsWithOffPanel.this.p2unit;
        }

        @Override
        public int compareTo(Setting o) {
            if (this.p1 > o.p1) {
                return 1;
            }
            if (this.p1 < o.p1) {
                return -1;
            }
            if (this.p2 > o.p2) {
                return 1;
            }
            if (this.p2 < o.p2) {
                return -1;
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Setting)) {
                return false;
            }
            return this.compareTo((Setting)o) == 0;
        }
    }
}

