/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.comm.CommInterface;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.panels.BasicButtonsPanel;
import dk.hkj.panels.BasicPanel;
import dk.hkj.panels.PopupAskQuadValue;
import dk.hkj.util.StringUtil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class SetDualPSVoltCurrentWithOffPanel
extends BasicButtonsPanel
implements ActionListener {
    public static String panelName = "SetDualPSVoltCurrentWithOff";
    protected String device1 = null;
    protected String device2 = null;
    DeviceInterface di1 = null;
    DeviceInterface di2 = null;
    protected boolean offWhileChanging = false;
    protected List<Setting> settings = new ArrayList<Setting>();
    protected boolean canGetVoltage1 = false;
    protected boolean canGetCurrent1 = false;
    protected boolean canGetVoltage2 = false;
    protected boolean canGetCurrent2 = false;
    protected boolean remoteSense = false;

    @Override
    public String getPanelName() {
        return panelName;
    }

    protected String getDevice1Only() {
        if (this.device1 == null) {
            return null;
        }
        int i = this.device1.indexOf(58);
        if (i <= 0) {
            return this.device1;
        }
        return this.device1.substring(0, i);
    }

    protected int getChannel1() {
        if (this.device1 == null) {
            return 0;
        }
        int i = this.device1.indexOf(58);
        if (i <= 0) {
            return 1;
        }
        return Integer.parseInt(this.device1.substring(i + 1));
    }

    protected String getDevice2Only() {
        if (this.device2 == null) {
            return null;
        }
        int i = this.device2.indexOf(58);
        if (i <= 0) {
            return this.device2;
        }
        return this.device2.substring(0, i);
    }

    protected int getChannel2() {
        if (this.device2 == null) {
            return 0;
        }
        int i = this.device2.indexOf(58);
        if (i <= 0) {
            return 1;
        }
        return Integer.parseInt(this.device2.substring(i + 1));
    }

    public SetDualPSVoltCurrentWithOffPanel() {
        this.buttons.add(new BasicButtonsPanel.Button((BasicButtonsPanel)this, "off", "off"));
        this.displayLayout(this.includeName);
    }

    @Override
    public BasicPanel.ParamsSet getParamsSet() {
        BasicPanel.ParamsSet ps = super.getParamsSet();
        ps.addParams(new String[]{"oc", "set", "remote"});
        ps.nChannels = 2;
        return ps;
    }

    private void makeButtons() {
        this.settings.sort(null);
        this.buttons.clear();
        this.buttons.add(new BasicButtonsPanel.Button((BasicButtonsPanel)this, "Off", "off"));
        int i = 0;
        while (i < this.settings.size()) {
            Setting setting = this.settings.get(i);
            this.buttons.add(new BasicButtonsPanel.Button((BasicButtonsPanel)this, setting.toString(), Integer.toString(i)));
            ++i;
        }
        this.forceFontResize();
        this.displayLayout(this.includeName);
    }

    @Override
    public void setParams(BasicPanel.ParamsSet paramsSet) {
        this.setDevice1(paramsSet.channels.get(0));
        this.setDevice2(paramsSet.channels.get(1));
        this.offWhileChanging = paramsSet.isPresent("oc");
        this.remoteSense = paramsSet.isPresent("remote");
        double[] vv = paramsSet.getDoubles("set");
        if (vv != null) {
            int i = 0;
            while (i < vv.length / 4) {
                this.settings.add(new Setting(vv[i * 4], vv[i * 4 + 1], vv[i * 4 + 2], vv[i * 4 + 3]));
                ++i;
            }
            this.makeButtons();
        }
        super.setParams(paramsSet);
    }

    @Override
    public void reset() {
    }

    @Override
    protected void popupMenuAdjust() {
        this.selectMenu("Devices1", "D1:", this.device1, InterfaceThreads.getDevicesHandlesWithInterface("!(PS|ACPS)", "setOn setVoltage setCurrent", true), '.', this);
        this.selectMenu("Devices2", "D2:", this.device2, InterfaceThreads.getDevicesHandlesWithInterface("!(PS|ACPS)", "setOn setVoltage setCurrent", true), '.', this);
        JMenuItem mi = null;
        if (this.device1 != null && this.device2 != null) {
            mi = new FontAdjust.FontMenuItem("Add setting");
            mi.setActionCommand("add");
            mi.addActionListener(this);
            this.popupMenu.add(mi);
        }
        if (this.buttons.size() > 1) {
            ArrayList<String> list = new ArrayList<String>();
            for (Setting setting : this.settings) {
                list.add(setting.toString());
            }
            this.listMenu("Remove setting", "X:", list, ' ', this);
        }
        mi = new FontAdjust.FontCheckBoxMenuItem("Off while changing");
        mi.setSelected(this.offWhileChanging);
        mi.setActionCommand("oc");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        if (this.isAnyRemoteSense()) {
            mi = new FontAdjust.FontCheckBoxMenuItem("Remote sense");
            mi.setSelected(this.remoteSense);
            mi.setActionCommand("remote");
            mi.addActionListener(this);
            this.popupMenu.add(mi);
        }
        this.addBasicPopupMenu();
    }

    @Override
    public void setSize(Dimension dim) {
        super.setSize(dim);
        this.displayLayout(this.includeName);
    }

    private void setDevice1(String device) {
        this.device1 = device;
        this.nameLabel.setText(this.combineNames(this.device1, this.device2, '.'));
        this.displayLayout(this.includeName);
        this.di1 = InterfaceThreads.getLoadedDeviceInterfaceHandle(this.getDevice1Only());
        this.canGetVoltage1 = this.di1.getIFace("getVoltage") != null;
        this.canGetCurrent1 = this.di1.getIFace("getCurrent") != null;
        this.makeButtons();
    }

    private void setDevice2(String device) {
        this.device2 = device;
        this.nameLabel.setText(this.combineNames(this.device1, this.device2, '.'));
        this.displayLayout(this.includeName);
        this.di2 = InterfaceThreads.getLoadedDeviceInterfaceHandle(this.getDevice2Only());
        this.canGetVoltage2 = this.di2.getIFace("getVoltage") != null;
        this.canGetCurrent2 = this.di2.getIFace("getCurrent") != null;
        this.makeButtons();
    }

    private boolean valueEquals(double v1, double v2) {
        double max = Math.max(Math.abs(v1), Math.abs(v2)) + 0.001;
        return Math.abs(v1 - v2) <= max / 100.0;
    }

    private boolean isAnyRemoteSense() {
        return this.di1 != null && this.di1.getIFace("setRemoteSense") != null || this.di2 != null && this.di2.getIFace("setRemoteSense") != null;
    }

    private void setParam(boolean on, Setting setting) {
        if (this.di1 == null || this.di2 == null) {
            return;
        }
        if (on) {
            boolean ok = true;
            if (this.offWhileChanging) {
                this.di1.executeIFace("setOn", this.getChannel1(), 0.0);
                this.di2.executeIFace("setOn", this.getChannel2(), 0.0);
                CommInterface.sleep(100);
            }
            try {
                double c;
                if (this.di1.getIFace("setRemoteSense") != null) {
                    this.di1.executeIFace("setRemoteSense", this.getChannel1(), this.remoteSense ? 1 : 0);
                }
                if (this.di2.getIFace("setRemoteSense") != null) {
                    this.di2.executeIFace("setRemoteSense", this.getChannel2(), this.remoteSense ? 1 : 0);
                }
                this.di1.executeIFace("setCurrent", this.getChannel1(), setting.current1);
                this.di2.executeIFace("setCurrent", this.getChannel2(), setting.current2);
                this.di1.executeIFace("setVoltage", this.getChannel1(), setting.voltage1);
                this.di2.executeIFace("setVoltage", this.getChannel2(), setting.voltage2);
                if (this.canGetCurrent1 && !this.valueEquals(c = this.di1.executeIFace("getCurrent", this.getChannel1(), null).asDouble(), setting.current1)) {
                    ok = false;
                }
                if (this.canGetVoltage1 && !this.valueEquals(c = this.di1.executeIFace("getVoltage", this.getChannel1(), null).asDouble(), setting.voltage1)) {
                    ok = false;
                }
                if (this.canGetCurrent2 && !this.valueEquals(c = this.di2.executeIFace("getCurrent", this.getChannel2(), null).asDouble(), setting.current2)) {
                    ok = false;
                }
                if (this.canGetVoltage2 && !this.valueEquals(c = this.di2.executeIFace("getVoltage", this.getChannel2(), null).asDouble(), setting.voltage2)) {
                    ok = false;
                }
            }
            catch (Exception exception) {
                ok = false;
            }
            if (ok) {
                this.di1.executeIFace("setOn", this.getChannel1(), 1.0);
                this.di2.executeIFace("setOn", this.getChannel2(), 1.0);
            } else {
                this.di1.executeIFace("setOn", this.getChannel1(), 0.0);
                this.di2.executeIFace("setOn", this.getChannel2(), 0.0);
                JOptionPane.showMessageDialog(this, "Cannot set " + setting.toString(), "Setting failed", 0);
            }
        } else {
            this.di1.executeIFace("setOn", this.getChannel1(), 0.0);
            this.di2.executeIFace("setOn", this.getChannel2(), 0.0);
        }
        this.di1.syncPopup();
        this.di2.syncPopup();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().startsWith("D1:")) {
            this.setDevice1(e.getActionCommand().substring(3));
        } else if (e.getActionCommand().startsWith("D2:")) {
            this.setDevice2(e.getActionCommand().substring(3));
        } else if (e.getActionCommand().equals("add")) {
            PopupAskQuadValue pav = new PopupAskQuadValue(this, "Add setting", "Volt 1:", "Current 1:", "Volt 2:", "Current 2:");
            if (!(Double.isNaN(pav.getValue1()) || Double.isNaN(pav.getValue2()) || Double.isNaN(pav.getValue3()) || Double.isNaN(pav.getValue4()))) {
                this.settings.add(new Setting(pav.getValue1(), pav.getValue2(), pav.getValue3(), pav.getValue4()));
                this.makeButtons();
            }
        } else if (e.getActionCommand().startsWith("X:")) {
            String remove = e.getActionCommand().substring(2);
            for (Setting setting : this.settings) {
                if (!remove.equals(setting.toString())) continue;
                this.settings.remove(setting);
                break;
            }
            this.makeButtons();
        } else if (e.getActionCommand().equals("F:off")) {
            this.setParam(false, null);
        } else if (e.getActionCommand().equals("oc")) {
            this.offWhileChanging = !this.offWhileChanging;
        } else if (e.getActionCommand().equals("sense")) {
            this.remoteSense = !this.remoteSense;
        } else if (e.getActionCommand().startsWith("F:")) {
            int i = Integer.parseInt(e.getActionCommand().substring(2));
            this.setParam(true, this.settings.get(i));
        }
    }

    @Override
    public boolean needData() {
        return false;
    }

    @Override
    public String generateScriptCmd() {
        StringBuilder sb = new StringBuilder();
        sb.append(panelName);
        sb.append(" ");
        sb.append(this.device1);
        sb.append(" ");
        sb.append(this.device2);
        sb.append(" ");
        sb.append(this.generateParams());
        if (this.buttons.size() > 0) {
            sb.append("set");
            for (Setting settings : this.settings) {
                sb.append(":");
                sb.append(settings.voltage1);
                sb.append(":");
                sb.append(settings.current1);
                sb.append(":");
                sb.append(settings.voltage2);
                sb.append(":");
                sb.append(settings.current2);
            }
            sb.append(" ");
        }
        if (this.offWhileChanging) {
            sb.append("oc ");
        }
        if (this.remoteSense) {
            sb.append("remote ");
        }
        sb.append(this.generateParamsColor());
        return sb.toString();
    }

    private class Setting
    implements Comparable<Setting> {
        double voltage1;
        double current1;
        double voltage2;
        double current2;

        Setting(double voltage1, double current1, double voltage2, double current2) {
            this.voltage1 = voltage1;
            this.current1 = current1;
            this.voltage2 = voltage2;
            this.current2 = current2;
        }

        public String toString() {
            return String.valueOf(StringUtil.formatDoubleEE(this.voltage1, false)) + "V " + StringUtil.formatDoubleEE(this.current1, false) + "A " + StringUtil.formatDoubleEE(this.voltage2, false) + "V " + StringUtil.formatDoubleEE(this.current2, false) + "A";
        }

        @Override
        public int compareTo(Setting o) {
            if (this.voltage1 > o.voltage1) {
                return 1;
            }
            if (this.voltage1 < o.voltage1) {
                return -1;
            }
            if (this.voltage2 > o.voltage2) {
                return 1;
            }
            if (this.voltage2 < o.voltage2) {
                return -1;
            }
            if (this.current1 > o.current1) {
                return 1;
            }
            if (this.current1 < o.current1) {
                return -1;
            }
            if (this.current2 > o.current2) {
                return 1;
            }
            if (this.current2 < o.current2) {
                return -1;
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Setting)) {
                return false;
            }
            return this.compareTo((Setting)o) == 0;
        }
    }
}

