/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.main.CommandProcessor;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.Support;
import dk.hkj.panels.BasicButtonsPanel;
import dk.hkj.panels.BasicPanel;
import dk.hkj.panels.PopupAskText;
import dk.hkj.panels.PopupEditScript;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ScriptPanel
extends BasicButtonsPanel {
    public static String panelName = "Script";
    private List<ScriptEntry> scriptEntries = new ArrayList<ScriptEntry>();
    private String title = "Script";

    public ScriptPanel() {
        this.nameLabel.setText(this.title);
        this.displayLayout(this.includeName);
    }

    @Override
    public String getPanelName() {
        return panelName;
    }

    @Override
    public BasicPanel.ParamsSet getParamsSet() {
        BasicPanel.ParamsSet ps = super.getParamsSet();
        ps.addParams(new String[]{"script"});
        ps.nChannels = 1;
        return ps;
    }

    @Override
    public void setParams(BasicPanel.ParamsSet paramsSet) {
        super.setParams(paramsSet);
        for (String script : paramsSet.getAllString("script")) {
            this.scriptEntries.add(new ScriptEntry(Support.unescapeFromCommandLine(script)));
        }
        this.title = paramsSet.channels.get(0);
        this.updateButtonsLayout();
        this.nameLabel.setText(this.title);
    }

    @Override
    public void reset() {
    }

    @Override
    public void systemStateChanged() {
        this.updateButtonsLayout();
    }

    @Override
    protected void popupMenuAdjust() {
        FontAdjust.FontMenuItem mi = null;
        FontAdjust.FontMenu menu = null;
        menu = new FontAdjust.FontMenu("Add menu script");
        this.popupMenu.add(menu);
        Support.paneCommand.scriptMenu.add(menu, "M:", this);
        mi = new FontAdjust.FontMenuItem("Add file script");
        mi.setActionCommand("file");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Add direct script");
        mi.setActionCommand("direct");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        ArrayList<String> editableScripts = new ArrayList<String>();
        for (ScriptEntry se : this.scriptEntries) {
            if (!se.isDirect()) continue;
            editableScripts.add(se.getName());
        }
        if (editableScripts.size() > 0) {
            this.listMenu("Edit script", "E:", editableScripts, '\n', this);
        }
        ArrayList<String> allScripts = new ArrayList<String>();
        for (ScriptEntry se : this.scriptEntries) {
            allScripts.add(se.getName());
        }
        if (allScripts.size() > 0) {
            this.listMenu("Delete script", "X:", allScripts, '\n', this);
        }
        mi = new FontAdjust.FontMenuItem("Edit name");
        mi.setActionCommand("title");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        this.addBasicPopupMenu();
    }

    private void updateButtonsLayout() {
        this.buttons.clear();
        for (ScriptEntry se : this.scriptEntries) {
            this.buttons.add(new BasicButtonsPanel.Button(this, se.getName(), se.getName(), se.isValid()));
        }
        this.displayLayout(this.includeName);
    }

    private void addFileScript() {
        FontAdjust.FontFileChooser fileChooser = new FontAdjust.FontFileChooser();
        fileChooser.setFileFilter(new FileNameExtensionFilter("TXT", "txt"));
        fileChooser.setAcceptAllFileFilterUsed(true);
        try {
            fileChooser.setCurrentDirectory(new File(Support.getDataPath()));
        }
        catch (Exception exception) {
            System.out.println("Failed to set director: " + Support.getDataPath());
        }
        if (fileChooser.showOpenDialog(this) == 0) {
            File file = fileChooser.getSelectedFile();
            this.scriptEntries.add(new ScriptEntry(file.getAbsolutePath()));
            this.updateButtonsLayout();
        }
    }

    private void addDirectScript() {
        ScriptEntry se = new ScriptEntry("");
        new PopupEditScript(this, "Add new direct script", se);
        if (!se.getName().isEmpty() && se.getEditableScript().length() > 0) {
            this.scriptEntries.add(se);
            this.updateButtonsLayout();
        }
    }

    private ScriptEntry find(String name) {
        for (ScriptEntry se : this.scriptEntries) {
            if (!se.getName().equals(name)) continue;
            return se;
        }
        return null;
    }

    private void editDirectScript(String name) {
        ScriptEntry se = this.find(name);
        if (se == null) {
            return;
        }
        new PopupEditScript(this, "Edit direct script", se);
        this.updateButtonsLayout();
    }

    private void deleteScript(String name) {
        ScriptEntry se = this.find(name);
        if (se == null) {
            return;
        }
        this.scriptEntries.remove(se);
        this.updateButtonsLayout();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        ScriptEntry se;
        if (arg0.getActionCommand().equals("file")) {
            this.addFileScript();
        } else if (arg0.getActionCommand().equals("direct")) {
            this.addDirectScript();
        } else if (arg0.getActionCommand().equals("title")) {
            PopupAskText pat = new PopupAskText(this, "Name text", this.title, 30);
            this.title = pat.getText();
            this.nameLabel.setText(this.title);
            this.forceFontResize();
        } else if (arg0.getActionCommand().startsWith("M:")) {
            this.scriptEntries.add(new ScriptEntry(arg0.getActionCommand().substring(2)));
            this.updateButtonsLayout();
        } else if (arg0.getActionCommand().startsWith("E:")) {
            this.editDirectScript(arg0.getActionCommand().substring(2));
        } else if (arg0.getActionCommand().startsWith("X:")) {
            this.deleteScript(arg0.getActionCommand().substring(2));
        } else if (arg0.getActionCommand().startsWith("F:") && (se = this.find(arg0.getActionCommand().substring(2))) != null) {
            se.run();
        }
    }

    @Override
    public String generateScriptCmd() {
        StringBuilder sb = new StringBuilder();
        sb.append(panelName);
        sb.append(" \"");
        sb.append(this.title);
        sb.append("\" ");
        for (ScriptEntry se : this.scriptEntries) {
            String s = Support.escapeForCommandLine(se.script);
            if (s.indexOf(32) >= 0) {
                sb.append('\"');
            }
            sb.append("script:");
            sb.append(Support.escapeForCommandLine(se.script));
            if (s.indexOf(32) >= 0) {
                sb.append('\"');
            }
            sb.append(' ');
        }
        sb.append(this.generateParams());
        sb.append(this.generateParamsColor());
        return sb.toString();
    }

    static class ScriptEntry {
        private String script;

        ScriptEntry(String script) {
            this.script = script;
        }

        public void setScript(String script) {
            this.script = script;
        }

        public String getEditableScript() {
            if (this.script == null || this.script.length() == 0) {
                return "";
            }
            int i = this.script.indexOf(10);
            if (i < 0 || !this.script.matches("# *;.*(\n.*)*")) {
                return this.script;
            }
            return this.script.substring(i + 1);
        }

        public boolean isDirect() {
            return this.script.matches("#.*(\n.*)*");
        }

        public boolean isValid() {
            return CommandProcessor.isScriptValid(this.script);
        }

        public void run() {
            CommandProcessor.runNamedScriptAsync(this.script);
        }

        public String getName() {
            if (this.script.matches("# *;.*(\n.*)*")) {
                int i = this.script.indexOf(59);
                int j = this.script.indexOf(10);
                if (j < 0) {
                    j = this.script.length();
                }
                return this.script.substring(i + 1, j).trim();
            }
            if (this.script.matches("#.*(\n.*)*")) {
                return "Direct";
            }
            if (Support.paneCommand.scriptMenu.getScript(this.script, false) != null) {
                return this.script.replace(";", " ");
            }
            int i = this.script.lastIndexOf(File.separatorChar);
            String s = this.script.substring(i + 1);
            if (s.toLowerCase().endsWith(".txt")) {
                s = s.substring(0, s.length() - 4);
            }
            return s;
        }
    }
}

