/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.ValueFormat;
import dk.hkj.panels.BasicLargeNSmallPanel;
import dk.hkj.panels.BasicPanel;
import java.awt.event.ActionEvent;

public class ReadoutPanel
extends BasicLargeNSmallPanel {
    public static String panelName = "Readout";
    protected String channel = null;
    protected double min = Double.MAX_VALUE;
    protected double max = -1.7976931348623157E308;
    protected double currentValue = Double.NaN;
    protected ValueFormat fmt = new ValueFormat("??", "", ValueFormat.formatD2);

    public ReadoutPanel() {
        super(1);
        this.small1LeftLabel.setToolTipText("Minimum");
        this.small1RightLabel.setToolTipText("Maximum");
        this.displayLayout(this.includeName);
    }

    @Override
    public String getPanelName() {
        return panelName;
    }

    @Override
    public BasicPanel.ParamsSet getParamsSet() {
        BasicPanel.ParamsSet ps = super.getParamsSet();
        ps.nChannels = 1;
        return ps;
    }

    @Override
    public void setParams(BasicPanel.ParamsSet paramsSet) {
        super.setParams(paramsSet);
        this.channel = paramsSet.channels.get(0);
        this.fmt = InterfaceThreads.findValueFormat(this.channel);
        this.largeLabel.setToolTipText(this.channel);
    }

    @Override
    public void update() {
        if (!this.isVisible()) {
            return;
        }
        if (this.channel == null) {
            super.update();
            return;
        }
        double v = this.readValue(this.channel);
        if (!Double.isNaN(v)) {
            this.currentValue = v;
            if (this.currentValue > this.max) {
                this.max = this.currentValue;
            }
            if (this.currentValue < this.min) {
                this.min = this.currentValue;
            }
            this.update(this.channel, String.valueOf(this.fmt.format.formatDisplay(this.currentValue)) + this.fmt.unit, "Min:" + this.fmt.format.formatDisplay(this.min), "Max:" + this.fmt.format.formatDisplay(this.max));
        }
    }

    @Override
    public void reset() {
        this.min = Double.MAX_VALUE;
        this.max = -1.7976931348623157E308;
    }

    @Override
    protected boolean supportReset() {
        return true;
    }

    @Override
    protected void popupMenuAdjust() {
        this.selectMenu("Select channel", "C:", this.channel, InterfaceThreads.listChannels(true, "*"), '.', this);
        super.popupMenuAdjust();
        this.addBasicPopupMenu();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().startsWith("C:")) {
            this.channel = arg0.getActionCommand().substring(2);
            this.fmt = InterfaceThreads.findValueFormat(this.channel);
            this.largeLabel.setToolTipText(this.channel);
            this.reset();
        }
    }

    @Override
    public boolean needData() {
        return true;
    }

    @Override
    public String generateScriptCmd() {
        StringBuilder sb = new StringBuilder();
        sb.append(panelName);
        sb.append(" ");
        sb.append(this.channel);
        sb.append(" ");
        sb.append(this.generateParams());
        sb.append(this.generateParamsColor());
        return sb.toString();
    }
}

