/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.main.FontAdjust;
import dk.hkj.main.PopupBase;
import dk.hkj.main.Support;
import dk.hkj.util.StringUtil;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class PopupAskValue
extends PopupBase
implements ActionListener {
    private double min;
    private double max;
    private JTextField entryTextField = null;
    private double value = Double.NaN;
    private boolean intOnly = false;

    public PopupAskValue(JComponent base, String title, double value, double min, double max) {
        this.init(base, title, value, min, max);
    }

    public PopupAskValue(JComponent base, String title, double value, double min, double max, boolean intOnly) {
        this.intOnly = intOnly;
        this.init(base, title, value, min, max);
    }

    private void init(JComponent base, String title, double value, double min, double max) {
        this.min = min;
        this.max = max;
        this.setTitle(title);
        this.setDefaultCloseOperation(2);
        this.definePopupName(title.replace(" ", ""), false);
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.setLayout(new FlowLayout(1, 20, 10));
        this.entryTextField = new FontAdjust.FontTextField(6);
        this.add(this.entryTextField);
        if (!Double.isNaN(value)) {
            this.entryTextField.setText(StringUtil.formatDoubleEE(value, false));
        }
        this.entryTextField.setActionCommand("enter");
        this.entryTextField.addActionListener(this);
        if (!Double.isNaN(min) && !Double.isNaN(max)) {
            this.add(new FontAdjust.FontLabel(String.valueOf(StringUtil.formatDoubleEE(min)) + " - " + StringUtil.formatDoubleEE(max)));
        }
        Point p = base.getLocationOnScreen();
        this.setLocation(p.x + base.getWidth() / 2, p.y);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().equals("enter")) {
            if (this.intOnly) {
                try {
                    long v = Long.parseLong(this.entryTextField.getText());
                    if ((double)v >= this.min && (double)v <= this.max) {
                        this.value = v;
                        this.setVisible(false);
                    }
                }
                catch (Exception exception) {}
            } else {
                double v = StringUtil.parseDoubleEE(this.entryTextField.getText());
                if (!Double.isNaN(v) && (Double.isNaN(this.min) || Double.isNaN(this.max) || v >= this.min && v <= this.max)) {
                    this.value = v;
                    this.setVisible(false);
                }
            }
            this.entryTextField.setBackground(Support.colorScheme.errorBackground);
        }
    }

    public double getValue() {
        return this.value;
    }
}

