/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.main.FontAdjust;
import dk.hkj.main.PopupBase;
import dk.hkj.main.Support;
import dk.hkj.util.StringUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class PopupAskTripleValue
extends PopupBase
implements ActionListener,
FocusListener {
    private JTextField entry1TextField = null;
    private JTextField entry2TextField = null;
    private JTextField entry3TextField = null;
    private double value1 = Double.NaN;
    private double value2 = Double.NaN;
    private double value3 = Double.NaN;
    private double min1 = Double.NaN;
    private double max1 = Double.NaN;
    private double min2 = Double.NaN;
    private double max2 = Double.NaN;
    private double min3 = Double.NaN;
    private double max3 = Double.NaN;
    private boolean ok1 = false;
    private boolean ok2 = false;
    private boolean ok3 = false;

    public PopupAskTripleValue(JComponent base, String title, String v1, String v2, String v3) {
        this.init(base, title, v1, v2, v3, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN);
    }

    public PopupAskTripleValue(JComponent base, String title, String v1, String v2, String v3, double min1, double max1, double min2, double max2, double min3, double max3) {
        this.init(base, title, v1, v2, v3, min1, max1, min2, max2, min3, max3);
    }

    private void init(JComponent base, String title, String v1, String v2, String v3, double min1, double max1, double min2, double max2, double min3, double max3) {
        this.min1 = min1;
        this.max1 = max1;
        this.min2 = min2;
        this.max2 = max2;
        this.min3 = min3;
        this.max3 = max3;
        this.setTitle(title);
        this.setDefaultCloseOperation(2);
        this.definePopupName(title.replace(" ", ""), false);
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.anchor = 13;
        c.insets = new Insets(2, 5, 2, 5);
        FontAdjust.FontLabel label = new FontAdjust.FontLabel(v1);
        this.add((Component)label, c);
        c.gridx = 1;
        c.gridy = 0;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(2, 5, 2, 5);
        this.entry1TextField = new FontAdjust.FontTextField(6);
        this.entry1TextField.addActionListener(this);
        this.entry1TextField.addFocusListener(this);
        this.add((Component)this.entry1TextField, c);
        if (!Double.isNaN(min1) && !Double.isNaN(max1)) {
            c.gridx = 2;
            c.gridy = 0;
            c.fill = 2;
            c.anchor = 10;
            c.insets = new Insets(2, 5, 2, 5);
            this.add((Component)new FontAdjust.FontLabel(String.valueOf(StringUtil.formatDoubleEE(min1)) + " - " + StringUtil.formatDoubleEE(max1)), c);
        }
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 2;
        c.anchor = 13;
        c.insets = new Insets(2, 5, 2, 5);
        label = new FontAdjust.FontLabel(v2);
        this.add((Component)label, c);
        c.gridx = 1;
        c.gridy = 1;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(2, 5, 2, 5);
        this.entry2TextField = new FontAdjust.FontTextField(6);
        this.entry2TextField.addActionListener(this);
        this.entry2TextField.addFocusListener(this);
        this.add((Component)this.entry2TextField, c);
        if (!Double.isNaN(min2) && !Double.isNaN(max2)) {
            c.gridx = 2;
            c.gridy = 1;
            c.fill = 2;
            c.anchor = 10;
            c.insets = new Insets(2, 5, 2, 5);
            this.add((Component)new FontAdjust.FontLabel(String.valueOf(StringUtil.formatDoubleEE(min2)) + " - " + StringUtil.formatDoubleEE(max2)), c);
        }
        c.gridx = 0;
        c.gridy = 2;
        c.fill = 2;
        c.anchor = 13;
        c.insets = new Insets(2, 5, 2, 5);
        label = new FontAdjust.FontLabel(v3);
        this.add((Component)label, c);
        c.gridx = 1;
        c.gridy = 2;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(2, 5, 2, 5);
        this.entry3TextField = new FontAdjust.FontTextField(6);
        this.entry3TextField.addActionListener(this);
        this.entry3TextField.addFocusListener(this);
        this.add((Component)this.entry3TextField, c);
        if (!Double.isNaN(min3) && !Double.isNaN(max3)) {
            c.gridx = 2;
            c.gridy = 2;
            c.fill = 2;
            c.anchor = 10;
            c.insets = new Insets(2, 5, 2, 5);
            this.add((Component)new FontAdjust.FontLabel(String.valueOf(StringUtil.formatDoubleEE(min3)) + " - " + StringUtil.formatDoubleEE(max3)), c);
        }
        Point p = base.getLocationOnScreen();
        this.setLocation(p.x + base.getWidth() / 2, p.y);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.checkFields();
        if (this.ok1 && this.ok2 && this.ok3) {
            this.setVisible(false);
        }
    }

    public double getValue1() {
        return this.value1;
    }

    public double getValue2() {
        return this.value2;
    }

    public double getValue3() {
        return this.value3;
    }

    private void checkFields() {
        this.value1 = StringUtil.parseDoubleEE(this.entry1TextField.getText());
        this.value2 = StringUtil.parseDoubleEE(this.entry2TextField.getText());
        this.value3 = StringUtil.parseDoubleEE(this.entry3TextField.getText());
        this.ok1 = !Double.isNaN(this.value1);
        this.ok2 = !Double.isNaN(this.value2);
        boolean bl = this.ok3 = !Double.isNaN(this.value3);
        if (this.value1 < this.min1 || this.value1 > this.max1) {
            this.ok1 = false;
        }
        if (this.value2 < this.min2 || this.value2 > this.max2) {
            this.ok2 = false;
        }
        if (this.value3 < this.min3 || this.value3 > this.max3) {
            this.ok3 = false;
        }
        this.entry1TextField.setBackground(this.ok1 ? Support.colorScheme.textBackground : Support.colorScheme.errorBackground);
        this.entry2TextField.setBackground(this.ok2 ? Support.colorScheme.textBackground : Support.colorScheme.errorBackground);
        this.entry3TextField.setBackground(this.ok3 ? Support.colorScheme.textBackground : Support.colorScheme.errorBackground);
    }

    @Override
    public void focusGained(FocusEvent arg0) {
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        this.checkFields();
    }
}

