/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.main.FontAdjust;
import dk.hkj.main.PopupBase;
import dk.hkj.main.Support;
import dk.hkj.util.StringUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class PopupAskDualValue
extends PopupBase
implements ActionListener,
FocusListener {
    private JTextField entry1TextField = null;
    private JTextField entry2TextField = null;
    private double value1 = Double.NaN;
    private double value2 = Double.NaN;
    private double refValue1 = Double.NaN;
    private double refValue2 = Double.NaN;
    private boolean v2AboveV1 = false;
    private double min1 = Double.NaN;
    private double max1 = Double.NaN;
    private double min2 = Double.NaN;
    private double max2 = Double.NaN;
    private boolean ok1 = false;
    private boolean ok2 = false;

    public PopupAskDualValue(JComponent base, String title, String v1, String v2) {
        this.init(base, title, v1, v2, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN);
    }

    public PopupAskDualValue(JComponent base, String title, String v1, String v2, double v1v, double v2v) {
        this.init(base, title, v1, v2, v1v, v2v, Double.NaN, Double.NaN, Double.NaN, Double.NaN);
    }

    public PopupAskDualValue(JComponent base, String title, String v1, String v2, double v1v, double v2v, boolean v2AboveV1) {
        this.v2AboveV1 = true;
        this.init(base, title, v1, v2, v1v, v2v, Double.NaN, Double.NaN, Double.NaN, Double.NaN);
    }

    public PopupAskDualValue(JComponent base, String title, String v1, String v2, double v1v, double v2v, double min1, double max1, double min2, double max2) {
        this.v2AboveV1 = false;
        this.init(base, title, v1, v2, v1v, v2v, min1, max1, min2, max2);
    }

    public PopupAskDualValue(JComponent base, String title, String v1, String v2, double v1v, double v2v, double min1, double max1, double min2, double max2, boolean v2AboveV1) {
        this.v2AboveV1 = v2AboveV1;
        this.init(base, title, v1, v2, v1v, v2v, min1, max1, min2, max2);
    }

    private void init(JComponent base, String title, String v1, String v2, double v1v, double v2v, double min1, double max1, double min2, double max2) {
        this.setTitle(title);
        this.setDefaultCloseOperation(2);
        this.definePopupName(title.replace(" ", ""), false);
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.refValue1 = v1v;
        this.refValue2 = v2v;
        this.min1 = min1;
        this.max1 = max1;
        this.min2 = min2;
        this.max2 = max2;
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.anchor = 13;
        c.insets = new Insets(2, 5, 2, 5);
        FontAdjust.FontLabel label = new FontAdjust.FontLabel(v1);
        this.add((Component)label, c);
        c.gridx = 1;
        c.gridy = 0;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(2, 5, 2, 5);
        this.entry1TextField = new FontAdjust.FontTextField(6);
        if (!Double.isNaN(v1v)) {
            this.entry1TextField.setText(StringUtil.formatDoubleEE(v1v, false));
        }
        this.entry1TextField.addActionListener(this);
        this.entry1TextField.addFocusListener(this);
        this.add((Component)this.entry1TextField, c);
        if (!Double.isNaN(min1) && !Double.isNaN(max1)) {
            c.gridx = 2;
            c.gridy = 0;
            c.fill = 2;
            c.anchor = 10;
            c.insets = new Insets(2, 5, 2, 5);
            this.add((Component)new FontAdjust.FontLabel(String.valueOf(StringUtil.formatDoubleEE(min1)) + " - " + StringUtil.formatDoubleEE(max1)), c);
        }
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 2;
        c.anchor = 13;
        c.insets = new Insets(2, 5, 2, 5);
        label = new FontAdjust.FontLabel(v2);
        this.add((Component)label, c);
        c.gridx = 1;
        c.gridy = 1;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(2, 5, 2, 5);
        this.entry2TextField = new FontAdjust.FontTextField(6);
        if (!Double.isNaN(v2v)) {
            this.entry2TextField.setText(StringUtil.formatDoubleEE(v2v, false));
        }
        this.entry2TextField.addActionListener(this);
        this.entry2TextField.addFocusListener(this);
        this.add((Component)this.entry2TextField, c);
        if (!Double.isNaN(min2) && !Double.isNaN(max2)) {
            c.gridx = 2;
            c.gridy = 1;
            c.fill = 2;
            c.anchor = 10;
            c.insets = new Insets(2, 5, 2, 5);
            this.add((Component)new FontAdjust.FontLabel(String.valueOf(StringUtil.formatDoubleEE(min2)) + " - " + StringUtil.formatDoubleEE(max2)), c);
        }
        Point p = base.getLocationOnScreen();
        this.setLocation(p.x + base.getWidth() / 2, p.y);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.checkFields();
        if (this.ok1 && this.ok2) {
            this.setVisible(false);
        }
    }

    public double getValue1() {
        return this.ok1 ? this.value1 : this.refValue1;
    }

    public double getValue2() {
        return this.ok2 ? this.value2 : this.refValue2;
    }

    private void checkFields() {
        this.value1 = StringUtil.parseDoubleEE(this.entry1TextField.getText());
        this.value2 = StringUtil.parseDoubleEE(this.entry2TextField.getText());
        this.ok1 = !Double.isNaN(this.value1);
        boolean bl = this.ok2 = !Double.isNaN(this.value2);
        if (this.v2AboveV1 && this.value1 >= this.value2) {
            this.ok1 = false;
            this.ok2 = false;
        }
        if (this.value1 < this.min1 || this.value1 > this.max1) {
            this.ok1 = false;
        }
        if (this.value2 < this.min2 || this.value2 > this.max2) {
            this.ok2 = false;
        }
        this.entry1TextField.setBackground(this.ok1 ? Support.colorScheme.textBackground : Support.colorScheme.errorBackground);
        this.entry2TextField.setBackground(this.ok2 ? Support.colorScheme.textBackground : Support.colorScheme.errorBackground);
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        ((JTextField)arg0.getSource()).selectAll();
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        this.checkFields();
    }
}

