/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.main.InterfaceThreads;
import dk.hkj.panels.BasicPSLoadReadoutPanel;
import dk.hkj.panels.BasicPanel;
import java.awt.event.ActionEvent;

public class PSLoadReadoutPanel
extends BasicPSLoadReadoutPanel {
    public static String panelName = "PSLoadReadout";

    public PSLoadReadoutPanel() {
        this.small1LeftLabel.setToolTipText("Voltage");
        this.small1RightLabel.setToolTipText("Power");
        this.small2LeftLabel.setToolTipText("Capacity");
        this.small2RightLabel.setToolTipText("Energy");
        this.displayLayout(this.includeName);
    }

    @Override
    public String getPanelName() {
        return panelName;
    }

    @Override
    public BasicPanel.ParamsSet getParamsSet() {
        BasicPanel.ParamsSet ps = super.getParamsSet();
        ps.nChannels = 1;
        return ps;
    }

    @Override
    public void setParams(BasicPanel.ParamsSet paramsSet) {
        super.setParams(paramsSet);
        this.setDevice(paramsSet.channels.get(0));
    }

    @Override
    protected void popupMenuAdjust() {
        this.selectMenu("Select device", "D:", this.getNameString(), InterfaceThreads.getDevicesHandlesWithInterface("!(?i)(ps|load)(:[0-9]+)?", "readVoltage readCurrent", true), '.', this);
        super.popupMenuAdjust();
        this.addBasicPopupMenu();
    }

    private void setDevice(String name) {
        this.loadDevices.clear();
        this.loadDevices.add(new BasicPSLoadReadoutPanel.LoadDevice(name));
        this.nameLabel.setText(this.getNameString());
        this.largeLabel.setToolTipText(this.getNameString());
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().startsWith("D:")) {
            this.setDevice(arg0.getActionCommand().substring(2));
            this.setDeviceType();
            this.reset();
        }
    }

    @Override
    public String generateScriptCmd() {
        StringBuilder sb = new StringBuilder();
        sb.append(panelName);
        sb.append(" ");
        sb.append(((BasicPSLoadReadoutPanel.LoadDevice)this.loadDevices.get(0)).getHandle() == null ? "?" : ((BasicPSLoadReadoutPanel.LoadDevice)this.loadDevices.get(0)).getHandle());
        sb.append(" ");
        sb.append(this.generateParams());
        sb.append(this.generateParamsColor());
        return sb.toString();
    }
}

