/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.main.DeviceInterface;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.panels.BasicDualButtonPanel;
import dk.hkj.panels.BasicPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class OnOffPanel
extends BasicDualButtonPanel
implements ActionListener {
    public static String panelName = "OnOff";
    protected String device = null;
    protected int deviceChannel = 1;

    public OnOffPanel() {
        this.firstButton.setText("On");
        this.secondButton.setText("Off");
    }

    @Override
    public String getPanelName() {
        return panelName;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        DeviceInterface di;
        if (arg0.getActionCommand().startsWith("D:")) {
            this.splitDevice(arg0.getActionCommand().substring(2));
            this.nameLabel.setText(this.deviceName());
            this.displayLayout(this.includeName);
        } else if (arg0.getActionCommand().equals("firstButton")) {
            DeviceInterface di2 = InterfaceThreads.getLoadedDeviceInterfaceHandle(this.device);
            if (di2 != null) {
                di2.executeIFace("setOn", this.deviceChannel, 1.0);
                di2.syncPopup();
            }
        } else if (arg0.getActionCommand().equals("secondButton") && (di = InterfaceThreads.getLoadedDeviceInterfaceHandle(this.device)) != null) {
            di.executeIFace("setOn", this.deviceChannel, 0.0);
            di.syncPopup();
        }
    }

    @Override
    public BasicPanel.ParamsSet getParamsSet() {
        BasicPanel.ParamsSet ps = super.getParamsSet();
        ps.addParams(new String[]{"on", "off"});
        ps.nChannels = 1;
        return ps;
    }

    private void splitDevice(String device) {
        this.deviceChannel = 1;
        this.device = device;
        if (device == null) {
            return;
        }
        int i = device.indexOf(58);
        if (i < 0) {
            return;
        }
        this.deviceChannel = Integer.parseInt(device.substring(i + 1));
        this.device = device.substring(0, i);
    }

    private String deviceName() {
        if (this.deviceChannel <= 1) {
            return this.device;
        }
        return String.valueOf(this.device) + ":" + this.deviceChannel;
    }

    @Override
    public void setParams(BasicPanel.ParamsSet paramsSet) {
        this.splitDevice(paramsSet.channels.get(0));
        this.firstButton.setToolTipText(this.device);
        this.secondButton.setToolTipText(this.device);
        this.nameLabel.setText(this.device == null ? "--empty--" : this.deviceName());
        String s = paramsSet.getString("on");
        if (s != null) {
            this.firstButton.setText(s);
        }
        if ((s = paramsSet.getString("off")) != null) {
            this.secondButton.setText(s);
        }
        super.setParams(paramsSet);
    }

    @Override
    public void reset() {
    }

    @Override
    protected void popupMenuAdjust() {
        this.selectMenu("Device", "D:", this.deviceName(), InterfaceThreads.getDevicesHandlesWithInterface("*", "setOn", true), ' ', this);
        super.popupMenuAdjust();
        this.addBasicPopupMenu();
    }

    @Override
    public String generateScriptCmd() {
        StringBuilder sb = new StringBuilder();
        sb.append(panelName);
        sb.append(" ");
        sb.append(this.deviceName());
        sb.append(" ");
        sb.append(this.generateParams());
        sb.append(this.generateParamsColor());
        return sb.toString();
    }
}

