/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.main.InterfaceThreads;
import dk.hkj.panels.BasicPSLoadReadoutPanel;
import dk.hkj.panels.BasicPanel;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JCheckBoxMenuItem;

public class MultiPSLoadReadoutPanel
extends BasicPSLoadReadoutPanel {
    public static String panelName = "MultiPSLoadReadout";

    public MultiPSLoadReadoutPanel() {
        this.displayLayout(this.includeName);
    }

    @Override
    public String getPanelName() {
        return panelName;
    }

    @Override
    protected void setDeviceType() {
        super.setDeviceType();
        if (this.deviceType == BasicPSLoadReadoutPanel.DeviceType.Different_Types) {
            this.small1LeftLabel.setToolTipText("Average Voltage");
            this.small1RightLabel.setToolTipText("Different between supplied and consumed power");
            this.small2LeftLabel.setToolTipText("Different between supplied and consumed capacity");
            this.small2RightLabel.setToolTipText("Different between supplied and consumed energy");
        } else {
            this.small1LeftLabel.setToolTipText("Average Voltage");
            this.small1RightLabel.setToolTipText("Total Power");
            this.small2LeftLabel.setToolTipText("Total Capacity");
            this.small2RightLabel.setToolTipText("Total Energy");
        }
    }

    @Override
    public BasicPanel.ParamsSet getParamsSet() {
        BasicPanel.ParamsSet ps = super.getParamsSet();
        ps.nChannels = 1;
        return ps;
    }

    @Override
    public void setParams(BasicPanel.ParamsSet paramsSet) {
        super.setParams(paramsSet);
        this.setDevices(paramsSet.channels.get(0));
    }

    private void setDevices(String names) {
        String[] stringArray = names.split("[;, ]+");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            BasicPSLoadReadoutPanel.LoadDevice ld = this.findLoadDevice(s);
            if (ld == null) {
                this.loadDevices.add(new BasicPSLoadReadoutPanel.LoadDevice(s));
            }
            ++n2;
        }
        this.nameLabel.setText(this.getNameString());
        StringBuilder sb = new StringBuilder();
        for (BasicPSLoadReadoutPanel.LoadDevice ldd : this.loadDevices) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(ldd.getHandle());
        }
        this.largeLabel.setToolTipText(sb.toString());
    }

    protected String getHandle() {
        if (this.loadDevices.size() == 0) {
            return null;
        }
        return ((BasicPSLoadReadoutPanel.LoadDevice)this.loadDevices.get(0)).getHandle();
    }

    @Override
    protected void popupMenuAdjust() {
        ArrayList<String> list = new ArrayList<String>();
        for (BasicPSLoadReadoutPanel.LoadDevice ld : this.loadDevices) {
            list.add(ld.getHandle());
        }
        this.multiSelectMenu("Devices", "D:", list, InterfaceThreads.getDevicesHandlesWithInterface("!(?i)(ps|load)(:[0-9]+)?", "readVoltage readCurrent", true), '.', this);
        super.popupMenuAdjust();
        this.addBasicPopupMenu();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().startsWith("D:")) {
            if (((JCheckBoxMenuItem)arg0.getSource()).isSelected()) {
                this.setDevices(arg0.getActionCommand().substring(2));
            } else {
                this.loadDevices.remove(this.findLoadDevice(arg0.getActionCommand().substring(2)));
            }
            this.reset();
            this.nameLabel.setText(this.getNameString());
            this.setDeviceType();
            this.displayLayout(this.includeName);
        }
    }

    @Override
    public String generateScriptCmd() {
        StringBuilder sb = new StringBuilder();
        sb.append(panelName);
        sb.append(" ");
        if (this.loadDevices.size() > 0) {
            sb.append("\"");
            for (BasicPSLoadReadoutPanel.LoadDevice ld : this.loadDevices) {
                sb.append(ld.getHandle());
                sb.append(" ");
            }
            sb.append("\"");
        } else {
            sb.append("?");
        }
        sb.append(" ");
        sb.append(this.generateParams());
        sb.append(this.generateParamsColor());
        return sb.toString();
    }
}

