/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.main.DeviceInterface;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.Support;
import dk.hkj.panels.BasicDualButtonPanel;
import dk.hkj.panels.BasicPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class MultiOnOffPanel
extends BasicDualButtonPanel
implements ActionListener {
    public static String panelName = "MultiOnOff";
    protected Support.StringListIC devices = new Support.StringListIC();

    public MultiOnOffPanel() {
        this.firstButton.setText("On");
        this.secondButton.setText("Off");
    }

    @Override
    public String getPanelName() {
        return panelName;
    }

    @Override
    public BasicPanel.ParamsSet getParamsSet() {
        BasicPanel.ParamsSet ps = super.getParamsSet();
        ps.addParams(new String[]{"on", "off"});
        ps.nChannels = 1;
        return ps;
    }

    private String getDeviceName(String device) {
        int i = device.indexOf(58);
        if (i > 0) {
            return device.substring(0, i);
        }
        return device;
    }

    private int getDeviceChannel(String device) {
        int i = device.indexOf(58);
        if (i > 0) {
            return Integer.parseInt(device.substring(i + 1));
        }
        return 1;
    }

    @Override
    public void setParams(BasicPanel.ParamsSet paramsSet) {
        String s;
        String[] stringArray = paramsSet.channels.get(0).split("[;, ]+");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            this.devices.add(s);
            ++n2;
        }
        this.firstButton.setToolTipText(paramsSet.channels.get(0));
        this.secondButton.setToolTipText(paramsSet.channels.get(0));
        s = paramsSet.getString("on");
        if (s != null) {
            this.firstButton.setText(s);
        }
        if ((s = paramsSet.getString("off")) != null) {
            this.secondButton.setText(s);
        }
        this.updateNameLabel();
        super.setParams(paramsSet);
    }

    private void updateNameLabel() {
        StringBuilder sb = new StringBuilder();
        if (this.devices.size() < 3) {
            for (String s : this.devices) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(s);
            }
        } else {
            sb.append(String.valueOf(this.devices.size()) + " devices");
        }
        this.nameLabel.setText(sb.length() == 0 ? "--empty--" : sb.toString());
        this.requestDisplayUpdate = true;
        sb.setLength(0);
        for (String s : this.devices) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(s);
        }
        this.nameLabel.setToolTipText(sb.toString());
        this.firstButton.setToolTipText(sb.toString());
        this.secondButton.setToolTipText(sb.toString());
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        DeviceInterface di;
        if (arg0.getActionCommand().startsWith("D:")) {
            this.devices.flip(arg0.getActionCommand().substring(2));
            this.updateNameLabel();
            this.displayLayout(this.includeName);
        } else if (arg0.getActionCommand().equals("firstButton")) {
            for (String s : this.devices) {
                di = InterfaceThreads.getLoadedDeviceInterfaceHandle(this.getDeviceName(s));
                if (di == null) continue;
                di.executeIFace("setOn", this.getDeviceChannel(s), 1.0);
            }
        } else if (arg0.getActionCommand().equals("secondButton")) {
            for (String s : this.devices) {
                di = InterfaceThreads.getLoadedDeviceInterfaceHandle(this.getDeviceName(s));
                if (di == null) continue;
                di.executeIFace("setOn", this.getDeviceChannel(s), 0.0);
            }
        }
        for (String s : this.devices) {
            di = InterfaceThreads.getLoadedDeviceInterfaceHandle(this.getDeviceName(s));
            if (di == null) continue;
            di.syncPopup();
        }
    }

    @Override
    public void reset() {
    }

    @Override
    protected void popupMenuAdjust() {
        this.multiSelectMenu("Devices", "D:", this.devices, InterfaceThreads.getDevicesHandlesWithInterface("*", "setOn", true), '.', this);
        super.popupMenuAdjust();
        this.addBasicPopupMenu();
    }

    @Override
    public String generateScriptCmd() {
        StringBuilder sb = new StringBuilder();
        sb.append(panelName);
        sb.append(" \"");
        int i = 0;
        while (i < this.devices.size()) {
            sb.append((String)this.devices.get(i));
            if (i != this.devices.size() - 1) {
                sb.append(" ");
            }
            ++i;
        }
        sb.append("\" ");
        sb.append(this.generateParams());
        sb.append(this.generateParamsColor());
        return sb.toString();
    }
}

