/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.main.FontAdjust;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.Support;
import dk.hkj.panels.BasicChartPanel;
import dk.hkj.panels.BasicPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import javax.swing.JMenuItem;
import org.jfree.chart.annotations.XYLineAnnotation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.DefaultXYDataset;

public class MinMaxChartPanel
extends BasicChartPanel
implements ActionListener {
    public static String panelName = "minMaxChart";
    private static final int MAX_DATA_POINTS = 50000;
    private static final int[] SampleList = new int[]{500, 1000, 2500, 5000, 10000, 25000, 50000};
    private String channel = null;
    private int maxDataPoints = 5000;
    private DefaultXYDataset dataset = null;
    private DataPoint[] dataPoints = new DataPoint[this.maxDataPoints];
    private int points = 0;
    private int index = 0;
    private boolean lowRes = false;
    private boolean timeScaleSeconds;

    public MinMaxChartPanel() {
        super(BasicChartPanel.ChartType.XY);
        this.dataset = new DefaultXYDataset();
        Support.MyDecimalFormat nf = new Support.MyDecimalFormat();
        nf.setSIFormat(true);
        ((NumberAxis)this.freeChart.getXYPlot().getDomainAxis()).setNumberFormatOverride(new MyTimeFormat());
        ((NumberAxis)this.freeChart.getXYPlot().getRangeAxis()).setNumberFormatOverride(nf);
        XYPlot plot = this.freeChart.getXYPlot();
        plot.setDataset(this.dataset);
        plot.addAnnotation(new XYLineAnnotation(-1.0E10, 0.0, 1.0E10, 0.0, new BasicStroke(1.0f), Color.yellow));
        plot.getRenderer().setSeriesPaint(0, Color.green);
        plot.getRenderer().setSeriesPaint(1, Color.blue);
        plot.getRenderer().setSeriesPaint(2, Color.blue);
        ((NumberAxis)plot.getRangeAxis()).setAutoRangeIncludesZero(false);
        this.displayLayout(true);
    }

    @Override
    public String getPanelName() {
        return panelName;
    }

    @Override
    public BasicPanel.ParamsSet getParamsSet() {
        BasicPanel.ParamsSet ps = super.getParamsSet();
        ps.addParams(new String[]{"samples", "lowres", "value"});
        ps.nChannels = 1;
        return ps;
    }

    @Override
    public void setParams(BasicPanel.ParamsSet paramsSet) {
        super.setParams(paramsSet);
        this.channel = paramsSet.channels.get(0);
        this.lowRes = paramsSet.isPresent("lowres");
        Double v = paramsSet.getValue("samples");
        if (v != null && v >= 300.0 && v <= 50000.0) {
            this.maxDataPoints = (int)v.doubleValue();
            this.dataPoints = new DataPoint[this.maxDataPoints];
        }
        this.setRange(this.freeChart.getXYPlot().getRangeAxis(), paramsSet.getString("value"));
        this.setToolTipText(this.channel);
        this.chartPanel.setToolTipText(this.channel);
        this.nameLabel.setText(this.channel == null ? "--empty--" : this.channel);
        this.reset();
    }

    @Override
    public void update() {
        double v;
        if (!this.isVisible()) {
            return;
        }
        if (this.channel != null && !Double.isNaN(v = this.readValue(this.channel))) {
            this.dataPoints[this.index] = new DataPoint(v);
            this.index = (this.index + 1) % this.maxDataPoints;
            if (this.points < this.maxDataPoints) {
                ++this.points;
            }
            this.requestDisplayUpdate = true;
        }
        if (this.requestDisplayUpdate) {
            this.sizeChartPanel();
            int samplesPerChart = (this.getWidth() - 30) / 2;
            if (this.points < samplesPerChart) {
                samplesPerChart = this.points;
            }
            long t0 = System.currentTimeMillis();
            int i = this.index - this.points;
            if (i < 0) {
                i += this.points;
            }
            try {
                long t = t0 - this.dataPoints[i].time;
                this.timeScaleSeconds = t < 300000L;
            }
            catch (Exception exception) {
                this.timeScaleSeconds = true;
            }
            double[][] minSeries = new double[2][samplesPerChart];
            double[][] avgSeries = new double[2][samplesPerChart];
            double[][] maxSeries = new double[2][samplesPerChart];
            int smooting = 0;
            int samplesPerPoint = 0;
            if (this.points > 1) {
                int ii = this.index;
                int chartSample = 0;
                while (chartSample < samplesPerChart) {
                    double tt;
                    double min = Double.MAX_VALUE;
                    double avg = 0.0;
                    double max = -1.7976931348623157E308;
                    int n1 = this.points * chartSample / samplesPerChart;
                    int n2 = Math.min(this.points * (chartSample + 1) / samplesPerChart, this.points);
                    samplesPerPoint = Math.max(1, n2 - n1);
                    int i2 = 0;
                    while (i2 < samplesPerPoint) {
                        double v2;
                        if (--ii < 0) {
                            ii = this.points - 1;
                        }
                        if ((v2 = this.dataPoints[ii].value) < min) {
                            min = v2;
                        }
                        if (v2 > max) {
                            max = v2;
                        }
                        avg += v2;
                        ++i2;
                    }
                    minSeries[0][chartSample] = tt = (double)(this.dataPoints[ii].time - t0) / 1000.0 / (double)(this.timeScaleSeconds ? 1 : 60);
                    avgSeries[0][chartSample] = tt;
                    maxSeries[0][chartSample] = tt;
                    minSeries[1][chartSample] = min;
                    avgSeries[1][chartSample] = avg / (double)samplesPerPoint;
                    maxSeries[1][chartSample] = max;
                    min = Double.MAX_VALUE;
                    avg = 0.0;
                    max = -1.7976931348623157E308;
                    ++chartSample;
                }
                if (samplesPerChart > 20) {
                    smooting = this.lowRes ? 3 : 1;
                    double[][] min2Series = new double[2][samplesPerChart];
                    double[][] avg2Series = new double[2][samplesPerChart];
                    double[][] max2Series = new double[2][samplesPerChart];
                    int i3 = 0;
                    while (i3 < samplesPerChart) {
                        double mi = Double.MAX_VALUE;
                        double av = 0.0;
                        double mx = -1.7976931348623157E308;
                        int nn = 0;
                        int j = i3 - smooting;
                        while (j < i3 + smooting + 1) {
                            if (j >= 0 && j < samplesPerChart) {
                                ++nn;
                                mi = Math.min(mi, minSeries[1][j]);
                                av += avgSeries[1][j];
                                mx = Math.max(mx, maxSeries[1][j]);
                            }
                            ++j;
                        }
                        min2Series[1][i3] = mi;
                        avg2Series[1][i3] = av / (double)nn;
                        max2Series[1][i3] = mx;
                        min2Series[0][i3] = minSeries[0][i3];
                        avg2Series[0][i3] = avgSeries[0][i3];
                        max2Series[0][i3] = maxSeries[0][i3];
                        ++i3;
                    }
                    minSeries = min2Series;
                    avgSeries = avg2Series;
                    maxSeries = max2Series;
                }
            }
            this.dataset.addSeries((Comparable)((Object)"avg"), avgSeries);
            if (samplesPerPoint > 1 || smooting > 0) {
                this.dataset.addSeries((Comparable)((Object)"min"), minSeries);
                this.dataset.addSeries((Comparable)((Object)"max"), maxSeries);
            } else {
                this.dataset.removeSeries((Comparable)((Object)"min"));
                this.dataset.removeSeries((Comparable)((Object)"max"));
            }
            this.repaint();
        }
        this.requestDisplayUpdate = false;
    }

    @Override
    public void reset() {
        this.points = 0;
        this.index = 0;
        this.requestDisplayUpdate = true;
    }

    @Override
    protected boolean supportReset() {
        return true;
    }

    @Override
    protected void popupMenuAdjust() {
        JMenuItem mi = null;
        FontAdjust.FontMenu menu = null;
        this.selectMenu("Select channel", "C:", this.channel, InterfaceThreads.listChannels(true, "*"), '.', this);
        mi = new FontAdjust.FontCheckBoxMenuItem("Low resolution");
        mi.setSelected(this.lowRes);
        mi.setToolTipText("When checked each point on the chart will include more data from neighbouring points");
        mi.setActionCommand("lowres");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        if (this.points > 2) {
            menu = new FontAdjust.FontMenu("Value scale");
            this.popupMenu.add(menu);
            double min = Double.MAX_VALUE;
            double max = -1.7976931348623157E308;
            int i = 0;
            while (i < this.points) {
                DataPoint dp = this.dataPoints[i];
                if (dp.value > max) {
                    max = dp.value;
                }
                if (dp.value < min) {
                    min = dp.value;
                }
                ++i;
            }
            this.addValueRangeMenu(menu, this.freeChart.getXYPlot().getRangeAxis(), min, max);
        }
        menu = new FontAdjust.FontMenu("Max. samples");
        this.popupMenu.add(menu);
        double sampleTime = this.getGridPanel().getSampleTime();
        int[] nArray = SampleList;
        int n = SampleList.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            int t = (int)((double)n3 * sampleTime);
            String s = t < 300 ? String.valueOf(Integer.toString(t)) + "s" : String.valueOf(Integer.toString(t / 60)) + "m";
            mi = new FontAdjust.FontRadioButtonMenuItem(String.valueOf(Integer.toString(n3)) + "   ~" + s);
            if (n3 == this.maxDataPoints) {
                mi.setSelected(true);
            }
            mi.setActionCommand("samples:" + n3);
            mi.addActionListener(this);
            menu.add(mi);
            ++n2;
        }
        this.addBasicPopupMenu();
    }

    @Override
    public boolean needData() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().startsWith("C:")) {
            this.channel = arg0.getActionCommand().substring(2);
            this.setToolTipText(this.channel);
            this.chartPanel.setToolTipText(this.channel);
            this.nameLabel.setText(this.channel == null ? "--empty--" : this.channel);
            this.reset();
        } else if (arg0.getActionCommand().startsWith("samples:")) {
            this.maxDataPoints = Integer.parseInt(arg0.getActionCommand().substring(8));
            this.dataPoints = new DataPoint[this.maxDataPoints];
            this.reset();
        } else if (arg0.getActionCommand().equals("lowres")) {
            this.lowRes = !this.lowRes;
        }
    }

    @Override
    public String generateScriptCmd() {
        StringBuilder sb = new StringBuilder();
        sb.append(panelName);
        sb.append(" ");
        sb.append(this.channel);
        sb.append(" ");
        if (this.lowRes) {
            sb.append("lowres ");
        }
        if (!this.freeChart.getXYPlot().getRangeAxis().isAutoRange()) {
            sb.append("value:");
            sb.append(this.getRangeString(this.freeChart.getXYPlot().getRangeAxis()));
            sb.append(" ");
        }
        sb.append(this.generateParams());
        sb.append("samples:");
        sb.append(this.maxDataPoints);
        sb.append(" ");
        sb.append(this.generateParamsColor());
        return sb.toString();
    }

    private static class DataPoint {
        double value;
        long time;

        DataPoint(double value) {
            this.value = value;
            this.time = System.currentTimeMillis();
        }
    }

    public class MyTimeFormat
    extends DecimalFormat {
        DecimalFormat df = new DecimalFormat("##0.#;-##0.#");

        public MyTimeFormat() {
            this.df.setGroupingUsed(false);
            super.setGroupingUsed(false);
            DecimalFormatSymbols dfs = new DecimalFormatSymbols();
            dfs.setDecimalSeparator('.');
            this.df.setDecimalFormatSymbols(dfs);
            super.setDecimalFormatSymbols(dfs);
        }

        @Override
        public StringBuffer format(double number, StringBuffer sbuf, FieldPosition pos) {
            this.df.format(number, sbuf, pos);
            sbuf.append(MinMaxChartPanel.this.timeScaleSeconds ? "" : "m");
            return sbuf;
        }
    }
}

