/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.main.FontAdjust;
import dk.hkj.main.ValueFormat;
import dk.hkj.panels.BasicLargeNSmallPanel;
import dk.hkj.panels.BasicPanel;
import dk.hkj.panels.DataMathReadout;
import dk.hkj.panels.PopupAskText;
import dk.hkj.panels.PopupEditMath;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class MathReadoutPanel
extends BasicLargeNSmallPanel
implements ActionListener {
    public static String panelName = "MathReadout";
    protected DataMathReadout dmr = new DataMathReadout(this, 1);

    public MathReadoutPanel() {
        super(0);
        this.displayLayout(this.includeName);
    }

    @Override
    public String getPanelName() {
        return panelName;
    }

    @Override
    public BasicPanel.ParamsSet getParamsSet() {
        BasicPanel.ParamsSet ps = this.dmr.getParamsSet(super.getParamsSet());
        return ps;
    }

    @Override
    public void setParams(BasicPanel.ParamsSet paramsSet) {
        super.setParams(paramsSet);
        this.dmr.setParams(paramsSet);
        this.displayLayout(this.includeName);
    }

    @Override
    public void update() {
        if (this.dmr.isEmpty()) {
            super.update();
            return;
        }
        String[] display = this.dmr.update();
        this.update(this.dmr.getName(), display[0]);
    }

    @Override
    public void reset() {
        this.dmr.reset();
    }

    @Override
    protected boolean supportReset() {
        return true;
    }

    @Override
    protected void popupMenuAdjust() {
        ValueFormat.formatMenu(this.popupMenu, "Format", "F:", this.dmr.getFormat(0), false, true, this);
        FontAdjust.FontMenuItem mi = new FontAdjust.FontMenuItem("Unit");
        mi.setActionCommand("unit");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Edit math");
        mi.setActionCommand("math");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        super.popupMenuAdjust();
        this.addBasicPopupMenu();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().startsWith("F:")) {
            this.dmr.setFormat(0, arg0.getActionCommand().substring(2));
            this.dmr.updateHot();
            this.forceFontResize();
        } else if (arg0.getActionCommand().equals("unit")) {
            PopupAskText pat = new PopupAskText(this, "Enter unit", this.dmr.getUnit(0), 6);
            this.dmr.setUnit(0, pat.getText());
            this.dmr.updateHot();
            this.forceFontResize();
        } else if (arg0.getActionCommand().equals("math")) {
            new PopupEditMath(this, "Math panel", this.dmr);
            this.reset();
            this.forceFontResize();
        }
    }

    @Override
    public boolean needData() {
        return true;
    }

    @Override
    public String generateScriptCmd() {
        StringBuilder sb = new StringBuilder();
        sb.append(panelName);
        sb.append(" ");
        sb.append(this.dmr.generateParams());
        sb.append(this.generateParams());
        sb.append(this.generateParamsColor());
        return sb.toString();
    }
}

