/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.main.FontAdjust;
import dk.hkj.main.ValueFormat;
import dk.hkj.panels.BasicDualReadoutPanel;
import dk.hkj.panels.BasicPanel;
import dk.hkj.panels.DataMathReadout;
import dk.hkj.panels.PopupAskText;
import dk.hkj.panels.PopupEditMath;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class MathDualReadoutPanel
extends BasicDualReadoutPanel
implements ActionListener {
    public static String panelName = "MathDualReadout";
    protected DataMathReadout dmr = new DataMathReadout(this, 2);

    public MathDualReadoutPanel() {
        this.twoNames = false;
        this.setNames(this.dmr.getName(), "");
    }

    @Override
    public String getPanelName() {
        return panelName;
    }

    @Override
    public BasicPanel.ParamsSet getParamsSet() {
        BasicPanel.ParamsSet ps = this.dmr.getParamsSet(super.getParamsSet());
        return ps;
    }

    @Override
    public void setParams(BasicPanel.ParamsSet paramsSet) {
        super.setParams(paramsSet);
        this.dmr.setParams(paramsSet);
        this.setNames(this.dmr.getName(), "");
    }

    @Override
    public void update() {
        if (this.dmr.isEmpty()) {
            super.update();
            return;
        }
        String[] display = this.dmr.update();
        this.update(display[0], display[1]);
    }

    @Override
    public void reset() {
        this.dmr.reset();
    }

    @Override
    protected boolean supportReset() {
        return true;
    }

    @Override
    protected void popupMenuAdjust() {
        ValueFormat.formatMenu(this.popupMenu, "Format 1", "F1:", this.dmr.getFormat(0), false, true, this);
        ValueFormat.formatMenu(this.popupMenu, "Format 2", "F2:", this.dmr.getFormat(1), false, true, this);
        FontAdjust.FontMenuItem mi = new FontAdjust.FontMenuItem("Unit 1");
        mi.setActionCommand("unit1");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Unit 2");
        mi.setActionCommand("unit2");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Edit math");
        mi.setActionCommand("math");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        this.addBasicPopupMenu();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().startsWith("F1:")) {
            this.dmr.setFormat(0, arg0.getActionCommand().substring(3));
            this.dmr.updateHot();
            this.forceFontResize();
        } else if (arg0.getActionCommand().startsWith("F2:")) {
            this.dmr.setFormat(1, arg0.getActionCommand().substring(3));
            this.dmr.updateHot();
            this.forceFontResize();
        } else if (arg0.getActionCommand().equals("unit1")) {
            PopupAskText pat = new PopupAskText(this, "Enter unit", this.dmr.getUnit(0), 6);
            this.dmr.setUnit(0, pat.getText());
            this.dmr.updateHot();
            this.forceFontResize();
        } else if (arg0.getActionCommand().equals("unit2")) {
            PopupAskText pat = new PopupAskText(this, "Enter unit", this.dmr.getUnit(1), 6);
            this.dmr.setUnit(1, pat.getText());
            this.dmr.updateHot();
            this.forceFontResize();
        } else if (arg0.getActionCommand().equals("math")) {
            new PopupEditMath(this, "Math panel", this.dmr);
            this.reset();
            this.setNames(this.dmr.getName(), "");
            this.forceFontResize();
        }
    }

    @Override
    public boolean needData() {
        return true;
    }

    @Override
    public String generateScriptCmd() {
        StringBuilder sb = new StringBuilder();
        sb.append(panelName);
        sb.append(" ");
        sb.append(this.dmr.generateParams());
        sb.append(this.generateParams());
        sb.append(this.generateParamsColor());
        return sb.toString();
    }
}

