/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.main.FontAdjust;
import dk.hkj.panels.BasicBitsReadoutPanel;
import dk.hkj.panels.BasicPanel;
import dk.hkj.panels.DataMathReadout;
import dk.hkj.panels.PopupEditMath;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;

public class MathBitsReadoutPanel
extends BasicBitsReadoutPanel
implements ActionListener {
    public static String panelName = "MathBitsReadout";
    protected DataMathReadout dmr = new DataMathReadout(1, true);

    public MathBitsReadoutPanel() {
        this.nameLabel.setText(this.dmr.getName());
        this.setBitNames();
        this.displayLayout(this.includeName);
    }

    @Override
    public BasicPanel.ParamsSet getParamsSet() {
        BasicPanel.ParamsSet ps = this.dmr.getParamsSet(super.getParamsSet());
        return ps;
    }

    @Override
    public void setParams(BasicPanel.ParamsSet paramsSet) {
        super.setParams(paramsSet);
        this.dmr.setParams(paramsSet);
        this.nameLabel.setText(this.dmr.getName());
        this.displayLayout(this.includeName);
    }

    @Override
    public String getPanelName() {
        return panelName;
    }

    @Override
    public void reset() {
        super.reset();
        this.dmr.reset();
        this.setBitNames();
    }

    @Override
    public void update() {
        if (!this.isVisible()) {
            return;
        }
        if (this.dmr.isEmpty()) {
            this.bp.update();
            return;
        }
        long[] display = this.dmr.updateLong();
        if (display != null && display.length >= 1) {
            this.bp.updateValue(display[0]);
        }
        if (this.requestDisplayUpdate) {
            this.sizeBitsPanel();
            this.requestDisplayUpdate = false;
            this.repaint();
        }
    }

    @Override
    protected void popupMenuAdjust() {
        JMenuItem mi = null;
        mi = new FontAdjust.FontMenuItem("Edit math");
        mi.setActionCommand("math");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        mi = new FontAdjust.FontCheckBoxMenuItem("LSB first");
        mi.setSelected(this.bp.getLsbFirst());
        mi.setActionCommand("lsb");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        this.addBasicPopupMenu();
    }

    private void setBitNames() {
        String[] bitNames = this.dmr.getVarAsString("bitNames", "B0 B1 B2 B3").split("[;, ]+");
        if (bitNames.length > 0) {
            this.bp.setBits(bitNames.length);
            int i = 0;
            while (i < bitNames.length) {
                this.bp.setBitName(i, bitNames[i]);
                ++i;
            }
        } else {
            this.bp.setBits(4);
            this.bp.resetBitNames();
        }
        this.update();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().equals("math")) {
            new PopupEditMath(this, "Math panel", this.dmr);
            this.nameLabel.setText(this.dmr.getName());
            this.reset();
            this.update();
        } else if (arg0.getActionCommand().startsWith("lsb")) {
            this.bp.setLsbFirst(!this.bp.getLsbFirst());
        }
    }

    @Override
    public String generateScriptCmd() {
        StringBuilder sb = new StringBuilder();
        sb.append(panelName);
        sb.append(" ");
        sb.append(this.dmr.generateParams());
        sb.append(" ");
        sb.append(this.generateParams());
        sb.append(this.generateParamsColor());
        return sb.toString();
    }
}

