/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.main.FontAdjust;
import dk.hkj.panels.BasicAnalogReadoutPanel;
import dk.hkj.panels.BasicPanel;
import dk.hkj.panels.DataMathReadout;
import dk.hkj.panels.PopupAskDualValue;
import dk.hkj.panels.PopupAskText;
import dk.hkj.panels.PopupEditMath;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;

public class MathAnalogReadoutPanel
extends BasicAnalogReadoutPanel
implements ActionListener {
    public static String panelName = "MathAnalogReadout";
    protected DataMathReadout dmr = new DataMathReadout(this, 1);

    public MathAnalogReadoutPanel() {
        this.nameLabel.setText(this.dmr.getName());
        this.displayLayout(this.includeName);
    }

    @Override
    public BasicPanel.ParamsSet getParamsSet() {
        BasicPanel.ParamsSet ps = this.dmr.getParamsSet(super.getParamsSet());
        return ps;
    }

    @Override
    public void setParams(BasicPanel.ParamsSet paramsSet) {
        super.setParams(paramsSet);
        this.dmr.setParams(paramsSet);
        this.nameLabel.setText(this.dmr.getName());
        this.displayLayout(this.includeName);
    }

    @Override
    public String getPanelName() {
        return panelName;
    }

    @Override
    public void update() {
        if (!this.isVisible()) {
            return;
        }
        if (this.dmr.isEmpty()) {
            this.adp.update();
            return;
        }
        double[] display = this.dmr.updateDouble();
        if (display != null) {
            this.adp.updateValue(display[0]);
        }
        if (this.requestDisplayUpdate) {
            this.sizeAnalogPanel();
            this.requestDisplayUpdate = false;
            this.repaint();
        }
    }

    @Override
    protected void popupMenuAdjust() {
        FontAdjust.FontMenu menu = null;
        JMenuItem mi = null;
        mi = new FontAdjust.FontMenuItem("Unit");
        mi.setActionCommand("unit");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Edit math");
        mi.setActionCommand("math");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        menu = new FontAdjust.FontMenu("Scale");
        this.popupMenu.add(menu);
        mi = new FontAdjust.FontRadioButtonMenuItem("Horizontal");
        if (this.adp.getScaleType() == BasicAnalogReadoutPanel.ScaleType.Horizontal) {
            mi.setSelected(true);
        }
        mi.setActionCommand("horizontal");
        mi.addActionListener(this);
        menu.add(mi);
        mi = new FontAdjust.FontRadioButtonMenuItem("Vertical");
        if (this.adp.getScaleType() == BasicAnalogReadoutPanel.ScaleType.Vertical) {
            mi.setSelected(true);
        }
        mi.setActionCommand("vertical");
        mi.addActionListener(this);
        menu.add(mi);
        mi = new FontAdjust.FontMenuItem("Limits");
        mi.setActionCommand("limits");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        mi = new FontAdjust.FontCheckBoxMenuItem("Alarm");
        mi.setSelected(this.adp.getAlarm());
        mi.setActionCommand("alarm");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        this.addBasicPopupMenu();
    }

    @Override
    public void reset() {
        super.reset();
        this.dmr.reset();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().equals("unit")) {
            PopupAskText pat = new PopupAskText(this, "Enter unit", this.dmr.getUnit(0), 6);
            this.adp.setUnit(pat.getText());
            this.update();
        } else if (arg0.getActionCommand().equals("math")) {
            new PopupEditMath(this, "Math panel", this.dmr);
            this.nameLabel.setText(this.dmr.getName());
            this.reset();
            this.update();
        } else if (arg0.getActionCommand().equals("limits")) {
            PopupAskDualValue pav = new PopupAskDualValue(this, "Limits", "Lower", "Upper", this.adp.getLower(), this.adp.getUpper(), true);
            if (!Double.isNaN(pav.getValue1()) && !Double.isNaN(pav.getValue2())) {
                this.adp.setLower(pav.getValue1());
                this.adp.setUpper(pav.getValue2());
                this.update();
            }
        } else if (arg0.getActionCommand().equals("alarm")) {
            this.adp.setAlarm(!this.adp.getAlarm());
            this.update();
        } else if (arg0.getActionCommand().equals("vertical")) {
            this.adp.setScaleType(BasicAnalogReadoutPanel.ScaleType.Vertical);
            this.update();
        } else if (arg0.getActionCommand().equals("horizontal")) {
            this.adp.setScaleType(BasicAnalogReadoutPanel.ScaleType.Horizontal);
            this.update();
        }
    }

    @Override
    public String generateScriptCmd() {
        StringBuilder sb = new StringBuilder();
        sb.append(panelName);
        sb.append(" ");
        sb.append(this.dmr.generateParams());
        sb.append(this.generateParams());
        sb.append(this.generateParamsColor());
        return sb.toString();
    }
}

