/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.main.FontAdjust;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.Support;
import dk.hkj.panels.BasicChartPanel;
import dk.hkj.panels.BasicPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Arrays;
import javax.swing.JMenuItem;
import org.jfree.chart.annotations.XYLineAnnotation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.renderer.xy.GradientXYBarPainter;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.statistics.HistogramType;

public class HistogramPanel
extends BasicChartPanel
implements ActionListener {
    public static String panelName = "Histogram";
    private static final int MAX_DATA_POINTS = 10000;
    private static final int[] BinList = new int[]{10, 25, 50, 100};
    private static final int[] SampleList = new int[]{250, 500, 1000, 2500, 5000, 10000};
    private String channel = null;
    private int bins = 10;
    private int maxDataPoints = 10000;
    private boolean pct = false;
    private double[] dataPoints = new double[this.maxDataPoints];
    private int points = 0;
    private int index = 0;

    public HistogramPanel() {
        super(BasicChartPanel.ChartType.Histogram);
        this.setPercent(false);
        Support.MyDecimalFormat nf = new Support.MyDecimalFormat();
        nf.setSIFormat(true);
        ((NumberAxis)this.freeChart.getXYPlot().getDomainAxis()).setNumberFormatOverride(nf);
        ((NumberAxis)this.freeChart.getXYPlot().getRangeAxis()).setNumberFormatOverride(new ScaleFormatter());
        this.freeChart.getXYPlot().addAnnotation(new XYLineAnnotation(0.0, 0.0, 0.0, 1.0E10, new BasicStroke(1.0f), Color.yellow));
        this.displayLayout(true);
    }

    @Override
    public String getPanelName() {
        return panelName;
    }

    @Override
    public BasicPanel.ParamsSet getParamsSet() {
        BasicPanel.ParamsSet ps = super.getParamsSet();
        ps.addParams(new String[]{"bins", "samples", "pct", "value"});
        ps.nChannels = 1;
        return ps;
    }

    @Override
    public void setParams(BasicPanel.ParamsSet paramsSet) {
        super.setParams(paramsSet);
        this.channel = paramsSet.channels.get(0);
        this.setPercent(paramsSet.isPresent("pct"));
        Double v = paramsSet.getValue("bins");
        if (v != null && v >= 10.0 && v <= 100.0) {
            this.bins = (int)v.doubleValue();
        }
        this.setRange(this.freeChart.getXYPlot().getDomainAxis(), paramsSet.getString("value"));
        v = paramsSet.getValue("samples");
        if (v != null && v >= 300.0 && v <= 10000.0) {
            this.maxDataPoints = (int)v.doubleValue();
            this.dataPoints = new double[this.maxDataPoints];
        }
        this.setToolTipText(this.channel);
        this.chartPanel.setToolTipText(this.channel);
        this.nameLabel.setText(this.channel == null ? "--empty--" : this.channel);
        this.reset();
    }

    @Override
    public void update() {
        double v;
        if (!this.isVisible()) {
            return;
        }
        if (this.channel != null && !Double.isNaN(v = this.readValue(this.channel))) {
            this.dataPoints[this.index] = v;
            this.index = (this.index + 1) % this.maxDataPoints;
            if (this.points < this.maxDataPoints) {
                ++this.points;
            }
            this.requestDisplayUpdate = true;
        }
        if (this.requestDisplayUpdate) {
            this.sizeChartPanel();
            HistogramDataset dataset = new HistogramDataset();
            if (this.pct) {
                dataset.setType(HistogramType.RELATIVE_FREQUENCY);
            }
            if (this.points == 0) {
                this.freeChart.getXYPlot().setDataset(0, dataset);
            } else if (this.points < 10000) {
                dataset.addSeries((Comparable)((Object)"data"), Arrays.copyOf(this.dataPoints, this.points), this.bins);
            } else {
                dataset.addSeries((Comparable)((Object)"data"), this.dataPoints, this.bins);
            }
            XYBarRenderer renderer = (XYBarRenderer)this.freeChart.getXYPlot().getRenderer();
            int w = this.getWidth() - 30;
            boolean compact = w / this.bins < 10;
            renderer.setMargin(compact ? 0.0 : 0.1);
            if (compact) {
                renderer.setBarPainter(new StandardXYBarPainter());
                renderer.setShadowVisible(false);
            } else {
                renderer.setBarPainter(new GradientXYBarPainter());
                renderer.setShadowVisible(true);
            }
            this.freeChart.getXYPlot().setDataset(0, dataset);
            this.repaint();
        }
        this.requestDisplayUpdate = false;
    }

    @Override
    public void reset() {
        this.points = 0;
        this.index = 0;
        this.requestDisplayUpdate = true;
    }

    @Override
    protected boolean supportReset() {
        return true;
    }

    @Override
    protected void popupMenuAdjust() {
        JMenuItem mi = null;
        FontAdjust.FontMenu menu = null;
        this.selectMenu("Select channel", "C:", this.channel, InterfaceThreads.listChannels(true, "*"), '.', this);
        mi = new FontAdjust.FontCheckBoxMenuItem("Percent");
        mi.setSelected(this.pct);
        mi.setActionCommand("pct");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        menu = new FontAdjust.FontMenu("Bins");
        this.popupMenu.add(menu);
        int[] nArray = BinList;
        int n = BinList.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            mi = new FontAdjust.FontRadioButtonMenuItem(Integer.toString(n3));
            if (n3 == this.bins) {
                mi.setSelected(true);
            }
            mi.setActionCommand("bins:" + n3);
            mi.addActionListener(this);
            menu.add(mi);
            ++n2;
        }
        if (this.points > 2) {
            menu = new FontAdjust.FontMenu("Value scale");
            this.popupMenu.add(menu);
            double min = Double.MAX_VALUE;
            double max = -1.7976931348623157E308;
            int i = 0;
            while (i < this.points) {
                double value = this.dataPoints[i];
                if (value > max) {
                    max = value;
                }
                if (value < min) {
                    min = value;
                }
                ++i;
            }
            this.addValueRangeMenu(menu, this.freeChart.getXYPlot().getDomainAxis(), min, max);
        }
        menu = new FontAdjust.FontMenu("Max. samples");
        this.popupMenu.add(menu);
        double sampleTime = this.getGridPanel().getSampleTime();
        int[] nArray2 = SampleList;
        int n4 = SampleList.length;
        int n5 = 0;
        while (n5 < n4) {
            int n6 = nArray2[n5];
            int t = (int)((double)n6 * sampleTime);
            String s = t < 300 ? String.valueOf(Integer.toString(t)) + "s" : String.valueOf(Integer.toString(t / 60)) + "m";
            mi = new FontAdjust.FontRadioButtonMenuItem(String.valueOf(Integer.toString(n6)) + "   ~" + s);
            if (n6 == this.maxDataPoints) {
                mi.setSelected(true);
            }
            mi.setActionCommand("samples:" + n6);
            mi.addActionListener(this);
            menu.add(mi);
            ++n5;
        }
        this.addBasicPopupMenu();
    }

    @Override
    public boolean needData() {
        return true;
    }

    private void setPercent(boolean pct) {
        this.pct = pct;
        ((NumberAxis)this.freeChart.getXYPlot().getRangeAxis()).setLabel(pct ? "Percent" : "Count");
    }

    @Override
    protected Image generateClipboardImage() {
        XYBarRenderer renderer = (XYBarRenderer)this.freeChart.getXYPlot().getRenderer();
        renderer.setMargin(0.1);
        renderer.setBarPainter(new GradientXYBarPainter());
        renderer.setShadowVisible(true);
        return super.generateClipboardImage();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().startsWith("C:")) {
            this.channel = arg0.getActionCommand().substring(2);
            this.setToolTipText(this.channel);
            this.chartPanel.setToolTipText(this.channel);
            this.nameLabel.setText(this.channel == null ? "--empty--" : this.channel);
            this.reset();
        } else if (arg0.getActionCommand().equals("pct")) {
            this.setPercent(!this.pct);
            this.requestDisplayUpdate = true;
        } else if (arg0.getActionCommand().startsWith("bins:")) {
            this.bins = Integer.parseInt(arg0.getActionCommand().substring(5));
            this.requestDisplayUpdate = true;
        } else if (arg0.getActionCommand().startsWith("samples:")) {
            this.maxDataPoints = Integer.parseInt(arg0.getActionCommand().substring(8));
            this.dataPoints = new double[this.maxDataPoints];
            this.reset();
        }
    }

    @Override
    public String generateScriptCmd() {
        StringBuilder sb = new StringBuilder();
        sb.append(panelName);
        sb.append(" ");
        sb.append(this.channel);
        sb.append(" ");
        if (this.pct) {
            sb.append("pct ");
        }
        sb.append(this.generateParams());
        sb.append("bins:");
        sb.append(this.bins);
        sb.append(" ");
        if (!this.freeChart.getXYPlot().getDomainAxis().isAutoRange()) {
            sb.append("value:");
            sb.append(this.getRangeString(this.freeChart.getXYPlot().getDomainAxis()));
            sb.append(" ");
        }
        sb.append("samples:");
        sb.append(this.maxDataPoints);
        sb.append(" ");
        sb.append(this.generateParamsColor());
        return sb.toString();
    }

    private class ScaleFormatter
    extends NumberFormat {
        private NumberFormat nf = new Support.MyDecimalFormat();

        private ScaleFormatter() {
        }

        @Override
        public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
            this.nf.setMinimumFractionDigits(HistogramPanel.this.pct ? 0 : 0);
            this.nf.setMaximumFractionDigits(HistogramPanel.this.pct ? 4 : 0);
            return this.nf.format(number * (HistogramPanel.this.pct ? 100.0 : 1.0), toAppendTo, pos);
        }

        @Override
        public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
            toAppendTo.append(number);
            return toAppendTo;
        }

        @Override
        public Number parse(String source, ParsePosition parsePosition) {
            return this.nf.parse(source, parsePosition);
        }
    }
}

