/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.main.DeviceInterface;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.ValueFormat;
import dk.hkj.panels.BasicLargeNSmallPanel;
import dk.hkj.panels.BasicPanel;
import dk.hkj.vars.Var;
import java.awt.event.ActionEvent;
import java.util.List;

public class EfficiencyReadoutPanel
extends BasicLargeNSmallPanel {
    public static String panelName = "EfficiencyReadout";
    private Channel in = new Channel();
    private Channel out = new Channel();
    private String title = "";
    private ValueFormat fmt = new ValueFormat("??", "", ValueFormat.formatSI6);
    private ValueFormat fmtPct = new ValueFormat("??", "", ValueFormat.formatD3);

    public EfficiencyReadoutPanel() {
        super(2);
        this.small1LeftLabel.setToolTipText("Voltage drop");
        this.small1RightLabel.setToolTipText("Power loss");
        this.small2LeftLabel.setToolTipText("Power in");
        this.small2RightLabel.setToolTipText("Power out");
        this.displayLayout(this.includeName);
    }

    @Override
    public String getPanelName() {
        return panelName;
    }

    @Override
    public BasicPanel.ParamsSet getParamsSet() {
        BasicPanel.ParamsSet ps = super.getParamsSet();
        ps.nChannels = 4;
        return ps;
    }

    @Override
    public void setParams(BasicPanel.ParamsSet paramsSet) {
        super.setParams(paramsSet);
        this.in.device = paramsSet.channels.get(0);
        this.in.auxDevice = paramsSet.channels.get(1);
        this.out.device = paramsSet.channels.get(2);
        this.out.auxDevice = paramsSet.channels.get(3);
        this.in.setup();
        this.out.setup();
    }

    @Override
    public void update() {
        if (!this.isVisible()) {
            return;
        }
        if (!this.in.valid || !this.out.valid) {
            super.update(this.title);
            return;
        }
        this.in.update();
        this.out.update();
        double eff = 1.0 - (this.in.watt - this.out.watt) / this.in.watt;
        if (this.in.watt <= 1.0E-12 && this.out.watt <= 1.0E-12) {
            eff = 0.0;
        }
        this.update(this.title, String.valueOf(this.fmtPct.format.formatDisplay(eff * 100.0)) + "%", "Drop:" + this.fmt.format.formatDisplay(this.in.volt - this.out.volt) + "V", "Loss:" + this.fmt.format.formatDisplay(this.in.watt - this.out.watt) + "W", "In:" + this.fmt.format.formatDisplay(this.in.watt) + "W", "Out:" + this.fmt.format.formatDisplay(this.out.watt) + "W");
    }

    private void setupValueNames() {
        this.title = String.valueOf(this.in.getTitle()) + " -> " + this.out.getTitle();
        this.nameLabel.setText(this.title);
        this.largeLabel.setToolTipText(this.title);
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean needData() {
        return true;
    }

    @Override
    protected void popupMenuAdjust() {
        List<String> dmm = InterfaceThreads.getDevicesHandlesWithInterface("*", "readValue", true);
        List<String> main = InterfaceThreads.getDevicesHandlesWithInterface("*", "readCurrent", true);
        List<String> aux = InterfaceThreads.getDevicesHandlesWithInterface("*", "readVoltage", true);
        aux.add(0, "");
        for (String n : dmm) {
            String u;
            DeviceInterface di = InterfaceThreads.getLoadedDeviceInterfaceHandle(n);
            if (di == null) continue;
            int channel = 1;
            int i = n.indexOf(58);
            if (i > 1) {
                channel = Integer.parseInt(n.substring(i + 1));
            }
            if ((u = di.executeIFace("unitValue", channel, "").asString()).equals("V")) {
                aux.add(n);
                continue;
            }
            if (!u.equals("A")) continue;
            main.add(n);
        }
        main.sort(null);
        aux.sort(null);
        this.selectMenu("In (All or Current)", "in1:", this.in.device, main, '.', this);
        this.selectMenu("Optional in (Voltage)", "in2:", this.in.auxDevice, aux, '.', this);
        this.selectMenu("Out (All or Current)", "out1:", this.out.device, main, '.', this);
        this.selectMenu("Optional out (Voltage)", "out2:", this.out.auxDevice, aux, '.', this);
        super.popupMenuAdjust();
        this.addBasicPopupMenu();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().startsWith("in1:")) {
            this.in.device = arg0.getActionCommand().substring(4);
            this.in.setup();
            this.setupValueNames();
        } else if (arg0.getActionCommand().startsWith("in2:")) {
            this.in.auxDevice = arg0.getActionCommand().substring(4);
            this.in.setup();
            this.setupValueNames();
        } else if (arg0.getActionCommand().startsWith("out1:")) {
            this.out.device = arg0.getActionCommand().substring(5);
            this.out.setup();
            this.setupValueNames();
        } else if (arg0.getActionCommand().startsWith("out2:")) {
            this.out.auxDevice = arg0.getActionCommand().substring(5);
            this.out.setup();
            this.setupValueNames();
        }
    }

    @Override
    public String generateScriptCmd() {
        StringBuilder sb = new StringBuilder();
        sb.append(panelName);
        sb.append(" ");
        sb.append(this.in.device == null || this.in.device.isEmpty() ? "?" : this.in.device);
        sb.append(" ");
        sb.append(this.in.auxDevice == null || this.in.auxDevice.isEmpty() ? "-" : this.in.auxDevice);
        sb.append(" ");
        sb.append(this.out.device == null || this.out.device.isEmpty() ? "?" : this.out.device);
        sb.append(" ");
        sb.append(this.out.auxDevice == null || this.out.auxDevice.isEmpty() ? "-" : this.out.auxDevice);
        sb.append(" ");
        sb.append(this.generateParams());
        sb.append(this.generateParamsColor());
        return sb.toString();
    }

    private class Channel {
        boolean valid = false;
        String device = "";
        String auxDevice = "";
        String voltage = "";
        String current = "";
        String power = "";
        double volt = 0.0;
        double amps = 0.0;
        double watt = 0.0;

        private Channel() {
        }

        private String getTitle() {
            if (this.auxDevice == null || this.auxDevice.isEmpty() || this.auxDevice.equals(this.device)) {
                return this.device;
            }
            return String.valueOf(this.device) + "/" + this.auxDevice;
        }

        private void setup() {
            this.valid = false;
            this.voltage = "";
            this.current = "";
            this.power = "";
            if (this.auxDevice.equals("-")) {
                this.auxDevice = "";
            }
            try {
                DeviceInterface di = InterfaceThreads.getLoadedDeviceInterfaceHandle(this.device);
                if (di == null) {
                    return;
                }
                int deviceChannel = 1;
                int i = this.device.indexOf(58);
                if (i > 1) {
                    deviceChannel = Integer.parseInt(this.device.substring(i + 1));
                }
                if (this.auxDevice == null || this.auxDevice.isEmpty()) {
                    this.voltage = di.executeIFace("nameVoltage", deviceChannel, "").asString();
                    this.current = di.executeIFace("nameCurrent", deviceChannel, "").asString();
                    this.power = di.getIFaces().containsKey("readPower") ? di.executeIFace("namePower", deviceChannel, "").asString() : null;
                } else {
                    DeviceInterface auxdi = InterfaceThreads.getLoadedDeviceInterfaceHandle(this.auxDevice);
                    if (auxdi == null) {
                        return;
                    }
                    int auxDeviceChannel = 1;
                    if (i > 1) {
                        auxDeviceChannel = Integer.parseInt(this.auxDevice.substring(i + 1));
                    }
                    if (di.getIFaces().containsKey("readCurrent")) {
                        this.current = di.executeIFace("nameCurrent", deviceChannel, "").asString();
                    } else {
                        this.current = di.executeIFace("nameValue", deviceChannel, "").asString();
                        if (!di.executeIFace("unitValue", deviceChannel, "").asString().equals("A")) {
                            this.current = "";
                        }
                    }
                    if (auxdi.getIFaces().containsKey("readVoltage")) {
                        this.voltage = auxdi.executeIFace("nameVoltage", auxDeviceChannel, "").asString();
                    } else {
                        this.voltage = auxdi.executeIFace("nameValue", auxDeviceChannel, "").asString();
                        if (!auxdi.executeIFace("unitValue", deviceChannel, "").asString().equals("V")) {
                            this.voltage = "";
                        }
                    }
                }
                this.valid = true;
            }
            catch (Exception exception) {}
        }

        private void update() {
            try {
                this.volt = Var.gl.find(this.voltage).asDouble();
                this.amps = Var.gl.find(this.current).asDouble();
                this.watt = this.power == null || this.power.isEmpty() ? this.volt * this.amps : Var.gl.find(this.power).asDouble();
            }
            catch (Exception exception) {
                this.volt = Double.NaN;
                this.amps = Double.NaN;
                this.watt = Double.NaN;
            }
        }
    }
}

