/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.ValueFormat;
import dk.hkj.panels.BasicDualReadoutPanel;
import dk.hkj.panels.BasicPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;

public class DualReadoutPanel
extends BasicDualReadoutPanel
implements ActionListener {
    public static String panelName = "DualReadout";
    protected String channel1 = null;
    protected String channel2 = null;
    protected ValueFormat fmt1 = new ValueFormat("??", "", ValueFormat.formatD2);
    protected ValueFormat fmt2 = new ValueFormat("??", "", ValueFormat.formatD2);

    public DualReadoutPanel() {
        this.displayLayout(true);
    }

    @Override
    public String getPanelName() {
        return panelName;
    }

    @Override
    public BasicPanel.ParamsSet getParamsSet() {
        BasicPanel.ParamsSet ps = super.getParamsSet();
        ps.nChannels = 2;
        return ps;
    }

    @Override
    public void setParams(BasicPanel.ParamsSet paramsSet) {
        this.channel1 = paramsSet.channels.get(0);
        this.fmt1 = InterfaceThreads.findValueFormat(this.channel1);
        this.valueLabel1.setToolTipText(this.channel1);
        this.channel2 = paramsSet.channels.get(1);
        this.fmt2 = InterfaceThreads.findValueFormat(this.channel2);
        this.valueLabel2.setToolTipText(this.channel1);
        this.setNames();
        super.setParams(paramsSet);
    }

    @Override
    public void update() {
        double v;
        String value1 = "888888";
        String value2 = "888888";
        if (this.channel1 != null && !Double.isNaN(v = this.readValue(this.channel1))) {
            value1 = String.valueOf(this.fmt1.format.formatDisplay(v)) + this.fmt1.unit;
        }
        if (this.channel2 != null && !Double.isNaN(v = this.readValue(this.channel2))) {
            value2 = String.valueOf(this.fmt2.format.formatDisplay(v)) + this.fmt2.unit;
        }
        this.update(value1, value2);
    }

    @Override
    public void reset() {
    }

    @Override
    protected void popupMenuAdjust() {
        List<String> list = InterfaceThreads.listChannels(true, "*");
        this.selectMenu(this.horizontal ? "Select left channel" : "Select top channel", "C1:", this.channel1, list, '.', this);
        this.selectMenu(this.horizontal ? "Select right channel" : "Select bottom channel", "C2:", this.channel2, list, '.', this);
        this.addBasicPopupMenu();
    }

    public void setNames() {
        if (this.channel1 == null || this.channel2 == null) {
            super.setNames("--empty--", "--empty--");
            return;
        }
        int i1 = this.channel1.indexOf(46);
        int i2 = this.channel2.indexOf(46);
        if (i1 > 0 && i1 == i2 && this.channel1.substring(0, i1).equalsIgnoreCase(this.channel2.substring(0, i2))) {
            super.setNames(this.channel1.substring(0, i1), null);
        } else {
            super.setNames(this.channel1, this.channel2);
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().startsWith("C1:")) {
            this.channel1 = arg0.getActionCommand().substring(3);
            this.fmt1 = InterfaceThreads.findValueFormat(this.channel1);
            this.valueLabel1.setToolTipText(this.channel1);
            this.setNames();
        } else if (arg0.getActionCommand().startsWith("C2:")) {
            this.channel2 = arg0.getActionCommand().substring(3);
            this.fmt2 = InterfaceThreads.findValueFormat(this.channel2);
            this.valueLabel2.setToolTipText(this.channel2);
            this.setNames();
        }
    }

    @Override
    public boolean needData() {
        return true;
    }

    @Override
    public String generateScriptCmd() {
        StringBuilder sb = new StringBuilder();
        sb.append(panelName);
        sb.append(" ");
        sb.append(this.channel1);
        sb.append(" ");
        sb.append(this.channel2);
        sb.append(" ");
        sb.append(this.generateParams());
        if (this.horizontal) {
            sb.append("hz ");
        }
        sb.append(this.generateParamsColor());
        return sb.toString();
    }
}

