/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.main.DeviceInterface;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.ValueFormat;
import dk.hkj.panels.BasicDualReadoutPanel;
import dk.hkj.panels.BasicPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;

public class DualDeviceReadoutPanel
extends BasicDualReadoutPanel
implements ActionListener {
    public static String panelName = "DualDeviceReadout";
    protected String device = null;
    protected DeviceInterface di = null;

    public DualDeviceReadoutPanel() {
        this.displayLayout(true);
    }

    @Override
    public String getPanelName() {
        return panelName;
    }

    @Override
    public BasicPanel.ParamsSet getParamsSet() {
        BasicPanel.ParamsSet ps = super.getParamsSet();
        ps.nChannels = 1;
        return ps;
    }

    @Override
    public void setParams(BasicPanel.ParamsSet paramsSet) {
        this.device = paramsSet.channels.get(0);
        this.di = InterfaceThreads.getLoadedDeviceInterfaceHandle(this.device);
        super.setParams(paramsSet);
        this.setDevice();
    }

    @Override
    public void update() {
        String value1 = "888888";
        String value2 = "888888";
        if (this.di != null) {
            double v;
            value1 = "---";
            value2 = "---";
            String c1 = this.di.getValueName(0);
            String c2 = this.di.getValueName(1);
            if (!c1.isEmpty()) {
                c1 = String.valueOf(this.device) + "." + c1;
                v = this.readValue(c1);
                ValueFormat fmt1 = InterfaceThreads.findValueFormat(c1);
                if (!Double.isNaN(v)) {
                    value1 = String.valueOf(fmt1.format.formatDisplay(v)) + fmt1.unit;
                }
            }
            if (!c2.isEmpty()) {
                c2 = String.valueOf(this.device) + "." + c2;
                v = this.readValue(c2);
                ValueFormat fmt2 = InterfaceThreads.findValueFormat(c2);
                if (!Double.isNaN(v)) {
                    value2 = String.valueOf(fmt2.format.formatDisplay(v)) + fmt2.unit;
                }
            }
            super.setNames(c1, c2);
        }
        this.update(value1, value2);
    }

    @Override
    public void reset() {
    }

    @Override
    protected void popupMenuAdjust() {
        List<String> list = InterfaceThreads.listDeviceHandles();
        this.selectMenu("Select device", "D:", this.device, list, '.', this);
        this.addBasicPopupMenu();
    }

    public void setDevice() {
        this.di = InterfaceThreads.getLoadedDeviceInterfaceHandle(this.device);
        if (this.di == null) {
            return;
        }
        super.setNames(this.device, this.device);
        this.valueLabel2.setToolTipText(this.device);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().startsWith("D:")) {
            this.device = arg0.getActionCommand().substring(2);
            this.valueLabel1.setToolTipText(this.device);
            this.setDevice();
        }
    }

    @Override
    public boolean needData() {
        return true;
    }

    @Override
    public String generateScriptCmd() {
        StringBuilder sb = new StringBuilder();
        sb.append(panelName);
        sb.append(" ");
        sb.append(this.device);
        sb.append(" ");
        sb.append(this.generateParams());
        if (this.horizontal) {
            sb.append("hz ");
        }
        sb.append(this.generateParamsColor());
        return sb.toString();
    }
}

