/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.main.FontAdjust;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.Support;
import dk.hkj.panels.BasicChartPanel;
import dk.hkj.panels.BasicPanel;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;

public class DualChartingPanel
extends BasicChartPanel
implements ActionListener {
    public static String panelName = "DualCharting";
    private static final Color color1 = Color.red;
    private static final Color color2 = Color.blue;
    private static final String[] TimeScales = new String[]{"Auto", "1m", "5m", "15m", "1h", "3h", "10h"};
    private DefaultXYDataset dataset1 = null;
    private DefaultXYDataset dataset2 = null;
    private String channel1 = null;
    private String channel2 = null;
    private List<SeriesPoint> currentSeries = new ArrayList<SeriesPoint>();
    private int divFactor = 1;
    private int divCount = 0;
    private String selectedTimeScale = TimeScales[0];
    private int scaleTime = 0;
    private char timeUnit = (char)32;

    public DualChartingPanel() {
        super(BasicChartPanel.ChartType.XY);
        this.dataset1 = new DefaultXYDataset();
        this.dataset2 = new DefaultXYDataset();
        XYPlot plot = this.freeChart.getXYPlot();
        plot.setRenderer(1, new XYLineAndShapeRenderer());
        plot.setDataset(0, this.dataset1);
        plot.setDataset(1, this.dataset2);
        plot.mapDatasetToRangeAxis(1, 1);
        plot.setRangeAxis(1, new NumberAxis(null));
        ((XYLineAndShapeRenderer)plot.getRenderer(0)).setDefaultShapesVisible(false);
        ((XYLineAndShapeRenderer)plot.getRenderer(1)).setDefaultShapesVisible(false);
        ((NumberAxis)plot.getRangeAxis(0)).setAutoRangeIncludesZero(false);
        ((NumberAxis)plot.getRangeAxis(1)).setAutoRangeIncludesZero(false);
        Support.MyDecimalFormat nf = new Support.MyDecimalFormat();
        nf.setMaximumFractionDigits(1);
        nf.setSIFormat(true);
        ((NumberAxis)plot.getRangeAxis(0)).setNumberFormatOverride(nf);
        ((NumberAxis)plot.getRangeAxis(1)).setNumberFormatOverride(nf);
        ((NumberAxis)plot.getDomainAxis()).setNumberFormatOverride(new MyTimeFormat());
        this.freeChart.getXYPlot().getRenderer().setDefaultToolTipGenerator(new XYToolTipGenerator(){

            @Override
            public String generateToolTip(XYDataset arg0, int arg1, int arg2) {
                return DualChartingPanel.this.channel1 == null ? "" : DualChartingPanel.this.channel1;
            }
        });
        plot.getRenderer(0).setSeriesPaint(0, color1);
        plot.getRenderer(1).setSeriesPaint(0, color2);
        plot.setRangeAxisLocation(0, AxisLocation.TOP_OR_LEFT);
        plot.setRangeAxisLocation(1, AxisLocation.BOTTOM_OR_RIGHT);
        this.updateColor();
        this.displayLayout(true);
    }

    @Override
    public String getPanelName() {
        return panelName;
    }

    @Override
    public BasicPanel.ParamsSet getParamsSet() {
        BasicPanel.ParamsSet ps = super.getParamsSet();
        ps.addParams(new String[]{"time", "value1", "value2"});
        ps.nChannels = 2;
        return ps;
    }

    @Override
    public void setParams(BasicPanel.ParamsSet paramsSet) {
        super.setParams(paramsSet);
        this.channel1 = paramsSet.channels.get(0);
        this.channel2 = paramsSet.channels.get(1);
        Double t = paramsSet.getTime("time");
        if (t != null) {
            this.setTimeScale((int)t.doubleValue());
        }
        this.setRange(this.freeChart.getXYPlot().getRangeAxis(0), paramsSet.getString("value1"));
        this.setRange(this.freeChart.getXYPlot().getRangeAxis(1), paramsSet.getString("value2"));
        this.setToolTipText(String.valueOf(this.channel1) + " " + this.channel2);
        this.nameLabel.setText(this.combineNames(this.channel1, this.channel2, '.'));
        this.displayLayout(this.includeName);
        this.freeChart.getXYPlot().getDomainAxis().setVisible(this.includeScales);
        this.freeChart.getXYPlot().getRangeAxis(0).setVisible(this.includeScales);
        this.freeChart.getXYPlot().getRangeAxis(1).setVisible(this.includeScales);
    }

    @Override
    public void update() {
        int i;
        if (!this.isVisible()) {
            return;
        }
        double t = (double)System.currentTimeMillis() / 1000.0;
        if (this.channel1 != null && this.channel2 != null) {
            double v1 = this.readValue(this.channel1);
            double v2 = this.readValue(this.channel2);
            if (!Double.isNaN(v1) && !Double.isNaN(v2)) {
                ++this.divCount;
                if (this.divCount >= this.divFactor) {
                    this.currentSeries.add(new SeriesPoint(t, v1, v2));
                    this.divCount = 0;
                    if (this.currentSeries.size() > this.getWidth() * 4) {
                        this.divFactor *= 2;
                        ArrayList<SeriesPoint> s = new ArrayList<SeriesPoint>();
                        i = 0;
                        while (i < this.currentSeries.size() / 2) {
                            s.add(this.currentSeries.get(i * 2));
                            ++i;
                        }
                        this.currentSeries = s;
                    }
                    this.requestDisplayUpdate = true;
                }
            }
        }
        if (this.requestDisplayUpdate) {
            this.sizeChartPanel();
            int tt = this.scaleTime;
            if (this.scaleTime == 0 && this.currentSeries.size() > 0) {
                tt = Math.max((int)(t - this.currentSeries.get((int)0).time), this.scaleTime);
            }
            double f = 1.0;
            if (tt < 310) {
                this.timeUnit = (char)32;
            } else if (tt < 7220) {
                this.timeUnit = (char)109;
                f = 60.0;
            } else {
                this.timeUnit = (char)104;
                f = 3600.0;
            }
            while (this.scaleTime > 0 && this.currentSeries.size() > 0 && this.currentSeries.get((int)0).time - t < (double)(-this.scaleTime - 10)) {
                this.currentSeries.remove(0);
            }
            double[][] series1 = new double[2][this.currentSeries.size()];
            double[][] series2 = new double[2][this.currentSeries.size()];
            i = 0;
            while (i < this.currentSeries.size()) {
                SeriesPoint sp = this.currentSeries.get(i);
                series1[0][i] = (sp.time - t) / f;
                series1[1][i] = sp.value1;
                series2[0][i] = (sp.time - t) / f;
                series2[1][i] = sp.value2;
                ++i;
            }
            if (this.scaleTime > 0) {
                this.freeChart.getXYPlot().getDomainAxis().setRange((double)(-this.scaleTime) / f, 0.0);
            }
            this.dataset1.addSeries((Comparable)((Object)"data1"), series1);
            this.dataset2.addSeries((Comparable)((Object)"data2"), series2);
        }
        this.requestDisplayUpdate = false;
    }

    @Override
    protected void popupMenuAdjust() {
        FontAdjust.FontRadioButtonMenuItem mi = null;
        FontAdjust.FontMenu menu = null;
        this.selectMenu("Select left channel", "C1:", this.channel1, InterfaceThreads.listChannels(true, "*"), '.', this);
        this.selectMenu("Select right channel", "C2:", this.channel2, InterfaceThreads.listChannels(true, "*"), '.', this);
        if (this.currentSeries.size() > 2) {
            menu = new FontAdjust.FontMenu("Left value scale");
            this.popupMenu.add(menu);
            double min1 = Double.MAX_VALUE;
            double max1 = -1.7976931348623157E308;
            double min2 = Double.MAX_VALUE;
            double max2 = -1.7976931348623157E308;
            for (SeriesPoint sp : this.currentSeries) {
                if (sp.value1 > max1) {
                    max1 = sp.value1;
                }
                if (sp.value1 < min1) {
                    min1 = sp.value1;
                }
                if (sp.value2 > max2) {
                    max2 = sp.value2;
                }
                if (!(sp.value2 < min2)) continue;
                min2 = sp.value2;
            }
            this.addValueRangeMenu(menu, this.freeChart.getXYPlot().getRangeAxis(0), min1, max1);
            menu = new FontAdjust.FontMenu("Right value scale");
            this.popupMenu.add(menu);
            this.addValueRangeMenu(menu, this.freeChart.getXYPlot().getRangeAxis(1), min2, max2);
        }
        menu = new FontAdjust.FontMenu("Time scale");
        this.popupMenu.add(menu);
        String[] stringArray = TimeScales;
        int n = TimeScales.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            mi = new FontAdjust.FontRadioButtonMenuItem(t);
            if (this.selectedTimeScale.equals(t)) {
                mi.setSelected(true);
            }
            mi.setActionCommand("TS:" + t);
            mi.addActionListener(this);
            menu.add(mi);
            ++n2;
        }
        this.addBasicPopupMenu();
    }

    @Override
    protected boolean supportReset() {
        return true;
    }

    @Override
    public void reset() {
        this.currentSeries.clear();
        this.divFactor = 1;
        this.requestDisplayUpdate = true;
    }

    private void setTimeScale(int v) {
        ValueAxis domain = this.freeChart.getXYPlot().getDomainAxis();
        if (v == 0) {
            domain.setAutoRange(true);
            this.scaleTime = 0;
            this.selectedTimeScale = "Auto";
        } else {
            domain.setAutoRange(false);
            this.scaleTime = v;
            this.selectedTimeScale = this.scaleTime % 3600 == 0 ? this.scaleTime / 3600 + "h" : (this.scaleTime % 60 == 0 ? this.scaleTime / 60 + "m" : "" + this.scaleTime);
        }
        this.requestDisplayUpdate = true;
    }

    private void setTimeScale(String v) {
        if (this.selectedTimeScale.matches("[0-9]+")) {
            this.setTimeScale(Integer.parseInt(this.selectedTimeScale.substring(0, this.selectedTimeScale.length() - 1)));
        } else if (this.selectedTimeScale.matches("[0-9]+m")) {
            this.setTimeScale(Integer.parseInt(this.selectedTimeScale.substring(0, this.selectedTimeScale.length() - 1)) * 60);
        } else if (this.selectedTimeScale.matches("[0-9]+h")) {
            this.setTimeScale(Integer.parseInt(this.selectedTimeScale.substring(0, this.selectedTimeScale.length() - 1)) * 3600);
        } else {
            this.setTimeScale(0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().startsWith("C1:")) {
            this.channel1 = arg0.getActionCommand().substring(3);
            this.nameLabel.setText(this.combineNames(this.channel1, this.channel2, '.'));
            this.setToolTipText(this.nameLabel.getText());
            this.chartPanel.setToolTipText(this.nameLabel.getText());
            this.reset();
        } else if (arg0.getActionCommand().startsWith("C2:")) {
            this.channel2 = arg0.getActionCommand().substring(3);
            this.nameLabel.setText(this.combineNames(this.channel1, this.channel2, '.'));
            this.setToolTipText(this.nameLabel.getText());
            this.chartPanel.setToolTipText(this.nameLabel.getText());
            this.reset();
        } else if (arg0.getActionCommand().startsWith("TS:")) {
            this.setTimeScale(arg0.getActionCommand().substring(3));
        }
    }

    @Override
    public boolean needData() {
        return true;
    }

    @Override
    public void updateColor() {
        super.updateColor();
        XYPlot plot = this.freeChart.getXYPlot();
        ValueAxis range = plot.getRangeAxis(0);
        range.setLabelPaint(color1);
        range.setTickLabelPaint(color1);
        range.setTickMarkPaint(color1);
        range = plot.getRangeAxis(1);
        range.setLabelPaint(color2);
        range.setTickLabelPaint(color2);
        range.setTickMarkPaint(color2);
    }

    @Override
    public String generateScriptCmd() {
        StringBuilder sb = new StringBuilder();
        sb.append(panelName);
        sb.append(" ");
        sb.append(this.channel1);
        sb.append(" ");
        sb.append(this.channel2);
        sb.append(" ");
        sb.append(this.generateParams());
        if (!this.selectedTimeScale.equalsIgnoreCase(TimeScales[0])) {
            sb.append("time:");
            sb.append(this.selectedTimeScale);
            sb.append(" ");
        }
        if (!this.freeChart.getXYPlot().getRangeAxis(0).isAutoRange()) {
            sb.append("value1:");
            sb.append(this.getRangeString(this.freeChart.getXYPlot().getRangeAxis(0)));
            sb.append(" ");
        }
        if (!this.freeChart.getXYPlot().getRangeAxis(1).isAutoRange()) {
            sb.append("value2:");
            sb.append(this.getRangeString(this.freeChart.getXYPlot().getRangeAxis(1)));
            sb.append(" ");
        }
        sb.append(this.generateParamsColor());
        return sb.toString();
    }

    public class MyTimeFormat
    extends DecimalFormat {
        DecimalFormat df = new DecimalFormat("##0.0;-##0.0");
        boolean siFormat = false;
        boolean eFormat = false;

        public MyTimeFormat() {
            this.df.setGroupingUsed(false);
            super.setGroupingUsed(false);
            DecimalFormatSymbols dfs = new DecimalFormatSymbols();
            dfs.setDecimalSeparator('.');
            this.df.setDecimalFormatSymbols(dfs);
            super.setDecimalFormatSymbols(dfs);
        }

        @Override
        public StringBuffer format(double number, StringBuffer sbuf, FieldPosition pos) {
            super.format(number, sbuf, pos);
            if (DualChartingPanel.this.timeUnit != ' ') {
                sbuf.append(DualChartingPanel.this.timeUnit);
            }
            return sbuf;
        }
    }

    private class SeriesPoint {
        double time;
        double value1;
        double value2;

        public SeriesPoint(double time, double value1, double value2) {
            this.time = time;
            this.value1 = value1;
            this.value2 = value2;
        }
    }
}

