/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.devices.SetupFormatsAdjuster;
import dk.hkj.main.FontAdjust;
import dk.hkj.panels.BasicAdjustPanel;
import dk.hkj.panels.BasicPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class DualAdjustPanel
extends BasicAdjustPanel
implements ActionListener {
    public static String panelName = "DualAdjust";
    protected String param = null;

    public DualAdjustPanel() {
        super(2);
    }

    @Override
    public BasicPanel.ParamsSet getParamsSet() {
        BasicPanel.ParamsSet ps = super.getParamsSet();
        ps.nChannels = 2;
        return ps;
    }

    @Override
    public void setParams(BasicPanel.ParamsSet paramsSet) {
        this.channelData[0].setParamName(paramsSet.channels.get(0));
        this.channelData[1].setParamName(paramsSet.channels.get(1));
        this.setNameLabel();
        super.setParams(paramsSet);
        this.forceFontResize();
    }

    private void setNameLabel() {
        this.nameLabel.setText(this.combineNames(this.channelData[0].getParamName(), this.channelData[1].getParamName(), ' '));
    }

    @Override
    protected void popupMenuAdjust() {
        this.selectMenu("Select param 1", "P1:", this.channelData[0].getParamName(), SetupFormatsAdjuster.listAdjustableParamsNames(false), ' ', this);
        this.selectMenu("Select param 2", "P2:", this.channelData[1].getParamName(), SetupFormatsAdjuster.listAdjustableParamsNames(false), ' ', this);
        FontAdjust.FontMenuItem mi = new FontAdjust.FontMenuItem("Min/max 1");
        mi.setActionCommand("mm1");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Min/max 2");
        mi.setActionCommand("mm2");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        FontAdjust.FontMenu menu = new FontAdjust.FontMenu("Precision 1");
        this.popupMenu.add(menu);
        this.channelData[0].precisionMenu(menu);
        menu = new FontAdjust.FontMenu("Precision 2");
        this.popupMenu.add(menu);
        this.channelData[1].precisionMenu(menu);
        this.addBasicPopupMenu();
    }

    @Override
    public String getPanelName() {
        return panelName;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().startsWith("P1:")) {
            this.channelData[0].setParamName(arg0.getActionCommand().substring(3));
            this.setNameLabel();
            this.forceFontResize();
        } else if (arg0.getActionCommand().startsWith("P2:")) {
            this.channelData[1].setParamName(arg0.getActionCommand().substring(3));
            this.setNameLabel();
            this.forceFontResize();
        } else if (arg0.getActionCommand().equals("mm1")) {
            this.channelData[0].adjustMinMax();
        } else if (arg0.getActionCommand().equals("mm2")) {
            this.channelData[1].adjustMinMax();
        }
    }

    @Override
    public String generateScriptCmd() {
        StringBuilder sb = new StringBuilder();
        sb.append(panelName);
        sb.append(" \"");
        sb.append(this.channelData[0].getParamName());
        sb.append("\" \"");
        sb.append(this.channelData[1].getParamName());
        sb.append("\" ");
        sb.append(this.generateParams());
        sb.append(this.generateParamsColor());
        return sb.toString();
    }
}

