/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.devices.SetupFormatsAdjuster;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.PopupAdjustScale;
import dk.hkj.main.PopupParamAdjuster;
import dk.hkj.main.Support;
import dk.hkj.panels.BasicButtonsPanel;
import dk.hkj.panels.BasicPanel;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class DevicePopupsPanel
extends BasicButtonsPanel {
    public static String panelName = "DevicePopups";
    protected String deviceHandle = null;
    protected DeviceInterface di = null;
    private BasicButtonsPanel.Button modeButton = null;
    protected boolean includeMode = true;
    protected boolean includeSetup = true;
    protected Support.StringListIC includeAdjust = new Support.StringListIC();
    protected Support.StringListIC includeAdjuster = new Support.StringListIC();

    public DevicePopupsPanel() {
        this.defineButtons();
    }

    @Override
    public String getPanelName() {
        return panelName;
    }

    @Override
    public BasicPanel.ParamsSet getParamsSet() {
        BasicPanel.ParamsSet ps = super.getParamsSet();
        ps.addParams(new String[]{"mode", "setup", "adjust", "adjuster"});
        ps.nChannels = 1;
        return ps;
    }

    @Override
    public void setParams(BasicPanel.ParamsSet paramsSet) {
        String[] params;
        int n;
        this.deviceHandle = paramsSet.channels.get(0);
        if (this.deviceHandle.equals("?")) {
            this.deviceHandle = null;
        } else {
            this.di = InterfaceThreads.getLoadedDeviceInterfaceHandle(this.deviceHandle);
        }
        this.includeMode = paramsSet.isPresent("mode");
        this.includeSetup = paramsSet.isPresent("setup");
        String[] channels = paramsSet.getStrings("adjust");
        if (channels != null) {
            String[] stringArray = channels;
            n = channels.length;
            int n2 = 0;
            while (n2 < n) {
                String channel = stringArray[n2];
                if ((channel = channel.trim()).length() > 0) {
                    this.includeAdjust.add(channel);
                }
                ++n2;
            }
        }
        if ((params = paramsSet.getStrings("adjuster")) != null) {
            String[] stringArray = params;
            int n3 = params.length;
            n = 0;
            while (n < n3) {
                String param = stringArray[n];
                if ((param = param.trim()).length() > 0) {
                    this.includeAdjuster.add(param);
                }
                ++n;
            }
        }
        this.defineButtons();
        super.setParams(paramsSet);
    }

    @Override
    public void setSize(Dimension dim) {
        super.setSize(dim);
        this.displayLayout(this.includeName);
    }

    private void setUseModeMenu() {
        boolean use;
        boolean bl = use = this.includeName || this.buttons.size() > 1;
        if (this.modeButton != null) {
            this.modeButton.getButton().setInheritsPopupMenu(!use);
        }
    }

    private void defineButtons() {
        this.nameLabel.setText(this.deviceHandle);
        this.buttons.clear();
        this.modeButton = null;
        if (this.includeMode && (this.di == null || this.di.haveModesPopup())) {
            this.modeButton = new BasicButtonsPanel.Button(this, "Mode", "mode", "Open mode popup", this.di != null);
            this.modeButton.getButton().setComponentPopupMenu(null);
            this.modeButton.getButton().addMouseListener(new MouseAdapter(){

                private void showPopupMenu() {
                    if (DevicePopupsPanel.this.di != null) {
                        DevicePopupsPanel.this.di.showModesMenu(DevicePopupsPanel.this.modeButton.getButton());
                    }
                }

                @Override
                public void mousePressed(MouseEvent arg0) {
                    DevicePopupsPanel.this.setUseModeMenu();
                    if (arg0.isPopupTrigger()) {
                        this.showPopupMenu();
                    }
                }

                @Override
                public void mouseReleased(MouseEvent arg0) {
                    if (arg0.isPopupTrigger()) {
                        this.showPopupMenu();
                    }
                }
            });
            this.buttons.add(this.modeButton);
        }
        if (this.includeSetup && (this.di == null || this.di.haveSetupPopup())) {
            this.buttons.add(new BasicButtonsPanel.Button(this, "Setup", "setup", "Open setup popup", this.di != null));
        }
        if (this.di != null) {
            String s;
            for (String channel : this.includeAdjust) {
                if (channel.equalsIgnoreCase("All")) {
                    this.buttons.add(new BasicButtonsPanel.Button(this, "Adjust", "A:All", "Adjust scale for all channels", this.di != null));
                    continue;
                }
                s = channel;
                if (s.toUpperCase().startsWith(this.di.getHandleName())) {
                    s = s.substring(this.di.getHandleName().length() + 1);
                }
                this.buttons.add(new BasicButtonsPanel.Button(this, "As:" + s, "A:" + channel, "Adjust scale for " + s, this.di != null));
            }
            for (String param : this.includeAdjuster) {
                if (param.equalsIgnoreCase("All")) {
                    this.buttons.add(new BasicButtonsPanel.Button(this, "Adjuster", "PA:All", "Param adjuster with selection for all device params", this.di != null));
                    continue;
                }
                s = param;
                if (s.toUpperCase().startsWith(this.di.getHandleName())) {
                    s = s.substring(this.di.getHandleName().length() + 1);
                }
                this.buttons.add(new BasicButtonsPanel.Button(this, "Pa:" + s, "PA:" + param, "Param adjuster for " + s, this.di != null));
            }
        }
        this.buttons.sort(null);
        this.setUseModeMenu();
        this.displayLayout(this.includeName);
        this.forceFontResize();
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean needData() {
        return false;
    }

    private void doFunction(String func) {
        if (this.di == null) {
            return;
        }
        if (func.equals("mode")) {
            this.di.showModesPopup(this);
        } else if (func.equals("setup")) {
            this.di.showSetupPopup(this);
        }
    }

    private void doAdjust(String channel) {
        if (channel.equals("All")) {
            channel = String.valueOf(this.di.getHandleName()) + ".*";
        }
        PopupAdjustScale pas = PopupAdjustScale.getPopup();
        pas.filterChannels(channel);
        pas.setLocation(this.getLocationOnScreen());
        pas.setVisible(true);
    }

    @Override
    protected void popupMenuAdjust() {
        FontAdjust.FontCheckBoxMenuItem mi = null;
        this.selectMenu("Select device", "D:", this.deviceHandle, InterfaceThreads.getDevicesHandlesWithInterface("*", "", false), ' ', this);
        if (this.di == null || this.di.haveModesPopup()) {
            mi = null;
            mi = new FontAdjust.FontCheckBoxMenuItem("Include mode");
            mi.setSelected(this.includeMode);
            mi.setActionCommand("mode");
            mi.addActionListener(this);
            this.popupMenu.add(mi);
        }
        if (this.di == null || this.di.haveSetupPopup()) {
            mi = new FontAdjust.FontCheckBoxMenuItem("Include setup");
            mi.setSelected(this.includeSetup);
            mi.setActionCommand("setup");
            mi.addActionListener(this);
        }
        this.popupMenu.add(mi);
        if (this.di != null) {
            FontAdjust.FontMenu menu = new FontAdjust.FontMenu("Adjust");
            menu.addActionListener(this);
            this.popupMenu.add(menu);
            mi = new FontAdjust.FontCheckBoxMenuItem("All");
            mi.setSelected(this.includeAdjust.contains("All"));
            mi.setActionCommand("A:All");
            mi.addActionListener(this);
            menu.add(mi);
            for (String channel : InterfaceThreads.listChannels(true, String.valueOf(this.di.getHandleName()) + ".*")) {
                mi = new FontAdjust.FontCheckBoxMenuItem(channel);
                mi.setSelected(this.includeAdjust.contains(channel));
                mi.setActionCommand("A:" + channel);
                mi.addActionListener(this);
                menu.add(mi);
            }
            menu = new FontAdjust.FontMenu("Adjuster");
            menu.addActionListener(this);
            this.popupMenu.add(menu);
            mi = new FontAdjust.FontCheckBoxMenuItem("All");
            mi.setSelected(this.includeAdjuster.contains("All"));
            mi.setActionCommand("PA:All");
            mi.addActionListener(this);
            menu.add(mi);
            for (String param : SetupFormatsAdjuster.listAdjustableParamsNames(false)) {
                if (!param.matches(String.valueOf(this.di.getHandleName()) + " .*")) continue;
                mi = new FontAdjust.FontCheckBoxMenuItem(param);
                mi.setSelected(this.includeAdjuster.contains(param));
                mi.setActionCommand("PA:" + param);
                mi.addActionListener(this);
                menu.add(mi);
            }
        }
        this.addBasicPopupMenu();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().startsWith("mode")) {
            this.includeMode = !this.includeMode;
            this.defineButtons();
        } else if (e.getActionCommand().startsWith("setup")) {
            this.includeSetup = !this.includeSetup;
            this.defineButtons();
        } else if (e.getActionCommand().startsWith("A:")) {
            this.includeAdjust.flip(e.getActionCommand().substring(2));
            this.defineButtons();
        } else if (e.getActionCommand().startsWith("PA:")) {
            this.includeAdjuster.flip(e.getActionCommand().substring(3));
            this.defineButtons();
        } else if (e.getActionCommand().startsWith("D:")) {
            this.deviceHandle = e.getActionCommand().substring(2);
            this.di = InterfaceThreads.getLoadedDeviceInterfaceHandle(this.deviceHandle);
            this.defineButtons();
        } else if (e.getActionCommand().startsWith("F:A:")) {
            this.doAdjust(e.getActionCommand().substring(4));
        } else if (e.getActionCommand().startsWith("F:PA:")) {
            PopupParamAdjuster.getPopup(e.getActionCommand().substring(5));
        } else if (e.getActionCommand().startsWith("F:")) {
            this.doFunction(e.getActionCommand().substring(2));
        }
    }

    @Override
    public String generateScriptCmd() {
        StringBuilder sb = new StringBuilder();
        sb.append(panelName);
        sb.append(" ");
        sb.append(this.deviceHandle == null ? "?" : this.deviceHandle);
        sb.append(" ");
        if (this.includeMode) {
            sb.append("mode ");
        }
        if (this.includeSetup) {
            sb.append("setup ");
        }
        if (this.includeAdjust.size() > 0) {
            sb.append("adjust");
            for (String adjust : this.includeAdjust) {
                sb.append(":");
                sb.append(adjust);
            }
            sb.append(" ");
        }
        if (this.includeAdjuster.size() > 0) {
            sb.append("\"adjuster");
            for (String adjuster : this.includeAdjuster) {
                sb.append(":");
                sb.append(adjuster);
            }
            sb.append("\" ");
        }
        sb.append(this.generateParams());
        sb.append(this.generateParamsColor());
        return sb.toString();
    }
}

