/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.main.Support;
import dk.hkj.main.ValueFormat;
import dk.hkj.panels.BasicPanel;
import dk.hkj.script.Script;
import dk.hkj.vars.Var;

public class DataMathReadout {
    private int readouts = 0;
    private Script script = null;
    private String nameString = null;
    private String initScript = null;
    private String updateScript = null;
    private String[] units = null;
    private String errorMessage = "";
    private ValueFormat.ValueFormatter[] format;
    private long lastTime = System.currentTimeMillis();
    private Var[] display = null;
    private Var dt = null;
    private Var time = null;
    private boolean bits = false;
    private BasicPanel bp;

    public DataMathReadout(BasicPanel bp, int readouts) {
        this.bp = bp;
        this.init(readouts, false);
    }

    DataMathReadout(int readouts, boolean bits) {
        this.init(readouts, bits);
    }

    public boolean isBits() {
        return this.bits;
    }

    public void init(int readouts, boolean bits) {
        this.readouts = readouts;
        this.bits = bits;
        this.units = new String[readouts];
        this.format = new ValueFormat.ValueFormatter[readouts];
        this.display = new Var[readouts];
        int i = 0;
        while (i < readouts) {
            this.units[i] = "";
            this.format[i] = ValueFormat.getFormatter("SI");
            this.display[i] = Var.createValue("display" + (readouts == 1 ? "" : Integer.valueOf(i + 1)), "");
            ++i;
        }
        this.dt = Var.createValue("dt", 0);
        this.time = Var.createValue("time", 0);
        if (readouts == 1) {
            if (bits) {
                this.updateScript = "display=(display+1)%63;";
                this.initScript = "bitNames=\"B0 B1 B2 B3 B4 B5\"";
            } else {
                this.updateScript = "display=display+0.01;";
                this.initScript = "";
            }
        } else {
            this.updateScript = "display1=display1+0.01;\ndisplay2=display2-0.01;\n";
            this.initScript = "display2=100;\n";
            if (readouts >= 3) {
                this.initScript = String.valueOf(this.initScript) + "display3=\"Hello\";\n";
                this.format[2] = ValueFormat.getFormatter("Text");
            }
            if (readouts >= 4) {
                this.updateScript = String.valueOf(this.updateScript) + "display4=display1*10/3;\n";
            }
            if (readouts >= 5) {
                this.updateScript = String.valueOf(this.updateScript) + "display5=(display1*display2*1.1)/2.0;\n";
            }
        }
        this.nameString = "Test " + readouts;
        this.reset();
    }

    public String getVarAsString(String varName, String def) {
        if (this.script == null) {
            this.script = new Script(this.bp.script);
        }
        return this.script.getLocalVars().getAsString(varName, def);
    }

    public String getName() {
        return this.nameString;
    }

    public void setName(String name) {
        this.nameString = name;
    }

    public BasicPanel.ParamsSet getParamsSet(BasicPanel.ParamsSet ps) {
        ps.addParams(new String[]{"unit", "format"});
        ps.nChannels = 3;
        return ps;
    }

    public void setParams(BasicPanel.ParamsSet paramsSet) {
        String[] ff;
        this.nameString = paramsSet.channels.get(0);
        this.initScript = paramsSet.channels.get(1);
        this.updateScript = paramsSet.channels.get(2);
        String[] uu = paramsSet.getStrings("unit");
        if (uu != null) {
            int i = 0;
            while (i < this.readouts && i < uu.length) {
                this.units[i] = uu[i];
                ++i;
            }
        }
        if ((ff = paramsSet.getStrings("format")) != null) {
            int i = 0;
            while (i < this.readouts && i < ff.length) {
                this.format[i] = ValueFormat.getFormatter(ff[i]);
                ++i;
            }
        }
        this.reset();
    }

    public boolean isEmpty() {
        return this.nameString == null || this.nameString.length() == 0 || this.updateScript == null || this.updateScript.length() == 0;
    }

    public boolean isError() {
        return !this.errorMessage.isEmpty();
    }

    public int getReadouts() {
        return this.readouts;
    }

    public String getUnit(int i) {
        return this.units[i];
    }

    public void setUnit(int i, String unit) {
        this.units[i] = unit.replace(" ", "_");
    }

    public String getInitScript() {
        return this.initScript;
    }

    public void setInitScript(String script) {
        this.initScript = script;
    }

    public String getUpdateScript() {
        return this.updateScript;
    }

    public void setUpdateScript(String script) {
        this.updateScript = script;
    }

    public void setUnit(String script) {
        this.updateScript = script;
    }

    public ValueFormat.ValueFormatter getFormat(int i) {
        return this.format[i];
    }

    public void setFormat(int i, String name) {
        this.format[i] = ValueFormat.getFormatter(name);
    }

    public String[] updateHot() {
        String[] result = new String[this.readouts];
        try {
            int i = 0;
            while (i < this.readouts) {
                result[i] = String.valueOf(this.format[i].formatDisplay(this.display[i])) + this.units[i];
                ++i;
            }
        }
        catch (Exception exception) {}
        return result;
    }

    public long[] updateLong() {
        if (this.script == null) {
            this.script = new Script(this.bp.script);
        }
        long t = System.currentTimeMillis();
        long dt = t - this.lastTime;
        this.lastTime = t;
        this.time.set((double)this.lastTime / 1000.0);
        this.dt.set((double)dt / 1000.0);
        long[] result = new long[this.readouts];
        try {
            this.script.execute(this.updateScript);
            int i = 0;
            while (i < this.readouts) {
                result[i] = this.display[i].asLong();
                ++i;
            }
        }
        catch (Exception e) {
            this.errorMessage = e.getMessage();
            return null;
        }
        return result;
    }

    public double[] updateDouble() {
        if (this.script == null) {
            this.script = new Script(this.bp.script);
        }
        long t = System.currentTimeMillis();
        long dt = t - this.lastTime;
        this.lastTime = t;
        this.time.set((double)this.lastTime / 1000.0);
        this.dt.set((double)dt / 1000.0);
        double[] result = new double[this.readouts];
        try {
            this.script.execute(this.updateScript);
            int i = 0;
            while (i < this.readouts) {
                result[i] = this.display[i].asDouble();
                ++i;
            }
        }
        catch (Exception e) {
            this.errorMessage = e.getMessage();
            return null;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public String[] update() {
        block5: {
            if (this.script == null) {
                this.script = new Script(this.bp.script);
            }
            t = System.currentTimeMillis();
            dt = t - this.lastTime;
            this.lastTime = t;
            this.time.set((double)this.lastTime / 1000.0);
            this.dt.set((double)dt / 1000.0);
            result = new String[this.readouts];
            try {
                this.script.execute(this.updateScript);
                i = 0;
                while (i < this.readouts) {
                    result[i] = String.valueOf(this.format[i].formatDisplay(this.display[i])) + this.units[i];
                    ++i;
                }
                break block5;
            }
            catch (Exception e) {
                this.errorMessage = e.getMessage();
                i = 0;
                ** while (i < this.readouts)
            }
lbl-1000:
            // 1 sources

            {
                result[i] = this.errorMessage;
                ++i;
                continue;
            }
        }
        return result;
    }

    public void reset() {
        this.script = new Script(this.bp == null ? null : this.bp.script);
        this.dt.set(0);
        this.time.set(0);
        this.script.addLocalVar(this.dt);
        this.script.addLocalVar(this.time);
        if (this.bits) {
            this.script.addLocalVar("bitNames", new Var());
        }
        int i = 0;
        while (i < this.readouts) {
            this.display[i].set(0);
            this.script.addLocalVar(this.display[i]);
            ++i;
        }
        try {
            if (this.initScript != null && this.initScript.length() > 0) {
                this.script.execute(this.initScript);
            }
            this.errorMessage = "";
        }
        catch (Exception e) {
            this.errorMessage = e.getMessage();
        }
        this.lastTime = System.currentTimeMillis();
    }

    private boolean formatChanged() {
        int i = 0;
        while (i < this.readouts) {
            if (!this.format[i].getName().equals("SI")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String generateParams() {
        StringBuilder sb = new StringBuilder();
        sb.append(" \"");
        sb.append(this.nameString);
        sb.append("\" \"");
        sb.append(Support.escapeForCommandLine(this.initScript));
        sb.append("\" \"");
        sb.append(Support.escapeForCommandLine(this.updateScript));
        sb.append("\" ");
        sb.append("unit");
        int i = 0;
        while (i < this.readouts) {
            sb.append(":");
            sb.append(this.units[i]);
            ++i;
        }
        sb.append(" ");
        if (this.formatChanged()) {
            sb.append("format");
            i = 0;
            while (i < this.readouts) {
                sb.append(":");
                sb.append(this.format[i].getName());
                ++i;
            }
            sb.append(" ");
        }
        return sb.toString();
    }
}

