/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.main.FontAdjust;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.Support;
import dk.hkj.panels.BasicChartPanel;
import dk.hkj.panels.BasicPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.annotations.XYLineAnnotation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;

public class ChartingPanel
extends BasicChartPanel
implements ActionListener {
    public static String panelName = "Charting";
    private static final String[] TimeScales = new String[]{"Auto", "1m", "5m", "15m", "1h", "3h", "10h"};
    private DefaultXYDataset dataset = null;
    private String channel = null;
    private List<SeriesPoint> currentSeries = new ArrayList<SeriesPoint>();
    private int divFactor = 1;
    private int divCount = 0;
    private String selectedTimeScale = TimeScales[0];
    private int scaleTime = 0;
    private char timeUnit = (char)32;

    public ChartingPanel() {
        super(BasicChartPanel.ChartType.XY);
        this.dataset = new DefaultXYDataset();
        Support.MyDecimalFormat nf = new Support.MyDecimalFormat();
        nf.setMaximumFractionDigits(1);
        ((NumberAxis)this.freeChart.getXYPlot().getRangeAxis()).setNumberFormatOverride(nf);
        nf.setSIFormat(true);
        ((NumberAxis)this.freeChart.getXYPlot().getDomainAxis()).setNumberFormatOverride(new MyTimeFormat());
        this.freeChart.getXYPlot().getRenderer().setDefaultToolTipGenerator(new XYToolTipGenerator(){

            @Override
            public String generateToolTip(XYDataset arg0, int arg1, int arg2) {
                return ChartingPanel.this.channel == null ? "" : ChartingPanel.this.channel;
            }
        });
        XYPlot plot = this.freeChart.getXYPlot();
        plot.setDataset(this.dataset);
        plot.addAnnotation(new XYLineAnnotation(-1.0E10, 0.0, 1.0E10, 0.0, new BasicStroke(1.0f), Color.yellow));
        ((NumberAxis)plot.getRangeAxis()).setAutoRangeIncludesZero(false);
        this.displayLayout(true);
    }

    @Override
    public String getPanelName() {
        return panelName;
    }

    @Override
    public BasicPanel.ParamsSet getParamsSet() {
        BasicPanel.ParamsSet ps = super.getParamsSet();
        ps.addParams(new String[]{"time", "value"});
        ps.nChannels = 1;
        return ps;
    }

    @Override
    public void setParams(BasicPanel.ParamsSet paramsSet) {
        super.setParams(paramsSet);
        this.channel = paramsSet.channels.get(0);
        Double t = paramsSet.getTime("time");
        if (t != null) {
            this.setTimeScale((int)t.doubleValue());
        }
        this.setRange(this.freeChart.getXYPlot().getRangeAxis(), paramsSet.getString("value"));
        this.setToolTipText(this.channel);
        this.chartPanel.setToolTipText(this.channel);
        this.nameLabel.setText(this.channel == null ? "--empty--" : this.channel);
        this.displayLayout(this.includeName);
        this.freeChart.getXYPlot().getDomainAxis().setVisible(this.includeScales);
        this.freeChart.getXYPlot().getRangeAxis().setVisible(this.includeScales);
    }

    @Override
    public void update() {
        double v;
        if (!this.isVisible()) {
            return;
        }
        double t = (double)System.currentTimeMillis() / 1000.0;
        if (this.channel != null && !Double.isNaN(v = this.readValue(this.channel))) {
            ++this.divCount;
            if (this.divCount >= this.divFactor) {
                this.currentSeries.add(new SeriesPoint(t, v));
                this.divCount = 0;
                if (this.currentSeries.size() > this.getWidth() * 4) {
                    this.divFactor *= 2;
                    ArrayList<SeriesPoint> s = new ArrayList<SeriesPoint>();
                    int i = 0;
                    while (i < this.currentSeries.size() / 2) {
                        s.add(this.currentSeries.get(i * 2));
                        ++i;
                    }
                    this.currentSeries = s;
                }
                this.requestDisplayUpdate = true;
            }
        }
        if (this.requestDisplayUpdate) {
            this.sizeChartPanel();
            int tt = this.scaleTime;
            if (this.scaleTime == 0 && this.currentSeries.size() > 0) {
                tt = Math.max((int)(t - this.currentSeries.get((int)0).time), this.scaleTime);
            }
            double f = 1.0;
            if (tt < 310) {
                this.timeUnit = (char)32;
            } else if (tt < 7220) {
                this.timeUnit = (char)109;
                f = 60.0;
            } else {
                this.timeUnit = (char)104;
                f = 3600.0;
            }
            while (this.scaleTime > 0 && this.currentSeries.size() > 0 && this.currentSeries.get((int)0).time - t < (double)(-this.scaleTime - 10)) {
                this.currentSeries.remove(0);
            }
            double[][] series = new double[2][this.currentSeries.size()];
            int i = 0;
            while (i < this.currentSeries.size()) {
                SeriesPoint sp = this.currentSeries.get(i);
                series[0][i] = (sp.time - t) / f;
                series[1][i] = sp.value;
                ++i;
            }
            if (this.scaleTime > 0) {
                this.freeChart.getXYPlot().getDomainAxis().setRange((double)(-this.scaleTime) / f, 0.0);
            }
            this.dataset.addSeries((Comparable)((Object)"data"), series);
        }
        this.requestDisplayUpdate = false;
    }

    @Override
    protected void popupMenuAdjust() {
        FontAdjust.FontRadioButtonMenuItem mi = null;
        FontAdjust.FontMenu menu = null;
        this.selectMenu("Select channel", "C:", this.channel, InterfaceThreads.listChannels(true, "*"), '.', this);
        if (this.currentSeries.size() > 2) {
            menu = new FontAdjust.FontMenu("Value scale");
            this.popupMenu.add(menu);
            double min = Double.MAX_VALUE;
            double max = -1.7976931348623157E308;
            for (SeriesPoint sp : this.currentSeries) {
                if (sp.value > max) {
                    max = sp.value;
                }
                if (!(sp.value < min)) continue;
                min = sp.value;
            }
            this.addValueRangeMenu(menu, this.freeChart.getXYPlot().getRangeAxis(), min, max);
        }
        menu = new FontAdjust.FontMenu("Time scale");
        this.popupMenu.add(menu);
        String[] stringArray = TimeScales;
        int n = TimeScales.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            mi = new FontAdjust.FontRadioButtonMenuItem(t);
            if (this.selectedTimeScale.equals(t)) {
                mi.setSelected(true);
            }
            mi.setActionCommand("TS:" + t);
            mi.addActionListener(this);
            menu.add(mi);
            ++n2;
        }
        this.addBasicPopupMenu();
    }

    @Override
    protected boolean supportReset() {
        return true;
    }

    @Override
    public void reset() {
        this.currentSeries.clear();
        this.divFactor = 1;
        this.requestDisplayUpdate = true;
    }

    private void setTimeScale(int v) {
        ValueAxis domain = this.freeChart.getXYPlot().getDomainAxis();
        if (v == 0) {
            domain.setAutoRange(true);
            this.scaleTime = 0;
            this.selectedTimeScale = "Auto";
        } else {
            domain.setAutoRange(false);
            this.scaleTime = v;
            this.selectedTimeScale = this.scaleTime % 3600 == 0 ? this.scaleTime / 3600 + "h" : (this.scaleTime % 60 == 0 ? this.scaleTime / 60 + "m" : "" + this.scaleTime);
        }
        this.requestDisplayUpdate = true;
    }

    private void setTimeScale(String v) {
        if (this.selectedTimeScale.matches("[0-9]+")) {
            this.setTimeScale(Integer.parseInt(this.selectedTimeScale.substring(0, this.selectedTimeScale.length() - 1)));
        } else if (this.selectedTimeScale.matches("[0-9]+m")) {
            this.setTimeScale(Integer.parseInt(this.selectedTimeScale.substring(0, this.selectedTimeScale.length() - 1)) * 60);
        } else if (this.selectedTimeScale.matches("[0-9]+h")) {
            this.setTimeScale(Integer.parseInt(this.selectedTimeScale.substring(0, this.selectedTimeScale.length() - 1)) * 3600);
        } else {
            this.setTimeScale(0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().startsWith("C:")) {
            this.channel = arg0.getActionCommand().substring(2);
            this.setToolTipText(this.channel);
            this.chartPanel.setToolTipText(this.channel);
            this.nameLabel.setText(this.channel == null ? "--empty--" : this.channel);
            this.reset();
        } else if (arg0.getActionCommand().startsWith("TS:")) {
            this.setTimeScale(arg0.getActionCommand().substring(3));
        }
    }

    @Override
    public boolean needData() {
        return true;
    }

    @Override
    public String generateScriptCmd() {
        StringBuilder sb = new StringBuilder();
        sb.append(panelName);
        sb.append(" ");
        sb.append(this.channel);
        sb.append(" ");
        sb.append(this.generateParams());
        if (!this.selectedTimeScale.equalsIgnoreCase(TimeScales[0])) {
            sb.append("time:");
            sb.append(this.selectedTimeScale);
            sb.append(" ");
        }
        if (!this.freeChart.getXYPlot().getRangeAxis().isAutoRange()) {
            sb.append("value:");
            sb.append(this.getRangeString(this.freeChart.getXYPlot().getRangeAxis()));
            sb.append(" ");
        }
        sb.append(this.generateParamsColor());
        return sb.toString();
    }

    public class MyTimeFormat
    extends DecimalFormat {
        DecimalFormat df = new DecimalFormat("##0.0;-##0.0");
        boolean siFormat = false;
        boolean eFormat = false;

        public MyTimeFormat() {
            this.df.setGroupingUsed(false);
            super.setGroupingUsed(false);
            DecimalFormatSymbols dfs = new DecimalFormatSymbols();
            dfs.setDecimalSeparator('.');
            this.df.setDecimalFormatSymbols(dfs);
            super.setDecimalFormatSymbols(dfs);
        }

        @Override
        public StringBuffer format(double number, StringBuffer sbuf, FieldPosition pos) {
            super.format(number, sbuf, pos);
            if (ChartingPanel.this.timeUnit != ' ') {
                sbuf.append(ChartingPanel.this.timeUnit);
            }
            return sbuf;
        }
    }

    private class SeriesPoint {
        double time;
        double value;

        public SeriesPoint(double time, double value) {
            this.time = time;
            this.value = value;
        }
    }
}

