/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.main.FontAdjust;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.ValueFormat;
import dk.hkj.panels.BasicBitsReadoutPanel;
import dk.hkj.panels.BasicPanel;
import dk.hkj.panels.PopupAskValue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;

public class BitsReadoutPanel
extends BasicBitsReadoutPanel
implements ActionListener {
    public static String panelName = "BitsReadout";
    private String channel = null;

    public BitsReadoutPanel() {
        this.nameLabel.setText("--empty--");
        this.displayLayout(this.includeName);
    }

    @Override
    public BasicPanel.ParamsSet getParamsSet() {
        BasicPanel.ParamsSet ps = super.getParamsSet();
        ps.nChannels = 1;
        return ps;
    }

    @Override
    public void setParams(BasicPanel.ParamsSet paramsSet) {
        super.setParams(paramsSet);
        this.setChannel(paramsSet.channels.get(0));
        this.setToolTipText(this.channel);
        this.nameLabel.setText(this.channel);
    }

    @Override
    public String getPanelName() {
        return panelName;
    }

    @Override
    public void update() {
        double v;
        if (!this.isVisible()) {
            return;
        }
        if (this.channel != null && !Double.isNaN(v = this.readValue(this.channel))) {
            this.bp.updateValue((long)v);
        }
        if (this.requestDisplayUpdate) {
            this.sizeBitsPanel();
            this.requestDisplayUpdate = false;
            this.repaint();
        }
    }

    @Override
    protected void popupMenuAdjust() {
        JMenuItem mi = null;
        this.selectMenu("Select channel", "C:", this.channel, InterfaceThreads.listChannels(true, "*"), '.', this);
        mi = new FontAdjust.FontMenuItem("Bits");
        mi.setActionCommand("bits");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        mi = new FontAdjust.FontCheckBoxMenuItem("LSB first");
        mi.setSelected(this.bp.getLsbFirst());
        mi.setActionCommand("lsb");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        this.addBasicPopupMenu();
    }

    private void setChannel(String channel) {
        this.channel = channel;
        ValueFormat fmt = InterfaceThreads.findValueFormat(channel);
        if (fmt.format.digitalValues() > 0) {
            this.bp.setBits(fmt.format.digitalValues());
            int i = 0;
            while (i < fmt.format.digitalValues()) {
                this.bp.setBitName(i, fmt.format.getValueName(i));
                ++i;
            }
        } else {
            this.bp.resetBitNames();
        }
        this.setToolTipText(channel);
        this.nameLabel.setText(channel == null ? "--empty--" : channel);
        this.reset();
        this.update();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().startsWith("C:")) {
            this.setChannel(arg0.getActionCommand().substring(2));
        } else if (arg0.getActionCommand().equals("bits")) {
            PopupAskValue pav = new PopupAskValue(this, "Bits", this.bp.getBits(), 1.0, 32.0, true);
            if (!Double.isNaN(pav.getValue())) {
                this.bp.setBits((int)pav.getValue());
            }
        } else if (arg0.getActionCommand().startsWith("lsb")) {
            this.bp.setLsbFirst(!this.bp.getLsbFirst());
        }
    }

    @Override
    public String generateScriptCmd() {
        StringBuilder sb = new StringBuilder();
        sb.append(panelName);
        sb.append(" ");
        sb.append(this.channel);
        sb.append(" ");
        sb.append(this.generateParams());
        sb.append(this.generateParamsColor());
        return sb.toString();
    }
}

