/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.color.ColorUtil;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.PopupGridPanel;
import dk.hkj.main.PopupTestInterface;
import dk.hkj.script.Script;
import dk.hkj.util.CharacterEscapes;
import dk.hkj.util.MySwingUtil;
import dk.hkj.util.StringUtil;
import dk.hkj.vars.Var;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public abstract class BasicPanel
extends JPanel {
    protected final int WIDTH_CORRECTION = 8;
    private final int MAXIMUM_FONT_SIZE = 200;
    protected final String EmptyChannelText = "--empty--";
    private int fontSize = 0;
    protected Font fontLarge = null;
    protected Font fontMedium = null;
    protected Font fontSmall = null;
    protected JPopupMenu popupMenu = null;
    protected JMenu popupSubMenu = null;
    protected boolean requestDisplayUpdate = true;
    public boolean doubleWidth = false;
    public boolean doubleHeight = false;
    protected Color foregroundColor = null;
    protected Color backgroundColor = null;
    protected boolean ownFontSize = false;
    protected boolean includeName = true;
    protected boolean panelClosed = false;
    protected Script script = null;

    public void setParams(ParamsSet paramsSet) {
        PopupGridPanel pgp;
        this.doubleWidth = paramsSet.isPresent("dw");
        this.doubleHeight = paramsSet.isPresent("dh");
        this.ownFontSize = paramsSet.isPresent("own");
        boolean bl = this.includeName = !paramsSet.isPresent("nn");
        if (paramsSet.colors.size() > 0) {
            this.foregroundColor = paramsSet.colors.get(0);
            paramsSet.colors.remove(0);
        }
        if (paramsSet.colors.size() > 0) {
            this.backgroundColor = paramsSet.colors.get(0);
            paramsSet.colors.remove(0);
        }
        if ((this.doubleWidth || this.doubleHeight) && (pgp = this.getGridPanel()) != null) {
            pgp.sizePanels(true);
            pgp.layoutPanels();
        }
        if (this.backgroundColor != null) {
            this.setBackground(this.backgroundColor);
        }
        this.updateColor();
        this.displayLayout(this.includeName);
        this.requestDisplayUpdate = true;
    }

    public ParamsSet getParamsSet() {
        return new ParamsSet(new String[]{"dw", "dh", "own", "nn"});
    }

    public BasicPanel() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                BasicPanel.this.panelClosed = true;
            }
        });
        this.popupMenu = new JPopupMenu();
        this.popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent arg0) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
                BasicPanel.this.popupMenu.removeAll();
                BasicPanel.this.popupSubMenu = new FontAdjust.FontMenu("General settings");
                BasicPanel.this.popupMenuAdjust();
            }
        });
        this.setComponentPopupMenu(this.popupMenu);
        this.forceFontResize();
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0), BorderFactory.createEmptyBorder(1, 2, 1, 2)));
    }

    protected abstract String getFontGroup();

    public abstract String getPanelName();

    protected String combineNames(String name1, String name2, char deli) {
        if (name1 == null && name2 == null) {
            return "--empty--";
        }
        if (name1 != null && name2 == null) {
            return "(" + name1 + ")";
        }
        if (name1 == null && name2 != null) {
            return "(" + name2 + ")";
        }
        int i = name1.indexOf(deli);
        if (i > 0) {
            name1 = name1.substring(0, i);
        }
        if ((i = name2.indexOf(deli)) > 0) {
            name2 = name2.substring(0, i);
        }
        if (name1.equals(name2)) {
            return name1;
        }
        return String.valueOf(name1) + " " + name2;
    }

    protected String trackChannel(String channel) {
        if (channel == null) {
            return null;
        }
        int i = channel.indexOf(46);
        if (i < 0) {
            return channel;
        }
        String handle = channel.substring(0, i);
        DeviceInterface di = InterfaceThreads.getLoadedDeviceInterfaceHandle(handle);
        if (di == null) {
            return channel;
        }
        List<String> list = di.getValueNameList();
        if (list.size() != 1 || Var.gl.find(list.get(0)) == null) {
            return channel;
        }
        return list.get(0);
    }

    protected double maxx(double v1, double v2) {
        return Math.max(v1, v2);
    }

    protected double maxx(double v1, double v2, double v3) {
        return Math.max(v1, Math.max(v2, v3));
    }

    protected double maxx(double v1, double v2, double v3, double v4) {
        return Math.max(Math.max(v1, v2), Math.max(v3, v4));
    }

    protected double maxx(double v1, double v2, double v3, double v4, double v5) {
        return Math.max(Math.max(Math.max(v1, v2), Math.max(v3, v4)), v5);
    }

    protected double maxw(TextSize t1, TextSize t2) {
        return Math.max(t1.w, t2.w);
    }

    protected double maxw(TextSize t1, TextSize t2, TextSize t3) {
        return Math.max(t1.w, Math.max(t2.w, t3.w));
    }

    protected double maxw(TextSize t1, TextSize t2, TextSize t3, TextSize t4) {
        return Math.max(Math.max(t1.w, t2.w), Math.max(t3.w, t4.w));
    }

    protected double maxw(TextSize t1, TextSize t2, TextSize t3, TextSize t4, TextSize t5) {
        return Math.max(Math.max(Math.max(t1.w, t2.w), Math.max(t3.w, t4.w)), t5.w);
    }

    protected TextSize getButtonSize(JButton button) {
        TextSize ts = this.getTextSize(button.getFont(), button.getText());
        Insets ii = button.getInsets();
        ts.w += (double)(ii.left + ii.right + 2);
        ts.h += (double)(ii.top + ii.bottom + 2);
        return ts;
    }

    protected TextSize getTextSize(Font font, String txt) {
        if (txt == null) {
            txt = "88.88";
        }
        Graphics2D grp = (Graphics2D)this.getGraphics();
        if (font == null || grp == null) {
            return new TextSize(0.0, 0.0);
        }
        Rectangle2D r = font.getStringBounds(txt, grp.getFontRenderContext());
        return new TextSize(r.getWidth(), r.getHeight());
    }

    public int getFontSize() {
        return this.fontSize;
    }

    protected void sizeFont(int size) {
        if (size != this.fontSize) {
            this.fontLarge = this.getFont().deriveFont((float)size);
            this.fontMedium = this.getFont().deriveFont((float)size * 0.7f);
            this.fontSmall = this.getFont().deriveFont((float)size * 0.5f);
            this.requestDisplayUpdate = true;
            this.fontSize = size;
        }
    }

    private void resizeFontAllPanels() {
        PopupGridPanel pgp = this.getGridPanel();
        if (pgp == null) {
            return;
        }
        for (BasicPanel bp : pgp.panelList) {
            bp.forceFontResize();
        }
    }

    protected void sizeFontAll() {
        if (!this.supportAdjustableFonts() || this.ownFontSize) {
            return;
        }
        PopupGridPanel pgp = this.getGridPanel();
        if (pgp == null) {
            return;
        }
        for (BasicPanel bp : pgp.panelList) {
            if (bp == this || !bp.getFontGroup().equals(this.getFontGroup()) || bp.ownFontSize) continue;
            bp.sizeFont(this.fontSize);
        }
    }

    protected void reduceFontSize(double maxHeight) {
        if (this.fontSize <= 8) {
            return;
        }
        int fs = (int)(maxHeight * (double)Toolkit.getDefaultToolkit().getScreenResolution() / 72.0);
        if (this.fontSize > fs) {
            this.fontSize = fs;
        }
        this.sizeFont(this.fontSize - 1);
    }

    protected boolean canReduceFontSize() {
        return this.fontSize > 8;
    }

    protected PopupGridPanel getGridPanel() {
        Container c = this.getParent();
        if (c == null) {
            return null;
        }
        while ((c = c.getParent()) != null && !(c instanceof PopupGridPanel)) {
        }
        if (c instanceof PopupGridPanel) {
            return (PopupGridPanel)c;
        }
        return null;
    }

    public void addBasicPopupMenu() {
        this.popupMenu.add(this.popupSubMenu);
        JMenuItem mi = null;
        mi = new FontAdjust.FontCheckBoxMenuItem("Include name");
        if (this.includeName) {
            mi.setSelected(true);
        }
        mi.setActionCommand("name");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                BasicPanel.this.includeName = !BasicPanel.this.includeName;
                BasicPanel.this.forceFontResize();
                BasicPanel.this.displayLayout(BasicPanel.this.includeName);
            }
        });
        this.popupSubMenu.add(mi);
        if (!this.getGridPanel().isSinglePanel()) {
            mi = new FontAdjust.FontCheckBoxMenuItem("Double width");
            mi.setSelected(this.doubleWidth);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    BasicPanel.this.doubleWidth = !BasicPanel.this.doubleWidth;
                    PopupGridPanel pgp = BasicPanel.this.getGridPanel();
                    pgp.sizePanels(true);
                    pgp.layoutPanels();
                }
            });
            this.popupSubMenu.add(mi);
            mi = new FontAdjust.FontCheckBoxMenuItem("Double height");
            mi.setSelected(this.doubleHeight);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BasicPanel.this.doubleHeight = !BasicPanel.this.doubleHeight;
                    PopupGridPanel pgp = BasicPanel.this.getGridPanel();
                    pgp.sizePanels(true);
                    pgp.layoutPanels();
                }
            });
            this.popupSubMenu.add(mi);
            if (this.supportAdjustableFonts()) {
                mi = new FontAdjust.FontCheckBoxMenuItem("Own font size");
                mi.setSelected(this.ownFontSize);
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        boolean bl = BasicPanel.this.ownFontSize = !BasicPanel.this.ownFontSize;
                        if (!BasicPanel.this.ownFontSize) {
                            BasicPanel.this.sizeFontAll();
                        } else {
                            BasicPanel.this.resizeFontAllPanels();
                        }
                    }
                });
                this.popupSubMenu.add(mi);
            }
        }
        if (this.supportReset()) {
            mi = new FontAdjust.FontMenuItem("Reset");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BasicPanel.this.reset();
                }
            });
            this.popupMenu.add(mi);
        }
        mi = new FontAdjust.FontMenuItem("Foreground color");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = MySwingUtil.colorChooser(BasicPanel.this, "Foreground color", BasicPanel.this.foregroundColor);
                if (c != null) {
                    BasicPanel.this.foregroundColor = c;
                    BasicPanel.this.updateColor();
                }
            }
        });
        this.popupSubMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Background color");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = MySwingUtil.colorChooser(BasicPanel.this, "Background color", BasicPanel.this.backgroundColor);
                if (c != null) {
                    BasicPanel.this.backgroundColor = c;
                    BasicPanel.this.setBackground(BasicPanel.this.backgroundColor);
                    BasicPanel.this.updateColor();
                }
            }
        });
        this.popupSubMenu.add(mi);
        if (!this.getGridPanel().isSinglePanel()) {
            FontAdjust.FontMenu menu = new FontAdjust.FontMenu("Move panel");
            this.popupMenu.add(menu);
            mi = new FontAdjust.FontMenuItem("Left/up");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BasicPanel.this.getGridPanel().moveUp(BasicPanel.this);
                }
            });
            menu.add(mi);
            mi = new FontAdjust.FontMenuItem("Right/down");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BasicPanel.this.getGridPanel().moveDown(BasicPanel.this);
                }
            });
            menu.add(mi);
            if (this.getGridPanel().getRows() > 1) {
                mi = new FontAdjust.FontMenuItem("Line up");
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        BasicPanel.this.getGridPanel().moveLineUp(BasicPanel.this);
                    }
                });
                menu.add(mi);
                mi = new FontAdjust.FontMenuItem("Line down");
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        BasicPanel.this.getGridPanel().moveLineDown(BasicPanel.this);
                    }
                });
                menu.add(mi);
            }
            mi = new FontAdjust.FontMenuItem("Start/Top");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BasicPanel.this.getGridPanel().moveTop(BasicPanel.this);
                }
            });
            menu.add(mi);
            mi = new FontAdjust.FontMenuItem("End/Bottom");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BasicPanel.this.getGridPanel().moveBottom(BasicPanel.this);
                }
            });
            menu.add(mi);
            mi = new FontAdjust.FontMenuItem("Remove panel");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BasicPanel.this.getGridPanel().removePanel(BasicPanel.this);
                }
            });
            this.popupMenu.add(mi);
            mi = new FontAdjust.FontMenuItem("Breakout as single panel");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BasicPanel.this.getGridPanel().convertToSingle(BasicPanel.this);
                }
            });
            this.popupMenu.add(mi);
        } else {
            mi = new FontAdjust.FontMenuItem("Move to grid panel");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BasicPanel.this.getGridPanel().moveToGrid(BasicPanel.this);
                }
            });
            this.popupMenu.add(mi);
        }
    }

    public void setScript(Script script) {
        this.script = script;
        this.reset();
    }

    public double readValue(String channel) {
        Var vv = this.script.findVar(channel);
        if (vv == null) {
            return Double.NaN;
        }
        return vv.asDouble();
    }

    protected boolean supportAdjustableFonts() {
        return true;
    }

    protected boolean supportReset() {
        return false;
    }

    public abstract void update();

    public abstract void reset();

    protected abstract void popupMenuAdjust();

    public abstract void updateColor();

    public abstract boolean needData();

    protected void toClipboard(String data) {
        Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(data);
        clpbrd.setContents(stringSelection, null);
    }

    protected void toClipboard(Image image) {
        ImageSelection imgSel = new ImageSelection(image);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(imgSel, null);
    }

    protected abstract void displayLayout(boolean var1);

    protected String getUnit(String handle, String func, int channel) {
        if (handle == null || func == null) {
            return "";
        }
        DeviceInterface di = InterfaceThreads.getLoadedDeviceInterfaceHandle(handle);
        if (di == null) {
            return "";
        }
        Var n = di.executeIFace("name" + func, channel, null);
        if (n != null) {
            String u = di.getValueFormat((String)n.asString()).unit;
            return u;
        }
        if (func.contains("Volt")) {
            return "V";
        }
        if (func.contains("Curr")) {
            return "A";
        }
        if (func.contains("Power")) {
            return "W";
        }
        if (func.contains("Capa")) {
            return "Ah";
        }
        if (func.contains("Freq")) {
            return "Hz";
        }
        if (func.contains("Energy")) {
            return "Wh";
        }
        if (func.contains("Resi")) {
            return "ohm";
        }
        if (func.contains("Temp")) {
            return "\u00b0C";
        }
        if (func.contains("DutyCycle")) {
            return "%";
        }
        if (func.contains("OVP")) {
            return "V";
        }
        if (func.contains("OCP")) {
            return "A";
        }
        if (func.contains("OPP")) {
            return "W";
        }
        return "";
    }

    protected List<String> getNumericFunctions(String handle, String filter) {
        ArrayList<String> list = new ArrayList<String>();
        filter = CharacterEscapes.forSimpleSearch(filter);
        DeviceInterface di = InterfaceThreads.getLoadedDeviceInterfaceHandle(handle);
        if (di == null) {
            return list;
        }
        for (String iff : di.getIFaces().keySet()) {
            if (PopupTestInterface.isOnOffFunction(iff) || PopupTestInterface.isTextFunction(iff) || !iff.matches(filter)) continue;
            list.add(iff);
        }
        return list;
    }

    protected void multiSelectMenu(String menuText, String menuId, List<String> currentChannels, List<String> list, char delimeter, ActionListener listner) {
        FontAdjust.FontMenu menu = new FontAdjust.FontMenu(menuText);
        list.sort(null);
        this.popupMenu.add(menu);
        FontAdjust.FontMenu subMenu = null;
        String subMenuName = null;
        for (String pp : list) {
            int i = pp.indexOf(delimeter);
            if (i > 0 && list.size() > 15) {
                String handle = pp.substring(0, i);
                if (!handle.equals(subMenuName)) {
                    subMenu = new FontAdjust.FontMenu(handle);
                    menu.add(subMenu);
                    subMenuName = handle;
                }
                FontAdjust.FontCheckBoxMenuItem mi = new FontAdjust.FontCheckBoxMenuItem(pp.substring(i + 1));
                if (currentChannels.contains(pp)) {
                    mi.setSelected(true);
                }
                mi.setActionCommand(String.valueOf(menuId) + pp);
                mi.addActionListener(listner);
                subMenu.add(mi);
                continue;
            }
            FontAdjust.FontCheckBoxMenuItem mi = new FontAdjust.FontCheckBoxMenuItem(pp);
            if (currentChannels.contains(pp)) {
                mi.setSelected(true);
            }
            mi.setActionCommand(String.valueOf(menuId) + pp);
            mi.addActionListener(listner);
            menu.add(mi);
            subMenuName = null;
        }
    }

    protected void selectMenu(String menuText, String menuId, String currentChannel, List<String> list, char delimeter, ActionListener listner) {
        FontAdjust.FontMenu menu = new FontAdjust.FontMenu(menuText);
        list.sort(null);
        this.popupMenu.add(menu);
        FontAdjust.FontMenu subMenu = null;
        String subMenuName = null;
        for (String pp : list) {
            int i = pp.indexOf(delimeter);
            if (i > 0 && list.size() > 10) {
                String handle = pp.substring(0, i);
                if (!handle.equals(subMenuName)) {
                    subMenu = new FontAdjust.FontMenu(handle);
                    menu.add(subMenu);
                    subMenuName = handle;
                }
                FontAdjust.FontRadioButtonMenuItem mi = new FontAdjust.FontRadioButtonMenuItem(pp.substring(i + 1));
                if (currentChannel != null && currentChannel.equals(pp)) {
                    mi.setSelected(true);
                }
                mi.setActionCommand(String.valueOf(menuId) + pp);
                mi.addActionListener(listner);
                subMenu.add(mi);
                continue;
            }
            FontAdjust.FontRadioButtonMenuItem mi = new FontAdjust.FontRadioButtonMenuItem(pp);
            if (currentChannel != null && currentChannel.equals(pp)) {
                mi.setSelected(true);
            }
            mi.setActionCommand(String.valueOf(menuId) + pp);
            mi.addActionListener(listner);
            menu.add(mi);
            subMenuName = null;
        }
    }

    protected void listMenu(String menuText, String menuId, List<String> list, char delimeter, ActionListener listner) {
        FontAdjust.FontMenu menu = new FontAdjust.FontMenu(menuText);
        this.popupMenu.add(menu);
        FontAdjust.FontMenu subMenu = null;
        String subMenuName = null;
        for (String pp : list) {
            int i = pp.indexOf(delimeter);
            if (i > 0 && list.size() > 20) {
                String handle = pp.substring(0, i);
                if (!handle.equals(subMenuName)) {
                    subMenu = new FontAdjust.FontMenu(handle);
                    menu.add(subMenu);
                    subMenuName = handle;
                }
                FontAdjust.FontMenuItem mi = new FontAdjust.FontMenuItem(pp.substring(i + 1));
                mi.setActionCommand(String.valueOf(menuId) + pp);
                mi.addActionListener(listner);
                subMenu.add(mi);
                continue;
            }
            FontAdjust.FontMenuItem mi = new FontAdjust.FontMenuItem(pp);
            mi.setActionCommand(String.valueOf(menuId) + pp);
            mi.addActionListener(listner);
            menu.add(mi);
            subMenuName = null;
        }
    }

    public void forceFontResize() {
        this.sizeFont(200);
        this.requestDisplayUpdate = true;
    }

    public String generateParams() {
        StringBuilder sb = new StringBuilder();
        if (!this.includeName) {
            sb.append("nn ");
        }
        if (this.doubleWidth) {
            sb.append("dw ");
        }
        if (this.doubleHeight) {
            sb.append("dh ");
        }
        if (this.ownFontSize) {
            sb.append("own ");
        }
        return sb.toString();
    }

    public String generateParamsColor() {
        StringBuilder sb = new StringBuilder();
        if (this.foregroundColor != null) {
            sb.append(ColorUtil.colorToName(this.foregroundColor));
            sb.append(" ");
        }
        if (this.backgroundColor != null) {
            if (this.foregroundColor == null) {
                sb.append("- ");
            }
            sb.append(ColorUtil.colorToName(this.backgroundColor));
            sb.append(" ");
        }
        return sb.toString();
    }

    public void systemStateChanged() {
    }

    public abstract String generateScriptCmd();

    static class ImageSelection
    implements Transferable {
        private Image image;

        public ImageSelection(Image image) {
            this.image = image;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.imageFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!DataFlavor.imageFlavor.equals(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.image;
        }
    }

    public static class ParamsSet {
        private List<String> valid = new ArrayList<String>();
        protected List<String> params = new ArrayList<String>();
        protected List<String> channels = new ArrayList<String>();
        protected List<Color> colors = new ArrayList<Color>();
        protected int nChannels = 0;

        public ParamsSet(String[] valid) {
            String[] stringArray = valid;
            int n = valid.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                this.valid.add(s);
                ++n2;
            }
        }

        public void addParams(String[] valid) {
            String[] stringArray = valid;
            int n = valid.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                this.valid.add(s);
                ++n2;
            }
        }

        public int getNChannels() {
            return this.nChannels;
        }

        public void addChannel(String channel) {
            this.channels.add(channel);
        }

        public void addColor(Color color) {
            this.colors.add(color);
        }

        public boolean add(String p) {
            String fullp = p;
            int i = p.indexOf(58);
            if (i > 0) {
                p = p.substring(0, i);
            }
            for (String s : this.valid) {
                if (!s.equalsIgnoreCase(p)) continue;
                this.params.add(fullp);
                return true;
            }
            return false;
        }

        protected boolean isPresent(String name) {
            for (String item : this.params) {
                if (!item.equalsIgnoreCase(name)) continue;
                return true;
            }
            return false;
        }

        protected Double getTime(String tag) {
            for (String item : this.params) {
                int i = item.indexOf(58);
                if (i <= 0 || !tag.equalsIgnoreCase(item.substring(0, i))) continue;
                String v = item.substring(i + 1);
                if (v.endsWith("m")) {
                    return Double.parseDouble(v.substring(0, v.length() - 1)) * 60.0;
                }
                if (v.endsWith("h")) {
                    return Double.parseDouble(v.substring(0, v.length() - 1)) * 3600.0;
                }
                if (v.endsWith("d")) {
                    return Double.parseDouble(v.substring(0, v.length() - 1)) * 3600.0 * 24.0;
                }
                if (v.endsWith("s")) {
                    return Double.parseDouble(v.substring(0, v.length() - 1));
                }
                return Double.parseDouble(v);
            }
            return null;
        }

        protected double[] getTimes(String tag) {
            for (String item : this.params) {
                int i = item.indexOf(58);
                if (i <= 0 || !tag.equalsIgnoreCase(item.substring(0, i))) continue;
                String[] ss = item.substring(i + 1).split("[:]");
                double[] tt = new double[ss.length];
                int j = 0;
                while (j < ss.length) {
                    String v = ss[j];
                    tt[j] = v.endsWith("m") ? Double.parseDouble(v.substring(0, v.length() - 1)) * 60.0 : (v.endsWith("h") ? Double.parseDouble(v.substring(0, v.length() - 1)) * 3600.0 : (v.endsWith("d") ? Double.parseDouble(v.substring(0, v.length() - 1)) * 3600.0 * 24.0 : (v.endsWith("s") ? Double.parseDouble(v.substring(0, v.length() - 1)) : Double.parseDouble(v))));
                    ++j;
                }
                return tt;
            }
            return null;
        }

        protected double[] getDoubles(String tag) {
            for (String item : this.params) {
                int i = item.indexOf(58);
                if (i <= 0 || !tag.equalsIgnoreCase(item.substring(0, i))) continue;
                String[] ss = item.substring(i + 1).split("[:]");
                double[] v = new double[ss.length];
                int j = 0;
                while (j < ss.length) {
                    v[j] = StringUtil.parseDoubleEE(ss[j]);
                    ++j;
                }
                return v;
            }
            return null;
        }

        protected int[] getInts(String tag) {
            for (String item : this.params) {
                int i = item.indexOf(58);
                if (i <= 0 || !tag.equalsIgnoreCase(item.substring(0, i))) continue;
                String[] ss = item.substring(i + 1).split("[:]");
                int[] v = new int[ss.length];
                int j = 0;
                while (j < ss.length) {
                    v[j] = StringUtil.parseInt(ss[j]);
                    ++j;
                }
                return v;
            }
            return null;
        }

        protected String[] getStrings(String tag) {
            for (String item : this.params) {
                int i = item.indexOf(58);
                if (i <= 0 || !tag.equalsIgnoreCase(item.substring(0, i))) continue;
                return item.substring(i + 1).split("[:]");
            }
            return null;
        }

        protected Double getValue(String tag) {
            for (String item : this.params) {
                int i = item.indexOf(58);
                if (i <= 0 || !tag.equalsIgnoreCase(item.substring(0, i))) continue;
                String v = item.substring(i + 1);
                return StringUtil.parseDoubleEE(v);
            }
            return null;
        }

        protected String getString(String tag) {
            for (String item : this.params) {
                int i = item.indexOf(58);
                if (i <= 0 || !tag.equalsIgnoreCase(item.substring(0, i))) continue;
                return item.substring(i + 1);
            }
            return null;
        }

        protected List<String> getAllString(String tag) {
            ArrayList<String> list = new ArrayList<String>();
            for (String item : this.params) {
                int i = item.indexOf(58);
                if (i <= 0 || !tag.equalsIgnoreCase(item.substring(0, i))) continue;
                list.add(item.substring(i + 1));
            }
            return list;
        }
    }

    public class TextSize {
        double w;
        double h;

        TextSize(double w, double h) {
            this.w = w;
            this.h = h;
        }

        public double getWidth() {
            return this.w;
        }

        public double getHeight() {
            return this.h;
        }

        public void addVertical(TextSize ts) {
            this.w = BasicPanel.this.maxx(this.w, ts.w);
            this.h += ts.h;
        }

        public void addHorizontal(TextSize ts) {
            this.h = BasicPanel.this.maxx(this.h, ts.h);
            this.w += ts.w;
        }

        public String toString() {
            return "w:" + this.w + " H:" + this.h;
        }
    }
}

