/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.main.DeviceInterface;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.ValueFormat;
import dk.hkj.panels.BasicLargeNSmallPanel;
import dk.hkj.vars.Var;
import java.util.ArrayList;
import java.util.List;

public abstract class BasicPSLoadReadoutPanel
extends BasicLargeNSmallPanel {
    protected List<LoadDevice> loadDevices = new ArrayList<LoadDevice>();
    protected long lastTime = 0L;
    protected DeviceType deviceType = DeviceType.Undef;

    public BasicPSLoadReadoutPanel() {
        super(2);
    }

    @Override
    public void update() {
        if (!this.isVisible()) {
            return;
        }
        long t = System.currentTimeMillis();
        long dt = t - this.lastTime;
        this.lastTime = t;
        boolean valid = true;
        for (LoadDevice ld : this.loadDevices) {
            if (ld.isValid()) {
                ld.update(dt);
                continue;
            }
            valid = false;
        }
        if (valid && this.loadDevices.size() > 0) {
            if (this.loadDevices.size() == 1) {
                LoadDevice ld;
                ld = this.loadDevices.get(0);
                this.update(this.getNameString(), ld.getCurrent(), ld.getVoltage(), ld.getPower(), ld.getCapacity(), ld.getEnergy());
            } else if (this.loadDevices.size() > 1) {
                LoadDevice ld2;
                double voltage = 0.0;
                double current = 0.0;
                double power = 0.0;
                double capacity = 0.0;
                double energy = 0.0;
                for (LoadDevice ld2 : this.loadDevices) {
                    voltage += ld2.voltage;
                    if (this.deviceType == DeviceType.Different_Types) {
                        if (ld2.getDeviceType() == DeviceType.PS) {
                            current += ld2.current;
                            power += ld2.power;
                            capacity += ld2.capacity - ld2.capacity0;
                            energy += ld2.energy - ld2.energy0;
                            continue;
                        }
                        current -= ld2.current;
                        power -= ld2.power;
                        capacity -= ld2.capacity - ld2.capacity0;
                        energy -= ld2.energy - ld2.energy0;
                        continue;
                    }
                    current += ld2.current;
                    power += ld2.power;
                    capacity += ld2.capacity - ld2.capacity0;
                    energy += ld2.energy - ld2.energy0;
                }
                ld2 = this.loadDevices.get(0);
                this.update(this.getNameString(), ld2.getCurrent(current), ld2.getVoltage(voltage / (double)this.loadDevices.size()), ld2.getPower(power), ld2.getCapacity(capacity), ld2.getEnergy(energy));
            }
        } else {
            super.update("--empty--");
        }
    }

    protected void setDeviceType() {
        this.deviceType = DeviceType.Undef;
        for (LoadDevice ld : this.loadDevices) {
            DeviceType dt = ld.getDeviceType();
            if (dt == DeviceType.Different_Types) {
                this.deviceType = DeviceType.Undef;
                return;
            }
            if (dt == this.deviceType) continue;
            this.deviceType = this.deviceType == dt || this.deviceType == DeviceType.Undef ? dt : DeviceType.Different_Types;
        }
    }

    protected String getNameString() {
        StringBuilder sb = new StringBuilder();
        if (this.loadDevices.size() == 0) {
            sb.append("--empty--");
        } else if (this.loadDevices.size() < 3) {
            for (LoadDevice ld : this.loadDevices) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(ld.getHandle());
            }
        } else {
            sb.append(String.valueOf(this.loadDevices.size()) + " " + this.deviceType.name().replace("_", " "));
        }
        return sb.toString();
    }

    @Override
    public void reset() {
        for (LoadDevice ld : this.loadDevices) {
            ld.reset();
        }
        this.lastTime = System.currentTimeMillis();
        this.requestDisplayUpdate = true;
    }

    protected LoadDevice findLoadDevice(String handle) {
        for (LoadDevice ld : this.loadDevices) {
            if (!ld.getHandle().equals(handle)) continue;
            return ld;
        }
        return null;
    }

    @Override
    protected boolean supportReset() {
        return true;
    }

    @Override
    public boolean needData() {
        return true;
    }

    protected static enum DeviceType {
        Undef,
        Load,
        PS,
        Different_Types;

    }

    protected static class LoadDevice {
        DeviceInterface di = null;
        private int deviceChannel = 0;
        private double current = 0.0;
        private double voltage = 0.0;
        private double power = 0.0;
        private double capacity = 0.0;
        private double energy = 0.0;
        private double capacity0 = 0.0;
        private double energy0 = 0.0;
        private boolean hasVI = false;
        private boolean hasPower = false;
        private boolean hasCapacity = false;
        private boolean hasEnergy = false;
        private String voltageName = null;
        private String currentName = null;
        private String powerName = null;
        private String capacityName = null;
        private String energyName = null;
        private ValueFormat fmtV = new ValueFormat("??", "V", ValueFormat.formatD2);
        private ValueFormat fmtC = new ValueFormat("??", "A", ValueFormat.formatD2);
        private ValueFormat fmtP = new ValueFormat("??", "W", ValueFormat.formatD2);
        private ValueFormat fmtCap = new ValueFormat("??", "Ah", ValueFormat.formatD3);
        private ValueFormat fmtEng = new ValueFormat("??", "Wh", ValueFormat.formatD3);
        private DeviceType deviceType = DeviceType.Undef;

        public LoadDevice(String handleName) {
            this.di = InterfaceThreads.getLoadedDeviceInterfaceHandle(handleName);
            if (this.di == null) {
                return;
            }
            int deviceChannel = 1;
            int i = handleName.indexOf(58);
            if (i > 1) {
                deviceChannel = Integer.parseInt(handleName.substring(i + 1));
            }
            if (this.di.hasIFaceType("PS") && this.di.hasIFaceType("load")) {
                this.deviceType = DeviceType.Different_Types;
            }
            if (this.di.hasIFaceType("PS")) {
                this.deviceType = DeviceType.PS;
            }
            if (this.di.hasIFaceType("load")) {
                this.deviceType = DeviceType.Load;
            }
            this.hasVI = this.di.getIFaces().containsKey("readVoltage") && this.di.getIFaces().containsKey("readCurrent");
            this.hasPower = this.di.getIFaces().containsKey("readPower");
            this.hasCapacity = this.di.getIFaces().containsKey("readCapacity");
            this.hasEnergy = this.di.getIFaces().containsKey("readEnergy");
            this.voltageName = this.di.executeIFace("nameVoltage", deviceChannel, "").asString();
            this.currentName = this.di.executeIFace("nameCurrent", deviceChannel, "").asString();
            this.fmtV = this.di.getValueFormat(this.stripHandle(this.voltageName));
            this.fmtC = this.di.getValueFormat(this.stripHandle(this.currentName));
            if (this.hasPower) {
                this.powerName = this.di.executeIFace("namePower", deviceChannel, "").asString();
                this.fmtP = this.di.getValueFormat(this.stripHandle(this.powerName));
            }
            if (this.hasCapacity) {
                this.capacityName = this.di.executeIFace("nameCapacity", deviceChannel, "").asString();
                this.fmtCap = this.di.getValueFormat(this.stripHandle(this.capacityName));
            }
            if (this.hasEnergy) {
                this.energyName = this.di.executeIFace("nameEnergy", deviceChannel, "").asString();
                this.fmtEng = this.di.getValueFormat(this.stripHandle(this.energyName));
            }
            this.reset();
        }

        public DeviceType getDeviceType() {
            return this.deviceType;
        }

        private String stripHandle(String name) {
            int i = name.indexOf(46);
            if (i < 0) {
                return name;
            }
            return name.substring(i + 1);
        }

        public String getHandle() {
            if (this.di == null || !this.hasVI) {
                return null;
            }
            if (this.deviceChannel > 1) {
                return String.valueOf(this.di.getHandleName()) + ":" + this.deviceChannel;
            }
            return this.di.getHandleName();
        }

        public boolean isValid() {
            return this.di != null && this.hasVI;
        }

        public void reset() {
            if (!this.hasCapacity) {
                this.capacity = 0.0;
            }
            if (!this.hasEnergy) {
                this.energy = 0.0;
            }
            this.capacity0 = this.capacity;
            this.energy0 = this.energy;
        }

        public String getCurrent() {
            if (!this.isValid()) {
                return "";
            }
            return String.valueOf(this.fmtC.format.formatDisplay(this.current)) + this.fmtC.unit;
        }

        public String getVoltage() {
            if (!this.isValid()) {
                return "";
            }
            return "Volt:" + this.fmtV.format.formatDisplay(this.voltage) + this.fmtV.unit;
        }

        public String getPower() {
            if (!this.isValid()) {
                return "";
            }
            return "Pow:" + this.fmtP.format.formatDisplay(this.power) + this.fmtP.unit;
        }

        public String getCapacity() {
            if (!this.isValid()) {
                return "";
            }
            return "Cap:" + this.fmtCap.format.formatDisplay(this.capacity - this.capacity0) + this.fmtCap.unit;
        }

        public String getEnergy() {
            if (!this.isValid()) {
                return "";
            }
            return "Eng:" + this.fmtEng.format.formatDisplay(this.energy - this.energy0) + this.fmtEng.unit;
        }

        public String getCurrent(double v) {
            if (!this.isValid()) {
                return "";
            }
            return String.valueOf(this.fmtC.format.formatDisplay(v)) + this.fmtC.unit;
        }

        public String getVoltage(double v) {
            if (!this.isValid()) {
                return "";
            }
            return "Volt:" + this.fmtV.format.formatDisplay(v) + this.fmtV.unit;
        }

        public String getPower(double v) {
            if (!this.isValid()) {
                return "";
            }
            return "Pow:" + this.fmtP.format.formatDisplay(v) + this.fmtP.unit;
        }

        public String getCapacity(double v) {
            if (!this.isValid()) {
                return "";
            }
            return "Cap:" + this.fmtCap.format.formatDisplay(v) + this.fmtCap.unit;
        }

        public String getEnergy(double v) {
            if (!this.isValid()) {
                return "";
            }
            return "Eng:" + this.fmtEng.format.formatDisplay(v) + this.fmtEng.unit;
        }

        public void update(long dt) {
            if (this.hasVI) {
                try {
                    this.voltage = Var.gl.get(this.voltageName).asDouble();
                    this.current = Var.gl.get(this.currentName).asDouble();
                    this.power = this.hasPower ? Var.gl.get(this.powerName).asDouble() : this.voltage * this.current;
                    this.capacity = this.hasCapacity ? Var.gl.get(this.capacityName).asDouble() : (this.capacity += this.current * (double)dt / 3600000.0);
                    this.energy = this.hasEnergy ? Var.gl.get(this.energyName).asDouble() : (this.energy += this.power * (double)dt / 3600000.0);
                }
                catch (Exception exception) {
                    this.voltage = 0.0;
                    this.current = 0.0;
                    this.power = 0.0;
                }
            }
        }

        public String toString() {
            return String.valueOf(this.getHandle()) + " " + this.getVoltage() + "  " + this.getCurrent();
        }
    }
}

