/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.main.FontAdjust;
import dk.hkj.panels.BasicPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public abstract class BasicDualReadoutPanel
extends BasicPanel {
    protected JLabel valueLabel1 = null;
    protected JLabel nameLabel1 = new JLabel("");
    protected JLabel valueLabel2 = null;
    protected JLabel nameLabel2 = null;
    protected boolean twoNames = true;
    protected boolean horizontal = false;
    protected String lastValue = null;

    protected BasicDualReadoutPanel() {
        this.nameLabel1.setInheritsPopupMenu(true);
        this.nameLabel1.setBorder(null);
        this.nameLabel1.setAlignmentX(0.0f);
        this.nameLabel1.setAlignmentY(0.0f);
        this.nameLabel1.setHorizontalAlignment(0);
        this.valueLabel1 = new JLabel("");
        this.valueLabel1.setInheritsPopupMenu(true);
        this.valueLabel1.setBorder(null);
        this.valueLabel1.setAlignmentX(0.0f);
        this.valueLabel1.setAlignmentY(0.0f);
        this.valueLabel1.setHorizontalAlignment(0);
        this.nameLabel2 = new JLabel("");
        this.nameLabel2.setInheritsPopupMenu(true);
        this.nameLabel2.setBorder(null);
        this.nameLabel2.setAlignmentX(0.0f);
        this.nameLabel2.setAlignmentY(0.0f);
        this.nameLabel2.setHorizontalAlignment(0);
        this.valueLabel2 = new JLabel("");
        this.valueLabel2.setInheritsPopupMenu(true);
        this.valueLabel2.setBorder(null);
        this.valueLabel2.setAlignmentX(0.0f);
        this.valueLabel2.setAlignmentY(0.0f);
        this.valueLabel2.setHorizontalAlignment(0);
    }

    @Override
    protected String getFontGroup() {
        return "LLReadout" + (this.doubleWidth ? "dw" : "") + (this.doubleHeight ? "dh" : "") + (this.horizontal ? "hz" : "");
    }

    @Override
    public BasicPanel.ParamsSet getParamsSet() {
        BasicPanel.ParamsSet ps = super.getParamsSet();
        ps.addParams(new String[]{"hz"});
        return ps;
    }

    @Override
    public void setParams(BasicPanel.ParamsSet paramsSet) {
        this.horizontal = paramsSet.isPresent("hz");
        super.setParams(paramsSet);
    }

    public void setNames(String name1, String name2) {
        this.twoNames = name2 != null && name2.length() > 0;
        this.nameLabel1.setText(name1);
        this.nameLabel2.setText(name2);
        this.displayLayout(this.includeName);
    }

    @Override
    public void update() {
        this.update("888888", "888888");
    }

    public void update(String value1, String value2) {
        if (!this.isVisible()) {
            return;
        }
        String s = String.valueOf(value1) + "#" + value2;
        if (this.requestDisplayUpdate || !s.equals(this.lastValue)) {
            this.lastValue = s;
            boolean fontAdjust = false;
            int w = 0;
            int h = 0;
            int lines = 4;
            do {
                BasicPanel.TextSize ts3;
                BasicPanel.TextSize ts2;
                BasicPanel.TextSize ts1;
                this.nameLabel1.setFont(this.fontSmall);
                this.valueLabel1.setFont(this.fontLarge);
                this.nameLabel2.setFont(this.fontSmall);
                this.valueLabel2.setFont(this.fontLarge);
                if (this.horizontal) {
                    ts1 = this.getTextSize(this.fontSmall, this.nameLabel1.getText());
                    ts2 = this.getTextSize(this.fontLarge, String.valueOf(value1) + "__" + value2);
                    ts3 = this.getTextSize(this.fontSmall, this.nameLabel2.getText());
                    if (this.includeName && this.twoNames) {
                        w = (int)this.maxw(ts1, ts2, ts3) + 8;
                        h = (int)(ts1.h + ts2.h + ts3.h) + 2;
                        lines = 3;
                    } else if (this.includeName) {
                        w = (int)this.maxw(ts1, ts2) + 8;
                        h = (int)(ts1.h + ts2.h) + 2;
                        lines = 2;
                    } else {
                        w = (int)ts2.w + 8;
                        h = (int)ts2.h + 2;
                        lines = 1;
                    }
                } else {
                    ts1 = this.getTextSize(this.fontSmall, this.nameLabel1.getText());
                    ts2 = this.getTextSize(this.fontLarge, value1);
                    ts3 = this.getTextSize(this.fontSmall, this.nameLabel2.getText());
                    BasicPanel.TextSize ts4 = this.getTextSize(this.fontLarge, value2);
                    if (this.includeName && this.twoNames) {
                        w = (int)this.maxw(ts1, ts2, ts3, ts4) + 8;
                        h = (int)(ts1.h + ts2.h + ts3.h + ts4.h) + 2;
                        lines = 4;
                    } else if (this.includeName) {
                        w = (int)this.maxw(ts1, ts2, ts4) + 8;
                        h = (int)(ts1.h + ts2.h + ts4.h) + 2;
                        lines = 3;
                    } else {
                        w = (int)this.maxw(ts2, ts4) + 8;
                        h = (int)(ts2.h + ts4.h) + 2;
                        lines = 2;
                    }
                }
                if (w <= this.getWidth() && h <= this.getHeight()) continue;
                this.reduceFontSize(this.getHeight() / lines);
                fontAdjust = true;
                this.nameLabel1.setFont(this.fontSmall);
                this.valueLabel1.setFont(this.fontLarge);
                this.nameLabel2.setFont(this.fontSmall);
                this.valueLabel2.setFont(this.fontLarge);
            } while ((w > this.getWidth() || h > this.getHeight()) && this.canReduceFontSize());
            if (fontAdjust) {
                this.sizeFontAll();
            }
            this.valueLabel1.setText(value1);
            this.valueLabel2.setText(value2);
            this.requestDisplayUpdate = false;
        }
        this.requestDisplayUpdate = false;
    }

    @Override
    public void updateColor() {
        if (this.foregroundColor != null) {
            this.nameLabel1.setForeground(this.foregroundColor);
            this.valueLabel1.setForeground(this.foregroundColor);
            this.nameLabel2.setForeground(this.foregroundColor);
            this.valueLabel2.setForeground(this.foregroundColor);
        }
        if (this.backgroundColor != null) {
            this.nameLabel1.setBackground(this.backgroundColor);
            this.valueLabel1.setBackground(this.backgroundColor);
            this.nameLabel2.setBackground(this.backgroundColor);
            this.valueLabel2.setBackground(this.backgroundColor);
        }
    }

    @Override
    protected void displayLayout(boolean includeName) {
        this.removeAll();
        if (this.horizontal) {
            JPanel p = new JPanel();
            p.setBackground(this.backgroundColor);
            p.setLayout(new BorderLayout());
            p.add((Component)this.valueLabel1, "West");
            p.add(Box.createHorizontalGlue());
            p.add((Component)this.valueLabel2, "East");
            p.setInheritsPopupMenu(true);
            if (includeName & this.twoNames) {
                if (this.twoNames) {
                    this.setLayout(new GridLayout(3, 1, 0, 2));
                }
                this.add(this.nameLabel1);
                this.add(p);
                this.add(this.nameLabel2);
            } else if (includeName) {
                this.setLayout(new GridLayout(2, 1, 0, 2));
                this.add(this.nameLabel1);
                this.add(p);
            } else {
                this.setLayout(new GridLayout(1, 1, 0, 2));
                this.add(p);
            }
        } else if (includeName & this.twoNames) {
            this.setLayout(new GridLayout(4, 1, 0, 2));
            this.add(this.nameLabel1);
            this.add(this.valueLabel1);
            this.add(this.nameLabel2);
            this.add(this.valueLabel2);
        } else if (includeName) {
            this.setLayout(new GridLayout(3, 1, 0, 2));
            this.add(this.nameLabel1);
            this.add(this.valueLabel1);
            this.add(this.valueLabel2);
        } else {
            this.setLayout(new GridLayout(2, 1, 0, 2));
            this.add(this.valueLabel1);
            this.add(this.valueLabel2);
        }
        this.validate();
        this.requestDisplayUpdate = true;
    }

    @Override
    public void addBasicPopupMenu() {
        JMenuItem mi = null;
        mi = new FontAdjust.FontCheckBoxMenuItem("Horizontal");
        mi.setSelected(this.horizontal);
        mi.setActionCommand("horizontal");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                BasicDualReadoutPanel.this.horizontal = !BasicDualReadoutPanel.this.horizontal;
                BasicDualReadoutPanel.this.forceFontResize();
                BasicDualReadoutPanel.this.displayLayout(BasicDualReadoutPanel.this.includeName);
            }
        });
        this.popupSubMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Copy to clipboard");
        mi.setActionCommand("clipboard");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicDualReadoutPanel.this.toClipboard(BasicDualReadoutPanel.this.generateClipboardText());
            }
        });
        this.popupMenu.add(mi);
        super.addBasicPopupMenu();
    }

    protected String generateClipboardText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.nameLabel1.getText());
        sb.append("\n");
        sb.append(this.valueLabel1.getText());
        sb.append("\n");
        if (this.twoNames) {
            sb.append(this.nameLabel2.getText());
            sb.append("\n");
        }
        sb.append(this.valueLabel2.getText());
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public String generateParams() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.generateParams());
        if (!this.horizontal) {
            sb.append("hz ");
        }
        return sb.toString();
    }
}

