/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.main.FontAdjust;
import dk.hkj.panels.BasicPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import javax.swing.JLabel;

public abstract class BasicDualLargeSingleMediumPanel
extends BasicPanel
implements ActionListener {
    private final String FILLER_TEXT = "888888";
    protected JLabel nameLabel = new JLabel("--empty--");
    protected JLabel largeLeftLabel = null;
    protected JLabel largeRightLabel = null;
    protected JLabel mediumLabel = null;

    protected BasicDualLargeSingleMediumPanel(int smallLines) {
        this.nameLabel.setInheritsPopupMenu(true);
        this.nameLabel.setBorder(null);
        this.nameLabel.setAlignmentX(0.0f);
        this.nameLabel.setAlignmentY(0.0f);
        this.nameLabel.setHorizontalAlignment(0);
        this.largeLeftLabel = new JLabel("--empty--");
        this.largeLeftLabel.setInheritsPopupMenu(true);
        this.largeLeftLabel.setBorder(null);
        this.largeLeftLabel.setAlignmentX(1.0f);
        this.largeLeftLabel.setAlignmentY(1.0f);
        this.largeLeftLabel.setHorizontalAlignment(2);
        this.largeRightLabel = new JLabel("--empty--");
        this.largeRightLabel.setInheritsPopupMenu(true);
        this.largeRightLabel.setBorder(null);
        this.largeRightLabel.setAlignmentX(-1.0f);
        this.largeRightLabel.setAlignmentY(-1.0f);
        this.largeRightLabel.setHorizontalAlignment(4);
        this.mediumLabel = new JLabel("--empty--");
        this.mediumLabel.setInheritsPopupMenu(true);
        this.mediumLabel.setBorder(null);
        this.mediumLabel.setAlignmentX(0.0f);
        this.mediumLabel.setAlignmentY(0.0f);
        this.mediumLabel.setHorizontalAlignment(0);
    }

    @Override
    protected String getFontGroup() {
        return "LLMreadout" + (this.doubleWidth ? "dw" : "") + (this.doubleHeight ? "dh" : "");
    }

    @Override
    public void update() {
        this.update("", "888888", "888888", "888888");
    }

    public void update(String channel) {
        this.update(channel, "888888", "888888", "888888");
    }

    public void update(String channel, String leftText, String rightText, String mediumText) {
        if (channel == null) {
            channel = "";
        }
        if (leftText == null) {
            leftText = "888888";
        }
        if (rightText == null) {
            rightText = "888888";
        }
        if (mediumText == null) {
            mediumText = "888888";
        }
        if (this.includeName && !this.nameLabel.getText().equals(channel)) {
            this.nameLabel.setText(channel);
            this.nameLabel.setFont(this.fontSmall);
            this.requestDisplayUpdate = true;
        }
        if (!this.largeLeftLabel.getText().equals(leftText)) {
            this.largeLeftLabel.setText(leftText);
            this.largeLeftLabel.setFont(this.fontLarge);
            this.requestDisplayUpdate = true;
        }
        if (!this.largeRightLabel.getText().equals(rightText)) {
            this.largeRightLabel.setText(rightText);
            this.largeRightLabel.setFont(this.fontLarge);
            this.requestDisplayUpdate = true;
        }
        if (!this.mediumLabel.getText().equals(mediumText)) {
            this.mediumLabel.setText(mediumText);
            this.mediumLabel.setFont(this.fontMedium);
            this.requestDisplayUpdate = true;
        }
        if (this.requestDisplayUpdate) {
            int h;
            int w;
            boolean fontAdjust = false;
            int estimatedFontHeight = (int)(2.1 * (double)this.getHeight() / ((this.includeName ? 1.0 : 0.0) + 3.4));
            do {
                BasicPanel.TextSize ts1 = this.includeName ? this.getTextSize(this.fontSmall, channel) : new BasicPanel.TextSize(this, 0.0, 0.0);
                BasicPanel.TextSize ts2 = this.getTextSize(this.fontLarge, String.valueOf(rightText) + "_" + leftText);
                BasicPanel.TextSize ts3 = this.getTextSize(this.fontMedium, mediumText);
                w = (int)this.maxw(ts1, ts2, ts3) + 8;
                h = (int)(ts1.h + ts2.h + ts3.h) + 2;
                if (w <= this.getWidth() && h <= this.getHeight()) continue;
                this.reduceFontSize(estimatedFontHeight);
                this.nameLabel.setFont(this.fontSmall);
                this.largeLeftLabel.setFont(this.fontLarge);
                this.largeRightLabel.setFont(this.fontLarge);
                this.mediumLabel.setFont(this.fontMedium);
                fontAdjust = true;
            } while ((w > this.getWidth() || h > this.getHeight()) && this.canReduceFontSize());
            if (fontAdjust) {
                this.sizeFontAll();
            }
            this.requestDisplayUpdate = false;
            this.revalidate();
        }
    }

    @Override
    public void updateColor() {
        if (this.foregroundColor != null) {
            this.nameLabel.setForeground(this.foregroundColor);
            this.largeLeftLabel.setForeground(this.foregroundColor);
            this.largeRightLabel.setForeground(this.foregroundColor);
            this.mediumLabel.setForeground(this.foregroundColor);
        }
        if (this.backgroundColor != null) {
            this.nameLabel.setBackground(this.backgroundColor);
            this.largeLeftLabel.setBackground(this.backgroundColor);
            this.largeRightLabel.setBackground(this.backgroundColor);
            this.mediumLabel.setBackground(this.backgroundColor);
        }
    }

    @Override
    protected void displayLayout(boolean includeName) {
        if (!this.isVisible()) {
            return;
        }
        this.removeAll();
        this.setLayout(new GridBagLayout());
        GridBagConstraints cc = new GridBagConstraints();
        int y = 0;
        if (includeName) {
            cc.gridy = y++;
            cc.gridx = 0;
            cc.gridwidth = 2;
            cc.fill = 2;
            cc.anchor = 11;
            cc.weightx = 1.0;
            cc.weighty = 1.0;
            this.add((Component)this.nameLabel, cc);
        }
        cc = new GridBagConstraints();
        cc.gridy = y;
        cc.gridx = 0;
        cc.fill = 2;
        cc.anchor = 17;
        cc.weightx = 1.0;
        cc.weighty = 1.0;
        this.add((Component)this.largeLeftLabel, cc);
        cc = new GridBagConstraints();
        cc.gridy = y++;
        cc.gridx = 1;
        cc.fill = 2;
        cc.anchor = 13;
        cc.weightx = 1.0;
        cc.weighty = 1.0;
        this.add((Component)this.largeRightLabel, cc);
        cc = new GridBagConstraints();
        cc.gridy = y++;
        cc.gridx = 0;
        cc.gridwidth = 2;
        cc.fill = 2;
        cc.anchor = 10;
        cc.weightx = 1.0;
        cc.weighty = 1.0;
        this.add((Component)this.mediumLabel, cc);
        this.forceFontResize();
    }

    protected String generateClipboardText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.nameLabel.getText());
        sb.append("\n");
        sb.append(this.largeLeftLabel.getText());
        sb.append("\n");
        sb.append(this.largeRightLabel.getText());
        sb.append("\n");
        sb.append(this.mediumLabel.getText());
        sb.append("\n");
        return sb.toString();
    }

    @Override
    protected void popupMenuAdjust() {
        FontAdjust.FontMenuItem mi = new FontAdjust.FontMenuItem("Copy to clipboard");
        mi.addActionListener(arg0 -> this.toClipboard(this.generateClipboardText()));
        this.popupMenu.add(mi);
    }
}

