/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.main.FontAdjust;
import dk.hkj.panels.BasicPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;

public abstract class BasicDualButtonPanel
extends BasicPanel
implements ActionListener {
    protected JLabel nameLabel = new JLabel("--empty--");
    protected JButton firstButton = null;
    protected JButton secondButton = null;
    private boolean horizontal = false;

    protected BasicDualButtonPanel() {
        this.nameLabel.setInheritsPopupMenu(true);
        this.nameLabel.setBorder(null);
        this.nameLabel.setAlignmentX(0.0f);
        this.nameLabel.setAlignmentY(0.0f);
        this.nameLabel.setHorizontalAlignment(0);
        this.firstButton = new JButton("");
        this.firstButton.setActionCommand("firstButton");
        this.firstButton.addActionListener(this);
        this.firstButton.setInheritsPopupMenu(true);
        this.firstButton.setMargin(new Insets(2, 2, 2, 2));
        this.secondButton = new JButton("");
        this.secondButton.setActionCommand("secondButton");
        this.secondButton.addActionListener(this);
        this.secondButton.setMargin(new Insets(2, 2, 2, 2));
        this.secondButton.setInheritsPopupMenu(true);
        this.displayLayout(this.includeName);
    }

    @Override
    protected String getFontGroup() {
        return "DualButton" + (this.doubleWidth ? "dw" : "") + (this.doubleHeight ? "dh" : "") + (this.horizontal ? "hz" : "");
    }

    @Override
    public BasicPanel.ParamsSet getParamsSet() {
        BasicPanel.ParamsSet ps = super.getParamsSet();
        ps.addParams(new String[]{"hz"});
        return ps;
    }

    @Override
    public void setParams(BasicPanel.ParamsSet paramsSet) {
        this.horizontal = paramsSet.isPresent("hz");
        super.setParams(paramsSet);
    }

    @Override
    public void update() {
        if (!this.requestDisplayUpdate) {
            return;
        }
        int w = 0;
        int h = 0;
        boolean fontAdjust = false;
        this.nameLabel.setFont(this.fontLarge);
        this.firstButton.setFont(this.fontLarge);
        this.secondButton.setFont(this.fontLarge);
        do {
            int lines;
            BasicPanel.TextSize ts1 = this.includeName ? this.getTextSize(this.fontLarge, this.nameLabel.getText()) : new BasicPanel.TextSize(this, 0.0, 0.0);
            BasicPanel.TextSize ts2 = this.getButtonSize(this.firstButton);
            BasicPanel.TextSize ts3 = this.getButtonSize(this.secondButton);
            if (this.horizontal) {
                w = (int)(ts2.w + ts3.w);
                h = (int)(ts1.h + this.maxx(ts2.h, ts3.h)) + 4;
                w = (int)this.maxx(w, ts1.w) + 8;
                lines = 1 + (this.includeName ? 1 : 0);
            } else {
                w = (int)this.maxx(ts2.w, ts3.w);
                h = (int)(ts1.h + ts2.h + ts3.h) + 4;
                w = (int)this.maxx(w, ts1.w) + 8;
                lines = 2 + (this.includeName ? 1 : 0);
            }
            if (w <= this.getWidth() && h <= this.getHeight()) continue;
            this.reduceFontSize(this.getHeight() / lines);
            this.nameLabel.setFont(this.fontLarge);
            this.firstButton.setFont(this.fontLarge);
            this.secondButton.setFont(this.fontLarge);
            fontAdjust = true;
        } while ((w > this.getWidth() || h > this.getHeight()) && this.canReduceFontSize());
        if (fontAdjust) {
            this.sizeFontAll();
        }
        this.revalidate();
        this.requestDisplayUpdate = false;
    }

    @Override
    public void updateColor() {
        this.firstButton.setForeground(this.foregroundColor);
        this.secondButton.setForeground(this.foregroundColor);
        this.nameLabel.setForeground(this.foregroundColor);
        this.requestDisplayUpdate = true;
    }

    @Override
    protected void displayLayout(boolean includeName) {
        this.removeAll();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        int n = 0;
        if (includeName) {
            c.fill = 2;
            c.anchor = 11;
            c.gridwidth = 2;
            c.weightx = 1.0;
            c.weighty = 1.0;
            this.add((Component)this.nameLabel, c);
            ++n;
        }
        if (this.horizontal) {
            c = new GridBagConstraints();
            c.gridy = n;
            c.gridx = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.anchor = 17;
            c.fill = 1;
            c.insets = new Insets(1, 1, 1, 1);
            this.add((Component)this.firstButton, c);
            c = new GridBagConstraints();
            c.gridy = n;
            c.gridx = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.anchor = 13;
            c.fill = 1;
            c.insets = new Insets(1, 1, 1, 1);
            this.add((Component)this.secondButton, c);
        } else {
            c = new GridBagConstraints();
            c = new GridBagConstraints();
            c.gridy = n;
            c.gridx = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.anchor = 10;
            c.fill = 1;
            c.insets = new Insets(1, 1, 1, 1);
            this.add((Component)this.firstButton, c);
            c = new GridBagConstraints();
            c.gridy = n + 1;
            c.gridx = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.insets = new Insets(1, 1, 1, 1);
            c.anchor = 10;
            c.fill = 1;
            this.add((Component)this.secondButton, c);
        }
        this.requestDisplayUpdate = true;
        this.forceFontResize();
    }

    @Override
    protected void popupMenuAdjust() {
        FontAdjust.FontCheckBoxMenuItem mi = null;
        mi = new FontAdjust.FontCheckBoxMenuItem("Horizontal");
        mi.setSelected(this.horizontal);
        mi.setActionCommand("horizontal");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                BasicDualButtonPanel.this.horizontal = !BasicDualButtonPanel.this.horizontal;
                BasicDualButtonPanel.this.displayLayout(BasicDualButtonPanel.this.includeName);
            }
        });
        this.popupSubMenu.add(mi);
    }

    @Override
    public boolean needData() {
        return false;
    }

    @Override
    public String generateParams() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.generateParams());
        if (this.horizontal) {
            sb.append("hz ");
        }
        return sb.toString();
    }
}

