/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.main.FontAdjust;
import dk.hkj.main.Support;
import dk.hkj.panels.BasicPanel;
import dk.hkj.panels.PopupAskDualValue;
import dk.hkj.util.MathUtil;
import dk.hkj.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;

public abstract class BasicChartPanel
extends BasicPanel {
    protected JFreeChart freeChart = null;
    protected JLabel nameLabel = null;
    protected ChartPanel chartPanel = null;
    protected boolean includeScales = true;

    BasicChartPanel(ChartType chartType) {
        switch (chartType) {
            case XY: {
                this.freeChart = ChartFactory.createXYLineChart("Chart", null, null, null, PlotOrientation.VERTICAL, true, true, false);
                break;
            }
            case Histogram: {
                this.freeChart = ChartFactory.createHistogram("Histogram", null, "Count", null, PlotOrientation.VERTICAL, true, true, false);
            }
        }
        FontAdjust.fontSizes.chartTheme.apply(this.freeChart);
        XYPlot plot = this.freeChart.getXYPlot();
        plot.getDomainAxis().setUpperMargin(0.0);
        plot.getDomainAxis().setLowerMargin(0.0);
        this.freeChart.getLegend().setVisible(false);
        this.freeChart.getTitle().setVisible(false);
        this.chartPanel = new ChartPanel(this.freeChart);
        this.chartPanel.setPopupMenu(null);
        this.chartPanel.setInheritsPopupMenu(true);
        this.chartPanel.setDomainZoomable(false);
        this.chartPanel.setRangeZoomable(false);
        this.chartPanel.setMouseZoomable(false);
        this.chartPanel.setDisplayToolTips(true);
        this.freeChart.setBackgroundPaint(this.getBackground());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent arg0) {
                BasicChartPanel.this.sizeChartPanel();
            }
        });
        this.nameLabel = new JLabel("");
        this.nameLabel.setInheritsPopupMenu(true);
        this.nameLabel.setBorder(null);
        this.nameLabel.setAlignmentX(0.0f);
        this.nameLabel.setAlignmentY(0.0f);
        this.nameLabel.setHorizontalAlignment(0);
        this.nameLabel.setText("--empty--");
    }

    @Override
    protected String getFontGroup() {
        return "Chart" + (this.doubleWidth ? "dw" : "") + (this.doubleHeight ? "dh" : "");
    }

    @Override
    public BasicPanel.ParamsSet getParamsSet() {
        BasicPanel.ParamsSet ps = super.getParamsSet();
        ps.addParams(new String[]{"noscale"});
        return ps;
    }

    @Override
    public void setParams(BasicPanel.ParamsSet paramsSet) {
        super.setParams(paramsSet);
        this.setScalesVisible(!paramsSet.isPresent("noscale"));
    }

    protected String getRangeString(ValueAxis range) {
        if (range.isAutoRange()) {
            return "auto";
        }
        return String.valueOf(StringUtil.formatDoubleEE(range.getRange().getLowerBound(), false)) + ":" + StringUtil.formatDoubleEE(range.getRange().getUpperBound(), false);
    }

    protected void setRange(ValueAxis range, String rangeStr) {
        if (rangeStr == null || rangeStr.length() == 0 || rangeStr.equalsIgnoreCase("auto")) {
            range.setAutoRange(true);
        } else {
            int i = rangeStr.indexOf(" - ");
            if (i > 0) {
                double yScaleMin = StringUtil.parseDoubleEE(rangeStr.substring(0, i));
                double yScaleMax = StringUtil.parseDoubleEE(rangeStr.substring(i + 3));
                range.setRange(yScaleMin, yScaleMax);
            } else {
                i = rangeStr.indexOf(58);
                double yScaleMin = StringUtil.parseDoubleEE(rangeStr.substring(0, i));
                double yScaleMax = StringUtil.parseDoubleEE(rangeStr.substring(i + 1));
                range.setRange(yScaleMin, yScaleMax);
            }
            range.setAutoRange(false);
        }
        this.requestDisplayUpdate = true;
    }

    private void addRangeZ(JMenu menu, ValueAxis range, double min, double max, double rangeExpand) {
        if (min < 0.0 && max > 0.0) {
            return;
        }
        FontAdjust.FontMenuItem mi = null;
        if (min >= 0.0) {
            double maxR = MathUtil.roundDigits(max * (1.0 + rangeExpand), 3);
            String s = "0 - " + StringUtil.formatDoubleEE(maxR, false);
            mi = new FontAdjust.FontMenuItem("Range " + s);
            mi.setActionCommand(s);
            mi.addActionListener(param -> this.setRange(range, param.getActionCommand()));
            menu.add(mi);
        } else if (max <= 0.0) {
            double minR = MathUtil.roundDigits(min * (1.0 + rangeExpand), 3);
            String s = String.valueOf(StringUtil.formatDoubleEE(minR, false)) + " - 0";
            mi = new FontAdjust.FontMenuItem("Range " + s);
            mi.setActionCommand(s);
            mi.addActionListener(param -> this.setRange(range, param.getActionCommand()));
            menu.add(mi);
        }
    }

    private void addRange(JMenu menu, ValueAxis range, double min, double max, double rangeExpand) {
        FontAdjust.FontMenuItem mi = null;
        rangeExpand = (max - min) * rangeExpand;
        double v = Math.pow(10.0, (int)Math.log10(rangeExpand) - 1);
        double minR = Math.rint((min - rangeExpand) / v) * v;
        double maxR = Math.rint((max + rangeExpand) / v) * v;
        double d = (maxR - minR) / 50.0;
        if (Math.abs(minR) > d && Math.abs(maxR) > d) {
            String s = String.valueOf(StringUtil.formatDoubleEE(minR, false)) + " - " + StringUtil.formatDoubleEE(maxR, false);
            mi = new FontAdjust.FontMenuItem("Range " + s);
            mi.setActionCommand(s);
            mi.addActionListener(param -> this.setRange(range, param.getActionCommand()));
            menu.add(mi);
        }
    }

    private void setManualRange(ValueAxis range, String prompt) {
        PopupAskDualValue padv = new PopupAskDualValue(this, prompt, "Lower bound", "Upper bound", range.getLowerBound(), range.getUpperBound(), true);
        range.setLowerBound(padv.getValue1());
        range.setUpperBound(padv.getValue2());
    }

    protected void addValueRangeMenu(JMenu menu, ValueAxis range, double min, double max) {
        FontAdjust.FontMenuItem mi = new FontAdjust.FontMenuItem("Auto");
        mi.setActionCommand("auto");
        mi.addActionListener(param -> this.setRange(range, param.getActionCommand()));
        menu.add(mi);
        mi = new FontAdjust.FontMenuItem("Manual");
        mi.setActionCommand("manual");
        mi.addActionListener(param -> this.setManualRange(range, "Enter range values"));
        menu.add(mi);
        this.addRangeZ(menu, range, min, max, 0.1);
        this.addRangeZ(menu, range, min, max, 0.2);
        this.addRangeZ(menu, range, min, max, 0.5);
        this.addRange(menu, range, min, max, 0.1);
        this.addRange(menu, range, min, max, 0.2);
        this.addRange(menu, range, min, max, 0.5);
    }

    protected void sizeChartPanel() {
        Dimension dim = new Dimension(this.getWidth() - 8, this.getHeight() - 10);
        if (this.includeName) {
            BasicPanel.TextSize ts = new BasicPanel.TextSize(this, 0.0, 0.0);
            boolean fontAdjust = false;
            do {
                ts = this.getTextSize(this.fontLarge, this.nameLabel.getText());
                ts.w += 8.0;
                if (!(ts.w > (double)this.getWidth()) && !(ts.h > (double)(this.getHeight() / 6))) continue;
                this.reduceFontSize(this.getHeight() / 6);
                fontAdjust = true;
            } while ((ts.w > (double)this.getWidth() || ts.h > (double)(this.getHeight() / 6)) && this.canReduceFontSize());
            if (fontAdjust) {
                this.sizeFontAll();
            }
            dim.height = (int)((double)dim.height - ts.h);
            this.nameLabel.setFont(this.fontLarge);
        }
        this.chartPanel.setMinimumSize(dim);
        this.chartPanel.setPreferredSize(dim);
        this.chartPanel.setMaximumSize(dim);
        this.chartPanel.setSize(dim);
    }

    @Override
    public void updateColor() {
        if (this.foregroundColor != null) {
            XYPlot plot = this.freeChart.getXYPlot();
            ValueAxis range = plot.getRangeAxis();
            range.setLabelPaint(this.foregroundColor);
            range.setTickLabelPaint(this.foregroundColor);
            range.setTickMarkPaint(this.foregroundColor);
            ValueAxis domain = plot.getDomainAxis();
            domain.setLabelPaint(this.foregroundColor);
            domain.setTickLabelPaint(this.foregroundColor);
            domain.setTickMarkPaint(this.foregroundColor);
            this.nameLabel.setForeground(this.foregroundColor);
        }
        if (this.backgroundColor != null) {
            this.freeChart.setBackgroundPaint(this.backgroundColor);
            this.nameLabel.setBackground(this.backgroundColor);
        }
    }

    private void setScalesVisible(boolean visible) {
        this.includeScales = visible;
        XYPlot plot = this.freeChart.getXYPlot();
        ValueAxis range = plot.getRangeAxis();
        range.setVisible(this.includeScales);
        range = plot.getRangeAxis(1);
        if (range != null) {
            range.setVisible(this.includeScales);
        }
        ValueAxis domain = plot.getDomainAxis();
        domain.setVisible(this.includeScales);
        this.requestDisplayUpdate = true;
    }

    @Override
    protected void displayLayout(boolean includeName) {
        this.removeAll();
        if (includeName) {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridy = 0;
            c.fill = 2;
            this.add((Component)this.nameLabel, c);
            c = new GridBagConstraints();
            c.gridy = 1;
            c.anchor = 15;
            this.add((Component)this.chartPanel, c);
        } else {
            this.setLayout(new BorderLayout());
            this.add(this.chartPanel);
        }
        this.validate();
        this.sizeChartPanel();
    }

    @Override
    public void addBasicPopupMenu() {
        JMenuItem mi = new FontAdjust.FontCheckBoxMenuItem("Include scales");
        mi.setSelected(this.includeScales);
        mi.addActionListener(arg0 -> this.setScalesVisible(!this.includeScales));
        this.popupSubMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Copy to clipboard");
        mi.addActionListener(arg0 -> this.toClipboard(this.generateClipboardImage()));
        this.popupMenu.add(mi);
        super.addBasicPopupMenu();
    }

    protected Image generateClipboardImage() {
        Dimension sz = Support.systemSettings.imageResolution[0];
        BufferedImage image = new BufferedImage((int)sz.getWidth(), (int)sz.getHeight(), 1);
        try {
            this.freeChart.getTitle().setVisible(true);
            this.freeChart.getTitle().setText(this.nameLabel.getText());
            this.freeChart.draw(image.createGraphics(), new Rectangle((int)sz.getWidth(), (int)sz.getHeight()));
        }
        finally {
            this.freeChart.getTitle().setVisible(false);
        }
        return image;
    }

    @Override
    public String generateParams() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.generateParams());
        if (!this.includeScales) {
            sb.append("noscale ");
        }
        return sb.toString();
    }

    protected static enum ChartType {
        XY,
        Histogram;

    }
}

