/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.panels.BasicPanel;
import dk.hkj.util.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;

public abstract class BasicButtonsPanel
extends BasicPanel
implements ActionListener {
    private static int MIN_BUTTON_WIDTH = 35;
    private static int MIN_BUTTON_HEIGHT = 25;
    protected JLabel nameLabel = null;
    protected List<Button> buttons = new ArrayList<Button>();
    private int columns = 1;
    private int rows = 1;

    protected BasicButtonsPanel() {
        this.nameLabel = new JLabel("--empty--");
        this.nameLabel.setInheritsPopupMenu(true);
        this.nameLabel.setBorder(null);
        this.nameLabel.setAlignmentX(0.0f);
        this.nameLabel.setAlignmentY(0.0f);
        this.nameLabel.setHorizontalAlignment(0);
    }

    @Override
    protected String getFontGroup() {
        return "Buttons" + this.rows + ":" + this.columns + (this.doubleWidth ? "dw" : "") + (this.doubleHeight ? "dh" : "");
    }

    @Override
    public void update() {
        if (this.requestDisplayUpdate) {
            int h;
            int w;
            boolean fontAdjust = false;
            for (Button b : this.buttons) {
                b.setFont(this.fontLarge);
            }
            this.nameLabel.setFont(this.fontLarge);
            int estimatedFontHeight = this.getHeight() / (this.rows + (this.includeName ? 1 : 0));
            do {
                w = this.calcWidth();
                h = this.calcHeight();
                if (this.includeName) {
                    BasicPanel.TextSize ts1 = this.getTextSize(this.fontLarge, this.nameLabel.getText());
                    w = (int)this.maxx(w, ts1.w + 8.0);
                    h = (int)((double)h + ts1.h + 4.0);
                }
                if (w <= this.getWidth() && h <= this.getHeight()) continue;
                this.reduceFontSize(estimatedFontHeight);
                for (Button b : this.buttons) {
                    b.setFont(this.fontLarge);
                }
                this.nameLabel.setFont(this.fontLarge);
                fontAdjust = true;
            } while ((w > this.getWidth() || h > this.getHeight()) && this.canReduceFontSize());
            if (fontAdjust) {
                this.sizeFontAll();
            }
            this.requestDisplayUpdate = false;
            this.revalidate();
            this.repaint();
        }
    }

    public void changeUnit(String unit) {
        for (Button button : this.buttons) {
            button.changeUnit(unit);
        }
    }

    /*
     * Unable to fully structure code
     */
    private int calcWidthColumn(int c) {
        w = 0.0;
        if (c < this.buttons.size()) ** GOTO lbl6
        return BasicButtonsPanel.MIN_BUTTON_WIDTH;
lbl-1000:
        // 1 sources

        {
            w = this.maxx(w, this.buttons.get(c).getWidth());
            c += this.columns;
lbl6:
            // 2 sources

            ** while (c < this.buttons.size())
        }
lbl7:
        // 1 sources

        return (int)w;
    }

    /*
     * Unable to fully structure code
     */
    private int calcHeightRow(int r) {
        h = 0.0;
        if (r < this.buttons.size()) ** GOTO lbl6
        return BasicButtonsPanel.MIN_BUTTON_HEIGHT;
lbl-1000:
        // 1 sources

        {
            h = this.maxx(h, this.buttons.get(r).getHeight());
            r += this.rows;
lbl6:
            // 2 sources

            ** while (r < this.buttons.size())
        }
lbl7:
        // 1 sources

        return (int)h;
    }

    private int calcWidth() {
        int w = 0;
        int c = 0;
        while (c < this.columns) {
            w += this.calcWidthColumn(c);
            ++c;
        }
        return w + 8;
    }

    private int calcHeight() {
        int h = 0;
        int r = 0;
        while (r < this.rows) {
            h += this.calcHeightRow(r);
            ++r;
        }
        return h + 2;
    }

    @Override
    public void updateColor() {
        if (this.foregroundColor != null) {
            for (Button b : this.buttons) {
                b.setForeground(this.foregroundColor);
            }
            this.nameLabel.setForeground(this.foregroundColor);
        }
    }

    @Override
    protected void displayLayout(boolean includeName) {
        this.removeAll();
        int n = this.buttons.size();
        int mw = 0;
        for (Button b : this.buttons) {
            JButton jb = b.getButton();
            if (jb == null) continue;
            mw = Math.max(mw, jb.getText().length());
        }
        mw = mw * 4 + MIN_BUTTON_WIDTH;
        int c = (Math.max(this.getWidth(), 150) - 8) / mw;
        int r = (Math.max(this.getHeight(), 100) - 4) / MIN_BUTTON_HEIGHT;
        if (includeName) {
            --r;
        }
        if (r <= 0) {
            r = 1;
        }
        if (c <= 0) {
            c = 1;
        }
        boolean cadj = false;
        while (r * c > n) {
            boolean bl = cadj = (double)c > (double)r * 1.2;
            if (cadj) {
                --c;
                continue;
            }
            --r;
        }
        if (c * r < n) {
            if (cadj) {
                ++c;
            } else {
                ++r;
            }
        }
        if (r <= 0) {
            r = 1;
        }
        if (c <= 0) {
            c = 1;
        }
        this.rows = r;
        this.columns = c;
        this.setLayout(new GridBagLayout());
        GridBagConstraints cc = new GridBagConstraints();
        int y0 = 0;
        if (includeName) {
            cc.gridy = y0++;
            cc.gridwidth = 100;
            cc.fill = 2;
            cc.anchor = 11;
            cc.weightx = 1.0;
            cc.weighty = 1.0;
            this.add((Component)this.nameLabel, cc);
        }
        if (r < 0 || c < 0) {
            return;
        }
        n = 0;
        r = 0;
        while (r < this.rows) {
            c = 0;
            while (c < this.columns) {
                if (n < this.buttons.size()) {
                    cc = new GridBagConstraints();
                    cc.gridx = c;
                    cc.gridy = r + y0;
                    cc.weightx = 2.0;
                    cc.weighty = 3.0;
                    cc.fill = 1;
                    cc.insets = new Insets(1, 1, 1, 1);
                    this.add((Component)this.buttons.get(n).getButton(), cc);
                    ++n;
                }
                ++c;
            }
            ++r;
        }
        this.forceFontResize();
        this.requestDisplayUpdate = true;
    }

    @Override
    public boolean needData() {
        return false;
    }

    protected class Button
    implements Comparable<Button> {
        private JButton button;
        private double value = 0.0;
        private String func = null;
        private String title = null;
        private BasicPanel.TextSize ts = null;
        private boolean sizeValid = false;
        private String unit = null;
        private String toolTip = null;
        private boolean enable = true;

        public Button(double value, String unit) {
            this.value = value;
            this.func = null;
            this.setUnit(unit);
            this.generateButton();
        }

        public Button(String title, double value) {
            this.title = title;
            this.value = value;
            this.func = null;
            this.setUnit(this.unit);
            this.generateButton();
        }

        public Button(String title, String func) {
            this.title = title;
            this.func = func;
            this.generateButton();
        }

        public Button(String title, String func, boolean enable) {
            this.enable = enable;
            this.title = title;
            this.func = func;
            this.generateButton();
        }

        public Button(String title, String func, String toolTip, boolean enable) {
            this.enable = enable;
            this.toolTip = toolTip;
            this.title = title;
            this.func = func;
            this.generateButton();
        }

        public String getTitle() {
            if (this.title != null) {
                return this.title;
            }
            return String.valueOf(StringUtil.formatDoubleEE(this.value, true)) + this.unit;
        }

        public void setEnabled(boolean enable) {
            this.enable = enable;
            if (this.button != null) {
                this.button.setEnabled(enable);
            }
        }

        public void setUnit(String unit) {
            this.unit = unit == null ? "" : unit.replace("_", " ").replace("-", "");
        }

        public double getValue() {
            return this.value;
        }

        public JButton getButton() {
            return this.button;
        }

        void calcTextSize() {
            this.ts = BasicButtonsPanel.this.getButtonSize(this.button);
            this.sizeValid = true;
        }

        public double getWidth() {
            if (!this.sizeValid) {
                this.calcTextSize();
            }
            return this.ts.w;
        }

        public double getHeight() {
            if (!this.sizeValid) {
                this.calcTextSize();
            }
            return this.ts.h;
        }

        public BasicPanel.TextSize getTextSize() {
            if (!this.sizeValid) {
                this.calcTextSize();
            }
            return this.ts;
        }

        public void setForeground(Color color) {
            if (color != null) {
                this.button.setForeground(color);
            }
        }

        public void changeUnit(String unit) {
            if (this.func == null && this.title == null) {
                this.unit = unit;
                this.button.setText(String.valueOf(StringUtil.formatDoubleEE(this.value, true)) + unit);
            }
        }

        public void generateButton() {
            this.sizeValid = false;
            if (this.func != null) {
                this.button = new JButton(this.title);
                this.button.setActionCommand("F:" + this.func);
            } else if (this.title != null) {
                this.button = new JButton(this.title);
                this.button.setActionCommand("V:" + StringUtil.formatDoubleEE(this.value, false));
            } else {
                this.button = new JButton(String.valueOf(StringUtil.formatDoubleEE(this.value, true)) + this.unit);
                this.button.setActionCommand("V:" + StringUtil.formatDoubleEE(this.value, false));
            }
            this.button.addActionListener(BasicButtonsPanel.this);
            this.button.setToolTipText(this.toolTip);
            this.button.setInheritsPopupMenu(true);
            this.button.setMargin(new Insets(2, 2, 2, 2));
            this.button.setEnabled(this.enable);
        }

        public String generateParam() {
            if (this.func != null) {
                return this.func;
            }
            return StringUtil.formatDoubleEE(this.value, false);
        }

        public void setFont(Font font) {
            if (font != this.button.getFont()) {
                this.button.setFont(font);
                this.sizeValid = false;
            }
        }

        @Override
        public int compareTo(Button o) {
            if (this.func != null && o.func != null) {
                return 0;
            }
            if (this.func != null) {
                return -1;
            }
            if (o.func != null) {
                return 1;
            }
            if (this.value > o.value) {
                return 1;
            }
            if (this.value < o.value) {
                return -1;
            }
            return 0;
        }
    }
}

