/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.panels.BasicPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class BasicBitsReadoutPanel
extends BasicPanel {
    protected BitsPanel bp = new BitsPanel();
    protected JLabel nameLabel = new JLabel("");

    protected BasicBitsReadoutPanel() {
        this.nameLabel.setInheritsPopupMenu(true);
        this.nameLabel.setBorder(null);
        this.nameLabel.setAlignmentX(0.0f);
        this.nameLabel.setAlignmentY(0.0f);
        this.nameLabel.setHorizontalAlignment(0);
    }

    @Override
    public BasicPanel.ParamsSet getParamsSet() {
        BasicPanel.ParamsSet ps = super.getParamsSet();
        ps.addParams(new String[]{"bits", "lsb"});
        return ps;
    }

    @Override
    public void setParams(BasicPanel.ParamsSet paramsSet) {
        int[] bits;
        super.setParams(paramsSet);
        if (paramsSet.isPresent("lsb")) {
            this.bp.setLsbFirst(true);
        }
        if ((bits = paramsSet.getInts("bits")) != null) {
            this.bp.setBits(bits[0]);
        }
    }

    @Override
    protected String getFontGroup() {
        return "Bits";
    }

    @Override
    public void reset() {
        this.bp.reset();
    }

    @Override
    protected boolean supportReset() {
        return true;
    }

    @Override
    public void updateColor() {
        if (this.foregroundColor != null) {
            this.nameLabel.setForeground(this.foregroundColor);
        }
        if (this.backgroundColor != null) {
            this.nameLabel.setBackground(this.backgroundColor);
        }
    }

    @Override
    public boolean needData() {
        return true;
    }

    @Override
    protected void displayLayout(boolean includeName) {
        this.removeAll();
        if (includeName) {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridy = 0;
            c.fill = 2;
            this.add((Component)this.nameLabel, c);
            c = new GridBagConstraints();
            c.gridy = 1;
            c.anchor = 15;
            this.add((Component)this.bp, c);
        } else {
            this.setLayout(new BorderLayout());
            this.add(this.bp);
        }
        this.validate();
        this.sizeBitsPanel();
    }

    protected void sizeBitsPanel() {
        Dimension dim = new Dimension(this.getWidth() - 8, this.getHeight() - 10);
        if (this.includeName) {
            BasicPanel.TextSize ts = new BasicPanel.TextSize(this, 0.0, 0.0);
            boolean fontAdjust = false;
            do {
                ts = this.getTextSize(this.fontLarge, this.nameLabel.getText());
                ts.w += 8.0;
                if (!(ts.w > (double)this.getWidth()) && !(ts.h > (double)(this.getHeight() / 6))) continue;
                this.reduceFontSize(this.getHeight() / 6);
                fontAdjust = true;
            } while ((ts.w > (double)this.getWidth() || ts.h > (double)(this.getHeight() / 6)) && this.canReduceFontSize());
            if (fontAdjust) {
                this.sizeFontAll();
            }
            dim.height = (int)((double)dim.height - ts.h);
            this.nameLabel.setFont(this.fontLarge);
        }
        this.bp.setMinimumSize(dim);
        this.bp.setPreferredSize(dim);
        this.bp.setMaximumSize(dim);
        this.bp.setSize(dim);
    }

    @Override
    public String generateParams() {
        StringBuilder sb = new StringBuilder();
        sb.append("bits:");
        sb.append(this.bp.getBits());
        sb.append(" ");
        if (this.bp.lsbFirst) {
            sb.append("lsb ");
        }
        return sb.toString();
    }

    protected class BitsPanel
    extends JPanel {
        private BufferedImage image = null;
        private final int MinBitWidth = 18;
        private int bits = 4;
        private long value = 0L;
        private String[] bitNames = new String[]{"0", "1", "2", "3"};
        private int fontYAdjust = 0;
        private final Color backgroundColor = new Color(240, 248, 152);
        private final Color onColor = new Color(28, 255, 0);
        private final Color offColor = new Color(200, 150, 0);
        private final Color textColor = new Color(0, 0, 0);
        private final Color textOffColor = new Color(160, 160, 160);
        private Font font = null;
        private int bitWidth = 0;
        private int bitHeight = 0;
        private int maxNameWidth = 0;
        private boolean lsbFirst = false;

        BitsPanel() {
            this.resizeGraphic(10, 10);
        }

        public int getBits() {
            return this.bits;
        }

        public void resetBitNames() {
            this.setBits(this.bits);
        }

        public void setBits(int bits) {
            this.bits = bits;
            this.bitNames = new String[bits];
            int i = 0;
            while (i < bits) {
                this.bitNames[i] = Integer.toString(i);
                ++i;
            }
            this.maxNameWidth = 0;
            this.update();
        }

        public void setBitName(int bit, String name) {
            this.bitNames[bit] = name;
            this.maxNameWidth = 0;
        }

        public boolean getLsbFirst() {
            return this.lsbFirst;
        }

        public void setLsbFirst(boolean lsbFirst) {
            this.lsbFirst = lsbFirst;
            this.update();
        }

        public void reset() {
            this.update();
        }

        public void update() {
            this.updateValue(this.value);
        }

        public void updateValue(long v) {
            this.value = v;
            this.makeGraphic();
            this.repaint();
        }

        private void calcMaxNameWidth(Graphics2D g) {
            this.maxNameWidth = 0;
            int i = 0;
            while (i < this.bits) {
                Rectangle2D sz = this.font.getStringBounds(this.bitNames[i], g.getFontRenderContext());
                this.maxNameWidth = Math.max(this.maxNameWidth, (int)sz.getWidth());
                ++i;
            }
        }

        private void resizeGraphic(int w, int h) {
            this.image = new BufferedImage(w, h, 2);
            float fs = (float)((double)(Math.min((float)h, (float)w / 2.0f) / 10.0f * (float)Toolkit.getDefaultToolkit().getScreenResolution()) / 72.0);
            this.fontYAdjust = (int)(-fs / 3.0f);
            this.font = this.getFont().deriveFont(fs);
            this.maxNameWidth = 0;
            this.makeGraphic();
        }

        private void paintBit(int bit, Graphics2D g, int x0, int y0) {
            boolean state = (this.value & 1L << bit) != 0L;
            g.setColor(state ? this.textColor : this.textOffColor);
            Rectangle2D sz = this.font.getStringBounds(this.bitNames[bit], g.getFontRenderContext());
            g.drawString(this.bitNames[bit], (int)((double)x0 - sz.getWidth() / 2.0), y0 - this.bitHeight / 2 - 3);
            g.setColor(this.offColor);
            g.fillOval(x0 - this.bitWidth / 2, y0 - this.bitHeight / 2, this.bitWidth, this.bitHeight);
            g.setColor(state ? this.onColor : this.backgroundColor);
            g.fillOval(x0 - this.bitWidth / 2 + 2, y0 - this.bitHeight / 2 + 2, this.bitWidth - 4, this.bitHeight - 4);
        }

        private void makeGraphic() {
            int line;
            int pos;
            int w = this.image.getWidth();
            int h = this.image.getHeight();
            Graphics2D g = this.image.createGraphics();
            if (this.maxNameWidth == 0) {
                this.calcMaxNameWidth(g);
            }
            g.setBackground(this.backgroundColor);
            g.clearRect(0, 0, w, h);
            g.setFont(this.font);
            int bitsLine = w / Math.max(18, this.maxNameWidth);
            int lines = 1;
            int[] BitsLine = new int[]{4, 8, 12, 16, 20, 24, 32, 99};
            int n = 0;
            while (bitsLine >= BitsLine[n] && n < BitsLine.length) {
                ++n;
            }
            if (n > 0) {
                --n;
            }
            bitsLine = this.bits <= 8 && BitsLine[n] >= 4 && h > 100 ? 4 : (this.bits <= 16 && BitsLine[n] >= 8 && h > 100 ? 8 : BitsLine[n]);
            lines = (this.bits + bitsLine - 1) / bitsLine;
            this.bitWidth = Math.min(w / (bitsLine + 1) - 2, (h * 8 / 10 - 10) / lines);
            if (this.bitWidth < 10) {
                this.bitWidth = 10;
            }
            this.bitHeight = this.bitWidth * 4 / 5;
            int lineHeight = h / 10 + this.bitHeight + 6;
            if (this.lsbFirst) {
                pos = 0;
                line = 0;
                int i = 0;
                while (i < this.bits) {
                    this.paintBit(i, g, (pos * 2 + 1) * w / (2 * bitsLine), lineHeight * (line + 1) - this.bitHeight / 2);
                    if (++pos >= bitsLine) {
                        pos = 0;
                        ++line;
                    }
                    ++i;
                }
            } else {
                pos = bitsLine - 1;
                line = (this.bits - 1) / bitsLine;
                int i = 0;
                while (i < this.bits) {
                    this.paintBit(i, g, (pos * 2 + 1) * w / (2 * bitsLine), lineHeight * (line + 1) - this.bitHeight / 2);
                    if (--pos < 0) {
                        pos = bitsLine - 1;
                        --line;
                    }
                    ++i;
                }
            }
            if (lines * lineHeight < h * 9 / 10 - 2) {
                g.setColor(this.textColor);
                String s = "0x" + Long.toString(this.value, 16);
                Rectangle2D sz = this.font.getStringBounds(s, g.getFontRenderContext());
                g.drawString(s, (int)((double)w - sz.getWidth() - 2.0), h - 2);
                g.drawString(Long.toString(this.value), 2, h - 2);
            }
        }

        protected void drawTextcy(Graphics2D g, int xLeft, int yCenter, String text) {
            Rectangle2D sz = this.font.getStringBounds(text, g.getFontRenderContext());
            g.drawString(text, xLeft, (int)((double)yCenter + sz.getHeight() / 2.0) + this.fontYAdjust);
        }

        protected void drawTextcx(Graphics2D g, int xCenter, int yBottom, String text) {
            Rectangle2D sz = this.font.getStringBounds(text, g.getFontRenderContext());
            g.drawString(text, (int)((double)xCenter - sz.getWidth() / 2.0), yBottom);
        }

        @Override
        protected void paintComponent(Graphics g) {
            int w = this.getWidth();
            int h = this.getHeight();
            if (w != this.image.getWidth() || h != this.image.getHeight()) {
                this.resizeGraphic(w, h);
            }
            g.drawImage(this.image, 0, 0, null);
        }
    }
}

