/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.panels.BasicPanel;
import dk.hkj.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class BasicAnalogReadoutPanel
extends BasicPanel {
    protected AnalogDrawerPanel adp = new AnalogDrawerPanel();
    protected JLabel nameLabel = new JLabel("");

    protected BasicAnalogReadoutPanel() {
        this.nameLabel.setInheritsPopupMenu(true);
        this.nameLabel.setBorder(null);
        this.nameLabel.setAlignmentX(0.0f);
        this.nameLabel.setAlignmentY(0.0f);
        this.nameLabel.setHorizontalAlignment(0);
    }

    @Override
    public BasicPanel.ParamsSet getParamsSet() {
        BasicPanel.ParamsSet ps = super.getParamsSet();
        ps.addParams(new String[]{"type", "limits", "alarm"});
        return ps;
    }

    @Override
    public void setParams(BasicPanel.ParamsSet paramsSet) {
        super.setParams(paramsSet);
        if (paramsSet.isPresent("alarm")) {
            this.adp.setAlarm(true);
        }
        String s = paramsSet.getString("type");
        this.adp.setScaleType(s);
        double[] v = paramsSet.getDoubles("limits");
        if (v != null && v.length == 2) {
            this.adp.setLower(v[0]);
            this.adp.setUpper(v[1]);
        }
    }

    @Override
    protected String getFontGroup() {
        return "Analog";
    }

    @Override
    public void reset() {
        this.adp.reset();
    }

    @Override
    protected boolean supportReset() {
        return true;
    }

    @Override
    public void updateColor() {
        if (this.foregroundColor != null) {
            this.nameLabel.setForeground(this.foregroundColor);
        }
        if (this.backgroundColor != null) {
            this.nameLabel.setBackground(this.backgroundColor);
        }
    }

    @Override
    public boolean needData() {
        return true;
    }

    @Override
    protected void displayLayout(boolean includeName) {
        this.removeAll();
        if (includeName) {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridy = 0;
            c.fill = 2;
            this.add((Component)this.nameLabel, c);
            c = new GridBagConstraints();
            c.gridy = 1;
            c.anchor = 15;
            this.add((Component)this.adp, c);
        } else {
            this.setLayout(new BorderLayout());
            this.add(this.adp);
        }
        this.validate();
        this.sizeAnalogPanel();
    }

    protected void sizeAnalogPanel() {
        Dimension dim = new Dimension(this.getWidth() - 8, this.getHeight() - 10);
        if (this.includeName) {
            BasicPanel.TextSize ts = new BasicPanel.TextSize(this, 0.0, 0.0);
            boolean fontAdjust = false;
            do {
                ts = this.getTextSize(this.fontLarge, this.nameLabel.getText());
                ts.w += 8.0;
                if (!(ts.w > (double)this.getWidth()) && !(ts.h > (double)(this.getHeight() / 6))) continue;
                this.reduceFontSize(this.getHeight() / 6);
                fontAdjust = true;
            } while ((ts.w > (double)this.getWidth() || ts.h > (double)(this.getHeight() / 6)) && this.canReduceFontSize());
            if (fontAdjust) {
                this.sizeFontAll();
            }
            dim.height = (int)((double)dim.height - ts.h);
            this.nameLabel.setFont(this.fontLarge);
        }
        this.adp.setMinimumSize(dim);
        this.adp.setPreferredSize(dim);
        this.adp.setMaximumSize(dim);
        this.adp.setSize(dim);
    }

    @Override
    public String generateParams() {
        StringBuilder sb = new StringBuilder();
        sb.append("type:");
        sb.append(this.adp.getScaleType().name());
        sb.append(" ");
        if (this.adp.getAlarm()) {
            sb.append("alarm ");
        }
        if (!this.adp.autoRange) {
            sb.append("limits:");
            sb.append(StringUtil.formatDoubleEE(this.adp.getLower(), false));
            sb.append(":");
            sb.append(StringUtil.formatDoubleEE(this.adp.getUpper(), false));
            sb.append(" ");
        }
        return sb.toString();
    }

    protected class AnalogDrawerPanel
    extends JPanel {
        private BufferedImage image = null;
        private double lower = -1.0E-15;
        private double upper = 1.0E-15;
        private double value = 0.0;
        private final Color backgroundColor = new Color(240, 248, 152);
        private final Color limitBackgroundColor = new Color(248, 200, 200);
        private final Color needleColor = new Color(28, 255, 0);
        private final Color tickColor = new Color(200, 150, 0);
        private final Color limitColor = new Color(180, 20, 20);
        private final Color textColor = new Color(0, 0, 0);
        private Font font = null;
        private boolean autoRange = true;
        private String unit = "";
        private boolean alarm = false;
        private ScaleType scaleType = ScaleType.Horizontal;
        private int fontYAdjust = 0;

        AnalogDrawerPanel() {
            this.resizeGraphic(10, 10);
        }

        public double getLower() {
            return this.lower;
        }

        public double getUpper() {
            return this.upper;
        }

        public boolean getAlarm() {
            return this.alarm;
        }

        public void setAlarm(boolean alarm) {
            this.alarm = alarm;
        }

        public void setLower(double lower) {
            this.lower = lower;
            this.autoRange = false;
        }

        public void setUpper(double upper) {
            this.upper = upper;
            this.autoRange = false;
        }

        public ScaleType getScaleType() {
            return this.scaleType;
        }

        public void setScaleType(ScaleType scaleType) {
            this.scaleType = scaleType;
        }

        public void setScaleType(String s) {
            if (s == null) {
                return;
            }
            ScaleType[] scaleTypeArray = ScaleType.values();
            int n = scaleTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ScaleType st = scaleTypeArray[n2];
                if (st.name().equalsIgnoreCase(s)) {
                    this.setScaleType(st);
                    return;
                }
                ++n2;
            }
        }

        public void reset() {
            if (this.autoRange) {
                this.lower = this.value - 1.0E-15;
                this.upper = this.value + 1.0E-15;
            }
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }

        public void update() {
            this.updateValue(this.value);
        }

        public void updateValue(double v) {
            this.value = v;
            if (this.autoRange) {
                boolean round = false;
                double r = this.upper - this.lower;
                if (this.value < this.lower - r / 4.0) {
                    this.lower = this.value + r / 4.0;
                    round = true;
                }
                if (this.value > this.upper + r / 4.0) {
                    this.upper = this.value - r / 4.0;
                    round = true;
                }
                if (round) {
                    r = this.upper - this.lower;
                    double vv = Math.pow(10.0, (int)Math.log10(r) - 2);
                    this.lower = Math.floor(this.lower / vv) * vv;
                    this.upper = Math.floor(this.upper / vv + 0.9) * vv;
                }
            }
            this.makeGraphic();
            this.repaint();
        }

        private void resizeGraphic(int w, int h) {
            this.image = new BufferedImage(w, h, 2);
            float fs = (float)((double)(Math.min((float)h, (float)w * 2.0f / 3.0f) / 10.0f * (float)Toolkit.getDefaultToolkit().getScreenResolution()) / 72.0);
            this.fontYAdjust = (int)(-fs / 3.0f);
            this.font = this.getFont().deriveFont(fs);
            this.makeGraphic();
        }

        private void makeGraphic() {
            switch (this.scaleType) {
                case Horizontal: {
                    this.makeGraphicHorizontal();
                    break;
                }
                case Vertical: {
                    this.makeGraphicVertical();
                }
            }
        }

        private void makeGraphicVertical() {
            int dh;
            int w = this.image.getWidth();
            int h = this.image.getHeight();
            Graphics2D g = this.image.createGraphics();
            if (this.alarm && (this.value < this.lower || this.value > this.upper)) {
                g.setBackground(this.limitBackgroundColor);
            } else {
                g.setBackground(this.backgroundColor);
            }
            g.clearRect(0, 0, w, h);
            int ticks = 7;
            int miny = 0;
            int maxy = 0;
            g.setFont(this.font);
            if (this.alarm) {
                g.setColor(this.limitColor);
                g.fillRect(w * 2 / 20 + 1, 0, w * 1 / 20, h * 3 / (ticks * 2));
                g.fillRect(w * 2 / 20 + 1, h * 11 / (ticks * 2), w * 1 / 20, h * 3 / (ticks * 2));
                g.fillRect(w * 11 / 20, 0, w * 1 / 20, h * 3 / (ticks * 2));
                g.fillRect(w * 11 / 20, h * 11 / (ticks * 2), w * 1 / 20, h * 3 / (ticks * 2));
            }
            g.setColor(this.tickColor);
            int i = 0;
            while (i < ticks) {
                int py = h * (i + i + 1) / (ticks * 2);
                int b1 = w * 3 / 20;
                int b2 = w * 11 / 20;
                if (i == 1) {
                    maxy = py;
                    b2 = w * 13 / 20;
                    b1 = w * 1 / 20;
                } else if (i == ticks - 2) {
                    miny = py;
                    b2 = w * 13 / 20;
                    b1 = w * 1 / 20;
                } else if (i == ticks / 2) {
                    b2 = w * 13 / 20;
                    b1 = w * 1 / 20;
                }
                g.drawLine(w * 10 / 20, py, b2, py);
                g.drawLine(w * 4 / 20, py, b1, py);
                ++i;
            }
            int py = (int)((this.value - this.lower) / (this.upper - this.lower) * (double)(maxy - miny) + (double)miny);
            g.setColor(this.needleColor);
            if (py >= 0 && py < h) {
                g.drawLine(w * 4 / 20, py, w * 10 / 20, py);
                g.drawLine(w * 5 / 20, py - 1, w * 9 / 20, py - 1);
                g.drawLine(w * 5 / 20, py + 1, w * 9 / 20, py + 1);
                if (h > 200) {
                    g.drawLine(w * 5 / 20, py - 2, w * 9 / 20, py - 2);
                    g.drawLine(w * 5 / 20, py + 2, w * 9 / 20, py + 2);
                }
            } else if (py < 0) {
                dh = h / 10;
                g.drawLine(w * 5 / 20, dh, w * 7 / 20, 0);
                g.drawLine(w * 5 / 20, dh + 1, w * 7 / 20, 1);
                g.drawLine(w * 7 / 20, 0, w * 9 / 20, dh);
                g.drawLine(w * 7 / 20, 1, w * 9 / 20, dh + 1);
            } else {
                dh = h / 10;
                g.drawLine(w * 5 / 20, h - dh, w * 7 / 20, h);
                g.drawLine(w * 5 / 20, h - dh - 1, w * 7 / 20, h - 1);
                g.drawLine(w * 7 / 20, h, w * 9 / 20, h - dh);
                g.drawLine(w * 7 / 20, h - 1, w * 9 / 20, h - dh - 1);
            }
            g.setColor(this.textColor);
            this.drawTextcy(g, w * 14 / 20, miny, StringUtil.formatDoubleEE(this.lower, false, 6));
            this.drawTextcy(g, w * 14 / 20, maxy, StringUtil.formatDoubleEE(this.upper, false, 6));
            this.drawTextcy(g, w * 14 / 20, h / 2, StringUtil.formatDoubleEE((this.lower + this.upper) / 2.0, false, 6));
        }

        protected void drawTextcy(Graphics2D g, int xLeft, int yCenter, String text) {
            Rectangle2D sz = this.font.getStringBounds(text, g.getFontRenderContext());
            g.drawString(text, xLeft, (int)((double)yCenter + sz.getHeight() / 2.0) + this.fontYAdjust);
        }

        private void makeGraphicHorizontal() {
            int dx;
            int w = this.image.getWidth();
            int h = this.image.getHeight();
            Graphics2D g = this.image.createGraphics();
            if (this.alarm && (this.value < this.lower || this.value > this.upper)) {
                g.setBackground(this.limitBackgroundColor);
            } else {
                g.setBackground(this.backgroundColor);
            }
            g.clearRect(0, 0, w, h);
            int ticks = 7;
            int minx = 0;
            int maxx = 0;
            g.setFont(this.font);
            if (this.alarm) {
                g.setColor(this.limitColor);
                g.fillRect(0, h * 14 / 20, w * 3 / 14, h * 1 / 20);
                g.fillRect(w * 11 / (ticks * 2), h * 14 / 20, w * 3 / (ticks * 2), h * 1 / 20);
            }
            g.setColor(this.tickColor);
            int i = 0;
            while (i < ticks) {
                int px = w * (i + i + 1) / (ticks * 2);
                int b = h * 14 / 20;
                if (i == 1) {
                    minx = px;
                    b = h * 16 / 20;
                } else if (i == ticks - 2) {
                    maxx = px;
                    b = h * 16 / 20;
                } else if (i == ticks / 2) {
                    b = h * 16 / 20;
                }
                g.drawLine(px, h * 12 / 20, px, b);
                ++i;
            }
            int px = (int)((this.value - this.lower) / (this.upper - this.lower) * (double)(maxx - minx) + (double)minx);
            g.setColor(this.needleColor);
            if (px >= 0 && px < w) {
                g.drawLine(px, h * 5 / 20, px, h * 12 / 20);
                g.drawLine(px - 1, h * 5 / 20, px - 1, h * 10 / 20);
                g.drawLine(px + 1, h * 5 / 20, px + 1, h * 10 / 20);
                if (w > 200) {
                    g.drawLine(px - 2, h * 5 / 20, px - 2, h * 10 / 20);
                    g.drawLine(px + 2, h * 5 / 20, px + 2, h * 10 / 20);
                }
            } else if (px < 0) {
                dx = w / 10;
                g.drawLine(dx, h * 6 / 20, 0, h * 17 / 40);
                g.drawLine(dx + 1, h * 6 / 20, 1, h * 17 / 40);
                g.drawLine(0, h * 17 / 40, dx, h * 11 / 20);
                g.drawLine(1, h * 17 / 40, dx + 1, h * 11 / 20);
            } else {
                dx = w / 10;
                g.drawLine(w - dx, h * 6 / 20, w, h * 17 / 40);
                g.drawLine(w - dx - 1, h * 6 / 20, w - 1, h * 17 / 40);
                g.drawLine(w, h * 17 / 40, w - dx, h * 11 / 20);
                g.drawLine(w - 1, h * 17 / 40, w - dx - 1, h * 11 / 20);
            }
            g.setColor(this.textColor);
            this.drawTextcx(g, minx, h * 19 / 20, StringUtil.formatDoubleEE(this.lower, false, 6));
            this.drawTextcx(g, maxx, h * 19 / 20, StringUtil.formatDoubleEE(this.upper, false, 6));
            this.drawTextcx(g, w / 2, h * 19 / 20, StringUtil.formatDoubleEE((this.lower + this.upper) / 2.0, false, 6));
            this.drawTextcx(g, w / 2, h * 4 / 20, String.valueOf(StringUtil.formatDoubleEE(this.value, false, 6)) + this.unit);
        }

        protected void drawTextcx(Graphics2D g, int xCenter, int yBottom, String text) {
            Rectangle2D sz = this.font.getStringBounds(text, g.getFontRenderContext());
            g.drawString(text, (int)((double)xCenter - sz.getWidth() / 2.0), yBottom);
        }

        @Override
        protected void paintComponent(Graphics g) {
            int w = this.getWidth();
            int h = this.getHeight();
            if (w != this.image.getWidth() || h != this.image.getHeight()) {
                this.resizeGraphic(w, h);
            }
            g.drawImage(this.image, 0, 0, null);
        }
    }

    public static enum ScaleType {
        Vertical,
        Horizontal;

    }
}

