/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.devices.SetupFormatsAdjuster;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.IconGenerator;
import dk.hkj.panels.BasicPanel;
import dk.hkj.panels.PopupAskDualValue;
import dk.hkj.util.MathUtil;
import dk.hkj.util.StringUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public abstract class BasicAdjustPanel
extends BasicPanel {
    protected int adjustParamsCount = 0;
    protected JLabel nameLabel = null;
    protected String device = null;
    protected ChannelData[] channelData = null;
    protected Timer timer = null;

    BasicAdjustPanel(int adjustParamsCount) {
        this.adjustParamsCount = adjustParamsCount;
        this.nameLabel = new FontAdjust.FontLabel("");
        this.nameLabel.setHorizontalTextPosition(0);
        this.channelData = new ChannelData[adjustParamsCount];
        int i = 0;
        while (i < adjustParamsCount) {
            this.channelData[i] = new ChannelData();
            ++i;
        }
        this.timer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ChannelData[] channelDataArray = BasicAdjustPanel.this.channelData;
                int n = BasicAdjustPanel.this.channelData.length;
                int n2 = 0;
                while (n2 < n) {
                    ChannelData cd = channelDataArray[n2];
                    cd.timerUpdate();
                    ++n2;
                }
            }
        });
        this.timer.start();
        this.nameLabel.setText("--empty--");
        this.displayLayout(this.includeName);
    }

    @Override
    protected String getFontGroup() {
        return "Adjust" + this.adjustParamsCount;
    }

    @Override
    public BasicPanel.ParamsSet getParamsSet() {
        BasicPanel.ParamsSet ps = super.getParamsSet();
        ps.addParams(new String[]{"prec", "", "min", "max"});
        return ps;
    }

    @Override
    public void setParams(BasicPanel.ParamsSet paramsSet) {
        ChannelData cd;
        super.setParams(paramsSet);
        int[] vi = paramsSet.getInts("prec");
        int i = 0;
        while (i < Math.min(this.channelData.length, vi.length)) {
            ChannelData cd2 = this.channelData[i];
            cd2.setPrecision(vi[i]);
            ++i;
        }
        double[] v = paramsSet.getDoubles("min");
        int i2 = 0;
        while (i2 < Math.min(this.channelData.length, v.length)) {
            cd = this.channelData[i2];
            cd.min = v[i2];
            cd.setMinMax();
            ++i2;
        }
        v = paramsSet.getDoubles("max");
        i2 = 0;
        while (i2 < Math.min(this.channelData.length, v.length)) {
            cd = this.channelData[i2];
            cd.max = v[i2];
            cd.setMinMax();
            ++i2;
        }
    }

    @Override
    public void update() {
        if (!this.requestDisplayUpdate) {
            return;
        }
        int w = 0;
        int h = 0;
        boolean fontAdjust = false;
        this.nameLabel.setFont(this.fontSmall);
        ChannelData[] channelDataArray = this.channelData;
        int n = this.channelData.length;
        int n2 = 0;
        while (n2 < n) {
            ChannelData cd = channelDataArray[n2];
            cd.setFont();
            ++n2;
        }
        do {
            BasicPanel.TextSize ts1 = this.includeName ? this.getTextSize(this.nameLabel.getFont(), this.nameLabel.getText()) : new BasicPanel.TextSize(this, 0.0, 0.0);
            BasicPanel.TextSize ts2 = new BasicPanel.TextSize(this, 0.0, 0.0);
            ChannelData[] channelDataArray2 = this.channelData;
            int n3 = this.channelData.length;
            int n4 = 0;
            while (n4 < n3) {
                ChannelData cd = channelDataArray2[n4];
                ts2.addVertical(cd.getTextSize());
                ++n4;
            }
            w = (int)this.maxx(ts1.w, ts2.w) + 8;
            h = (int)(ts1.h + ts2.h) + 2;
            if (w <= this.getWidth() && h <= this.getHeight()) continue;
            this.reduceFontSize((double)this.getHeight() / (0.5 + (double)this.channelData.length * 1.5));
            this.nameLabel.setFont(this.fontSmall);
            channelDataArray2 = this.channelData;
            n3 = this.channelData.length;
            n4 = 0;
            while (n4 < n3) {
                ChannelData cd = channelDataArray2[n4];
                cd.setFont();
                ++n4;
            }
            fontAdjust = true;
        } while ((w > this.getWidth() || h > this.getHeight()) && this.canReduceFontSize());
        if (fontAdjust) {
            this.sizeFontAll();
        }
        this.revalidate();
        this.requestDisplayUpdate = false;
    }

    @Override
    public void reset() {
    }

    @Override
    public void updateColor() {
        ChannelData[] channelDataArray = this.channelData;
        int n = this.channelData.length;
        int n2 = 0;
        while (n2 < n) {
            ChannelData cd = channelDataArray[n2];
            cd.updateColor();
            ++n2;
        }
    }

    @Override
    public boolean needData() {
        return false;
    }

    @Override
    protected void displayLayout(boolean includeName) {
        this.removeAll();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        if (includeName) {
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 11;
            c.gridwidth = 3;
            c.weightx = 0.0;
            c.weighty = 0.0;
            this.add((Component)this.nameLabel, c);
        }
        int ii = 0;
        while (ii < this.adjustParamsCount) {
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = ii + 1;
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            this.add((Component)this.channelData[ii].getPanel(), c);
            ++ii;
        }
    }

    @Override
    public String generateParams() {
        ChannelData cd;
        StringBuilder sb = new StringBuilder();
        sb.append(super.generateParams());
        sb.append("prec");
        ChannelData[] channelDataArray = this.channelData;
        int n = this.channelData.length;
        int n2 = 0;
        while (n2 < n) {
            cd = channelDataArray[n2];
            sb.append(":");
            sb.append(cd.getPrecisionIndex());
            ++n2;
        }
        sb.append("min");
        channelDataArray = this.channelData;
        n = this.channelData.length;
        n2 = 0;
        while (n2 < n) {
            cd = channelDataArray[n2];
            sb.append(":");
            sb.append(StringUtil.formatDoubleEE(cd.min, false));
            ++n2;
        }
        sb.append(" ");
        sb.append("max");
        channelDataArray = this.channelData;
        n = this.channelData.length;
        n2 = 0;
        while (n2 < n) {
            cd = channelDataArray[n2];
            sb.append(":");
            sb.append(StringUtil.formatDoubleEE(cd.max, false));
            ++n2;
        }
        sb.append(" ");
        return sb.toString();
    }

    protected class ChannelData
    implements MouseMotionListener,
    MouseWheelListener,
    MouseListener {
        protected Precision precision = Precision.Medium;
        private String paramName = "";
        private SetupFormatsAdjuster.AdjustParam param = null;
        private JLabel valueLabel = null;
        private JLabel adjustLabel = null;
        private JLabel minLabel = null;
        private JLabel maxLabel = null;
        private JPanel panel = this.createPanel();
        private double value;
        private double txValue;
        private double min;
        private double max;
        private int x0 = 0;
        private int y0 = 0;
        private double value0;
        private int digits = 3;
        private boolean threadBusy = false;

        private ChannelData() {
        }

        public int getPrecisionIndex() {
            switch (this.precision) {
                case Low: {
                    return 0;
                }
                case Medium: {
                    return 1;
                }
                case High: {
                    return 2;
                }
            }
            return 0;
        }

        public Precision getPrecision() {
            return this.precision;
        }

        public void setPrecision(int i) {
            switch (i) {
                case 0: {
                    this.setPrecision(Precision.Low);
                    break;
                }
                case 1: {
                    this.setPrecision(Precision.Medium);
                    break;
                }
                case 2: {
                    this.setPrecision(Precision.High);
                }
            }
        }

        public void setPrecision(Precision precision) {
            this.precision = precision;
            switch (precision) {
                case Low: {
                    this.adjustLabel.setIcon(IconGenerator.makeIcon(IconGenerator.IconType.AdjustPadLow));
                    break;
                }
                case Medium: {
                    this.adjustLabel.setIcon(IconGenerator.makeIcon(IconGenerator.IconType.AdjustPadMedium));
                    break;
                }
                case High: {
                    this.adjustLabel.setIcon(IconGenerator.makeIcon(IconGenerator.IconType.AdjustPadHigh));
                }
            }
            BasicAdjustPanel.this.requestDisplayUpdate = true;
        }

        public void precisionMenu(JMenu menu) {
            FontAdjust.FontRadioButtonMenuItem mi = new FontAdjust.FontRadioButtonMenuItem("Low");
            mi.setSelected(this.precision == Precision.Low);
            mi.addActionListener(x -> this.setPrecision(Precision.Low));
            menu.add(mi);
            mi = new FontAdjust.FontRadioButtonMenuItem("Medium");
            mi.setSelected(this.precision == Precision.Medium);
            mi.addActionListener(x -> this.setPrecision(Precision.Medium));
            menu.add(mi);
            mi = new FontAdjust.FontRadioButtonMenuItem("High");
            mi.setSelected(this.precision == Precision.High);
            mi.addActionListener(x -> this.setPrecision(Precision.High));
            menu.add(mi);
        }

        public void updateColor() {
            if (BasicAdjustPanel.this.foregroundColor != null) {
                BasicAdjustPanel.this.nameLabel.setForeground(BasicAdjustPanel.this.foregroundColor);
                this.valueLabel.setForeground(BasicAdjustPanel.this.foregroundColor);
                this.minLabel.setForeground(BasicAdjustPanel.this.foregroundColor);
                this.maxLabel.setForeground(BasicAdjustPanel.this.foregroundColor);
            }
            if (BasicAdjustPanel.this.backgroundColor != null) {
                BasicAdjustPanel.this.nameLabel.setBackground(BasicAdjustPanel.this.backgroundColor);
                this.valueLabel.setBackground(BasicAdjustPanel.this.backgroundColor);
                this.minLabel.setBackground(BasicAdjustPanel.this.backgroundColor);
                this.adjustLabel.setBackground(BasicAdjustPanel.this.backgroundColor);
                this.maxLabel.setBackground(BasicAdjustPanel.this.backgroundColor);
            }
        }

        public String getParamName() {
            return this.paramName;
        }

        public String getHandleName() {
            if (this.paramName == null) {
                return null;
            }
            int i = this.paramName.indexOf(32);
            if (i > 0) {
                return this.paramName.substring(0, i);
            }
            return this.paramName;
        }

        public void setParamName(String paramName) {
            this.paramName = paramName;
            this.param = SetupFormatsAdjuster.getAdjustParam(paramName);
            if (this.param == null) {
                this.paramName = null;
                return;
            }
            this.min = this.param.getMin();
            this.max = this.param.getMax();
            this.txValue = this.value = this.param.getParam().doubleValue();
            this.setMinMax();
            this.showValue();
        }

        private void timerUpdate() {
            if (this.param != null && this.txValue != this.value && !this.threadBusy) {
                new ParamWriter(this, this.value);
                this.txValue = this.value;
            }
        }

        private void showValue() {
            this.valueLabel.setText(String.valueOf(StringUtil.formatDoubleEE(this.value, false)) + this.param.getUnit());
            BasicAdjustPanel.this.requestDisplayUpdate = true;
        }

        private void setMinMax() {
            this.minLabel.setText(StringUtil.formatDoubleEE(this.min, false));
            this.maxLabel.setText(StringUtil.formatDoubleEE(this.max, false));
            BasicAdjustPanel.this.requestDisplayUpdate = true;
            this.digits = (int)(Math.log10(this.max - this.min) + 4.0);
            if (this.precision == Precision.High) {
                ++this.digits;
            }
        }

        protected void setFont() {
            this.valueLabel.setFont(BasicAdjustPanel.this.fontLarge);
            this.minLabel.setFont(BasicAdjustPanel.this.fontMedium);
            this.maxLabel.setFont(BasicAdjustPanel.this.fontMedium);
        }

        protected BasicPanel.TextSize getTextSize() {
            BasicPanel.TextSize ts1 = BasicAdjustPanel.this.getTextSize(this.valueLabel.getFont(), this.valueLabel.getText());
            BasicPanel.TextSize ts2 = BasicAdjustPanel.this.getTextSize(this.minLabel.getFont(), this.valueLabel.getText());
            BasicPanel.TextSize ts4 = BasicAdjustPanel.this.getTextSize(this.maxLabel.getFont(), this.valueLabel.getText());
            return new BasicPanel.TextSize(BasicAdjustPanel.this, BasicAdjustPanel.this.maxx(ts1.w, ts2.w + 32.0 + ts4.w), ts1.h + BasicAdjustPanel.this.maxx(ts2.h, 32.0, ts4.h));
        }

        private JPanel createPanel() {
            JPanel panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            panel.addMouseMotionListener(this);
            panel.addMouseWheelListener(this);
            panel.addMouseListener(this);
            panel.setInheritsPopupMenu(true);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 10;
            c.gridwidth = 3;
            c.weightx = 0.0;
            c.weighty = 1.0;
            this.valueLabel = new JLabel("888888");
            this.valueLabel.setHorizontalTextPosition(0);
            this.valueLabel.addMouseMotionListener(this);
            this.valueLabel.addMouseWheelListener(this);
            this.valueLabel.addMouseListener(this);
            panel.add((Component)this.valueLabel, c);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 1;
            c.anchor = 17;
            c.weightx = 0.0;
            c.weighty = 1.0;
            this.minLabel = new JLabel("888888");
            this.minLabel.addMouseMotionListener(this);
            this.minLabel.setHorizontalTextPosition(2);
            this.minLabel.addMouseListener(this);
            this.minLabel.addMouseWheelListener(this);
            panel.add((Component)this.minLabel, c);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 1;
            c.anchor = 10;
            c.weightx = 1.0;
            c.weighty = 1.0;
            this.adjustLabel = new JLabel(IconGenerator.makeIcon(IconGenerator.IconType.AdjustPadMedium));
            this.adjustLabel.setToolTipText("Click and drag or turn mouse wheel to adjust");
            this.adjustLabel.addMouseMotionListener(this);
            this.adjustLabel.addMouseListener(this);
            this.adjustLabel.addMouseWheelListener(this);
            panel.add((Component)this.adjustLabel, c);
            c = new GridBagConstraints();
            c.gridx = 2;
            c.gridy = 1;
            c.anchor = 13;
            c.weightx = 0.0;
            c.weighty = 1.0;
            this.maxLabel = new JLabel("888888");
            this.maxLabel.addMouseMotionListener(this);
            this.maxLabel.setHorizontalTextPosition(4);
            this.maxLabel.addMouseListener(this);
            this.maxLabel.addMouseWheelListener(this);
            panel.add((Component)this.maxLabel, c);
            return panel;
        }

        public JPanel getPanel() {
            return this.panel;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent arg0) {
            if (arg0.getButton() != 0) {
                return;
            }
            double d = -(this.max - this.min) * arg0.getPreciseWheelRotation() / 200.0;
            if (this.precision == Precision.Low) {
                d *= 3.0;
            }
            if (this.precision == Precision.High) {
                d /= 3.0;
            }
            this.value += d;
            this.value0 = this.value;
            this.value = MathUtil.roundDigits(Math.max(Math.abs(this.max), Math.abs(this.min)), this.value, this.digits);
            if (this.value > this.max) {
                this.value = this.max;
            }
            if (this.value < this.min) {
                this.value = this.min;
            }
            this.showValue();
        }

        @Override
        public void mouseDragged(MouseEvent arg0) {
            if (this.param == null) {
                return;
            }
            int dx = arg0.getXOnScreen() - this.x0;
            int dy = this.y0 - arg0.getYOnScreen();
            double d = (this.max - this.min) * Math.sqrt(dx * dx + dy * dy) / 2000.0;
            if (this.precision == Precision.Low) {
                d *= 3.0;
            }
            if (this.precision == Precision.High) {
                d /= 3.0;
            }
            double a = Math.atan2(dy, dx);
            double fac = 0.0;
            if (a >= -0.7853981633974483 && a < 2.356194490192345) {
                fac = 1.0 - Math.abs(a - 0.7853981633974483) / Math.PI * 2.0;
            } else {
                if (a > 0.0) {
                    a -= Math.PI * 2;
                }
                fac = -1.0 + Math.abs(a + 2.356194490192345) / Math.PI * 2.0;
            }
            this.value = this.value0 + d * fac;
            this.value = MathUtil.roundDigits(Math.max(Math.abs(this.max), Math.abs(this.min)), this.value, this.digits);
            if (this.value > this.max) {
                this.value = this.max;
            }
            if (this.value < this.min) {
                this.value = this.min;
            }
            this.showValue();
        }

        @Override
        public void mouseMoved(MouseEvent arg0) {
            this.x0 = arg0.getXOnScreen();
            this.y0 = arg0.getYOnScreen();
            this.value0 = this.value;
        }

        public void adjustMinMax() {
            PopupAskDualValue adv = new PopupAskDualValue(BasicAdjustPanel.this, "Enter limits", "Min:", "Max:", this.min, this.max, this.param.getMin(), this.param.getMax(), this.param.getMin(), this.param.getMax(), true);
            if (!Double.isNaN(adv.getValue1())) {
                this.min = adv.getValue1();
            }
            if (!Double.isNaN(adv.getValue2())) {
                this.max = adv.getValue2();
            }
            this.setMinMax();
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
            if (SwingUtilities.isMiddleMouseButton(arg0)) {
                switch (this.precision) {
                    case High: {
                        this.setPrecision(Precision.Low);
                        break;
                    }
                    case Low: {
                        this.setPrecision(Precision.Medium);
                        break;
                    }
                    case Medium: {
                        this.setPrecision(Precision.High);
                        break;
                    }
                }
                BasicAdjustPanel.this.repaint();
            }
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }
    }

    private static class ParamWriter
    extends Thread {
        ChannelData channelData;
        double value = 0.0;

        ParamWriter(ChannelData channelData, double value) {
            this.channelData = channelData;
            this.value = value;
            channelData.threadBusy = true;
            this.setDaemon(true);
            this.run();
        }

        @Override
        public void run() {
            try {
                this.channelData.param.setParam(this.value, true);
            }
            catch (Exception exception) {}
            this.channelData.threadBusy = false;
        }
    }

    protected static enum Precision {
        Low,
        Medium,
        High;

    }
}

