/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.panels;

import dk.hkj.main.AutoHold;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.ValueFormat;
import dk.hkj.panels.BasicLargeNSmallPanel;
import dk.hkj.panels.BasicPanel;
import dk.hkj.util.StringUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormatSymbols;
import javax.swing.JMenu;

public class AutoHoldReadoutPanel
extends BasicLargeNSmallPanel
implements ActionListener {
    public static String panelName = "AutoHoldReadout";
    protected String channel = null;
    protected ValueFormat fmt = new ValueFormat("??", "", ValueFormat.formatD2);
    protected AutoHold ah = new AutoHold(this);

    public AutoHoldReadoutPanel() {
        super(3);
        this.small1LeftLabel.setToolTipText("#1");
        this.small1RightLabel.setToolTipText("#4");
        this.small2LeftLabel.setToolTipText("#2");
        this.small2RightLabel.setToolTipText("#5");
        this.small3LeftLabel.setToolTipText("#3");
        this.small3RightLabel.setToolTipText("#6");
        this.displayLayout(this.includeName);
    }

    @Override
    public String getPanelName() {
        return panelName;
    }

    @Override
    public BasicPanel.ParamsSet getParamsSet() {
        BasicPanel.ParamsSet ps = super.getParamsSet();
        ps.addParams(new String[]{"tol", "time", "min"});
        ps.nChannels = 1;
        return ps;
    }

    @Override
    public void setParams(BasicPanel.ParamsSet paramsSet) {
        super.setParams(paramsSet);
        this.channel = paramsSet.channels.get(0);
        Double d = paramsSet.getValue("tol");
        if (d != null) {
            this.ah.setTolerance(d / 100.0);
        }
        if ((d = paramsSet.getValue("time")) != null) {
            this.ah.setLockTime(d);
        }
        if ((d = paramsSet.getValue("min")) != null) {
            this.ah.setMinValue(d);
        }
        this.fmt = InterfaceThreads.findValueFormat(this.channel);
        this.largeLabel.setToolTipText(this.channel);
    }

    @Override
    public void update() {
        if (!this.isVisible()) {
            return;
        }
        if (this.channel == null) {
            super.update();
            return;
        }
        double v = this.readValue(this.channel);
        if (!Double.isNaN(v) && this.ah.newValue(v)) {
            this.requestDisplayUpdate = true;
        }
        if (this.requestDisplayUpdate) {
            String v1 = this.ah.getSampleAsString(0, this.fmt.format);
            String v2 = this.ah.getSampleAsString(1, this.fmt.format);
            String v3 = this.ah.getSampleAsString(2, this.fmt.format);
            String v4 = this.ah.getSampleAsString(3, this.fmt.format);
            String v5 = this.ah.getSampleAsString(4, this.fmt.format);
            String v6 = this.ah.getSampleAsString(5, this.fmt.format);
            this.update(this.channel, String.valueOf(this.fmt.format.formatDisplay(this.ah.getCurrentValue())) + this.fmt.unit, "#1: " + v1, "#4: " + v4, "#2: " + v2, "#5: " + v5, "#3: " + v3, "#6: " + v6);
            this.requestDisplayUpdate = false;
        }
    }

    @Override
    public void reset() {
        this.ah.reset();
    }

    @Override
    protected boolean supportReset() {
        return true;
    }

    private void addToleranceMenuItem(JMenu menu, double tol) {
        FontAdjust.FontRadioButtonMenuItem mi = new FontAdjust.FontRadioButtonMenuItem(String.valueOf(Double.toString(tol * 100.0)) + "%");
        if (tol == this.ah.getTolerance()) {
            mi.setSelected(true);
        }
        mi.setActionCommand("tol:" + Double.toString(tol));
        mi.addActionListener(this);
        menu.add(mi);
    }

    private void addLockTimeMenuItem(JMenu menu, double lt) {
        FontAdjust.FontRadioButtonMenuItem mi = new FontAdjust.FontRadioButtonMenuItem(String.valueOf(Double.toString(lt)) + "s");
        if (lt == this.ah.getLockTime()) {
            mi.setSelected(true);
        }
        mi.setActionCommand("t:" + Double.toString(lt));
        mi.addActionListener(this);
        menu.add(mi);
    }

    private void addMinValueMenuItem(JMenu menu, double value) {
        FontAdjust.FontRadioButtonMenuItem mi = new FontAdjust.FontRadioButtonMenuItem(String.valueOf(StringUtil.formatDoubleEE(value)) + this.fmt.unit);
        if (value == this.ah.getMinValue()) {
            mi.setSelected(true);
        }
        mi.setActionCommand("min:" + Double.toString(value));
        mi.addActionListener(this);
        menu.add(mi);
    }

    @Override
    protected void popupMenuAdjust() {
        this.selectMenu("Select channel", "C:", this.channel, InterfaceThreads.listChannels(true, "*"), '.', this);
        FontAdjust.FontMenu menu = new FontAdjust.FontMenu("Tolerance");
        this.popupMenu.add(menu);
        this.addToleranceMenuItem(menu, 1.0E-4);
        this.addToleranceMenuItem(menu, 3.0E-4);
        this.addToleranceMenuItem(menu, 0.001);
        this.addToleranceMenuItem(menu, 0.003);
        this.addToleranceMenuItem(menu, 0.01);
        this.addToleranceMenuItem(menu, 0.03);
        this.addToleranceMenuItem(menu, 0.1);
        menu = new FontAdjust.FontMenu("Lock time");
        this.popupMenu.add(menu);
        this.addLockTimeMenuItem(menu, 1.0);
        this.addLockTimeMenuItem(menu, 1.5);
        this.addLockTimeMenuItem(menu, 2.0);
        this.addLockTimeMenuItem(menu, 3.0);
        menu = new FontAdjust.FontMenu("Min. value");
        this.popupMenu.add(menu);
        this.addMinValueMenuItem(menu, 0.0);
        this.addMinValueMenuItem(menu, 1.0E-4);
        this.addMinValueMenuItem(menu, 0.001);
        this.addMinValueMenuItem(menu, 0.01);
        this.addMinValueMenuItem(menu, 0.1);
        this.addMinValueMenuItem(menu, 1.0);
        this.addMinValueMenuItem(menu, 10.0);
        this.addMinValueMenuItem(menu, 100.0);
        FontAdjust.FontMenuItem mi = new FontAdjust.FontMenuItem("Numbers to clipboard ");
        mi.setActionCommand("cc");
        mi.addActionListener(this);
        this.popupMenu.add(mi);
        super.popupMenuAdjust();
        this.addBasicPopupMenu();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().startsWith("C:")) {
            this.channel = arg0.getActionCommand().substring(2);
            this.fmt = InterfaceThreads.findValueFormat(this.channel);
            this.largeLabel.setToolTipText(this.channel);
            this.reset();
        } else if (arg0.getActionCommand().startsWith("tol:")) {
            this.ah.setTolerance(StringUtil.parseDoubleEE(arg0.getActionCommand().substring(4)));
        } else if (arg0.getActionCommand().startsWith("t:")) {
            this.ah.setLockTime(StringUtil.parseDoubleEE(arg0.getActionCommand().substring(2)));
        } else if (arg0.getActionCommand().startsWith("min:")) {
            this.ah.setMinValue(StringUtil.parseDoubleEE(arg0.getActionCommand().substring(4)));
        } else if (arg0.getActionCommand().startsWith("cc")) {
            this.copyNumbersToClipboard();
        }
    }

    @Override
    public boolean needData() {
        return true;
    }

    private void copyNumbersToClipboard() {
        StringBuilder sb = new StringBuilder();
        for (Double d : this.ah.getSampleList()) {
            sb.append(Double.toString(d).replace('.', DecimalFormatSymbols.getInstance().getDecimalSeparator()));
            sb.append("\n");
        }
        this.toClipboard(sb.toString());
    }

    @Override
    protected String generateClipboardText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.nameLabel.getText());
        sb.append("\n");
        for (Double d : this.ah.getSampleList()) {
            sb.append(String.valueOf(this.fmt.format.formatDisplay(d)) + this.fmt.unit);
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public String generateScriptCmd() {
        StringBuilder sb = new StringBuilder();
        sb.append(panelName);
        sb.append(" ");
        sb.append(this.channel);
        sb.append(" ");
        sb.append("tol:");
        sb.append(StringUtil.formatDoubleEE(this.ah.getTolerance() * 100.0, false));
        sb.append(" ");
        sb.append("time:");
        sb.append(StringUtil.formatDoubleEE(this.ah.getLockTime(), false));
        sb.append(" ");
        sb.append("min:");
        sb.append(StringUtil.formatDoubleEE(this.ah.getMinValue(), false));
        sb.append(" ");
        sb.append(this.generateParams());
        sb.append(this.generateParamsColor());
        return sb.toString();
    }
}

